/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.cache;

import com.arun.bhardwaj.exceptions.ServiceException;
import com.arun.bhardwaj.service.project.ManagerProjectServiceImpl;
import java.util.Map;

public class ArchitectNamesCache {
    private static Map<Integer, String> architectIdToNameMap;

    private ArchitectNamesCache() {
    }

    public static String getArchitectName(Integer architectId) {
        return architectIdToNameMap.get(architectId);
    }

    public static Integer getArchitectIdByName(String architectName) {
        for (Map.Entry<Integer, String> entry : architectIdToNameMap.entrySet()) {
            if (!entry.getValue().equals(architectName)) continue;
            return entry.getKey();
        }
        return -1;
    }

    public static Map<Integer, String> getArchitectNames() {
        return architectIdToNameMap;
    }

    public static void loadArchitectName() throws ServiceException {
        ManagerProjectServiceImpl service = new ManagerProjectServiceImpl();
        architectIdToNameMap = service.loadArchitectName();
    }
}

