/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.cache;

import com.arun.bhardwaj.exceptions.ServiceException;
import com.arun.bhardwaj.service.project.ManagerProjectServiceImpl;
import java.util.Map;

public class BuilderNamesCache {
    private static Map<Integer, String> builderIdToNameMap;

    private BuilderNamesCache() {
    }

    public static String getBuilderName(Integer builderId) {
        return builderIdToNameMap.get(builderId);
    }

    public static Integer getBuilderIdByName(String builderName) {
        for (Map.Entry<Integer, String> entry : builderIdToNameMap.entrySet()) {
            if (!entry.getValue().equals(builderName)) continue;
            return entry.getKey();
        }
        return -1;
    }

    public static Map<Integer, String> getBuilderNames() {
        return builderIdToNameMap;
    }

    public static void loadBuilderName() throws ServiceException {
        ManagerProjectServiceImpl service = new ManagerProjectServiceImpl();
        builderIdToNameMap = service.loadBuilderNames();
    }
}

