/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.controller;

import com.arun.bhardwaj.exceptions.ServiceException;
import com.arun.bhardwaj.service.LoginService;
import com.arun.bhardwaj.service.LoginServiceImpl;
import com.arun.bhardwaj.utility.AppUtility;
import com.arun.bhardwaj.utility.EmailUtility;
import com.arun.bhardwaj.utility.UserCache;
import com.arun.bhardwaj.view.ForgetPasswordView;
import com.arun.bhardwaj.view.LoginView;
import com.arun.bhardwaj.view.common.ErrorDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JOptionPane;

public class ForgetPasswordController
implements ActionListener {
    private ForgetPasswordView view;
    private final LoginView loginView;
    private final LoginService loginService;
    private String emailOTP;

    public ForgetPasswordController(ForgetPasswordView view) {
        this.view = view;
        this.loginView = view.getLoginView();
        this.loginService = new LoginServiceImpl();
        view.getChangePasswordButton().addActionListener(this);
        view.getSignInButton().addActionListener(this);
        view.getSendOtpButton().addActionListener(this);
    }

    private void handleChangePassword() {
        String password = new String(this.view.getPasswordField().getPassword()).trim();
        String emailOtp = this.view.getEmailOtpField().getText().trim();
        if (password.isEmpty() || emailOtp.isEmpty()) {
            JOptionPane.showMessageDialog(this.view.getBasePanel(), "All fields are mandatory. Please fill in all details.", "Error", 0);
            return;
        }
        if (!emailOtp.matches("\\d{4}")) {
            JOptionPane.showMessageDialog(this.view.getBasePanel(), "Email OTP must be a 4-digit numeric value.", "Error", 0);
            this.view.getEmailOtpField().requestFocus();
            return;
        }
        if (emailOtp.equals(this.getEmailOTP())) {
            try {
                String newPassword = String.valueOf(this.view.getPasswordField().getPassword());
                this.loginService.changePassword(newPassword);
                if (UserCache.getValidity() > 0L) {
                    this.loginService.renewDatabase(UserCache.getValidity(), newPassword);
                }
                JOptionPane.showMessageDialog(this.view.getBasePanel(), "Password changed successfully");
                this.loginView.getLoginCardLayout().show(this.loginView.getLoginBasePanel(), "signIn");
            }
            catch (ServiceException e) {
                new ErrorDialog(e, "Error in change Password");
            }
        } else {
            JOptionPane.showMessageDialog(this.view.getBasePanel(), "The entered email OTP is incorrect..", "Error", 0);
        }
    }

    private void handleSendEmailOTP() {
        StringBuilder message = new StringBuilder();
        char[] generatedOTP = AppUtility.generateOTP(4);
        message.append("<p>Your  OTP to reset your " + LoginView.AppName + " account </p>");
        message.append("<h2>");
        message.append(generatedOTP);
        message.append("</h2>");
        message.append("<p>Sincerely, </p> <p>Team " + LoginView.AppName + " </p> <p> Mob: <a href='https://wa.me/8800776704'>8800776704 </a> </p>");
        message.append("<p> Email <a href='mailto:support@shreetechnoworld.com'>support@shreetechnoworld.com </a></p>");
        message.append("<p> Website <a href='https://www.shreetechnoworld.com'>shreetechnoworld.com </a></p>");
        message.append("<p><h6> This is a system generated mail. Please don't reply. </h6> </p>");
        EmailUtility.sendEmailToClient(UserCache.getRegisteredEmailId(), "Your " + LoginView.AppName + " One Time Password ", message.toString());
        this.setEmailOTP(String.valueOf(generatedOTP));
        String userMessage = String.format("<html>OTP has been sent to your registered email<br><b>%s</b></html>", UserCache.getRegisteredEmailId());
        this.view.getMessageToUser().setText(userMessage);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.view.getSendOtpButton()) {
            if (AppUtility.isInternetConnected()) {
                this.handleSendEmailOTP();
            } else {
                JOptionPane.showMessageDialog(this.view.getBasePanel(), "Please check internet connection", "Error", 0);
            }
        }
        if (e.getSource() == this.view.getSignInButton()) {
            this.loginView.getLoginCardLayout().show(this.loginView.getLoginBasePanel(), "signIn");
        }
        if (e.getSource() == this.view.getChangePasswordButton()) {
            this.handleChangePassword();
        }
    }

    public String getEmailOTP() {
        return this.emailOTP;
    }

    public void setEmailOTP(String emailOTP) {
        this.emailOTP = emailOTP;
    }
}

