/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.controller;

import com.arun.bhardwaj.utility.AppUtility;
import com.arun.bhardwaj.view.InnerPanelView;
import com.arun.bhardwaj.view.ai.TalkWithAI;
import com.arun.bhardwaj.view.common.ErrorDialog;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class InnerPanelController
implements ChangeListener,
ActionListener {
    InnerPanelView view;

    public InnerPanelController(InnerPanelView view) {
        this.view = view;
        this.view.getMainTabs().addChangeListener(this);
        this.view.getGenerateContentBtn().addActionListener(this);
        this.view.getDownloadOllamaBtn().addActionListener(this);
        if (AppUtility.checkOllamaRunningStatus()) {
            this.view.getGenerateContentBtn().setToolTipText("Talk with virtual assistant");
            view.getDownloadOllamaBtn().setVisible(false);
        } else {
            this.view.getGenerateContentBtn().setEnabled(false);
            this.view.getGenerateContentBtn().setToolTipText("AI is not running");
            view.getDownloadOllamaBtn().setVisible(true);
            view.getDownloadOllamaBtn().setToolTipText("Download Ollama and start the server on port 11434. Click here to download.");
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object obj = e.getSource();
        if (obj == this.view.getMainTabs()) {
            String strTitle = this.view.getMainTabs().getTitleAt(this.view.getMainTabs().getSelectedIndex());
            if ("Project Navigator".equals(strTitle)) {
                this.view.getProjectDetailsView().getController().loadInitialData();
            } else if ("Property Management".equals(strTitle)) {
                this.view.getPropertyView().getPropertyController().loadInitialData();
            } else if ("Enquiry Management".equals(strTitle)) {
                this.view.getEnquiryView().getEnquiryController().loadInitialData();
            } else if ("Contact Management".equals(strTitle)) {
                this.view.getContactView().getContactController().loadInitialData();
            } else if ("Settings".equals(strTitle)) {
                this.view.getSettingsView().getUserDetailsView().getUserDetailsController().loadUserDetails();
                try {
                    AppUtility.validateUser();
                    if (AppUtility.isInternetConnected()) {
                        ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
                        executorService.schedule(() -> this.view.getSettingsView().getUserDetailsView().getUserDetailsController().checkForUpdate(), 2L, TimeUnit.SECONDS);
                        executorService.shutdown();
                    }
                }
                catch (Exception ex) {
                    new ErrorDialog(ex, "check for software update");
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.view.getDownloadOllamaBtn()) {
            String url = "https://ollama.com/download";
            try {
                Desktop desktop = Desktop.getDesktop();
                URI uri = new URI(url);
                desktop.browse(uri);
            }
            catch (Exception ex) {
                new ErrorDialog(ex, "unable to open the URL " + url);
            }
        }
        if (e.getSource() == this.view.getGenerateContentBtn()) {
            TalkWithAI generateText = new TalkWithAI();
            generateText.getDio().setVisible(true);
        }
    }
}

