/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.controller;

import com.arun.bhardwaj.controller.BackgroundTask;
import com.arun.bhardwaj.controller.RenewalViewController;
import com.arun.bhardwaj.exceptions.ServiceException;
import com.arun.bhardwaj.utility.AppUtility;
import com.arun.bhardwaj.utility.AutoResize;
import com.arun.bhardwaj.utility.UserCache;
import com.arun.bhardwaj.view.LoginView;
import com.arun.bhardwaj.view.common.ErrorDialog;
import com.arun.bhardwaj.view.legal.PrivacyPolicyView;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;

public class LoginController
implements ActionListener {
    private final LoginView view;

    public LoginController(LoginView view) {
        this.view = view;
        try {
            UserCache.loadUserDetails();
            this.showClientDetails();
            Thread thread = new Thread(new BackgroundTask());
            thread.start();
            view.getPrivacyPolicyButton().addActionListener(this);
            view.getExitButton().addActionListener(this);
            view.getRenewalButton().addActionListener(this);
        }
        catch (ServiceException e) {
            view.getLoginCardLayout().show(view.getLoginBasePanel(), "signUp");
        }
        LoginView.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                int result = JOptionPane.showConfirmDialog(LoginView.frame, "Are you sure you want to exit?", "Confirm Exit", 0);
                if (result == 0) {
                    int isBackup = JOptionPane.showConfirmDialog(LoginView.frame, "Would you like to take a backup?", "Confirm Exit", 0);
                    if (isBackup == 0) {
                        try {
                            AppUtility.createBackup();
                            JOptionPane.showMessageDialog(LoginView.frame, "Backup created successfully");
                        }
                        catch (IOException ex) {
                            new ErrorDialog(ex, ex.getMessage());
                        }
                    }
                    LoginView.frame.dispose();
                    System.exit(0);
                }
            }
        });
    }

    public LoginView getView() {
        return this.view;
    }

    public void showClientDetails() {
        try {
            if (UserCache.getValidity() <= 7L) {
                this.view.getUserDetailsLabel().setForeground(new Color(227, 3, 39, 255));
            } else {
                this.view.getUserDetailsLabel().setForeground(new Color(63, 151, 255, 255));
            }
            this.view.getUserDetailsLabel().setText(UserCache.getUserStatusDetails());
            InputStream inputStream = UserCache.getInputStreamLogoImage();
            if (inputStream != null) {
                BufferedImage image = ImageIO.read(inputStream);
                if (image != null) {
                    AutoResize responsiveImg = new AutoResize(image);
                    this.view.getClientLogo().removeAll();
                    this.view.getClientLogo().add(responsiveImg);
                    this.view.getClientLogo().revalidate();
                    this.view.getClientLogo().repaint();
                } else {
                    this.view.getClientLogo().removeAll();
                    this.view.getClientLogo().revalidate();
                    this.view.getClientLogo().repaint();
                }
            } else {
                this.view.getClientLogo().removeAll();
                this.view.getClientLogo().revalidate();
                this.view.getClientLogo().repaint();
            }
        }
        catch (IOException e) {
            new ErrorDialog(e, "showClientDetails");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int choice;
        Object obj = e.getSource();
        if (obj == this.view.getRenewalButton()) {
            RenewalViewController.userPassword = new String(LoginView.password);
            this.view.getCardLayout().show(this.view.getDetailBasePanel(), "login");
            this.view.getLoginCardLayout().show(this.view.getLoginBasePanel(), "renewalAccount");
        }
        if (obj == this.view.getPrivacyPolicyButton()) {
            if (AppUtility.isInternetConnected()) {
                new PrivacyPolicyView();
            } else {
                JOptionPane.showMessageDialog(LoginView.frame, "Please check your internet connection", "Error message", 0);
            }
        }
        if (obj == this.view.getExitButton() && (choice = JOptionPane.showConfirmDialog(LoginView.frame, "Are you sure you want to exit ?", "", 0)) == 0) {
            if (LoginView.isBackgroundProcessActive) {
                JOptionPane.showMessageDialog(LoginView.frame, "We're currently downloading and updating the software to enhance your experience.\nThis process may take up to 2 minutes.\nOnce the update is complete, Application will restart. then enjoy the latest features and improvements.\nWe appreciate your patience and thank you for choosing Real estate solution.\n", "In progress", 1);
            } else {
                int isBackup = JOptionPane.showConfirmDialog(LoginView.frame, "Would you like to take a backup?", "Confirm Exit", 0);
                if (isBackup == 0) {
                    try {
                        AppUtility.createBackup();
                        JOptionPane.showMessageDialog(LoginView.frame, "Backup created successfully");
                    }
                    catch (IOException ex) {
                        new ErrorDialog(ex, ex.getMessage());
                    }
                }
                LoginView.frame.dispose();
                System.exit(0);
            }
        }
    }
}

