/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.controller;

import com.arun.bhardwaj.controller.LoginController;
import com.arun.bhardwaj.exceptions.ServiceException;
import com.arun.bhardwaj.model.property.RenewalRequest;
import com.arun.bhardwaj.service.LoginService;
import com.arun.bhardwaj.service.LoginServiceImpl;
import com.arun.bhardwaj.utility.AppUtility;
import com.arun.bhardwaj.utility.AutoResize;
import com.arun.bhardwaj.utility.EmailUtility;
import com.arun.bhardwaj.utility.ReadEmailUtility;
import com.arun.bhardwaj.utility.UPIQRCodeGenerator;
import com.arun.bhardwaj.utility.UserCache;
import com.arun.bhardwaj.view.RenewalView;
import com.arun.bhardwaj.view.common.ErrorDialog;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.zxing.WriterException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.search.FlagTerm;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.Timer;

public class RenewalViewController
implements ActionListener {
    private RenewalView view;
    private int price;
    private String nextEffectiveDate;
    private LoginService loginService;
    protected static String userPassword;
    private String transactionId;

    public RenewalViewController(RenewalView view) {
        this.view = view;
        this.loginService = new LoginServiceImpl();
        view.getPayButton().addActionListener(this);
        view.getNoOfMonths().addActionListener(this);
        view.getValidatePayButton().addActionListener(this);
        view.getValidatePayButton().setToolTipText("Re-validate payment");
    }

    private void calculateAmount() {
        int durationsInMonth = (Integer)this.view.getNoOfMonths().getSelectedItem();
        if (durationsInMonth == 0) {
            this.view.getPayButton().setEnabled(false);
            this.view.getTotalAmountLabel().setVisible(false);
            this.view.getNextEffectiveDateLabel().setVisible(false);
        } else {
            this.view.getPayButton().setEnabled(true);
            this.view.getTotalAmountLabel().setVisible(true);
            this.view.getNextEffectiveDateLabel().setVisible(true);
        }
        int pricePerMonth = 825;
        int discount = 0;
        if (durationsInMonth == 3) {
            discount = 5;
        } else if (durationsInMonth == 6) {
            discount = 10;
        } else if (durationsInMonth == 12) {
            discount = 15;
        }
        int amount = pricePerMonth * durationsInMonth;
        int discountAmount = amount * discount / 100;
        int totalAmount = amount - discountAmount;
        this.setPrice(totalAmount);
        String totalAmountWithCurrencySymbol = AppUtility.getFormattedCurrency(String.valueOf(totalAmount));
        this.view.getQrCodeLabel().setIcon(null);
        if (durationsInMonth == 1) {
            this.view.getTotalAmountLabel().setText("Amount : " + totalAmountWithCurrencySymbol);
        } else {
            this.view.getTotalAmountLabel().setText("Amount : " + amount + " - " + discountAmount + " = " + totalAmountWithCurrencySymbol);
        }
        String effectiveDate = AppUtility.convertDatetoString(LocalDate.now().plusMonths(durationsInMonth));
        if (UserCache.getValidity() > 0L) {
            effectiveDate = AppUtility.convertDatetoString(LocalDate.now().plusDays(UserCache.getValidity()).plusMonths(durationsInMonth));
        }
        this.setNextEffectiveDate(effectiveDate);
        this.view.getNextEffectiveDateLabel().setText("Next effective date : " + effectiveDate);
    }

    private void initiateRenewal() throws ServiceException {
        LocalDate nextEffectiveDate = AppUtility.convertStringToDate(this.getNextEffectiveDate());
        LocalDate today = LocalDate.now();
        long daysDiff = ChronoUnit.DAYS.between(today, nextEffectiveDate);
        this.loginService.renewDatabase(daysDiff, userPassword);
        JOptionPane.showMessageDialog(this.view.getBasePanel(), "Success! Your subscription has been successfully renewed. \nEnjoy uninterrupted access to real estate software. \nThank you for your continued support! \n For security reasons, please log in again to continue using the application. ");
        new LoginController(this.view.getLoginView()).showClientDetails();
        System.exit(0);
    }

    private boolean isApprovalReceived(String transactionId) throws Exception {
        Message[] messages;
        boolean isApproved = false;
        Session session = ReadEmailUtility.getSession();
        Store store = session.getStore();
        store.connect();
        Folder inbox = store.getFolder("INBOX");
        inbox.open(2);
        for (Message message : messages = inbox.search(new FlagTerm(new Flags(Flags.Flag.SEEN), false))) {
            String subject = message.getSubject();
            String messageFrom = String.valueOf(message.getFrom()[0]);
            if (!subject.contains(transactionId) || !messageFrom.contains("shreetechnoworld@outlook.com") && !messageFrom.contains("admin@shreetechnoworld.com")) continue;
            isApproved = true;
            message.setFlag(Flags.Flag.SEEN, true);
        }
        inbox.close(false);
        store.close();
        return isApproved;
    }

    private void handlePayButton() {
        if (AppUtility.isInternetConnected()) {
            this.view.getErrorLabel().setText("");
            try {
                this.setTransactionId(AppUtility.generateTransactionId());
                String upiLink = "upi://pay?pa=Shreetechnoworld@airtel&pn=Arun&am=" + this.getPrice() + "&cu=INR";
                BufferedImage image = UPIQRCodeGenerator.generateQRCode(upiLink);
                ImageIcon icon = new ImageIcon(AutoResize.resize(image, 160, 130));
                this.view.getQrCodeLabel().setIcon(icon);
                this.view.getTimerLabel().setVisible(true);
                this.view.setMinutes(5);
                this.view.setSeconds(0);
                this.view.setTimer(new Timer(1000, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (RenewalViewController.this.view.getMinutes() == 0 && RenewalViewController.this.view.getSeconds() == 0) {
                            RenewalViewController.this.view.getTimer().stop();
                            JOptionPane.showMessageDialog(RenewalViewController.this.view.getBasePanel(), " Oops! It seems there was an issue processing your subscription purchase. \nDon't worry, your payment transaction has not been completed. \nPlease contact our support team for assistance. \nWe apologize for any inconvenience.\nTransaction id " + RenewalViewController.this.transactionId, "Transaction status", 1);
                            RenewalViewController.this.view.getPayButton().setVisible(false);
                            RenewalViewController.this.view.getValidatePayButton().setVisible(true);
                        } else {
                            if (RenewalViewController.this.view.getSeconds() == 0) {
                                RenewalViewController.this.view.setMinutes(RenewalViewController.this.view.getMinutes() - 1);
                                RenewalViewController.this.view.setSeconds(59);
                            } else {
                                if (RenewalViewController.this.view.getSeconds() % 10 == 0) {
                                    try {
                                        if (RenewalViewController.this.isApprovalReceived(RenewalViewController.this.getTransactionId())) {
                                            RenewalViewController.this.initiateRenewal();
                                            RenewalViewController.this.view.getTimer().stop();
                                        }
                                    }
                                    catch (Exception ex) {
                                        new ErrorDialog(ex, "Initiate renewal");
                                    }
                                }
                                RenewalViewController.this.view.setSeconds(RenewalViewController.this.view.getSeconds() - 1);
                            }
                            RenewalViewController.this.view.getTimerLabel().setText(AppUtility.formatTime(RenewalViewController.this.view.getMinutes(), RenewalViewController.this.view.getSeconds()));
                        }
                    }
                }));
                this.view.getTimer().start();
                this.view.getNoOfMonths().setEnabled(false);
                this.view.getPayButton().setEnabled(false);
                RenewalRequest renewalRequest = new RenewalRequest(this.transactionId, UserCache.getClientId(), UserCache.getRegisteredEmailId(), String.valueOf(ChronoUnit.DAYS.between(LocalDate.now(), AppUtility.convertStringToDate(this.getNextEffectiveDate()))), String.valueOf(UserCache.getValidity()), this.getNextEffectiveDate(), String.valueOf(this.getPrice()));
                ObjectMapper objectMapper = new ObjectMapper();
                objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
                EmailUtility.sendEmailToRES("Request for renewal by " + renewalRequest.email(), objectMapper.writeValueAsString(renewalRequest));
            }
            catch (WriterException | IOException ex) {
                new ErrorDialog(ex, "Payment QR Generation");
            }
        } else {
            this.view.getErrorLabel().setText("Please check your internet connection");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj == this.view.getValidatePayButton()) {
            try {
                if (this.isApprovalReceived(this.getTransactionId())) {
                    this.initiateRenewal();
                } else {
                    JOptionPane.showMessageDialog(this.view.getBasePanel(), " Oops! It seems there was an issue processing your subscription purchase. \nDon't worry, your payment transaction has not been completed. \nPlease contact our support team for assistance. \nWe apologize for any inconvenience.\nTransaction id " + this.getTransactionId(), "Transaction status", 1);
                }
            }
            catch (Exception ex) {
                new ErrorDialog(ex, "Payment re-validate ");
            }
        }
        if (obj == this.view.getNoOfMonths()) {
            this.calculateAmount();
        }
        if (obj == this.view.getPayButton()) {
            this.handlePayButton();
        }
    }

    public int getPrice() {
        return this.price;
    }

    public void setPrice(int price) {
        this.price = price;
    }

    public String getNextEffectiveDate() {
        return this.nextEffectiveDate;
    }

    public void setNextEffectiveDate(String nextEffectiveDate) {
        this.nextEffectiveDate = nextEffectiveDate;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }
}

