/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.controller;

import com.arun.bhardwaj.cache.ArchitectNamesCache;
import com.arun.bhardwaj.cache.BuilderNamesCache;
import com.arun.bhardwaj.cache.ContactGroupCache;
import com.arun.bhardwaj.cache.ProjectGroupCache;
import com.arun.bhardwaj.cache.PropertyGroupCache;
import com.arun.bhardwaj.controller.RenewalViewController;
import com.arun.bhardwaj.exceptions.ServiceException;
import com.arun.bhardwaj.service.LoginService;
import com.arun.bhardwaj.service.LoginServiceImpl;
import com.arun.bhardwaj.utility.UserCache;
import com.arun.bhardwaj.view.InnerPanelView;
import com.arun.bhardwaj.view.LoginView;
import com.arun.bhardwaj.view.SignInView;
import com.arun.bhardwaj.view.common.ErrorDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JOptionPane;

public class SignInController
implements ActionListener,
KeyListener {
    private final SignInView view;
    private final LoginView loginView;
    private final LoginService loginService;
    private String userName;

    public SignInController(SignInView view) {
        this.view = view;
        this.loginView = view.getLoginView();
        this.loginService = new LoginServiceImpl();
        this.setUserName(UserCache.getUserName());
        this.view.getUserNameLabel().setText(UserCache.getUserName());
        view.getIsAdmin().addActionListener(this);
        view.getSignInButton().addActionListener(this);
        view.getForgetPasswordButton().addActionListener(this);
        view.getPasswordField().addKeyListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.view.getIsAdmin()) {
            this.handleIsAdmin();
        }
        if (e.getSource() == this.view.getSignInButton()) {
            this.handleSignIn();
        }
        if (e.getSource() == this.view.getForgetPasswordButton()) {
            this.handleForgetPassword();
        }
    }

    private void handleForgetPassword() {
        this.loginView.getLoginCardLayout().show(this.loginView.getLoginBasePanel(), "forgetPassword");
    }

    private void handleSignIn() {
        if (this.view.getIsAdmin().isSelected()) {
            if (this.view.getPasswordField().getPassword().length == 0) {
                this.showErrorMessage("Password is mandatory");
                this.view.getPasswordField().requestFocus();
                return;
            }
        } else {
            if (this.view.getUserNameField().getText().isBlank()) {
                this.showErrorMessage("Username is mandatory");
                this.view.getUserNameField().requestFocus();
                return;
            }
            if (this.view.getPasswordField().getPassword().length == 0) {
                this.showErrorMessage("Password is mandatory");
                this.view.getPasswordField().requestFocus();
                return;
            }
        }
        try {
            if (this.loginService.validateUser(new String(this.view.getPasswordField().getPassword()))) {
                if (UserCache.getValidity() <= 5L && UserCache.getValidity() > 0L) {
                    int choice = JOptionPane.showConfirmDialog(LoginView.frame, "We've noticed that your account is set to expire in " + UserCache.getValidity() + " days. \n\n To ensure uninterrupted access, we invite you to take immediate action and renew your subscription. This will not only prevent any disruption but also guarantee continued access to our services.", "", 0);
                    if (choice == 0) {
                        RenewalViewController.userPassword = new String(this.view.getPasswordField().getPassword());
                        this.view.getLoginView().getLoginCardLayout().show(this.view.getLoginView().getLoginBasePanel(), "renewalAccount");
                    } else {
                        this.executeInnerPanel();
                    }
                } else if (UserCache.getValidity() <= 0L) {
                    RenewalViewController.userPassword = new String(this.view.getPasswordField().getPassword());
                    this.view.getLoginView().getLoginCardLayout().show(this.view.getLoginView().getLoginBasePanel(), "renewalAccount");
                } else {
                    this.executeInnerPanel();
                }
            } else {
                this.showErrorMessage("Wrong password");
            }
        }
        catch (ServiceException e) {
            new ErrorDialog(e, "Validate user");
        }
        catch (Exception e) {
            new ErrorDialog(e, "Validate user and load initial project details");
        }
    }

    private void executeInnerPanel() throws Exception {
        PropertyGroupCache.loadPropertyGroup();
        ProjectGroupCache.loadProjectType();
        ContactGroupCache.loadContactGroups();
        BuilderNamesCache.loadBuilderName();
        ArchitectNamesCache.loadArchitectName();
        this.view.getLoginView();
        LoginView.getInnerPanel().add(new InnerPanelView());
        LoginView.password = new String(this.view.getPasswordField().getPassword());
        this.view.getLoginView().getRenewalButton().setVisible(true);
        this.view.getLoginView().getCardLayout().show(this.view.getLoginView().getDetailBasePanel(), "inner");
    }

    private void showErrorMessage(String message) {
        JOptionPane.showMessageDialog(this.view.getBasePanel(), message, "Error", 0);
    }

    private void handleIsAdmin() {
        this.view.getUserNameLabel().setText(this.view.getIsAdmin().isSelected() ? this.getUserName() : "Username");
        this.view.getUserNameField().setVisible(!this.view.getIsAdmin().isSelected());
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        Object obj = e.getSource();
        if (obj == this.view.getPasswordField() && e.getKeyCode() == 10) {
            this.handleSignIn();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

