/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.controller;

import com.arun.bhardwaj.exceptions.ServiceException;
import com.arun.bhardwaj.model.UserDetails;
import com.arun.bhardwaj.service.LoginService;
import com.arun.bhardwaj.service.LoginServiceImpl;
import com.arun.bhardwaj.utility.AppUtility;
import com.arun.bhardwaj.utility.EmailUtility;
import com.arun.bhardwaj.utility.UserCache;
import com.arun.bhardwaj.view.SignUpView;
import com.arun.bhardwaj.view.common.ChooseImage;
import com.arun.bhardwaj.view.common.ErrorDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.time.LocalDate;
import javax.swing.JOptionPane;

public class SignUpController
implements ActionListener {
    private final SignUpView view;
    private String logoPath;
    private String generatedOtp;
    private String enteredEmailId;
    private LoginService service;

    public SignUpController(SignUpView view) {
        this.view = view;
        this.service = new LoginServiceImpl();
        view.getSignUpButton().addActionListener(this);
        view.getSelectLogoButton().addActionListener(this);
        view.getDeleteLogoButton().addActionListener(this);
        view.getSendOTPButton().addActionListener(this);
    }

    private void handleSignUp() {
        String userName = this.view.getUserNameField().getText().trim();
        String address = this.view.getAddressTextArea().getText().trim();
        String contactNo = this.view.getMobileNoField().getText().trim();
        String password = new String(this.view.getPasswordField().getPassword()).trim();
        String email = this.view.getEmailField().getText().trim();
        String emailOtp = this.view.getEmailOTPField().getText().trim();
        if (userName.isEmpty() || address.isEmpty() || contactNo.isEmpty() || password.isEmpty() || email.isEmpty() || emailOtp.isEmpty()) {
            JOptionPane.showMessageDialog(this.view.getBasePanel(), "All fields are mandatory. Please fill in all details.", "Error", 0);
            return;
        }
        if (!contactNo.matches("\\d+")) {
            JOptionPane.showMessageDialog(this.view.getBasePanel(), "Contact number must be numeric.", "Error", 0);
            this.view.getMobileNoField().requestFocus();
            return;
        }
        if (!email.matches("^[\\w.%+-]+@[\\w.-]+\\.[a-zA-Z]{2,6}$")) {
            JOptionPane.showMessageDialog(this.view.getBasePanel(), "Please enter a valid email address.", "Error", 0);
            this.view.getEmailField().requestFocus();
            return;
        }
        if (!emailOtp.matches("\\d{4}")) {
            JOptionPane.showMessageDialog(this.view.getBasePanel(), "Email OTP must be a 4-digit numeric value.", "Error", 0);
            this.view.getEmailOTPField().requestFocus();
            return;
        }
        if (email.equals(this.getEnteredEmailId()) && emailOtp.equals(this.getGeneratedOtp())) {
            UserDetails userDetails = new UserDetails.Builder().userName(userName).address(address).password(password).email(email).logoPath(this.getLogoPath() == null ? "" : this.getLogoPath()).mobileNo(contactNo).clientId(AppUtility.generateTransactionId()).effectiveTill(AppUtility.convertDatetoString(LocalDate.now().plusDays(9L))).build();
            try {
                this.service.createUserWithDatabase(userDetails);
                JOptionPane.showMessageDialog(this.view.getBasePanel(), "Login created successfully", "Success", 1);
                UserCache.loadUserDetails();
                this.view.getLoginView().getLoginCardLayout().show(this.view.getLoginView().getLoginBasePanel(), "signIn");
                this.view.getLoginView().getController().showClientDetails();
            }
            catch (ServiceException ex) {
                new ErrorDialog(ex, "User creation");
            }
        } else {
            JOptionPane.showMessageDialog(this.view.getBasePanel(), "The entered email OTP is incorrect..", "Error", 0);
        }
    }

    private void handleDeleteLogo() {
        this.view.getClientLogo().removeAll();
        this.view.getClientLogo().repaint();
        this.view.getClientLogo().revalidate();
        this.setLogoPath("");
        this.view.getDeleteLogoButton().setVisible(false);
        this.view.getSelectLogoButton().setVisible(true);
    }

    private void handleGenerateAndSendOTPOnEmail() {
        try {
            String email = this.view.getEmailField().getText().trim();
            if (email.isBlank()) {
                this.showErrorMessage("Email is mandatory");
                this.view.getEmailField().requestFocus();
                return;
            }
            if (!AppUtility.isValidEmail(email)) {
                this.showErrorMessage("Email is not valid");
                this.view.getEmailField().requestFocus();
                return;
            }
            String message = String.format("<html>Please confirm your email is <b>%s</b> to receive the OTP.</html>", email);
            int choice = JOptionPane.showConfirmDialog(this.view.getBasePanel(), message, "Send OTP", 1);
            if (choice == 0) {
                this.generateOTPAndSendEmail();
                JOptionPane.showMessageDialog(this.view.getBasePanel(), "An OTP has been sent.\nPlease also check your junk or spam folder if you don't see it in your inbox.", "OTP Sent", 1);
                this.view.getEmailOTPField().requestFocus();
                this.setEnteredEmailId(email);
            }
        }
        catch (Exception ex) {
            this.showErrorMessage("Unable to send OTP. Please check your connection.");
        }
    }

    private void generateOTPAndSendEmail() {
        StringBuilder message = new StringBuilder();
        char[] generatedOTP = AppUtility.generateOTP(4);
        this.setGeneratedOtp(String.valueOf(generatedOTP));
        message.append("<p>Your  OTP to verify your email for Real Estate Solutions </p>");
        message.append("<h2>");
        message.append(generatedOTP);
        message.append("</h2>");
        message.append("<p>Sincerely, </p> <p>Team Real Estate Solutions </p> <p> Mob: <a href='https://wa.me/8800776704'>8800776704 </a> </p>");
        message.append("<p> Email <a href='mailto:support@shreetechnoworld.com'>support@shreetechnoworld.com </a></p>");
        message.append("<p> Website <a href='https://www.shreetechnoworld.com'>shreetechnoworld.com </a></p>");
        message.append("<p><h6> This is a system generated mail. Please don't reply. </h6> </p>");
        EmailUtility.sendEmailToClient(this.view.getEmailField().getText(), "Your Real Estate Solutions One Time Password ", message.toString());
    }

    private void showErrorMessage(String message) {
        JOptionPane.showMessageDialog(this.view.getBasePanel(), message, "Error", 0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.view.getSignUpButton()) {
            this.handleSignUp();
        }
        if (e.getSource() == this.view.getSelectLogoButton()) {
            new ChooseImage(this, "Choose logo");
        }
        if (e.getSource() == this.view.getDeleteLogoButton()) {
            this.handleDeleteLogo();
        }
        if (e.getSource() == this.view.getSendOTPButton()) {
            this.handleGenerateAndSendOTPOnEmail();
        }
    }

    public SignUpView getView() {
        return this.view;
    }

    public String getLogoPath() {
        return this.logoPath;
    }

    public void setLogoPath(String logoPath) {
        this.logoPath = logoPath;
    }

    public String getGeneratedOtp() {
        return this.generatedOtp;
    }

    public void setGeneratedOtp(String generatedOtp) {
        this.generatedOtp = generatedOtp;
    }

    public String getEnteredEmailId() {
        return this.enteredEmailId;
    }

    public void setEnteredEmailId(String enteredEmailId) {
        this.enteredEmailId = enteredEmailId;
    }
}

