/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.controller.ai;

import com.arun.bhardwaj.utility.AppUtility;
import com.arun.bhardwaj.view.ai.TalkWithAI;
import com.arun.bhardwaj.view.common.ErrorDialog;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TalkWithAIController
implements ActionListener,
KeyListener,
FocusListener {
    private TalkWithAI view;
    private StringBuffer conversation;
    private Timer timer;
    private int colorIndex = 0;
    private static final Color[] colors = new Color[]{Color.RED, Color.GREEN, Color.BLUE, Color.ORANGE, Color.MAGENTA};
    private List<String> urlInput = new ArrayList<String>();
    private String fileInput;

    public TalkWithAIController(final TalkWithAI view) {
        this.view = view;
        view.getGenerateTextBtn().addActionListener(this);
        view.getCopyToClipboard().addActionListener(this);
        view.getDownloadModelBtn().addActionListener(this);
        view.getNewChatBtn().addActionListener(this);
        view.getPromtField().addKeyListener(this);
        view.getPromtField().addFocusListener(this);
        view.getUrlField().addFocusListener(this);
        view.getSourceDropdown().addActionListener(this);
        this.conversation = new StringBuffer();
        this.timer = new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                view.getAnimatedEditorPanel().setBackground(colors[TalkWithAIController.this.colorIndex]);
                TalkWithAIController.this.colorIndex = (TalkWithAIController.this.colorIndex + 1) % colors.length;
            }
        });
        this.modifyScreen();
    }

    private void modifyScreen() {
        if (this.checkModelAvailable()) {
            this.view.getDownloadModelBtn().setVisible(false);
            this.view.getCopyToClipboard().setVisible(true);
            this.view.getPromtField().setEditable(true);
            this.view.getGenerateTextBtn().setVisible(true);
            this.view.getNewChatBtn().setEnabled(false);
            this.view.getCopyToClipboard().setEnabled(false);
        } else {
            this.view.getDownloadModelBtn().setVisible(true);
            this.view.getCopyToClipboard().setVisible(false);
            this.view.getPromtField().setEditable(false);
            this.view.getGenerateTextBtn().setVisible(false);
            this.view.getNewChatBtn().setVisible(false);
        }
    }

    private boolean checkModelAvailable() {
        boolean result = false;
        try {
            String output;
            String urlString = "http://localhost:11434/api/tags";
            URL url = new URL(urlString);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json");
            if (conn.getResponseCode() != 200) {
                throw new RuntimeException("Failed : HTTP error code : " + conn.getResponseCode());
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((output = br.readLine()) != null) {
                response.append(output);
            }
            conn.disconnect();
            JSONObject jsonResponse = new JSONObject(response.toString());
            JSONArray models = jsonResponse.getJSONArray("models");
            for (int i = 0; i < models.length(); ++i) {
                JSONObject model = models.getJSONObject(i);
                if (!model.getString("name").equals("llama3.2:latest")) continue;
                result = true;
                break;
            }
        }
        catch (Exception e) {
            new ErrorDialog(e, "validate model");
        }
        return result;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.view.getSourceDropdown()) {
            String selectedOption = (String)this.view.getSourceDropdown().getSelectedItem();
            if ("URL".equals(selectedOption)) {
                this.view.getUrlField().setEditable(true);
                this.view.getUrlField().setText("Enter URL");
            } else if ("File".equals(selectedOption)) {
                this.openFile();
            } else {
                this.view.getUrlField().setEditable(false);
                this.view.getUrlField().setText("");
            }
        }
        if (e.getSource() == this.view.getNewChatBtn()) {
            this.view.getEditorPane().setText("");
            this.conversation.setLength(0);
            this.view.getNewChatBtn().setEnabled(false);
            this.view.getCopyToClipboard().setEnabled(false);
            this.urlInput.clear();
        }
        if (e.getSource() == this.view.getDownloadModelBtn()) {
            this.view.getDownloadModelBtn().setEnabled(false);
            this.timer.start();
            SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){
                private boolean errorStatus;

                @Override
                protected Void doInBackground() throws Exception {
                    try {
                        String errorLine;
                        String[] command = new String[]{"ollama", "pull", "llama3.2:latest"};
                        ProcessBuilder builder = new ProcessBuilder(command);
                        Process process = builder.start();
                        BufferedReader errorReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                        StringBuilder errorOutput = new StringBuilder();
                        while ((errorLine = errorReader.readLine()) != null) {
                            errorOutput.append(errorLine).append("\n");
                        }
                        int exitCode = process.waitFor();
                        if (process.exitValue() != 0) {
                            String troubleShooting = "1. Make sure you have Ollama installed: If you don't have Ollama installed, you can download it from ollama.com.\n2. Execute the command: Once installed, open your terminal (Command Prompt for Windows, Terminal for macOS or Linux), and run the following command:\n3. ollama pull llama3.2:latest\nThis command will fetch the latest version of the LLaMA model, which should resolve the issue.\nIf you're still encountering issues, ensure that:\n* Your internet connection is stable.\n* Ollama has the correct permissions to access the necessary resources.\n";
                            TalkWithAIController.this.view.getEditorPane().setText(troubleShooting);
                            this.errorStatus = true;
                        }
                    }
                    catch (IOException | InterruptedException ex) {
                        this.errorStatus = true;
                        new ErrorDialog(ex, "Error in download model");
                    }
                    return null;
                }

                @Override
                protected void done() {
                    if (!this.errorStatus) {
                        JOptionPane.showMessageDialog(TalkWithAIController.this.view.getDio(), "Downloaded successfully");
                    }
                    TalkWithAIController.this.view.getDownloadModelBtn().setEnabled(true);
                    TalkWithAIController.this.modifyScreen();
                    TalkWithAIController.this.timer.stop();
                    TalkWithAIController.this.view.getAnimatedEditorPanel().setBackground(null);
                }
            };
            worker.execute();
        }
        if (e.getSource() == this.view.getCopyToClipboard()) {
            String selectedText = this.view.getEditorPane().getSelectedText();
            if (selectedText != null && !selectedText.isEmpty()) {
                StringSelection stringSelection = new StringSelection(selectedText);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(stringSelection, null);
                JOptionPane.showMessageDialog(this.view.getDio(), "copied", "Warning", 2);
            } else {
                JOptionPane.showMessageDialog(this.view.getDio(), "No text selected!", "Warning", 2);
            }
        }
        if (e.getSource() == this.view.getGenerateTextBtn() && !"Ask your query here".equals(this.view.getPromtField().getText())) {
            if ("URL".equals(this.view.getSourceDropdown().getSelectedItem())) {
                try {
                    if (!AppUtility.isValidURL(this.view.getUrlField().getText())) {
                        JOptionPane.showMessageDialog(this.view.getDio(), "Invalid URL", "Error", 0);
                        return;
                    }
                }
                catch (IOException | URISyntaxException ex) {
                    new ErrorDialog(ex, "validate URL and its data");
                    return;
                }
            }
            this.timer.start();
            this.view.getGenerateTextBtn().setEnabled(false);
            this.view.getPromtField().setEditable(false);
            this.view.getNewChatBtn().setEnabled(true);
            this.view.getCopyToClipboard().setEnabled(true);
            new TaskCallAIWorker().execute();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        Object obj = e.getSource();
        if (obj == this.view.getPromtField() && e.getKeyCode() == 10) {
            this.timer.start();
            this.view.getGenerateTextBtn().setEnabled(false);
            this.view.getPromtField().setEditable(false);
            this.view.getNewChatBtn().setEnabled(true);
            this.view.getCopyToClipboard().setEnabled(true);
            new TaskCallAIWorker().execute();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (e.getSource() == this.view.getPromtField()) {
            if (!"Ask your query here".equals(this.view.getPromtField().getText())) {
                return;
            }
            this.view.getPromtField().setText("");
        }
        if (e.getSource() == this.view.getUrlField()) {
            if (!"Enter URL".equals(this.view.getUrlField().getText())) {
                return;
            }
            this.view.getUrlField().setText("");
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getSource() == this.view.getPromtField() && this.view.getPromtField().getText().isEmpty()) {
            this.view.getPromtField().setText("Ask your query here");
        }
        if (e.getSource() == this.view.getUrlField() && this.view.getUrlField().getText().isEmpty()) {
            this.view.getUrlField().setText("Enter URL");
        }
    }

    public List<String> readAndExtractParagraphs(String urlInput) throws IOException {
        URL url = new URL(urlInput);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        if (connection.getResponseCode() != 200) {
            throw new IOException("Failed to fetch data from URL. HTTP Code: " + connection.getResponseCode());
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            String line;
            StringBuilder content = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                content.append(line);
            }
            ArrayList<String> paragraphs = new ArrayList<String>();
            Pattern pattern = Pattern.compile("<p\\b[^>]*>(.*?)</p>", 32);
            Matcher matcher = pattern.matcher(content);
            while (matcher.find()) {
                String paragraph = matcher.group(1).replaceAll("<[^>]*>", "").trim();
                if (paragraph.isEmpty()) continue;
                paragraphs.add(paragraph);
            }
            ArrayList<String> arrayList = paragraphs;
            return arrayList;
        }
    }

    private void openFile() {
        JFileChooser fileChooser = new JFileChooser();
        int result = fileChooser.showOpenDialog(this.view.getDio());
        if (result == 0) {
            File file = fileChooser.getSelectedFile();
            try {
                String fileType = Files.probeContentType(file.toPath());
                this.view.getUrlField().setText(file.getAbsolutePath());
                this.fileInput = "";
                if (fileType != null && fileType.contains("pdf")) {
                    this.fileInput = this.readPdfFile(file);
                } else if (fileType != null && fileType.contains("json")) {
                    this.fileInput = this.readJsonFile(file);
                } else if (fileType != null && (fileType.contains("xml") || fileType.equals("application/xml"))) {
                    this.fileInput = this.readXmlFile(file);
                } else if (fileType != null && fileType.contains("csv")) {
                    this.fileInput = this.readCsvFile(file);
                } else if (fileType != null && fileType.contains("text")) {
                    this.fileInput = this.readTextFile(file);
                } else {
                    JOptionPane.showMessageDialog(this.view.getDio(), "Unsupported file type", "Warning", 2);
                }
            }
            catch (Exception ex) {
                new ErrorDialog(ex, "read data from file");
            }
        }
    }

    private String readPdfFile(File file) throws IOException {
        try (PDDocument document = PDDocument.load(file);){
            PDFTextStripper pdfStripper = new PDFTextStripper();
            String string = pdfStripper.getText(document);
            return string;
        }
    }

    private String readJsonFile(File file) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        Object json = objectMapper.readValue(file, Object.class);
        return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(json);
    }

    private String readXmlFile(File file) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(file);
        NodeList nodeList = doc.getElementsByTagName("*");
        StringBuilder content = new StringBuilder();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            content.append(nodeList.item(i).getTextContent()).append("\n");
        }
        return content.toString();
    }

    private String readCsvFile(File file) throws IOException {
        List<String> lines = Files.readAllLines(file.toPath());
        StringBuilder csvContent = new StringBuilder();
        for (String line : lines) {
            csvContent.append(line).append("\n");
        }
        return csvContent.toString();
    }

    private String readTextFile(File file) throws IOException {
        return new String(Files.readAllBytes(file.toPath()));
    }

    private class TaskCallAIWorker
    extends SwingWorker<Void, Void> {
        private TaskCallAIWorker() {
        }

        @Override
        protected Void doInBackground() throws Exception {
            HttpClient client = HttpClient.newHttpClient();
            ObjectMapper objectMapper = new ObjectMapper();
            ObjectNode payload = objectMapper.createObjectNode();
            payload.put("model", "llama3.2:latest");
            if ("URL".equals(TalkWithAIController.this.view.getSourceDropdown().getSelectedItem())) {
                TalkWithAIController.this.urlInput = TalkWithAIController.this.readAndExtractParagraphs(TalkWithAIController.this.view.getUrlField().getText());
                payload.put("prompt", TalkWithAIController.this.urlInput.stream().collect(Collectors.joining()) + " : " + TalkWithAIController.this.view.getPromtField().getText());
                TalkWithAIController.this.conversation.append("You :").append(TalkWithAIController.this.view.getPromtField().getText()).append(" ( source : ").append(TalkWithAIController.this.view.getUrlField().getText()).append(" )");
            } else if ("File".equals(TalkWithAIController.this.view.getSourceDropdown().getSelectedItem())) {
                payload.put("prompt", TalkWithAIController.this.fileInput + " : " + TalkWithAIController.this.view.getPromtField().getText());
                TalkWithAIController.this.conversation.append("You :").append(TalkWithAIController.this.view.getPromtField().getText()).append(" ( source : ").append(TalkWithAIController.this.view.getUrlField().getText()).append(" )");
            } else {
                payload.put("prompt", TalkWithAIController.this.conversation.toString() + "  " + TalkWithAIController.this.view.getPromtField().getText());
                TalkWithAIController.this.conversation.append("You :").append(TalkWithAIController.this.view.getPromtField().getText());
            }
            TalkWithAIController.this.conversation.append("\n");
            payload.put("temperature", 1);
            payload.put("stream", false);
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create("http://localhost:11434/api/generate")).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(payload.toString())).build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() == 200) {
                JsonNode jsonResponse = objectMapper.readTree(response.body());
                String assistantMessage = jsonResponse.get("response").asText();
                TalkWithAIController.this.view.getEditorPane().setText("");
                TalkWithAIController.this.conversation.append("System :").append(assistantMessage);
                TalkWithAIController.this.conversation.append("\n \n");
                TalkWithAIController.this.view.getEditorPane().setText(TalkWithAIController.this.conversation.toString());
            } else {
                TalkWithAIController.this.view.getEditorPane().setText("Failed to get a response. Status Code: " + response.statusCode());
                TalkWithAIController.this.timer.stop();
                TalkWithAIController.this.view.getAnimatedEditorPanel().setBackground(null);
            }
            return null;
        }

        @Override
        protected void done() {
            TalkWithAIController.this.timer.stop();
            TalkWithAIController.this.view.getAnimatedEditorPanel().setBackground(null);
            TalkWithAIController.this.view.getGenerateTextBtn().setEnabled(true);
            TalkWithAIController.this.view.getPromtField().setEditable(true);
            TalkWithAIController.this.view.getPromtField().setText("");
            TalkWithAIController.this.view.getPromtField().setFocusable(true);
        }
    }
}

