/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.controller.common;

import com.arun.bhardwaj.controller.SignUpController;
import com.arun.bhardwaj.utility.AutoResize;
import com.arun.bhardwaj.view.common.ChooseImage;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileNameExtensionFilter;

public class ChooseImageController
implements ActionListener {
    private final ChooseImage view;
    private String imagePath;
    private BufferedImage selectedImage;
    private String lastOpenedDirectory;

    public ChooseImageController(ChooseImage view) {
        this.view = view;
        this.initializeListeners();
    }

    private void initializeListeners() {
        this.view.getBrowseBtn().addActionListener(this);
        this.view.getSelectBtn().addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.view.getBrowseBtn()) {
            this.handleBrowseAction();
        } else if (source == this.view.getSelectBtn()) {
            this.handleSelectAction();
        }
    }

    private void handleBrowseAction() {
        JFileChooser chooser = new JFileChooser();
        if (this.lastOpenedDirectory != null && !this.lastOpenedDirectory.isEmpty()) {
            chooser.setCurrentDirectory(new File(this.lastOpenedDirectory));
        }
        chooser.setFileFilter(new FileNameExtensionFilter("Image Files (JPG, JPEG, GIF, PNG)", "jpg", "jpeg", "gif", "png"));
        if (chooser.showOpenDialog(this.view.getBrowseBtn()) == 0) {
            this.lastOpenedDirectory = chooser.getSelectedFile().getParent();
            File selectedFile = chooser.getSelectedFile();
            try {
                this.loadAndDisplayImage(selectedFile);
            }
            catch (IOException ex) {
                this.showErrorDialog("Error while choosing the file: " + ex.getMessage());
            }
        }
    }

    private void loadAndDisplayImage(File file) throws IOException {
        BufferedImage image = ImageIO.read(file);
        AutoResize responsiveImg = new AutoResize(image);
        this.setImagePath(file.getPath());
        this.setSelectedImage(image);
        JPanel previewPanel = this.view.getPreviewPanel();
        previewPanel.removeAll();
        previewPanel.add(responsiveImg);
        previewPanel.revalidate();
        previewPanel.repaint();
        new ImageIcon(AutoResize.resize(image, 70, 60)).getImage().flush();
        this.view.getSelectBtn().setVisible(true);
    }

    private void handleSelectAction() {
        Object object = this.view.getCallingObject();
        if (object instanceof SignUpController) {
            SignUpController controller = (SignUpController)object;
            this.updateRegistrationLogo(controller);
        }
        this.view.getDio().setVisible(false);
    }

    private void updateRegistrationLogo(SignUpController controller) {
        AutoResize responsiveImg = new AutoResize(this.getSelectedImage());
        JPanel clientLogo = controller.getView().getClientLogo();
        clientLogo.removeAll();
        clientLogo.add(responsiveImg);
        clientLogo.revalidate();
        clientLogo.repaint();
        controller.setLogoPath(this.getImagePath());
        controller.getView().getSelectLogoButton().setVisible(false);
        controller.getView().getDeleteLogoButton().setVisible(true);
    }

    private void showErrorDialog(String message) {
        JOptionPane.showMessageDialog(this.view.getPreviewPanel(), message, "Error Message", 0);
    }

    public String getImagePath() {
        return this.imagePath;
    }

    public void setImagePath(String imagePath) {
        this.imagePath = imagePath;
    }

    public BufferedImage getSelectedImage() {
        return this.selectedImage;
    }

    public void setSelectedImage(BufferedImage selectedImage) {
        this.selectedImage = selectedImage;
    }
}

