/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.controller.common;

import com.arun.bhardwaj.model.contact.ContactAdditionalInfo;
import com.arun.bhardwaj.model.contact.ContactAddress;
import com.arun.bhardwaj.model.contact.ContactDetails;
import com.arun.bhardwaj.model.contact.ContactEvent;
import com.arun.bhardwaj.model.contact.ContactLinks;
import com.arun.bhardwaj.model.contact.ContactNumber;
import com.arun.bhardwaj.service.contact.ContactRecordService;
import com.arun.bhardwaj.service.contact.ContactRecordServiceImpl;
import com.arun.bhardwaj.service.contact.ContactService;
import com.arun.bhardwaj.service.contact.ContactServiceImpl;
import com.arun.bhardwaj.service.property.PropertyService;
import com.arun.bhardwaj.service.property.PropertyServiceImpl;
import com.arun.bhardwaj.utility.AppUtility;
import com.arun.bhardwaj.utility.AutoResize;
import com.arun.bhardwaj.view.common.ContactDetailsView;
import com.arun.bhardwaj.view.common.ErrorDialog;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.event.HyperlinkEvent;

public class ContactDetailsController
implements ActionListener {
    private final ContactDetailsView view;
    private final ContactRecordService service;
    private final ContactService contactService;
    private final PropertyService propertyService;
    private final List<String> contactNumbers = new ArrayList<String>();
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public ContactDetailsController(ContactDetailsView view) {
        this.view = view;
        this.service = new ContactRecordServiceImpl();
        this.contactService = new ContactServiceImpl();
        this.propertyService = new PropertyServiceImpl();
        view.getSendButton().addActionListener(this);
        view.getShowImage().addActionListener(this);
        view.getClosePicDio().addActionListener(this);
        view.getShareItOnWhatsApp().addActionListener(this);
        view.getSaveImageDio().addActionListener(this);
        view.getContent().addHyperlinkListener(e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                AppUtility.openWebPage(e.getURL().toString());
            }
        });
        try {
            this.loadContactDetails();
            this.fetchPropertyCountByContactId();
        }
        catch (Exception e2) {
            JOptionPane.showMessageDialog(view.getDio(), e2.getMessage(), "Error", 0);
        }
    }

    private void fetchPropertyCountByContactId() throws Exception {
        int propertyCount = this.propertyService.fetchPropertyCountByContactId(this.view.getContactId());
        if (propertyCount == 1) {
            this.view.getPropertyCountLabel().setText(propertyCount + " Property");
        } else if (propertyCount > 1) {
            this.view.getPropertyCountLabel().setText(propertyCount + " Properties");
        } else {
            this.view.getPropertyCountLabel().setText("");
        }
    }

    private void loadContactDetails() throws Exception {
        InputStream inputStream = this.contactService.getImage(this.view.getContactId());
        if (inputStream != null) {
            BufferedImage image = ImageIO.read(inputStream);
            if (image != null) {
                AutoResize responsiveImg1 = new AutoResize(image);
                this.view.getImagePanel().removeAll();
                this.view.getImagePanel().add(responsiveImg1);
                this.view.getImagePanel().revalidate();
                this.view.getImagePanel().repaint();
                AutoResize responsiveImg = new AutoResize(image);
                this.view.getPicPanel().removeAll();
                this.view.getPicPanel().add(responsiveImg);
                this.view.getPicPanel().revalidate();
                this.view.getPicPanel().repaint();
                this.view.getShowImage().setVisible(true);
            } else {
                this.view.getImagePanel().removeAll();
                this.view.getImagePanel().add(new JLabel(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/photo-l.png")))));
                this.view.getImagePanel().revalidate();
                this.view.getImagePanel().repaint();
                this.view.getShowImage().setVisible(false);
            }
        } else {
            this.view.getImagePanel().removeAll();
            this.view.getImagePanel().add(new JLabel(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/photo-l.png")))));
            this.view.getImagePanel().revalidate();
            this.view.getImagePanel().repaint();
        }
        ContactDetails contactDetails = new ContactDetails.Builder().contactRecord(this.service.fetchContactBasicDetails(this.view.getContactId())).contactAddress(this.service.loadContactAddress(this.view.getContactId())).contactNumber(this.service.loadContacts(this.view.getContactId())).contactLinks(this.service.loadLinks(this.view.getContactId())).contactEvents(this.service.loadEvents(this.view.getContactId())).contactAdditionalInfo(this.service.loadAdditionalInfo(this.view.getContactId())).build();
        StringBuilder messageBuilder = new StringBuilder();
        this.view.getDio().setTitle("Details :" + contactDetails.contactRecord().name() + " - " + contactDetails.contactRecord().groupName());
        StringBuilder details = new StringBuilder();
        details.append("<!DOCTYPE html>\n<html>\n<head>\n    <title>User Details</title>\n    <style>\n        body {\n            font-family: Arial, sans-serif;\n            margin: 0;\n            padding: 0;\n        }\n\n        .container {\n            max-width: 800px;\n            margin: 0 auto;\n            background-color: #fff;\n            padding: 10px;\n            border-radius: 10px;\n            box-shadow: 0px 0px 10px rgba(0, 0, 0, 0.2);\n        }\n\n        h1 {\n            font-size: 18px;\n            margin-top: 0;\n        }\n\n        h2 {\n            font-size: 16px;\n            margin-top: 20px;\n        }\n\n        h3 {\n            font-size: 14px;\n            margin-top: 15px;\n        }\n\n        p {\n            font-size: 12px;\n            margin: 5px 0;\n        }\n\n        ul {\n            list-style-type: none;\n            padding: 0;\n        }\n\n        .address, .contact, .event {\n            border: 1px solid #ccc;\n            padding: 5px;\n            margin-bottom: 10px;\n            border-radius: 5px;\n            background-color: #eee8e3;\n\n        }\n\n    </style>\n</head>\n<body>\n    <div class=\"container\">\n\n");
        details.append("<h2> Name: ").append(contactDetails.contactRecord().name()).append("</h2>");
        messageBuilder.append("*Name:* ").append(contactDetails.contactRecord().name());
        if (!contactDetails.contactAddress().isEmpty()) {
            details.append(" <h3>Addresses</h3>");
            messageBuilder.append("\n\n*Address:* ");
            for (ContactAddress contactAddress : contactDetails.contactAddress()) {
                String address = contactAddress.address() + " " + contactAddress.area() + " " + contactAddress.city() + " " + contactAddress.pin();
                details.append("<div class='address'> <h3>");
                details.append(contactAddress.addressTagAs());
                details.append("</h3> <p>");
                details.append("<a href='https://www.google.com/maps/search/?api=1&query=").append(AppUtility.getEncodedText(address)).append("'>").append(address).append("</a>");
                details.append("</p> </div>");
                messageBuilder.append("\n").append(contactAddress.addressTagAs()).append(" - ").append(address);
            }
        }
        if (!contactDetails.contactNumber().isEmpty()) {
            this.view.getMessageToolBar().setVisible(true);
            details.append(" <h3>Contacts</h3>");
            messageBuilder.append("\n\n*Contacts:* ");
            this.contactNumbers.clear();
            for (ContactNumber contactNumber : contactDetails.contactNumber()) {
                details.append("<div class='address'> <h3>");
                details.append(contactNumber.contactTagAs());
                details.append("</h3> <p>");
                details.append("<a href='https://wa.me/").append(contactNumber.contactValue()).append("'>").append(contactNumber.contactValue()).append("</a>");
                this.contactNumbers.add(contactNumber.contactValue());
                details.append("</p> </div>");
                messageBuilder.append("\n").append(contactNumber.contactTagAs()).append(" - ").append(contactNumber.contactValue());
            }
        } else {
            this.view.getMessageToolBar().setVisible(false);
        }
        if (!contactDetails.contactLinks().isEmpty()) {
            details.append(" <h3>Links</h3>");
            messageBuilder.append("\n\n*Links:* ");
            for (ContactLinks contactLinks : contactDetails.contactLinks()) {
                details.append("<div class='address'> <h3>");
                details.append(contactLinks.tagAs()).append(" - ").append(contactLinks.linkType());
                details.append("</h3> <p>");
                if ("Email".equals(contactLinks.linkType())) {
                    details.append("<a href='mailto:").append(contactLinks.value()).append("'>").append(contactLinks.value()).append("</a>");
                } else {
                    details.append("<a href='").append(contactLinks.value()).append("'>").append(contactLinks.value()).append("</a>");
                }
                details.append("</p> </div>");
                messageBuilder.append("\n").append(contactLinks.tagAs()).append(" - ").append(contactLinks.value());
            }
        }
        if (!contactDetails.contactEvents().isEmpty()) {
            details.append(" <h3>Events</h3>");
            messageBuilder.append("\n\n*Events:* ");
            for (ContactEvent contactEvent : contactDetails.contactEvents()) {
                details.append("<div class='address'> <h3>");
                details.append(contactEvent.eventTagAs());
                details.append("</h3> <p>");
                details.append(contactEvent.date());
                details.append("</p> </div>");
                messageBuilder.append("\n").append(contactEvent.eventTagAs()).append(" - ").append(contactEvent.date());
            }
        }
        if (!contactDetails.contactAdditionalInfo().isEmpty()) {
            details.append(" <h3>Additional Info</h3>");
            messageBuilder.append("\n\n*Additional Info:* ");
            for (ContactAdditionalInfo contactAdditionalInfo : contactDetails.contactAdditionalInfo()) {
                details.append("<div class='address'> <h3>");
                details.append(contactAdditionalInfo.tagAs());
                details.append("</h3> <p>");
                details.append(contactAdditionalInfo.value());
                details.append("</p> </div>");
                messageBuilder.append("\n").append(contactAdditionalInfo.tagAs()).append(" - ").append(contactAdditionalInfo.value());
            }
        }
        this.view.getContent().setText(details.toString());
        this.setMessage(messageBuilder.toString());
        this.view.getContent().setCaretPosition(0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser fileChooser;
        int result;
        Object obj = e.getSource();
        if (obj == this.view.getSaveImageDio() && (result = (fileChooser = new JFileChooser()).showSaveDialog(this.view.getPicDio())) == 0) {
            File selectedFile = fileChooser.getSelectedFile();
            Object fileName = selectedFile.getName();
            fileName = (String)fileName + ".png";
            selectedFile = new File(fileChooser.getCurrentDirectory(), (String)fileName);
            try {
                InputStream inputStream = this.contactService.getImage(this.view.getContactId());
                if (inputStream != null) {
                    BufferedImage image = ImageIO.read(inputStream);
                    ImageIO.write((RenderedImage)image, "png", selectedFile);
                    JOptionPane.showMessageDialog(this.view.getPicDio(), "Image saved successfully!");
                }
            }
            catch (Exception ex) {
                new ErrorDialog(ex, "save image");
            }
        }
        if (obj == this.view.getShareItOnWhatsApp()) {
            if (AppUtility.isInternetConnected()) {
                String message = this.getMessage();
                try {
                    String encodedText = AppUtility.getEncodedText(message);
                    String link = "https://wa.me/?phone=&text=" + encodedText;
                    Desktop.getDesktop().browse(new URI(link));
                }
                catch (Exception ex) {
                    new ErrorDialog(ex, "Contact sharing on whatsApp");
                }
            } else {
                JOptionPane.showMessageDialog(this.view.getDio(), "Please check your internet connection.", "Error message", 0);
            }
        }
        if (obj == this.view.getClosePicDio()) {
            this.view.getPicDio().setVisible(false);
        }
        if (obj == this.view.getShowImage()) {
            this.view.getPicDio().setVisible(true);
        }
        if (obj == this.view.getSendButton()) {
            try {
                if (!this.view.getMessageTextArea().getText().isEmpty()) {
                    String encodedText = AppUtility.getEncodedText(this.view.getMessageTextArea().getText());
                    String link = "https://wa.me/" + this.contactNumbers.get(0) + "?text=" + encodedText;
                    Desktop.getDesktop().browse(new URI(link));
                }
            }
            catch (IOException | URISyntaxException ex) {
                new ErrorDialog(ex, "While taking backup");
            }
        }
    }

    public ContactDetailsView getView() {
        return this.view;
    }
}

