/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.controller.common;

import com.arun.bhardwaj.cache.ContactGroupCache;
import com.arun.bhardwaj.controller.enquiry.EnquiryRecordController;
import com.arun.bhardwaj.controller.project.ManageProjectViewController;
import com.arun.bhardwaj.controller.property.PropertyController;
import com.arun.bhardwaj.controller.property.PropertyForSellController;
import com.arun.bhardwaj.controller.property.PropertyOnRentController;
import com.arun.bhardwaj.controller.property.PropertyRecordController;
import com.arun.bhardwaj.controller.settings.ManageTeamController;
import com.arun.bhardwaj.service.contact.ContactService;
import com.arun.bhardwaj.service.contact.ContactServiceImpl;
import com.arun.bhardwaj.view.common.ContactDialogView;
import com.arun.bhardwaj.view.common.ErrorDialog;
import com.arun.bhardwaj.view.contact.ContactRecordView;
import com.arun.bhardwaj.view.property.PropertyRecordView;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.Objects;
import java.util.stream.IntStream;
import javax.swing.ImageIcon;

public class ContactDialogController
implements ActionListener {
    private final ContactDialogView view;
    private final ContactService contactService;
    private final ContactRecordView contactRecordView;

    public ContactDialogController(ContactDialogView view) {
        this.view = view;
        this.contactService = new ContactServiceImpl();
        this.contactRecordView = new ContactRecordView();
        this.addActionEvent();
        this.populateContactGroup();
        this.populateContacts();
    }

    private void addActionEvent() {
        this.view.getCancelBtn().addActionListener(this);
        this.view.getSelectBtn().addActionListener(this);
        this.view.getNewRecordBtn().addActionListener(this);
        this.view.getContactGroupCb().addActionListener(this);
    }

    public void populateContactGroup() {
        try {
            this.view.getContactGroupCb().removeAllItems();
            Map<Integer, String> contactGroupDts = ContactGroupCache.getGroupIdToNameMap();
            contactGroupDts.forEach((key, value) -> this.view.getContactGroupCb().addItem(value));
        }
        catch (Exception e) {
            new ErrorDialog(e, "populateContactGroup");
        }
    }

    public void populateContacts() {
        String contactGroup = (String)this.view.getContactGroupCb().getSelectedItem();
        if (contactGroup != null) {
            try {
                this.view.getContactCb().removeAllItems();
                Map<Integer, String> contacts = this.contactService.loadContactNamesByGroup(contactGroup);
                contacts.forEach((key, value) -> this.view.getContactCb().addItem(value));
                this.view.getSelectBtn().setEnabled(!contacts.isEmpty());
            }
            catch (Exception e) {
                new ErrorDialog(e, "populateContacts");
            }
        }
    }

    public void loadGroups() {
        try {
            this.contactRecordView.getGroupNames().removeAllItems();
            Map<Integer, String> contactGroupDts = ContactGroupCache.getGroupIdToNameMap();
            contactGroupDts.forEach((key, value) -> this.contactRecordView.getGroupNames().addItem(value));
        }
        catch (Exception e) {
            new ErrorDialog(e, "loadGroups");
        }
    }

    private void resetContactRecordForm() {
        this.contactRecordView.setContactId(0);
        this.contactRecordView.setNumberId(0);
        this.contactRecordView.setAddressId(0);
        this.contactRecordView.getNameField().setText("");
        this.contactRecordView.getImagePreview().setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/photo-l.png"))));
        this.contactRecordView.getRemoveImageBtn().setEnabled(false);
        this.contactRecordView.getAddressField().setText("");
        this.contactRecordView.getAreaField().setText("");
        this.contactRecordView.getCityField().setText("");
        this.contactRecordView.getPinField().setText("");
        this.contactRecordView.getPhoneNoField().setText("");
        this.contactRecordView.getComment().setText("");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.view.getNewRecordBtn()) {
            this.loadGroups();
            this.contactRecordView.getDio().setTitle("New Record");
            this.contactRecordView.getUpdateBtn().setVisible(false);
            this.contactRecordView.getSaveBtn().setVisible(true);
            this.resetContactRecordForm();
            IntStream.rangeClosed(1, 5).forEachOrdered(index -> this.contactRecordView.getMainTabs().setEnabledAt(index, false));
            this.contactRecordView.getMainTabs().setSelectedIndex(0);
            this.contactRecordView.getDio().setVisible(true);
            this.populateContactGroup();
            this.populateContacts();
        }
        if (e.getSource() == this.view.getCancelBtn()) {
            this.view.getDio().setVisible(false);
            this.view.getDio().dispose();
        }
        if (e.getSource() == this.view.getContactGroupCb()) {
            this.populateContacts();
        }
        if (e.getSource() == this.view.getSelectBtn()) {
            String contactGroup = (String)this.view.getContactGroupCb().getSelectedItem();
            String contactName = (String)this.view.getContactCb().getSelectedItem();
            try {
                int contactId = this.contactService.fetchContactId(contactGroup, contactName);
                assert (contactName != null);
                contactName = contactName.replace("\\.", "");
                if (this.view.getObject() instanceof PropertyRecordController) {
                    PropertyRecordView.getOfferedByNameTf().setText(contactName);
                    PropertyRecordView.getOfferedByNameIdTf().setText(String.valueOf(contactId));
                } else {
                    Object object = this.view.getObject();
                    if (object instanceof PropertyOnRentController) {
                        PropertyOnRentController controller = (PropertyOnRentController)object;
                        if ("owner".equals(this.view.getFieldName())) {
                            controller.getView().getOwnerTf().setText(contactName);
                            controller.getView().setOwnerContactId(contactId);
                        } else if ("rentedBy".equals(this.view.getFieldName())) {
                            controller.getView().getRentedByTf().setText(contactName);
                            controller.getView().setRentedByContactId(contactId);
                        } else {
                            controller.getView().getTenantTf().setText(contactName);
                            controller.getView().setTenantContactId(contactId);
                        }
                    } else {
                        object = this.view.getObject();
                        if (object instanceof PropertyForSellController) {
                            PropertyForSellController controller = (PropertyForSellController)object;
                            if ("buyer".equals(this.view.getFieldName())) {
                                controller.getView().getBuyerTf().setText(contactName);
                                controller.getView().setBuyerContactId(contactId);
                            } else if ("seller".equals(this.view.getFieldName())) {
                                controller.getView().getSellerTf().setText(contactName);
                                controller.getView().setSellerContactId(contactId);
                            } else {
                                controller.getView().getSellByTf().setText(contactName);
                                controller.getView().setSaleByContactId(contactId);
                            }
                        } else {
                            object = this.view.getObject();
                            if (object instanceof PropertyController) {
                                PropertyController controller = (PropertyController)object;
                                if ("selectedName".equals(this.view.getFieldName())) {
                                    controller.getView().getSelectedContactName().setText(" " + contactName + " - " + contactGroup);
                                    controller.getView().setSelectedContactId(contactId);
                                }
                            } else {
                                object = this.view.getObject();
                                if (object instanceof EnquiryRecordController) {
                                    EnquiryRecordController controller = (EnquiryRecordController)object;
                                    if ("contact".equals(this.view.getFieldName())) {
                                        controller.getView().getNameTf().setText(contactName);
                                        controller.getView().setSelectedContactId(contactId);
                                    }
                                } else {
                                    object = this.view.getObject();
                                    if (object instanceof ManageTeamController) {
                                        ManageTeamController controller = (ManageTeamController)object;
                                        if ("selectedName".equals(this.view.getFieldName())) {
                                            controller.setContactId(contactId);
                                            controller.getView().getTeamMemberNameField().setText(contactName);
                                            controller.getView().getSaveBtn().setEnabled(true);
                                        }
                                    } else {
                                        object = this.view.getObject();
                                        if (object instanceof ManageProjectViewController) {
                                            ManageProjectViewController controller = (ManageProjectViewController)object;
                                            if ("builder".equals(this.view.getFieldName())) {
                                                controller.getView().setBuilderContactId(contactId);
                                                controller.getView().getBuilderNameTf().setText(contactName);
                                            } else {
                                                controller.getView().setArchitectContactId(contactId);
                                                controller.getView().getArchitectNameTf().setText(contactName);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception ex) {
                new ErrorDialog(ex, "getSelectBtn");
            }
            this.view.getDio().setVisible(false);
        }
    }
}

