/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.controller.common;

import com.arun.bhardwaj.factory.DocumentManagementFactory;
import com.arun.bhardwaj.model.DocumentDetails;
import com.arun.bhardwaj.utility.AppUtility;
import com.arun.bhardwaj.utility.AutoResize;
import com.arun.bhardwaj.view.common.ErrorDialog;
import com.arun.bhardwaj.view.common.ManageDocuments;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.pdfbox.text.PDFTextStripper;

public class ManageDocumentsController
implements ListSelectionListener,
ActionListener,
KeyListener,
FocusListener {
    private final ManageDocuments view;
    private String lastOpenedDirectory;
    private String selectedFileText;
    private StringBuffer conversation;
    private Timer timer;
    private int colorIndex = 0;
    private static final Color[] colors = new Color[]{Color.RED, Color.GREEN, Color.BLUE, Color.ORANGE, Color.MAGENTA};

    public ManageDocumentsController(final ManageDocuments view) {
        this.view = view;
        this.loadDocumentDetails();
        view.getSelectionModel().addListSelectionListener(this);
        view.getUploadDocuments().addActionListener(this);
        view.getBrowseBtn().addActionListener(this);
        view.getSaveBtn().addActionListener(this);
        view.getCloseDocumentDio().addActionListener(this);
        view.getRemoveDocumentBtn().addActionListener(this);
        view.getSaveDocument().addActionListener(this);
        view.getDownloadAll().addActionListener(this);
        view.getCallAiBtn().addActionListener(this);
        view.getZoomInBtn().addActionListener(this);
        view.getZoomOutBtn().addActionListener(this);
        view.getUploadMultipledocumentsBtn().addActionListener(this);
        view.getCopyToClipboard().addActionListener(this);
        view.getPromptTf().addKeyListener(this);
        view.getPromptTf().addFocusListener(this);
        AppUtility.tableZoomInZoomOut(true, view.getTable());
        AppUtility.tableZoomInZoomOut(true, view.getTable());
        this.conversation = new StringBuffer();
        this.timer = new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                view.getAnimatedEditorPanel().setBackground(colors[ManageDocumentsController.this.colorIndex]);
                ManageDocumentsController.this.colorIndex = (ManageDocumentsController.this.colorIndex + 1) % colors.length;
            }
        });
    }

    private void loadDetailsOnRowSelection() {
        block19: {
            try {
                int documentId = (Integer)this.view.getTable().getValueAt(this.view.getTable().getSelectedRow(), 3);
                String fileName = (String)this.view.getTable().getValueAt(this.view.getTable().getSelectedRow(), 2);
                this.view.getImageName().setText(fileName);
                this.view.getRemoveDocumentBtn().setEnabled(true);
                this.view.getSaveDocument().setEnabled(true);
                this.view.getDownloadAll().setEnabled(true);
                DocumentDetails documentDetails = Objects.requireNonNull(DocumentManagementFactory.getDocumentServiceProvider(this.view.getFromModule())).getDocument(documentId);
                String fileExtension = this.getFileExtension(documentDetails.fileName());
                if ("pdf".equals(fileExtension)) {
                    try (PDDocument document = PDDocument.load(documentDetails.document());){
                        PDFRenderer pdfRenderer = new PDFRenderer(document);
                        int pageIndex = 0;
                        BufferedImage image = pdfRenderer.renderImageWithDPI(pageIndex, 100.0f, ImageType.RGB);
                        this.displayDocumentPreview(image);
                        InputStream inputStream = documentDetails.document();
                        if (inputStream != null) {
                            File tempFile = File.createTempFile("tempPdf", ".pdf");
                            try (FileOutputStream outputStream = new FileOutputStream(tempFile);){
                                int bytesRead;
                                byte[] buffer = new byte[1024];
                                while ((bytesRead = inputStream.read(buffer)) != -1) {
                                    ((OutputStream)outputStream).write(buffer, 0, bytesRead);
                                }
                            }
                            this.readPdfFile();
                        }
                        if (AppUtility.checkOllamaRunningStatus()) {
                            this.view.getPreviewSplitPane().setDividerLocation(250);
                            this.view.getPreviewSplitPane().setRightComponent(this.view.getChatWithDocumentPanel());
                            this.view.getPreviewSplitPane().revalidate();
                            this.view.getPreviewSplitPane().repaint();
                        } else {
                            this.selectedFileText = "";
                            this.view.getPreviewSplitPane().setRightComponent(null);
                            this.view.getPreviewSplitPane().revalidate();
                            this.view.getPreviewSplitPane().repaint();
                        }
                        break block19;
                    }
                }
                BufferedImage image = ImageIO.read(documentDetails.document());
                this.displayDocumentPreview(image);
                this.selectedFileText = "";
                this.view.getPreviewSplitPane().setRightComponent(null);
                this.view.getPreviewSplitPane().revalidate();
                this.view.getPreviewSplitPane().repaint();
            }
            catch (Exception ex) {
                new ErrorDialog(ex, "load documents");
            }
        }
    }

    public void loadDocumentDetails() {
        try {
            List<DocumentDetails> details = Objects.requireNonNull(DocumentManagementFactory.getDocumentServiceProvider(this.view.getFromModule())).loadDocuments(this.view.getPrimaryKey());
            this.view.getDefaultTableModel().setRowCount(0);
            if (details.isEmpty()) {
                this.view.getRemoveDocumentBtn().setEnabled(false);
                this.view.getSaveDocument().setEnabled(false);
                this.resetPreviewPanel();
                this.selectedFileText = "";
                this.view.getPreviewSplitPane().setRightComponent(null);
                this.view.getPreviewSplitPane().revalidate();
                this.view.getPreviewSplitPane().repaint();
            } else {
                IntStream.range(0, details.size()).forEach(index -> {
                    this.view.getDefaultTableModel().addRow(new Object[]{"", "", "", ""});
                    this.view.getTable().setValueAt(String.valueOf(index + 1), index, 0);
                    this.view.getTable().setValueAt(((DocumentDetails)details.get(index)).date().split(" ")[0], index, 1);
                    this.view.getTable().setValueAt(((DocumentDetails)details.get(index)).fileName(), index, 2);
                    this.view.getTable().setValueAt(((DocumentDetails)details.get(index)).documentId(), index, 3);
                    this.view.getTable().setAutoCreateRowSorter(true);
                });
                if (this.view.getTable().getRowCount() > 0) {
                    this.view.getTable().setRowSelectionInterval(0, 0);
                    this.loadDetailsOnRowSelection();
                }
            }
        }
        catch (Exception e) {
            new ErrorDialog(e, "loadPropertyStatusHistory");
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.view.getSelectionModel() && this.view.getTable().getSelectedRow() >= 0) {
            this.loadDetailsOnRowSelection();
        }
    }

    private boolean isAllowedFileType(File file) {
        String extension = this.getFileExtension(file.getName());
        return extension != null && (extension.equals("jpg") || extension.equals("jpeg") || extension.equals("png") || extension.equals("gif") || extension.equals("pdf"));
    }

    private String getFileExtension(String name) {
        int lastIndexOfDot = name.lastIndexOf(46);
        if (lastIndexOfDot == -1 || lastIndexOfDot == 0 || lastIndexOfDot == name.length() - 1) {
            return null;
        }
        return name.substring(lastIndexOfDot + 1);
    }

    private void resetDocumentPanel() {
        this.view.setFileName("");
        this.view.setFilePath("");
        this.view.getUploadPanel().removeAll();
        this.view.getUploadPanel().revalidate();
        this.view.getUploadPanel().repaint();
    }

    private void resetPreviewPanel() {
        this.view.setFileName("");
        this.view.setFilePath("");
        this.view.getPreviewPanel().removeAll();
        this.view.getPreviewPanel().revalidate();
        this.view.getPreviewPanel().repaint();
    }

    private void displayDocument(BufferedImage image) {
        if (image != null) {
            AutoResize responsiveImg = new AutoResize(image);
            this.view.getUploadPanel().removeAll();
            this.view.getUploadPanel().add(responsiveImg);
            this.view.getUploadPanel().revalidate();
            this.view.getUploadPanel().repaint();
        }
    }

    private void displayDocumentPreview(BufferedImage image) {
        if (image != null) {
            AutoResize responsiveImg = new AutoResize(image);
            this.view.getPreviewPanel().removeAll();
            this.view.getPreviewPanel().add(responsiveImg);
            this.view.getPreviewPanel().revalidate();
            this.view.getPreviewPanel().repaint();
        }
    }

    private void readPdfFile() {
        block14: {
            try {
                int documentId = (Integer)this.view.getTable().getValueAt(this.view.getTable().getSelectedRow(), 3);
                DocumentDetails documentDetails = Objects.requireNonNull(DocumentManagementFactory.getDocumentServiceProvider(this.view.getFromModule())).getDocument(documentId);
                InputStream inputStream = documentDetails.document();
                if (inputStream == null) break block14;
                File tempFile = File.createTempFile("tempPdf", ".pdf");
                try (FileOutputStream outputStream = new FileOutputStream(tempFile);){
                    int bytesRead;
                    byte[] buffer = new byte[1024];
                    while ((bytesRead = inputStream.read(buffer)) != -1) {
                        ((OutputStream)outputStream).write(buffer, 0, bytesRead);
                    }
                }
                try (PDDocument document = PDDocument.load(tempFile);){
                    PDFTextStripper pdfStripper = new PDFTextStripper();
                    this.selectedFileText = pdfStripper.getText(document);
                }
            }
            catch (Exception ex) {
                new ErrorDialog(ex, "save image");
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int result;
        JFileChooser fileChooser;
        Object obj = e.getSource();
        if (e.getSource() == this.view.getCopyToClipboard()) {
            String selectedText = this.view.getResponseTextArea().getSelectedText();
            if (selectedText != null && !selectedText.isEmpty()) {
                StringSelection stringSelection = new StringSelection(selectedText);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(stringSelection, null);
                JOptionPane.showMessageDialog(this.view.getDocumentDio(), "copied", "Warning", 2);
            } else {
                JOptionPane.showMessageDialog(this.view.getDocumentDio(), "No text selected!", "Warning", 2);
            }
        }
        if (obj == this.view.getCallAiBtn() && !"Ask your query here".equals(this.view.getPromptTf().getText())) {
            this.timer.start();
            this.view.getCallAiBtn().setEnabled(false);
            this.view.getPromptTf().setEditable(false);
            new TaskCallAIWorker().execute();
        }
        if (obj == this.view.getUploadMultipledocumentsBtn()) {
            try {
                fileChooser = new JFileChooser();
                if (this.lastOpenedDirectory != null && !this.lastOpenedDirectory.isEmpty()) {
                    fileChooser.setCurrentDirectory(new File(this.lastOpenedDirectory));
                }
                FileNameExtensionFilter filter = new FileNameExtensionFilter("Images and PDFs", "jpg", "jpeg", "png", "gif", "pdf");
                fileChooser.setFileFilter(filter);
                fileChooser.setMultiSelectionEnabled(true);
                int returnValue = fileChooser.showOpenDialog(this.view.getUploadMultipledocumentsBtn());
                if (returnValue == 0) {
                    File[] selectedFiles = fileChooser.getSelectedFiles();
                    this.lastOpenedDirectory = fileChooser.getSelectedFile().getParent();
                    for (File file : selectedFiles) {
                        DocumentDetails documentDetails = new DocumentDetails.Builder().fileName(file.getName()).filePath(file.getPath()).primaryKey(this.view.getPrimaryKey()).build();
                        Objects.requireNonNull(DocumentManagementFactory.getDocumentServiceProvider(this.view.getFromModule())).save(documentDetails);
                        this.view.getUploadDio().setVisible(false);
                    }
                    JOptionPane.showMessageDialog(this.view.getUploadDio(), "Successfully saved !", "Success", 1);
                    this.loadDocumentDetails();
                }
            }
            catch (Exception e1) {
                new ErrorDialog(e1, "upload multiple documents");
            }
        }
        if (obj == this.view.getDownloadAll()) {
            fileChooser = new JFileChooser();
            fileChooser.setFileSelectionMode(1);
            int result2 = fileChooser.showSaveDialog(this.view.getSaveDocument());
            if (result2 == 0) {
                File folderPath = fileChooser.getSelectedFile();
                try {
                    List<DocumentDetails> documentDetailList = Objects.requireNonNull(DocumentManagementFactory.getDocumentServiceProvider(this.view.getFromModule())).downloadAllDocuments(this.view.getPrimaryKey());
                    for (DocumentDetails documentDetail : documentDetailList) {
                        folderPath = new File(fileChooser.getCurrentDirectory(), documentDetail.fileName());
                        InputStream inputStream = documentDetail.document();
                        if (inputStream == null) continue;
                        if ("pdf".equals(this.getFileExtension(documentDetail.fileName()))) {
                            FileOutputStream outputStream = new FileOutputStream(folderPath);
                            try {
                                int bytesRead;
                                byte[] buffer = new byte[1024];
                                while ((bytesRead = inputStream.read(buffer)) != -1) {
                                    ((OutputStream)outputStream).write(buffer, 0, bytesRead);
                                }
                                continue;
                            }
                            finally {
                                ((OutputStream)outputStream).close();
                                continue;
                            }
                        }
                        BufferedImage image = ImageIO.read(inputStream);
                        ImageIO.write((RenderedImage)image, Objects.requireNonNull(this.getFileExtension(documentDetail.fileName())), folderPath);
                    }
                    JOptionPane.showMessageDialog(this.view.getDocumentDio(), "Document saved successfully!");
                }
                catch (Exception ex) {
                    new ErrorDialog(ex, "save all files");
                }
            }
        }
        if (obj == this.view.getSaveDocument() && (result = (fileChooser = new JFileChooser()).showSaveDialog(this.view.getSaveDocument())) == 0) {
            File selectedFile = fileChooser.getSelectedFile();
            Object fileName = selectedFile.getName();
            String documentName = (String)this.view.getTable().getValueAt(this.view.getTable().getSelectedRow(), 2);
            fileName = (String)fileName + "." + this.getFileExtension(documentName);
            selectedFile = new File(fileChooser.getCurrentDirectory(), (String)fileName);
            try {
                int documentId = (Integer)this.view.getTable().getValueAt(this.view.getTable().getSelectedRow(), 3);
                DocumentDetails documentDetails = Objects.requireNonNull(DocumentManagementFactory.getDocumentServiceProvider(this.view.getFromModule())).getDocument(documentId);
                InputStream inputStream = documentDetails.document();
                if (inputStream != null) {
                    if ("pdf".equals(this.getFileExtension(documentName))) {
                        try (FileOutputStream outputStream = new FileOutputStream(selectedFile);){
                            int bytesRead;
                            byte[] buffer = new byte[1024];
                            while ((bytesRead = inputStream.read(buffer)) != -1) {
                                ((OutputStream)outputStream).write(buffer, 0, bytesRead);
                            }
                        }
                    } else {
                        BufferedImage image = ImageIO.read(inputStream);
                        ImageIO.write((RenderedImage)image, Objects.requireNonNull(this.getFileExtension(documentName)), selectedFile);
                    }
                    JOptionPane.showMessageDialog(this.view.getDocumentDio(), "Document saved successfully!");
                }
            }
            catch (Exception ex) {
                new ErrorDialog(ex, "save image");
            }
        }
        if (obj == this.view.getRemoveDocumentBtn()) {
            String selectedName = (String)this.view.getTable().getValueAt(this.view.getTable().getSelectedRow(), 2);
            int choose = JOptionPane.showConfirmDialog(this.view.getDocumentDio(), "Warning : Are you sure to delete " + selectedName + " ?", "Delete record", 1);
            if (choose == 0) {
                int documentId = (Integer)this.view.getTable().getValueAt(this.view.getTable().getSelectedRow(), 3);
                try {
                    Objects.requireNonNull(DocumentManagementFactory.getDocumentServiceProvider(this.view.getFromModule())).deleteDocument(documentId);
                    JOptionPane.showMessageDialog(this.view.getDocumentDio(), "Successfully deleted !", "Success", 1);
                    this.loadDocumentDetails();
                }
                catch (Exception ex) {
                    new ErrorDialog(ex, "Delete document");
                }
            }
        }
        if (obj == this.view.getSaveBtn()) {
            try {
                DocumentDetails documentDetails = new DocumentDetails.Builder().fileName(this.view.getFileName()).filePath(this.view.getFilePath()).primaryKey(this.view.getPrimaryKey()).build();
                Objects.requireNonNull(DocumentManagementFactory.getDocumentServiceProvider(this.view.getFromModule())).save(documentDetails);
                JOptionPane.showMessageDialog(this.view.getUploadDio(), "Successfully saved !", "Success", 1);
                this.view.getUploadDio().setVisible(false);
                this.loadDocumentDetails();
            }
            catch (Exception ex) {
                new ErrorDialog(ex, "Save contact documents");
            }
        }
        if (obj == this.view.getBrowseBtn()) {
            fileChooser = new JFileChooser();
            if (this.lastOpenedDirectory != null && !this.lastOpenedDirectory.isEmpty()) {
                fileChooser.setCurrentDirectory(new File(this.lastOpenedDirectory));
            }
            FileNameExtensionFilter filter = new FileNameExtensionFilter("Images and PDFs", "jpg", "jpeg", "png", "gif", "pdf");
            fileChooser.setFileFilter(filter);
            int returnVal = fileChooser.showOpenDialog(this.view.getBrowseBtn());
            if (returnVal == 0) {
                try {
                    File selectedFile = fileChooser.getSelectedFile();
                    if (this.isAllowedFileType(selectedFile)) {
                        String fileName = fileChooser.getSelectedFile().getName();
                        this.lastOpenedDirectory = fileChooser.getSelectedFile().getParent();
                        this.view.setFileName(fileName);
                        String path = fileChooser.getSelectedFile().getPath();
                        this.view.setFilePath(path);
                        if ("pdf".equals(this.getFileExtension(selectedFile.getName()))) {
                            try (PDDocument document = PDDocument.load(new File(path));){
                                PDFRenderer pdfRenderer = new PDFRenderer(document);
                                int pageIndex = 0;
                                BufferedImage image = pdfRenderer.renderImageWithDPI(pageIndex, 100.0f, ImageType.RGB);
                                this.displayDocument(image);
                            }
                        } else {
                            BufferedImage image = ImageIO.read(new File(path));
                            this.displayDocument(image);
                        }
                        this.view.getSaveBtn().setEnabled(true);
                    } else {
                        JOptionPane.showMessageDialog(this.view.getUploadDio(), "Please select a valid image or PDF file.", "Error Message", 0);
                        this.resetDocumentPanel();
                    }
                }
                catch (Exception e1) {
                    new ErrorDialog(e1, "error while load image or pdf");
                }
            }
        }
        if (obj == this.view.getCloseDocumentDio()) {
            this.view.getUploadDio().setVisible(false);
        }
        if (obj == this.view.getUploadDocuments()) {
            this.resetDocumentPanel();
            this.view.getUploadDio().setVisible(true);
        }
        if (obj == this.view.getZoomInBtn()) {
            AppUtility.tableZoomInZoomOut(true, this.view.getTable());
        }
        if (obj == this.view.getZoomOutBtn()) {
            AppUtility.tableZoomInZoomOut(false, this.view.getTable());
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (e.getSource() == this.view.getPromptTf()) {
            if (!"Ask your query here".equals(this.view.getPromptTf().getText())) {
                return;
            }
            this.view.getPromptTf().setText("");
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getSource() == this.view.getPromptTf() && this.view.getPromptTf().getText().isEmpty()) {
            this.view.getPromptTf().setText("Ask your query here");
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        Object obj = e.getSource();
        if (obj == this.view.getPromptTf() && e.getKeyCode() == 10) {
            this.timer.start();
            this.view.getCallAiBtn().setEnabled(false);
            this.view.getPromptTf().setEditable(false);
            new TaskCallAIWorker().execute();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    private class TaskCallAIWorker
    extends SwingWorker<Void, Void> {
        private TaskCallAIWorker() {
        }

        @Override
        protected Void doInBackground() throws Exception {
            HttpClient client = HttpClient.newHttpClient();
            ObjectMapper objectMapper = new ObjectMapper();
            ObjectNode payload = objectMapper.createObjectNode();
            payload.put("model", "llama3.2:latest");
            payload.put("prompt", ManageDocumentsController.this.selectedFileText + " : " + ManageDocumentsController.this.view.getPromptTf().getText());
            ManageDocumentsController.this.conversation.append("You :").append(ManageDocumentsController.this.view.getPromptTf().getText());
            ManageDocumentsController.this.conversation.append("\n");
            payload.put("temperature", 1);
            payload.put("stream", false);
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create("http://localhost:11434/api/generate")).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(payload.toString())).build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() == 200) {
                JsonNode jsonResponse = objectMapper.readTree(response.body());
                String assistantMessage = jsonResponse.get("response").asText();
                ManageDocumentsController.this.view.getResponseTextArea().setText("");
                ManageDocumentsController.this.conversation.append("System :").append(assistantMessage);
                ManageDocumentsController.this.conversation.append("\n \n");
                ManageDocumentsController.this.view.getResponseTextArea().setText(ManageDocumentsController.this.conversation.toString());
            } else {
                ManageDocumentsController.this.view.getResponseTextArea().setText("Failed to get a response. Status Code: " + response.statusCode());
                ManageDocumentsController.this.timer.stop();
                ManageDocumentsController.this.view.getAnimatedEditorPanel().setBackground(null);
            }
            return null;
        }

        @Override
        protected void done() {
            ManageDocumentsController.this.timer.stop();
            ManageDocumentsController.this.view.getAnimatedEditorPanel().setBackground(null);
            ManageDocumentsController.this.view.getCallAiBtn().setEnabled(true);
            ManageDocumentsController.this.view.getPromptTf().setEditable(true);
            ManageDocumentsController.this.view.getPromptTf().setText("");
            ManageDocumentsController.this.view.getPromptTf().setFocusable(true);
        }
    }
}

