/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.controller.contact;

import com.arun.bhardwaj.cache.ContactGroupCache;
import com.arun.bhardwaj.model.contact.ContactAddress;
import com.arun.bhardwaj.model.contact.ContactEvents;
import com.arun.bhardwaj.model.contact.ContactNumber;
import com.arun.bhardwaj.model.contact.ContactRecord;
import com.arun.bhardwaj.model.contact.ContactStatistics;
import com.arun.bhardwaj.service.contact.ContactRecordService;
import com.arun.bhardwaj.service.contact.ContactRecordServiceImpl;
import com.arun.bhardwaj.service.contact.ContactService;
import com.arun.bhardwaj.service.contact.ContactServiceImpl;
import com.arun.bhardwaj.service.contact.ManageGroupService;
import com.arun.bhardwaj.service.contact.ManageGroupServiceImpl;
import com.arun.bhardwaj.utility.AppUtility;
import com.arun.bhardwaj.utility.AutoResize;
import com.arun.bhardwaj.view.LoginView;
import com.arun.bhardwaj.view.common.ContactDetailsView;
import com.arun.bhardwaj.view.common.DisplayPieChart;
import com.arun.bhardwaj.view.common.ErrorDialog;
import com.arun.bhardwaj.view.common.ManageDocuments;
import com.arun.bhardwaj.view.contact.ContactRecordView;
import com.arun.bhardwaj.view.contact.ContactView;
import com.arun.bhardwaj.view.contact.ManageGroup;
import com.opencsv.CSVReader;
import com.opencsv.exceptions.CsvValidationException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.IntStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jfree.data.general.DefaultPieDataset;

public class ContactController
implements ListSelectionListener,
ActionListener,
KeyListener,
FocusListener {
    private final ContactView view;
    private final ManageGroup manageGroupView;
    private final ContactRecordView contactRecordView;
    private final ContactService service;
    private final ContactRecordService contactRecordService;
    private final ManageGroupService manageGroupService;
    private String lastOpenedDirectory;
    private static final String CLICK_HERE_TO_SEARCH_CONTACTS = "Click here to search contacts";
    private final DefaultPieDataset dataset = new DefaultPieDataset();
    private int selectedRowIndex = 0;

    public int getSelectedRowIndex() {
        return this.selectedRowIndex;
    }

    public void setSelectedRowIndex(int selectedRowIndex) {
        this.selectedRowIndex = selectedRowIndex;
    }

    public ContactController(ContactView view) {
        this.view = view;
        this.manageGroupView = new ManageGroup();
        this.contactRecordView = new ContactRecordView();
        this.service = new ContactServiceImpl();
        this.contactRecordService = new ContactRecordServiceImpl();
        this.manageGroupService = new ManageGroupServiceImpl();
        this.addActionEvent();
        this.view.getSelectionModel().addListSelectionListener(this);
        this.view.getSearchTf().addKeyListener(this);
        this.view.getSearchTf().addFocusListener(this);
        this.addToolTip();
        AppUtility.tableZoomInZoomOut(true, view.getTable());
        AppUtility.tableZoomInZoomOut(true, view.getTable());
        view.getNotificationPanel().addHyperlinkListener(e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                AppUtility.openWebPage(e.getURL().toString());
            }
        });
        this.view.getNewI().setMnemonic('n');
    }

    public void loadInitialData() {
        this.loadGroups();
    }

    private void addToolTip() {
        this.view.getNewI().setToolTipText("Add contact");
        this.view.getNewG().setToolTipText("Add group");
        this.view.getUpdR().setToolTipText("Update contact");
        this.view.getUpdG().setToolTipText("Update group");
        this.view.getDel().setToolTipText("Delete contact");
        this.view.getDelG().setToolTipText("Delete group");
        this.view.getRefBtn().setToolTipText("Refresh");
        this.view.getViewBtn().setToolTipText("View details");
        this.view.getGroupList().setToolTipText("Select group to filter records");
        this.view.getSearchCb().setToolTipText("Select option for searching records");
        this.view.getZoomInBtn().setToolTipText("Zoom in Ctr +");
        this.view.getZoomOutBtn().setToolTipText("Zoom out Ctr -");
        this.view.getShowPieChartBtn().setToolTipText("Show pie chart");
        this.view.getImportBtn().setToolTipText("Import contacts");
    }

    private void addActionEvent() {
        this.view.getNewI().addActionListener(this);
        this.view.getNewG().addActionListener(this);
        this.view.getUpdR().addActionListener(this);
        this.view.getUpdG().addActionListener(this);
        this.view.getDel().addActionListener(this);
        this.view.getDelG().addActionListener(this);
        this.view.getRefBtn().addActionListener(this);
        this.view.getViewBtn().addActionListener(this);
        this.view.getManageDocumentBtn().addActionListener(this);
        this.view.getGroupList().addActionListener(this);
        this.view.getUpdatePopupMenu().addActionListener(this);
        this.view.getDeletePopupMenu().addActionListener(this);
        this.view.getViewPopupMenu().addActionListener(this);
        this.view.getNewRPopupMenu().addActionListener(this);
        this.view.getRefPopupMenu().addActionListener(this);
        this.view.getZoomInBtn().addActionListener(this);
        this.view.getZoomOutBtn().addActionListener(this);
        this.view.getManaDocumentPopupMenu().addActionListener(this);
        this.view.getShowPieChartBtn().addActionListener(this);
        this.view.getShowChartPopupMenu().addActionListener(this);
        this.view.getImportBtn().addActionListener(this);
        this.view.getImportPopupMenu().addActionListener(this);
        this.view.getImportCancelBtn().addActionListener(this);
        this.view.getDownloadTemplate().addActionListener(this);
        this.view.getImportRecordBtn().addActionListener(this);
        this.view.getNextButton().addActionListener(this);
        this.view.getPrevButton().addActionListener(this);
    }

    public void loadGroups() {
        try {
            this.view.getGroupList().removeAllItems();
            this.contactRecordView.getGroupNames().removeAllItems();
            this.view.getImportGroupCb().removeAllItems();
            this.view.getGroupList().addItem("All Records");
            Map<Integer, String> contactGroupDts = ContactGroupCache.getGroupIdToNameMap();
            contactGroupDts.forEach((key, value) -> {
                this.view.getGroupList().addItem(value);
                this.contactRecordView.getGroupNames().addItem(value);
                this.view.getImportGroupCb().addItem(value);
            });
            this.loadContactRecords();
        }
        catch (Exception e) {
            new ErrorDialog(e, "load group");
        }
    }

    private void loadContactRecords() {
        try {
            AppUtility.validateUser();
            String selectedGroupName = (String)this.view.getGroupList().getSelectedItem();
            int selectedGroupId = ContactGroupCache.getGroupIdByName(selectedGroupName);
            if ("All Records".equals(selectedGroupName)) {
                this.view.getUpdR().setEnabled(false);
                this.view.getDel().setEnabled(false);
                this.view.getUpdG().setEnabled(false);
                this.view.getDelG().setEnabled(false);
            } else {
                this.view.getUpdG().setEnabled(true);
                this.view.getDelG().setEnabled(true);
                this.view.getUpdR().setEnabled(false);
                this.view.getDel().setEnabled(false);
            }
            String search = "";
            search = CLICK_HERE_TO_SEARCH_CONTACTS.equals(this.view.getSearchTf().getText().trim()) || this.view.getSearchTf().getText().isEmpty() ? "" : this.view.getSearchTf().getText().trim();
            String searchBy = (String)this.view.getSearchCb().getSelectedItem();
            List<ContactRecord> contacts = this.service.loadContactDetails(selectedGroupId, search, searchBy, this.view.getCurrentPage(), this.view.getPAGE_SIZE());
            if (contacts.size() > 0) {
                this.view.setTotalRecords(contacts.get(0).totalRecords());
            }
            this.view.getDefaultTableModel().setRowCount(0);
            IntStream.range(0, contacts.size()).forEach(index -> {
                this.view.getDefaultTableModel().addRow(new Object[]{"", "", "", "", "", "", "", "", "", "", "", "", ""});
                String strAddress = ((ContactRecord)contacts.get(index)).primaryAddress().address() == null ? "" : ((ContactRecord)contacts.get(index)).primaryAddress().address();
                String strArea = ((ContactRecord)contacts.get(index)).primaryAddress().area() == null ? "" : ((ContactRecord)contacts.get(index)).primaryAddress().area();
                String strCity = ((ContactRecord)contacts.get(index)).primaryAddress().city() == null ? "" : ((ContactRecord)contacts.get(index)).primaryAddress().city();
                String strPin = ((ContactRecord)contacts.get(index)).primaryAddress().pin() == null ? "" : ((ContactRecord)contacts.get(index)).primaryAddress().pin();
                String strFullAddress = strAddress + " " + strArea + " " + strCity + " " + strPin;
                this.view.getTable().setValueAt(String.valueOf(index + 1), index, 0);
                this.view.getTable().setValueAt(((ContactRecord)contacts.get(index)).name(), index, 1);
                this.view.getTable().setValueAt(strFullAddress, index, 2);
                this.view.getTable().setValueAt(((ContactRecord)contacts.get(index)).primaryNumber().contactValue(), index, 3);
                this.view.getTable().setValueAt(((ContactRecord)contacts.get(index)).comments(), index, 4);
                this.view.getTable().setValueAt(((ContactRecord)contacts.get(index)).contactId(), index, 5);
                this.view.getTable().setValueAt(((ContactRecord)contacts.get(index)).groupName(), index, 6);
                this.view.getTable().setValueAt(strAddress, index, 7);
                this.view.getTable().setValueAt(strArea, index, 8);
                this.view.getTable().setValueAt(strCity, index, 9);
                this.view.getTable().setValueAt(strPin, index, 10);
                this.view.getTable().setValueAt(((ContactRecord)contacts.get(index)).primaryAddress().addressId(), index, 11);
                this.view.getTable().setValueAt(((ContactRecord)contacts.get(index)).primaryNumber().contactNumberId(), index, 12);
                this.view.getTable().setAutoCreateRowSorter(true);
            });
            if (this.getSelectedRowIndex() != -1 && this.getSelectedRowIndex() < this.view.getTable().getRowCount()) {
                this.view.getTable().setRowSelectionInterval(this.getSelectedRowIndex(), this.getSelectedRowIndex());
                this.loadDetailsOnRowSelection();
            } else if (this.view.getTable().getRowCount() > 0) {
                this.view.getTable().setRowSelectionInterval(0, 0);
                this.loadDetailsOnRowSelection();
            }
            this.showContactStatistics();
            AppUtility.tableZoomInZoomOut(true, this.view.getTable());
            AppUtility.tableZoomInZoomOut(false, this.view.getTable());
            int startRecord = (this.view.getCurrentPage() - 1) * this.view.getPAGE_SIZE() + 1;
            int endRecord = Math.min(this.view.getCurrentPage() * this.view.getPAGE_SIZE(), this.view.getTotalRecords());
            String resultString = "Result " + startRecord + " - " + endRecord + " of " + this.view.getTotalRecords();
            this.view.getPageLabel().setText(resultString);
            this.view.getPrevButton().setEnabled(this.view.getCurrentPage() > 1);
            this.view.getNextButton().setEnabled(this.view.getCurrentPage() * this.view.getPAGE_SIZE() < this.view.getTotalRecords());
        }
        catch (Exception e) {
            new ErrorDialog(e, "load contact records");
        }
    }

    private void loadChartDataSet(List<ContactStatistics> data) {
        this.dataset.clear();
        for (ContactStatistics contactStatistics : data) {
            this.dataset.setValue((Comparable)((Object)contactStatistics.groupName()), contactStatistics.count());
        }
    }

    private void showContactStatistics() throws Exception {
        List<ContactStatistics> data = this.service.fetchContactStatistics();
        List<ContactEvents> events = this.service.fetchTodayContactEvents();
        this.loadChartDataSet(data);
        StringBuilder details = new StringBuilder();
        details.append("<html>\n<head>\n    <title>Group Information</title>\n    <style>\n        body { font-family: Arial, sans-serif;\n            text-align: center;\n        }\n        h1 {\n            color: #333;\n        }\n        table {\n            width: 100%;\n            max-width: 600px; /* Adjust as needed for your layout */\n            margin: 0 auto;\n            border-collapse: collapse;\n            border-spacing: 0;\n            overflow: auto;\n        }\n        th, td {\n            padding: 10px;\n            border: 1px solid #5B7687;\n            word-wrap: break-word;\n        }\n        th {\n            background-color: #115676;\n            color: #fff;\n        }\n    </style>\n</head>\n<body>\n    <h3>Group Details</h3>\n    <div style=\"overflow-x: auto;\">\n    <table>\n    <tr>\n        <th> Name</th>\n        <th>Count</th>\n    </tr>\n");
        for (ContactStatistics contactStatistics : data) {
            details.append("<tr> <td>");
            details.append(contactStatistics.groupName());
            details.append("</td>");
            details.append("<td>");
            details.append(contactStatistics.count());
            details.append("</td> </tr>");
        }
        details.append(" </table>\n    </div>\n");
        details.append("<div>");
        for (ContactEvents contactEvents : events) {
            details.append("<p> Today is ");
            details.append(contactEvents.name());
            details.append("'s ");
            details.append(contactEvents.eventName());
            if (contactEvents.contactNumber() != null) {
                details.append(" message on ");
                details.append("<a href='https://wa.me/").append(contactEvents.contactNumber()).append("'>").append(contactEvents.contactNumber()).append("</a>");
            }
            details.append("</p>");
        }
        details.append("</div>");
        details.append(" </body>\n</html>\n");
        this.view.getNotificationPanel().setText(details.toString());
    }

    private void resetContactRecordForm() {
        this.contactRecordView.setContactId(0);
        this.contactRecordView.setAddressId(0);
        this.contactRecordView.setNumberId(0);
        this.contactRecordView.getNameField().setText("");
        this.contactRecordView.getImagePreview().setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/photo-l.png"))));
        this.contactRecordView.getRemoveImageBtn().setEnabled(false);
        this.contactRecordView.getAddressField().setText("");
        this.contactRecordView.getAreaField().setText("");
        this.contactRecordView.getCityField().setText("");
        this.contactRecordView.getPinField().setText("");
        this.contactRecordView.getPhoneNoField().setText("");
        this.contactRecordView.getComment().setText("");
    }

    private void loadContactRecordForm(int row) throws Exception {
        String groupName = (String)this.view.getTable().getValueAt(this.view.getTable().getSelectedRow(), 6);
        this.contactRecordView.getGroupNames().setSelectedItem(groupName);
        int contactId = (Integer)this.view.getTable().getValueAt(row, 5);
        this.contactRecordView.setContactId(contactId);
        this.contactRecordView.getNameField().setText((String)this.view.getTable().getValueAt(row, 1));
        this.contactRecordView.getDio().setTitle("Update Record -" + (String)this.view.getTable().getValueAt(row, 1));
        this.contactRecordView.getPhoneNoField().setText((String)this.view.getTable().getValueAt(row, 3));
        this.contactRecordView.getComment().setText((String)this.view.getTable().getValueAt(row, 4));
        this.contactRecordView.getAddressField().setText((String)this.view.getTable().getValueAt(row, 7));
        this.contactRecordView.getAreaField().setText((String)this.view.getTable().getValueAt(row, 8));
        this.contactRecordView.getCityField().setText((String)this.view.getTable().getValueAt(row, 9));
        this.contactRecordView.getPinField().setText((String)this.view.getTable().getValueAt(row, 10));
        this.contactRecordView.setAddressId((Integer)this.view.getTable().getValueAt(row, 11));
        this.contactRecordView.setNumberId((Integer)this.view.getTable().getValueAt(row, 12));
        this.contactRecordView.getUpdateBtn().setVisible(true);
        this.contactRecordView.getSaveBtn().setVisible(false);
        InputStream inputStream = this.service.getImage(contactId);
        if (inputStream != null) {
            BufferedImage image = ImageIO.read(inputStream);
            if (image != null) {
                ImageIcon icon = new ImageIcon(AutoResize.resize(image, 64, 64));
                this.contactRecordView.getImagePreview().setIcon(icon);
                this.contactRecordView.getRemoveImageBtn().setEnabled(true);
            } else {
                this.contactRecordView.getImagePreview().setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/photo-l.png"))));
                this.contactRecordView.getRemoveImageBtn().setEnabled(false);
            }
        } else {
            this.contactRecordView.getImagePreview().setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/photo-l.png"))));
            this.contactRecordView.getRemoveImageBtn().setEnabled(false);
        }
        IntStream.rangeClosed(1, 5).forEachOrdered(index -> this.contactRecordView.getMainTabs().setEnabledAt(index, true));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean validateCsvHeaders(File csvFile) {
        try (CSVReader reader = new CSVReader(new FileReader(csvFile));){
            String[] headers = reader.readNext();
            if (headers == null) {
                JOptionPane.showMessageDialog(this.view.getImportDio(), "The CSV file is empty.", "Error", 0);
                boolean bl = false;
                return bl;
            }
            String[] REQUIRED_HEADERS = new String[]{"Name", "Address", "Area", "City", "Pin", "Mobile"};
            if (headers.length != REQUIRED_HEADERS.length) {
                JOptionPane.showMessageDialog(this.view.getImportDio(), "Invalid template.", "Error", 0);
                boolean bl = false;
                return bl;
            }
            int i = 0;
            while (i < headers.length) {
                if (!headers[i].trim().equalsIgnoreCase(REQUIRED_HEADERS[i])) {
                    JOptionPane.showMessageDialog(this.view.getImportDio(), "Invalid header: " + headers[i] + ". Expected: " + REQUIRED_HEADERS[i], "Error", 0);
                    boolean bl = false;
                    return bl;
                }
                ++i;
            }
            return true;
        }
        catch (CsvValidationException | IOException e) {
            new ErrorDialog(e, "import template");
        }
        return true;
    }

    Map<String, Object> analysisData(File csvFile) throws Exception {
        HashSet<String> seenNames = new HashSet<String>();
        String contactGroup = (String)this.view.getImportGroupCb().getSelectedItem();
        if (contactGroup != null) {
            Map<Integer, String> contacts = this.service.loadContactNamesByGroup(contactGroup);
            contacts.forEach((key, value) -> seenNames.add((String)value));
        }
        ArrayList<String[]> uniqueRecords = new ArrayList<String[]>();
        ArrayList<String> duplicateNames = new ArrayList<String>();
        try (CSVReader reader = new CSVReader(new FileReader(csvFile));){
            String[] nextLine;
            String[] header = reader.readNext();
            if (header != null) {
                uniqueRecords.add(header);
            }
            while ((nextLine = reader.readNext()) != null) {
                String name = nextLine[0].trim();
                if (seenNames.contains(name)) {
                    duplicateNames.add(name);
                    continue;
                }
                seenNames.add(name);
                uniqueRecords.add(nextLine);
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("uniqueRecords", uniqueRecords);
        result.put("duplicateNames", duplicateNames);
        return result;
    }

    private void saveContactDetails(File selectedFile) throws Exception {
        if (this.validateCsvHeaders(selectedFile)) {
            String selectedGroupName = (String)this.view.getImportGroupCb().getSelectedItem();
            Map<Integer, String> groupDts = ContactGroupCache.getGroupIdToNameMap();
            AtomicReference<Integer> selectedGroupId = new AtomicReference<Integer>(0);
            groupDts.forEach((key, value) -> {
                if (value.equals(selectedGroupName)) {
                    selectedGroupId.set((Integer)key);
                }
            });
            Map<String, Object> analysis = this.analysisData(selectedFile);
            List uniqueRecords = (List)analysis.get("uniqueRecords");
            List duplicateNames = (List)analysis.get("duplicateNames");
            if (!duplicateNames.isEmpty()) {
                JOptionPane.showMessageDialog(this.view.getImportDio(), "Duplicate names found: " + String.join((CharSequence)", ", duplicateNames));
            }
            uniqueRecords.remove(0);
            for (String[] data : uniqueRecords) {
                String strMobile;
                ContactRecord contactRecord = new ContactRecord.Builder().name(data[0]).groupId(selectedGroupId.get()).imagePath("").contactId(0).build();
                int contactId = this.contactRecordService.save(contactRecord);
                String strAddress = data[1];
                String strArea = data[2];
                String strCity = data[3];
                String strPin = data[4];
                if (!strAddress.isBlank()) {
                    ContactAddress contactAddress = new ContactAddress.Builder().addressTagAs("Primary").addressId(0).address(strAddress).area(strArea).city(strCity).pin(strPin).isPrimary(true).contactId(contactId).build();
                    this.contactRecordService.saveAddress(contactAddress);
                }
                if ((strMobile = data[5]).isBlank()) continue;
                ContactNumber contactNumber = new ContactNumber.Builder().contactNumberId(0).contactTagAs("Mobile").contactValue(strMobile).contactId(contactId).isPrimary(true).build();
                this.contactRecordService.saveContact(contactNumber);
            }
            if (uniqueRecords.isEmpty()) {
                JOptionPane.showMessageDialog(this.view.getImportDio(), "No unique record found !");
            } else {
                this.view.getImportInfoLabel().setText(uniqueRecords.size() + " records Imported successfully!");
                this.loadContactRecords();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser fileChooser;
        Object obj = e.getSource();
        if (e.getSource() == this.view.getPrevButton() && this.view.getCurrentPage() > 1) {
            this.view.setCurrentPage(this.view.getCurrentPage() - 1);
            this.loadContactRecords();
        }
        if (e.getSource() == this.view.getNextButton() && this.view.getCurrentPage() * this.view.getPAGE_SIZE() < this.view.getTotalRecords()) {
            this.view.setCurrentPage(this.view.getCurrentPage() + 1);
            this.loadContactRecords();
        }
        if (e.getSource() == this.view.getImportRecordBtn()) {
            fileChooser = new JFileChooser();
            if (this.lastOpenedDirectory != null && !this.lastOpenedDirectory.isEmpty()) {
                fileChooser.setCurrentDirectory(new File(this.lastOpenedDirectory));
            }
            FileNameExtensionFilter filter = new FileNameExtensionFilter("contact template", "csv");
            fileChooser.setFileFilter(filter);
            fileChooser.setDialogTitle("Select contact file");
            int userSelection = fileChooser.showOpenDialog(this.view.getImportBtn());
            if (userSelection == 0) {
                try {
                    File selectedFile = fileChooser.getSelectedFile();
                    this.lastOpenedDirectory = fileChooser.getSelectedFile().getParent();
                    this.saveContactDetails(selectedFile);
                }
                catch (Exception e1) {
                    new ErrorDialog(e1, "import template");
                }
            }
        }
        if (e.getSource() == this.view.getDownloadTemplate()) {
            fileChooser = new JFileChooser();
            fileChooser.setDialogTitle("Save import contacts template");
            int userSelection = fileChooser.showSaveDialog(this.view.getDownloadTemplate());
            if (userSelection == 0) {
                try {
                    File fileToSave = fileChooser.getSelectedFile();
                    if (!fileToSave.getName().endsWith(".csv")) {
                        fileToSave = new File(fileToSave.getAbsolutePath() + ".csv");
                    }
                    try (FileOutputStream file = new FileOutputStream(fileToSave);
                         PrintWriter writer = new PrintWriter(file);){
                        writer.println("Name,Address,Area,City,Pin,Mobile");
                        writer.flush();
                    }
                    JOptionPane.showMessageDialog(this.view.getImportDio(), "Download template successfully!");
                }
                catch (Exception e1) {
                    new ErrorDialog(e1, "Download template");
                }
            }
        }
        if (e.getSource() == this.view.getImportCancelBtn()) {
            this.view.getImportDio().setVisible(false);
            this.view.getImportDio().dispose();
        }
        if (obj == this.view.getImportBtn() || obj == this.view.getImportPopupMenu()) {
            this.view.getImportInfoLabel().setText("");
            AppUtility.setDialogLocationInCenter(this.view.getImportDio());
            this.view.getImportDio().setVisible(true);
        }
        if (obj == this.view.getManaDocumentPopupMenu() || obj == this.view.getManageDocumentBtn()) {
            int row = this.view.getTable().getSelectedRow();
            String selectedName = (String)this.view.getTable().getValueAt(row, 1);
            int selectedContactId = (Integer)this.view.getTable().getValueAt(row, 5);
            ManageDocuments manageDocuments = new ManageDocuments("Contacts", selectedContactId);
            manageDocuments.getDocumentDio().setTitle("Manage documents for - " + selectedName);
            manageDocuments.getDocumentDio().setVisible(true);
        }
        if (obj == this.view.getShowPieChartBtn() || obj == this.view.getShowChartPopupMenu()) {
            new DisplayPieChart(this.dataset, "Total contacts by group");
        }
        if (obj == this.view.getViewBtn() || obj == this.view.getViewPopupMenu()) {
            int row = this.view.getTable().getSelectedRow();
            if (row >= 0) {
                int selectedContactId = (Integer)this.view.getTable().getValueAt(row, 5);
                new ContactDetailsView(selectedContactId, null);
            } else {
                JOptionPane.showMessageDialog(LoginView.frame, "Select any record to delete");
            }
        }
        if (obj == this.view.getZoomInBtn()) {
            AppUtility.tableZoomInZoomOut(true, this.view.getTable());
        }
        if (obj == this.view.getZoomOutBtn()) {
            AppUtility.tableZoomInZoomOut(false, this.view.getTable());
        }
        if (obj == this.view.getRefBtn() || obj == this.view.getRefPopupMenu()) {
            this.loadGroups();
        }
        if (obj == this.view.getUpdR() || obj == this.view.getUpdatePopupMenu()) {
            int row = this.view.getTable().getSelectedRow();
            if (row >= 0) {
                try {
                    this.loadContactRecordForm(row);
                }
                catch (Exception ex) {
                    new ErrorDialog(ex, "load data to update contact");
                }
                this.contactRecordView.getMainTabs().setSelectedIndex(0);
                this.contactRecordView.getDio().setVisible(true);
                this.loadContactRecords();
            } else {
                JOptionPane.showMessageDialog(LoginView.frame, "Select any record for update");
            }
        }
        if (obj == this.view.getDel() || obj == this.view.getDeletePopupMenu()) {
            int choose;
            int[] selectedRows = this.view.getTable().getSelectedRows();
            StringBuilder contactsName = new StringBuilder();
            for (int row : selectedRows) {
                contactsName.append((String)this.view.getTable().getValueAt(row, 1));
                contactsName.append(", ");
            }
            int lastCommaIndex = contactsName.lastIndexOf(",");
            if (lastCommaIndex != -1) {
                contactsName.deleteCharAt(lastCommaIndex);
                int secondLastCommaIndex = contactsName.lastIndexOf(",", lastCommaIndex - 1);
                if (secondLastCommaIndex != -1) {
                    contactsName.replace(secondLastCommaIndex, secondLastCommaIndex + 1, " and");
                }
            }
            if ((choose = JOptionPane.showConfirmDialog(this.view, "Warning : if you delete " + contactsName + ", all related records will also be deleted. \nAre you sure to delete ?", "Delete record", 1)) == 0) {
                try {
                    ArrayList<Integer> selectedRowIdsList = new ArrayList<Integer>();
                    for (int row : selectedRows) {
                        selectedRowIdsList.add((Integer)this.view.getTable().getValueAt(row, 5));
                    }
                    this.service.deleteRecord(selectedRowIdsList);
                    JOptionPane.showMessageDialog(LoginView.frame, contactsName + " deleted successfully");
                    this.loadContactRecords();
                }
                catch (Exception ex) {
                    new ErrorDialog(ex, "Delete contact");
                }
            }
        }
        if (obj == this.view.getNewI() || obj == this.view.getNewRPopupMenu()) {
            this.contactRecordView.getDio().setTitle("New Record");
            this.contactRecordView.getUpdateBtn().setVisible(false);
            this.contactRecordView.getSaveBtn().setVisible(true);
            this.resetContactRecordForm();
            IntStream.rangeClosed(1, 5).forEachOrdered(index -> this.contactRecordView.getMainTabs().setEnabledAt(index, false));
            this.contactRecordView.getMainTabs().setSelectedIndex(0);
            this.contactRecordView.getDio().setVisible(true);
            this.loadContactRecords();
        }
        if (obj == this.view.getNewG()) {
            this.manageGroupView.getDio().setTitle("New group");
            this.manageGroupView.getUpdateBtn().setVisible(false);
            this.manageGroupView.getSaveBtn().setVisible(true);
            this.manageGroupView.getValidationError().setVisible(false);
            this.manageGroupView.setContactGroupId(0);
            this.manageGroupView.getGroupNameField().setText("");
            this.manageGroupView.getDio().setVisible(true);
            this.loadGroups();
        }
        if (obj == this.view.getUpdG()) {
            String selectedGroupName = (String)this.view.getGroupList().getSelectedItem();
            this.manageGroupView.getDio().setTitle("update group");
            this.manageGroupView.setContactGroupId(ContactGroupCache.getGroupIdByName(selectedGroupName));
            this.manageGroupView.getUpdateBtn().setVisible(true);
            this.manageGroupView.getSaveBtn().setVisible(false);
            this.manageGroupView.getValidationError().setVisible(false);
            this.manageGroupView.getGroupNameField().setText(selectedGroupName);
            this.manageGroupView.getDio().setVisible(true);
            this.loadGroups();
        }
        if (obj == this.view.getDelG()) {
            String selectedGroupName = (String)this.view.getGroupList().getSelectedItem();
            try {
                int selection = JOptionPane.showConfirmDialog(null, "Are you sure to delete group " + selectedGroupName, "Delete Group", 1);
                if (selection == 0) {
                    this.manageGroupService.deleteGroup(ContactGroupCache.getGroupIdByName(selectedGroupName));
                    JOptionPane.showMessageDialog(this.view, selectedGroupName + " group deleted successfully");
                    ContactGroupCache.loadContactGroups();
                    this.loadGroups();
                }
            }
            catch (Exception ex) {
                new ErrorDialog(ex, "getDelG");
            }
        }
        if (obj == this.view.getGroupList()) {
            this.loadContactRecords();
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (e.getSource() == this.view.getSearchTf() && this.view.getSearchTf().getText().trim().equals(CLICK_HERE_TO_SEARCH_CONTACTS)) {
            this.view.getSearchTf().setText("");
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getSource() == this.view.getSearchTf() && this.view.getSearchTf().getText().isBlank()) {
            this.view.getSearchTf().setText(CLICK_HERE_TO_SEARCH_CONTACTS);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getSource() == this.view.getSearchTf()) {
            this.loadContactRecords();
        }
    }

    private void loadDetailsOnRowSelection() {
        try {
            int contactId = (Integer)this.view.getTable().getValueAt(this.view.getTable().getSelectedRow(), 5);
            String groupName = (String)this.view.getTable().getValueAt(this.view.getTable().getSelectedRow(), 6);
            this.view.getShowGroupNameLabel().setText("Group Name : " + groupName);
            this.setSelectedRowIndex(this.view.getTable().getSelectedRow());
            InputStream inputStream = this.service.getImage(contactId);
            if (inputStream != null) {
                BufferedImage image = ImageIO.read(inputStream);
                if (image != null) {
                    AutoResize responsiveImg = new AutoResize(image);
                    this.view.getImageLabel().removeAll();
                    this.view.getImageLabel().add(responsiveImg);
                } else {
                    this.view.getImageLabel().removeAll();
                    this.view.getImageLabel().add(new JLabel(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/noImage.png")))));
                }
            } else {
                this.view.getImageLabel().removeAll();
                this.view.getImageLabel().add(new JLabel(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/noImage.png")))));
            }
            this.view.getImageLabel().revalidate();
            this.view.getImageLabel().repaint();
        }
        catch (Exception ex) {
            new ErrorDialog(ex, "loadDetailsOnRowSelection");
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.view.getSelectionModel()) {
            int[] selectedRows = this.view.getTable().getSelectedRows();
            if (selectedRows.length == 0) {
                this.view.getNotificationPanel().removeAll();
                this.view.getNotificationPanel().revalidate();
                this.view.getNotificationPanel().repaint();
                this.view.getImageLabel().removeAll();
                this.view.getImageLabel().add(new JLabel(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/noImage.png")))));
                this.view.getImageLabel().revalidate();
                this.view.getImageLabel().repaint();
                this.view.getUpdR().setEnabled(false);
                this.view.getDel().setEnabled(false);
                this.view.getManageDocumentBtn().setEnabled(false);
                this.view.getViewBtn().setEnabled(false);
                this.view.getShowGroupNameLabel().setText("");
            } else if (selectedRows.length == 1) {
                this.loadDetailsOnRowSelection();
                this.view.getUpdR().setEnabled(true);
                this.view.getDel().setEnabled(true);
                this.view.getManageDocumentBtn().setEnabled(true);
                this.view.getViewBtn().setEnabled(true);
                this.view.getUpdatePopupMenu().setVisible(true);
                this.view.getManaDocumentPopupMenu().setVisible(true);
                this.view.getViewPopupMenu().setVisible(true);
            } else {
                this.view.getNotificationPanel().removeAll();
                this.view.getNotificationPanel().revalidate();
                this.view.getNotificationPanel().repaint();
                this.view.getImageLabel().removeAll();
                this.view.getImageLabel().add(new JLabel(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/noImage.png")))));
                this.view.getImageLabel().revalidate();
                this.view.getImageLabel().repaint();
                this.view.getUpdR().setEnabled(false);
                this.view.getDel().setEnabled(true);
                this.view.getManageDocumentBtn().setEnabled(false);
                this.view.getViewBtn().setEnabled(false);
                this.view.getShowGroupNameLabel().setText("");
                this.view.getUpdatePopupMenu().setVisible(false);
                this.view.getManaDocumentPopupMenu().setVisible(false);
                this.view.getViewPopupMenu().setVisible(false);
            }
        }
    }
}

