/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.controller.contact;

import com.arun.bhardwaj.cache.ContactGroupCache;
import com.arun.bhardwaj.model.contact.ContactAdditionalInfo;
import com.arun.bhardwaj.model.contact.ContactAddress;
import com.arun.bhardwaj.model.contact.ContactEvent;
import com.arun.bhardwaj.model.contact.ContactLinks;
import com.arun.bhardwaj.model.contact.ContactNumber;
import com.arun.bhardwaj.model.contact.ContactRecord;
import com.arun.bhardwaj.service.contact.ContactRecordService;
import com.arun.bhardwaj.service.contact.ContactRecordServiceImpl;
import com.arun.bhardwaj.service.contact.ContactService;
import com.arun.bhardwaj.service.contact.ContactServiceImpl;
import com.arun.bhardwaj.utility.AppUtility;
import com.arun.bhardwaj.utility.AutoResize;
import com.arun.bhardwaj.view.common.CustomDatePicker;
import com.arun.bhardwaj.view.common.ErrorDialog;
import com.arun.bhardwaj.view.contact.ContactRecordView;
import com.arun.bhardwaj.view.contact.ManageGroup;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.IntStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;

public class ContactRecordController
implements ActionListener,
ChangeListener,
ListSelectionListener {
    private final ContactRecordView view;
    private final ContactRecordService service;
    private final ContactService contactService;
    private final ManageGroup manageGroupView;
    private String imagePath = "";
    private String lastOpenedDirectory;
    private static final String SAVE_AS_MANDATORY = "Save as is mandatory";
    private static final String DATE_MANDATORY = "Date is mandatory";
    private static final String VALUE_MANDATORY = "Value is mandatory";

    public String getImagePath() {
        return this.imagePath;
    }

    public void setImagePath(String imagePath) {
        this.imagePath = imagePath;
    }

    public ContactRecordController(ContactRecordView view) {
        this.view = view;
        this.service = new ContactRecordServiceImpl();
        this.manageGroupView = new ManageGroup();
        this.contactService = new ContactServiceImpl();
        this.addActionEvents();
        this.addToolTip();
        this.addTableSelectionEvent();
        view.getMainTabs().addChangeListener(this);
        this.increaseTableRowHeight();
    }

    private void increaseTableRowHeight() {
        AppUtility.tableZoomInZoomOut(true, this.view.getAddressTable());
        AppUtility.tableZoomInZoomOut(true, this.view.getAddressTable());
        AppUtility.tableZoomInZoomOut(true, this.view.getContactTable());
        AppUtility.tableZoomInZoomOut(true, this.view.getContactTable());
        AppUtility.tableZoomInZoomOut(true, this.view.getEmailTable());
        AppUtility.tableZoomInZoomOut(true, this.view.getEmailTable());
        AppUtility.tableZoomInZoomOut(true, this.view.getEventTable());
        AppUtility.tableZoomInZoomOut(true, this.view.getEventTable());
        AppUtility.tableZoomInZoomOut(true, this.view.getAdditionalInfoTable());
        AppUtility.tableZoomInZoomOut(true, this.view.getAdditionalInfoTable());
    }

    private void addToolTip() {
        this.view.getAddNewGroup().setToolTipText("Add new group");
        this.view.getBrowseImageBtn().setToolTipText("Select image for this contact");
        this.view.getRemoveImageBtn().setToolTipText("Remove image");
        this.view.getSaveBtn().setToolTipText("Save record");
        this.view.getUpdateBtn().setToolTipText("Update record");
        this.view.getCancelBtn().setToolTipText("Close");
    }

    private void addTableSelectionEvent() {
        this.view.getAddressSelectionModel().addListSelectionListener(this);
        this.view.getContactSelectionModel().addListSelectionListener(this);
        this.view.getEmailSelectionModel().addListSelectionListener(this);
        this.view.getEventSelectionModel().addListSelectionListener(this);
        this.view.getAdditionalInfoSelectionModel().addListSelectionListener(this);
    }

    private void addActionEvents() {
        this.view.getBrowseImageBtn().addActionListener(this);
        this.view.getRemoveImageBtn().addActionListener(this);
        this.view.getAddNewGroup().addActionListener(this);
        this.view.getCancelBtn().addActionListener(this);
        this.view.getSaveBtn().addActionListener(this);
        this.view.getUpdateBtn().addActionListener(this);
        this.view.getAddAddressBtn().addActionListener(this);
        this.view.getDeleteAddressBtn().addActionListener(this);
        this.view.getUpdateAddressBtn().addActionListener(this);
        this.view.getSaveAddressBtn().addActionListener(this);
        this.view.getUpdateAddrBtn().addActionListener(this);
        this.view.getCloseAddressBtn().addActionListener(this);
        this.view.getAddrZoomInBtn().addActionListener(this);
        this.view.getAddrZoomOutBtn().addActionListener(this);
        this.view.getAddrAddPopupMenu().addActionListener(this);
        this.view.getAddrUpdatePopupMenu().addActionListener(this);
        this.view.getAddrDeletePopupMenu().addActionListener(this);
        this.view.getAddrRefPopupMenu().addActionListener(this);
        this.view.getAddContactBtn().addActionListener(this);
        this.view.getUpdateContactBtn().addActionListener(this);
        this.view.getDeleteContactBtn().addActionListener(this);
        this.view.getContactDioSaveBtn().addActionListener(this);
        this.view.getContactDioUpdateBtn().addActionListener(this);
        this.view.getContactDioCloseBtn().addActionListener(this);
        this.view.getContactZoomInBtn().addActionListener(this);
        this.view.getContactZoomOutBtn().addActionListener(this);
        this.view.getContactAddPopupMenu().addActionListener(this);
        this.view.getContactUpdatePopupMenu().addActionListener(this);
        this.view.getContactDeletePopupMenu().addActionListener(this);
        this.view.getContactRefPopupMenu().addActionListener(this);
        this.view.getAddEmailBtn().addActionListener(this);
        this.view.getUpdateEmailBtn().addActionListener(this);
        this.view.getDeleteEmailBtn().addActionListener(this);
        this.view.getEmailDioSaveBtn().addActionListener(this);
        this.view.getEmailDioUpdateBtn().addActionListener(this);
        this.view.getEmailDioCloseBtn().addActionListener(this);
        this.view.getEmailZoomInBtn().addActionListener(this);
        this.view.getEmailZoomOutBtn().addActionListener(this);
        this.view.getEmailAddPopupMenu().addActionListener(this);
        this.view.getEmailUpdatePopupMenu().addActionListener(this);
        this.view.getEmailDeletePopupMenu().addActionListener(this);
        this.view.getEmailRefPopupMenu().addActionListener(this);
        this.view.getAddEventBtn().addActionListener(this);
        this.view.getUpdateEventBtn().addActionListener(this);
        this.view.getDeleteEventBtn().addActionListener(this);
        this.view.getEventDioSaveBtn().addActionListener(this);
        this.view.getEventDioUpdateBtn().addActionListener(this);
        this.view.getEventDioCloseBtn().addActionListener(this);
        this.view.getEventDioDateBtn().addActionListener(this);
        this.view.getEventZoomInBtn().addActionListener(this);
        this.view.getEventZoomOutBtn().addActionListener(this);
        this.view.getEventAddPopupMenu().addActionListener(this);
        this.view.getEventUpdatePopupMenu().addActionListener(this);
        this.view.getEventDeletePopupMenu().addActionListener(this);
        this.view.getEventRefPopupMenu().addActionListener(this);
        this.view.getAddAdditionalInfoBtn().addActionListener(this);
        this.view.getUpdateAdditionalInfoBtn().addActionListener(this);
        this.view.getDeleteAdditionalInfoBtn().addActionListener(this);
        this.view.getAddiInfoDioSaveBtn().addActionListener(this);
        this.view.getAddiInfoDioUpdateBtn().addActionListener(this);
        this.view.getAddiInfoDioCloseBtn().addActionListener(this);
        this.view.getAddiZoomInBtn().addActionListener(this);
        this.view.getAddiZoomOutBtn().addActionListener(this);
        this.view.getAddiAddPopupMenu().addActionListener(this);
        this.view.getAddiUpdatePopupMenu().addActionListener(this);
        this.view.getAddiDeletePopupMenu().addActionListener(this);
        this.view.getAddiRefPopupMenu().addActionListener(this);
    }

    private void populateContactGroup() {
        try {
            this.view.getGroupNames().removeAllItems();
            Map<Integer, String> contactGroupDts = ContactGroupCache.getGroupIdToNameMap();
            contactGroupDts.forEach((key, value) -> this.view.getGroupNames().addItem(value));
        }
        catch (Exception e) {
            new ErrorDialog(e, "populateContactGroup");
        }
    }

    private boolean isBasicFormValid() {
        boolean isValid = true;
        String selectedGroupName = (String)this.view.getGroupNames().getSelectedItem();
        if (selectedGroupName == null) {
            JOptionPane.showMessageDialog(this.view.getDio(), "Group is mandatory", "Error", 0);
            isValid = false;
        }
        if (this.view.getNameField().getText().trim().isEmpty()) {
            JOptionPane.showMessageDialog(this.view.getDio(), "Name is mandatory", "Error", 0);
            this.view.getNameField().requestFocus();
            isValid = false;
        }
        if (!AppUtility.isValidText(this.view.getNameField().getText())) {
            JOptionPane.showMessageDialog(this.view.getDio(), "Please enter valid name", "Error", 0);
            this.view.getNameField().requestFocus();
            isValid = false;
        }
        return isValid;
    }

    private boolean isAddressNotEmpty() {
        return !this.view.getAddressField().getText().isEmpty() || !this.view.getAreaField().getText().isEmpty() || !this.view.getCityField().getText().isEmpty() || !this.view.getPinField().getText().isEmpty();
    }

    private void saveOrUpdateContactBasicDetails() throws Exception {
        String selectedGroupName = (String)this.view.getGroupNames().getSelectedItem();
        ContactRecord contactRecord = new ContactRecord.Builder().name(this.view.getNameField().getText()).comments(this.view.getComment().getText()).imagePath(this.getImagePath()).groupId(ContactGroupCache.getGroupIdByName(selectedGroupName)).contactId(this.view.getContactId()).build();
        int contactId = this.service.save(contactRecord);
        this.view.setContactId(contactId);
        if (this.isAddressNotEmpty()) {
            ContactAddress contactAddress = new ContactAddress.Builder().addressTagAs("Home").addressId(this.view.getAddressId()).address(this.view.getAddressField().getText()).area(this.view.getAreaField().getText()).city(this.view.getCityField().getText()).pin(this.view.getPinField().getText()).isPrimary(true).contactId(contactId).build();
            if (this.view.getAddressId() == 0) {
                int addressId = this.service.saveAddress(contactAddress);
                this.view.setAddressId(addressId);
            } else {
                this.service.updateAddress(contactAddress);
            }
        }
        if (!this.view.getPhoneNoField().getText().isEmpty()) {
            ContactNumber contactNumber = new ContactNumber.Builder().contactNumberId(this.view.getNumberId()).contactTagAs("Mobile").contactValue(this.view.getPhoneNoField().getText()).contactId(contactId).isPrimary(true).build();
            if (this.view.getNumberId() == 0) {
                int contactNumberId = this.service.saveContact(contactNumber);
                this.view.setNumberId(contactNumberId);
            } else {
                this.service.updateContact(contactNumber);
            }
        }
        IntStream.rangeClosed(1, 5).forEachOrdered(index -> this.view.getMainTabs().setEnabledAt(index, true));
    }

    private void loadContactAddress() throws Exception {
        List<ContactAddress> contactAddresses = this.service.loadContactAddress(this.view.getContactId());
        this.view.getAddressDefaultTableModel().setRowCount(0);
        IntStream.range(0, contactAddresses.size()).forEach(index -> {
            this.view.getAddressDefaultTableModel().addRow(new Object[]{"", "", "", "", "", "", "", ""});
            this.view.getAddressTable().setValueAt(String.valueOf(index + 1), index, 0);
            this.view.getAddressTable().setValueAt(((ContactAddress)contactAddresses.get(index)).addressTagAs(), index, 1);
            this.view.getAddressTable().setValueAt(((ContactAddress)contactAddresses.get(index)).address(), index, 2);
            this.view.getAddressTable().setValueAt(((ContactAddress)contactAddresses.get(index)).area(), index, 3);
            this.view.getAddressTable().setValueAt(((ContactAddress)contactAddresses.get(index)).city(), index, 4);
            this.view.getAddressTable().setValueAt(((ContactAddress)contactAddresses.get(index)).pin(), index, 5);
            this.view.getAddressTable().setValueAt(((ContactAddress)contactAddresses.get(index)).isPrimary() ? "Yes" : "", index, 6);
            this.view.getAddressTable().setValueAt(((ContactAddress)contactAddresses.get(index)).addressId(), index, 7);
            this.view.getAddressTable().setAutoCreateRowSorter(true);
        });
        AppUtility.tableZoomInZoomOut(true, this.view.getAddressTable());
        AppUtility.tableZoomInZoomOut(false, this.view.getAddressTable());
    }

    private void loadContactNumbers() throws Exception {
        List<ContactNumber> contactNumbers = this.service.loadContacts(this.view.getContactId());
        this.view.getContactDefaultTableModel().setRowCount(0);
        IntStream.range(0, contactNumbers.size()).forEach(index -> {
            this.view.getContactDefaultTableModel().addRow(new Object[]{"", "", "", "", ""});
            this.view.getContactTable().setValueAt(String.valueOf(index + 1), index, 0);
            this.view.getContactTable().setValueAt(((ContactNumber)contactNumbers.get(index)).contactTagAs(), index, 1);
            this.view.getContactTable().setValueAt(((ContactNumber)contactNumbers.get(index)).contactValue(), index, 2);
            this.view.getContactTable().setValueAt(((ContactNumber)contactNumbers.get(index)).isPrimary() ? "Yes" : "", index, 3);
            this.view.getContactTable().setValueAt(((ContactNumber)contactNumbers.get(index)).contactNumberId(), index, 4);
            this.view.getContactTable().setAutoCreateRowSorter(true);
        });
        AppUtility.tableZoomInZoomOut(true, this.view.getContactTable());
        AppUtility.tableZoomInZoomOut(false, this.view.getContactTable());
    }

    private void loadContactEmails() throws Exception {
        List<ContactLinks> contactLinks = this.service.loadLinks(this.view.getContactId());
        this.view.getEmailDefaultTableModel().setRowCount(0);
        IntStream.range(0, contactLinks.size()).forEach(index -> {
            this.view.getEmailDefaultTableModel().addRow(new Object[]{"", "", "", "", ""});
            this.view.getEmailTable().setValueAt(String.valueOf(index + 1), index, 0);
            this.view.getEmailTable().setValueAt(((ContactLinks)contactLinks.get(index)).linkType(), index, 1);
            this.view.getEmailTable().setValueAt(((ContactLinks)contactLinks.get(index)).tagAs(), index, 2);
            this.view.getEmailTable().setValueAt(((ContactLinks)contactLinks.get(index)).value(), index, 3);
            this.view.getEmailTable().setValueAt(((ContactLinks)contactLinks.get(index)).linkId(), index, 4);
            this.view.getEmailTable().setAutoCreateRowSorter(true);
        });
        AppUtility.tableZoomInZoomOut(true, this.view.getEmailTable());
        AppUtility.tableZoomInZoomOut(false, this.view.getEmailTable());
    }

    private void loadContactEvents() throws Exception {
        List<ContactEvent> contactEvents = this.service.loadEvents(this.view.getContactId());
        this.view.getEventDefaultTableModel().setRowCount(0);
        IntStream.range(0, contactEvents.size()).forEach(index -> {
            this.view.getEventDefaultTableModel().addRow(new Object[]{"", "", "", ""});
            this.view.getEventTable().setValueAt(String.valueOf(index + 1), index, 0);
            this.view.getEventTable().setValueAt(((ContactEvent)contactEvents.get(index)).eventTagAs(), index, 1);
            this.view.getEventTable().setValueAt(((ContactEvent)contactEvents.get(index)).date(), index, 2);
            this.view.getEventTable().setValueAt(((ContactEvent)contactEvents.get(index)).eventId(), index, 3);
            this.view.getEventTable().setAutoCreateRowSorter(true);
        });
        AppUtility.tableZoomInZoomOut(true, this.view.getEventTable());
        AppUtility.tableZoomInZoomOut(false, this.view.getEventTable());
    }

    private void loadContactAdditionalInfo() throws Exception {
        List<ContactAdditionalInfo> contactAdditionalInfo = this.service.loadAdditionalInfo(this.view.getContactId());
        this.view.getAdditionalInfoDefaultTableModel().setRowCount(0);
        IntStream.range(0, contactAdditionalInfo.size()).forEach(index -> {
            this.view.getAdditionalInfoDefaultTableModel().addRow(new Object[]{"", "", "", ""});
            this.view.getAdditionalInfoTable().setValueAt(String.valueOf(index + 1), index, 0);
            this.view.getAdditionalInfoTable().setValueAt(((ContactAdditionalInfo)contactAdditionalInfo.get(index)).tagAs(), index, 1);
            this.view.getAdditionalInfoTable().setValueAt(((ContactAdditionalInfo)contactAdditionalInfo.get(index)).value(), index, 2);
            this.view.getAdditionalInfoTable().setValueAt(((ContactAdditionalInfo)contactAdditionalInfo.get(index)).id(), index, 3);
            this.view.getAdditionalInfoTable().setAutoCreateRowSorter(true);
        });
        AppUtility.tableZoomInZoomOut(true, this.view.getAdditionalInfoTable());
        AppUtility.tableZoomInZoomOut(false, this.view.getAdditionalInfoTable());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int choose;
        int row;
        Object obj = e.getSource();
        if (obj == this.view.getAddiZoomInBtn()) {
            AppUtility.tableZoomInZoomOut(true, this.view.getAdditionalInfoTable());
        }
        if (obj == this.view.getAddiZoomOutBtn()) {
            AppUtility.tableZoomInZoomOut(false, this.view.getAdditionalInfoTable());
        }
        if (obj == this.view.getEventZoomInBtn()) {
            AppUtility.tableZoomInZoomOut(true, this.view.getEventTable());
        }
        if (obj == this.view.getEventZoomOutBtn()) {
            AppUtility.tableZoomInZoomOut(false, this.view.getEventTable());
        }
        if (obj == this.view.getEmailZoomInBtn()) {
            AppUtility.tableZoomInZoomOut(true, this.view.getEmailTable());
        }
        if (obj == this.view.getEmailZoomOutBtn()) {
            AppUtility.tableZoomInZoomOut(false, this.view.getEmailTable());
        }
        if (obj == this.view.getContactZoomInBtn()) {
            AppUtility.tableZoomInZoomOut(true, this.view.getContactTable());
        }
        if (obj == this.view.getContactZoomOutBtn()) {
            AppUtility.tableZoomInZoomOut(false, this.view.getContactTable());
        }
        if (obj == this.view.getAddrZoomInBtn()) {
            AppUtility.tableZoomInZoomOut(true, this.view.getAddressTable());
        }
        if (obj == this.view.getAddrZoomOutBtn()) {
            AppUtility.tableZoomInZoomOut(false, this.view.getAddressTable());
        }
        if (obj == this.view.getEventDioDateBtn()) {
            CustomDatePicker customDatePicker = new CustomDatePicker(this, "eventDate");
            AppUtility.setDialogLocationInCenter(customDatePicker.getDio());
            customDatePicker.getDio().setVisible(true);
        }
        if (obj == this.view.getAddiInfoDioUpdateBtn()) {
            if (this.view.getAddiInfoDioTagAsTf().getText().isBlank()) {
                JOptionPane.showMessageDialog(this.view.getDio(), SAVE_AS_MANDATORY, "Error", 0);
                this.view.getAddiInfoDioTagAsTf().requestFocus();
            } else if (this.view.getAddiInfoDioValueTf().getText().isBlank()) {
                JOptionPane.showMessageDialog(this.view.getDio(), "Details is mandatory", "Error", 0);
                this.view.getAddiInfoDioValueTf().requestFocus();
            } else {
                try {
                    int row2 = this.view.getAdditionalInfoTable().getSelectedRow();
                    int id = (Integer)this.view.getAdditionalInfoTable().getValueAt(row2, 3);
                    this.service.updateAdditionalInfo(new ContactAdditionalInfo.Builder().tagAs(this.view.getAddiInfoDioTagAsTf().getText()).value(this.view.getAddiInfoDioValueTf().getText()).id(id).build());
                    JOptionPane.showMessageDialog(this.view.getDio(), "Successfully updated !");
                    this.loadContactAdditionalInfo();
                    this.view.getAddiInfoDio().setVisible(false);
                }
                catch (Exception ex) {
                    new ErrorDialog(ex, "getAddiInfoDioUpdateBtn");
                }
            }
        }
        if (obj == this.view.getDeleteAdditionalInfoBtn() || obj == this.view.getAddiDeletePopupMenu()) {
            try {
                int choose2;
                int row3 = this.view.getAdditionalInfoTable().getSelectedRow();
                if (row3 >= 0 && (choose2 = JOptionPane.showConfirmDialog(this.view.getDio(), "Are you sure to delete ?", "Delete", 1)) == 0) {
                    int id = (Integer)this.view.getAdditionalInfoTable().getValueAt(row3, 3);
                    this.service.deleteAdditionalInfo(id);
                    JOptionPane.showMessageDialog(this.view.getDio(), "Successfully deleted !", "Delete", 1);
                    this.loadContactAdditionalInfo();
                }
            }
            catch (Exception ex) {
                new ErrorDialog(ex, "getDeleteAdditionalInfoBtn");
            }
        }
        if (obj == this.view.getAddiInfoDioSaveBtn()) {
            if (this.view.getAddiInfoDioTagAsTf().getText().isBlank()) {
                JOptionPane.showMessageDialog(this.view.getDio(), SAVE_AS_MANDATORY, "Error", 0);
                this.view.getAddiInfoDioTagAsTf().requestFocus();
            } else if (this.view.getAddiInfoDioValueTf().getText().isBlank()) {
                JOptionPane.showMessageDialog(this.view.getDio(), "Details is mandatory", "Error", 0);
                this.view.getAddiInfoDioValueTf().requestFocus();
            } else {
                try {
                    this.service.saveAdditionalInfo(new ContactAdditionalInfo.Builder().tagAs(this.view.getAddiInfoDioTagAsTf().getText()).value(this.view.getAddiInfoDioValueTf().getText()).contactId(this.view.getContactId()).build());
                    JOptionPane.showMessageDialog(this.view.getDio(), "Successfully saved !", "Success", 1);
                    this.loadContactAdditionalInfo();
                    this.view.getAddiInfoDio().setVisible(false);
                }
                catch (Exception ex) {
                    new ErrorDialog(ex, "getAddiInfoDioSaveBtn");
                }
            }
        }
        if (obj == this.view.getUpdateAdditionalInfoBtn() || obj == this.view.getAddiUpdatePopupMenu()) {
            this.view.getAddiInfoDioSaveBtn().setVisible(false);
            this.view.getAddiInfoDioUpdateBtn().setVisible(true);
            int row4 = this.view.getAdditionalInfoTable().getSelectedRow();
            String tagAs = (String)this.view.getAdditionalInfoTable().getValueAt(row4, 1);
            String value = (String)this.view.getAdditionalInfoTable().getValueAt(row4, 2);
            this.view.getAddiInfoDioTagAsTf().setText(tagAs);
            this.view.getAddiInfoDioValueTf().setText(value);
            this.view.getAddiInfoDio().setTitle("Update Additional Information");
            this.view.getAddiInfoDio().setVisible(true);
        }
        if (obj == this.view.getAddAdditionalInfoBtn() || obj == this.view.getAddiAddPopupMenu()) {
            this.view.getAddiInfoDioTagAsTf().setText("");
            this.view.getAddiInfoDioValueTf().setText("");
            this.view.getAddiInfoDioSaveBtn().setVisible(true);
            this.view.getAddiInfoDioUpdateBtn().setVisible(false);
            this.view.getAddiInfoDio().setTitle("New Additional Information");
            this.view.getAddiInfoDio().setVisible(true);
        }
        if (obj == this.view.getAddiInfoDioCloseBtn()) {
            this.view.getAddiInfoDio().setVisible(false);
        }
        if (obj == this.view.getEventDioUpdateBtn()) {
            if (this.view.getEventDioTagAsTf().getText().isBlank()) {
                JOptionPane.showMessageDialog(this.view.getDio(), SAVE_AS_MANDATORY, "Error", 0);
                this.view.getEventDioTagAsTf().requestFocus();
            } else if (this.view.getEventDioValueTf().getText().isBlank()) {
                JOptionPane.showMessageDialog(this.view.getDio(), DATE_MANDATORY, "Error", 0);
                this.view.getEventDioValueTf().requestFocus();
            } else {
                try {
                    int row5 = this.view.getEventTable().getSelectedRow();
                    int eventId = (Integer)this.view.getEventTable().getValueAt(row5, 3);
                    this.service.updateEvent(new ContactEvent.Builder().eventTagAs(this.view.getEventDioTagAsTf().getText()).date(this.view.getEventDioValueTf().getText()).eventId(eventId).build());
                    JOptionPane.showMessageDialog(this.view.getDio(), "Successfully updated !");
                    this.loadContactEvents();
                    this.view.getEventDio().setVisible(false);
                }
                catch (Exception ex) {
                    new ErrorDialog(ex, "getEventDioUpdateBtn");
                }
            }
        }
        if (obj == this.view.getDeleteEventBtn() || obj == this.view.getEventDeletePopupMenu()) {
            try {
                int choose3;
                int row6 = this.view.getEventTable().getSelectedRow();
                if (row6 >= 0 && (choose3 = JOptionPane.showConfirmDialog(this.view.getDio(), "Are you sure to delete ?", "Delete", 1)) == 0) {
                    int eventId = (Integer)this.view.getEventTable().getValueAt(row6, 3);
                    this.service.deleteEvent(eventId);
                    JOptionPane.showMessageDialog(this.view.getDio(), "Successfully deleted !", "Delete", 1);
                    this.loadContactEvents();
                }
            }
            catch (Exception ex) {
                new ErrorDialog(ex, "getDeleteEventBtn");
            }
        }
        if (obj == this.view.getEventDioSaveBtn()) {
            if (this.view.getEventDioTagAsTf().getText().isBlank()) {
                JOptionPane.showMessageDialog(this.view.getDio(), "Event name is mandatory", "Error", 0);
                this.view.getEventDioTagAsTf().requestFocus();
            } else if (this.view.getEventDioValueTf().getText().isBlank()) {
                JOptionPane.showMessageDialog(this.view.getDio(), DATE_MANDATORY, "Error", 0);
            } else {
                try {
                    this.service.saveEvent(new ContactEvent.Builder().eventTagAs(this.view.getEventDioTagAsTf().getText()).date(this.view.getEventDioValueTf().getText()).contactId(this.view.getContactId()).build());
                    JOptionPane.showMessageDialog(this.view.getDio(), "Successfully saved !");
                    this.loadContactEvents();
                    this.view.getEventDio().setVisible(false);
                }
                catch (Exception ex) {
                    new ErrorDialog(ex, "getEventDioSaveBtn");
                }
            }
        }
        if (obj == this.view.getEventDioCloseBtn()) {
            this.view.getEventDio().setVisible(false);
        }
        if (obj == this.view.getAddEventBtn() || obj == this.view.getEventAddPopupMenu()) {
            this.view.getEventDioUpdateBtn().setVisible(false);
            this.view.getEventDioSaveBtn().setVisible(true);
            this.view.getEventDioTagAsTf().setText("");
            this.view.getEventDioValueTf().setText("");
            this.view.getEventDio().setTitle("New Event");
            this.view.getEventDio().setVisible(true);
        }
        if (obj == this.view.getUpdateEventBtn() || obj == this.view.getEventUpdatePopupMenu()) {
            this.view.getEventDioUpdateBtn().setVisible(true);
            this.view.getEventDioSaveBtn().setVisible(false);
            int row7 = this.view.getEventTable().getSelectedRow();
            String eventTagAs = (String)this.view.getEventTable().getValueAt(row7, 1);
            String date = (String)this.view.getEventTable().getValueAt(row7, 2);
            this.view.getEventDioTagAsTf().setText(eventTagAs);
            this.view.getEventDioValueTf().setText(date);
            this.view.getEventDio().setTitle("Update Event");
            this.view.getEventDio().setVisible(true);
        }
        if (obj == this.view.getEmailDioUpdateBtn()) {
            if (this.view.getEmailDioTagAsTf().getText().isBlank()) {
                JOptionPane.showMessageDialog(this.view.getDio(), SAVE_AS_MANDATORY, "Error", 0);
                this.view.getEmailDioTagAsTf().requestFocus();
            } else if (this.view.getEmailDioValueTf().getText().isBlank()) {
                JOptionPane.showMessageDialog(this.view.getDio(), VALUE_MANDATORY, "Error", 0);
                this.view.getEmailDioValueTf().requestFocus();
            } else {
                try {
                    String type = (String)this.view.getEmailDioUrlType().getSelectedItem();
                    if ("Email".equals(type) && AppUtility.isValidEmail(this.view.getEmailDioValueTf().getText()) || AppUtility.isValidURL(this.view.getEmailDioValueTf().getText())) {
                        int row8 = this.view.getEmailTable().getSelectedRow();
                        int linkId = (Integer)this.view.getEmailTable().getValueAt(row8, 4);
                        ContactLinks contactLinks = new ContactLinks.Builder().linkType((String)this.view.getEmailDioUrlType().getSelectedItem()).tagAs(this.view.getEmailDioTagAsTf().getText()).value(this.view.getEmailDioValueTf().getText()).linkId(linkId).build();
                        this.service.updateLinks(contactLinks);
                        JOptionPane.showMessageDialog(this.view.getDio(), "Successfully updated !", "Success", 1);
                        this.view.getEmailDio().setVisible(false);
                        this.loadContactEmails();
                    } else {
                        JOptionPane.showMessageDialog(this.view.getDio(), "Please enter valid value", "Error", 0);
                    }
                }
                catch (Exception ex) {
                    new ErrorDialog(ex, "getEmailDioUpdateBtn");
                }
            }
        }
        if (obj == this.view.getEmailDioSaveBtn()) {
            if (this.view.getEmailDioTagAsTf().getText().isBlank()) {
                JOptionPane.showMessageDialog(this.view.getDio(), SAVE_AS_MANDATORY, "Error", 0);
                this.view.getEmailDioTagAsTf().requestFocus();
            } else if (this.view.getEmailDioValueTf().getText().isBlank()) {
                JOptionPane.showMessageDialog(this.view.getDio(), VALUE_MANDATORY, "Error", 0);
                this.view.getEmailDioValueTf().requestFocus();
            } else {
                String type = (String)this.view.getEmailDioUrlType().getSelectedItem();
                try {
                    if ("Email".equals(type) && AppUtility.isValidEmail(this.view.getEmailDioValueTf().getText()) || AppUtility.isValidURL(this.view.getEmailDioValueTf().getText())) {
                        ContactLinks contactLinks = new ContactLinks.Builder().linkType((String)this.view.getEmailDioUrlType().getSelectedItem()).tagAs(this.view.getEmailDioTagAsTf().getText()).value(this.view.getEmailDioValueTf().getText()).contactId(this.view.getContactId()).build();
                        this.service.saveLinks(contactLinks);
                        JOptionPane.showMessageDialog(this.view.getDio(), "Successfully saved !", "Success", 1);
                        this.view.getEmailDio().setVisible(false);
                        this.loadContactEmails();
                    } else {
                        JOptionPane.showMessageDialog(this.view.getDio(), "Please enter valid value", "Error", 0);
                    }
                }
                catch (Exception ex) {
                    new ErrorDialog(ex, "getEmailDioSaveBtn");
                }
            }
        }
        if (obj == this.view.getDeleteEmailBtn() || obj == this.view.getEmailDeletePopupMenu()) {
            try {
                int choose4;
                int row9 = this.view.getEmailTable().getSelectedRow();
                if (row9 >= 0 && (choose4 = JOptionPane.showConfirmDialog(this.view.getDio(), "Are you sure to delete ?", "Delete", 1)) == 0) {
                    int linkId = (Integer)this.view.getEmailTable().getValueAt(row9, 4);
                    this.service.deleteLinks(linkId);
                    JOptionPane.showMessageDialog(this.view.getDio(), "Successfully deleted !", "Success", 1);
                    this.loadContactEmails();
                }
            }
            catch (Exception ex) {
                new ErrorDialog(ex, "getDeleteEmailBtn");
            }
        }
        if (obj == this.view.getAddEmailBtn() || obj == this.view.getEmailAddPopupMenu()) {
            this.view.getEmailDioSaveBtn().setVisible(true);
            this.view.getEmailDioUpdateBtn().setVisible(false);
            this.view.getEmailDioTagAsTf().setText("");
            this.view.getEmailDioValueTf().setText("");
            this.view.getEmailDio().setTitle("New Email/URL");
            this.view.getEmailDio().setVisible(true);
        }
        if (obj == this.view.getUpdateEmailBtn() || obj == this.view.getEmailUpdatePopupMenu()) {
            this.view.getEmailDioSaveBtn().setVisible(false);
            this.view.getEmailDioUpdateBtn().setVisible(true);
            int row10 = this.view.getEmailTable().getSelectedRow();
            String tagAs = (String)this.view.getEmailTable().getValueAt(row10, 1);
            String field = (String)this.view.getEmailTable().getValueAt(row10, 2);
            String value = (String)this.view.getEmailTable().getValueAt(row10, 3);
            this.view.getEmailDioTagAsTf().setText(field);
            this.view.getEmailDioValueTf().setText(value);
            this.view.getEmailDioUrlType().setSelectedItem(tagAs);
            this.view.getEmailDio().setTitle("Update Email/URL");
            this.view.getEmailDio().setVisible(true);
        }
        if (obj == this.view.getEmailDioCloseBtn()) {
            this.view.getEmailDio().setVisible(false);
        }
        if (obj == this.view.getContactDioCloseBtn()) {
            this.view.getContactDio().setVisible(false);
        }
        if (obj == this.view.getDeleteContactBtn() || obj == this.view.getContactDeletePopupMenu()) {
            try {
                int choose5;
                int row11 = this.view.getContactTable().getSelectedRow();
                if (row11 >= 0 && (choose5 = JOptionPane.showConfirmDialog(this.view.getDio(), "Are you sure to delete ?", "Delete", 1)) == 0) {
                    int contactNumberId = (Integer)this.view.getContactTable().getValueAt(row11, 4);
                    this.service.deleteContact(contactNumberId);
                    JOptionPane.showMessageDialog(this.view.getDio(), "Successfully deleted !", "Success", 1);
                    this.loadContactNumbers();
                }
            }
            catch (Exception ex) {
                new ErrorDialog(ex, "getDeleteContactBtn");
            }
        }
        if (obj == this.view.getContactDioUpdateBtn()) {
            if (this.view.getContactDioTagAsTf().getText().isBlank()) {
                JOptionPane.showMessageDialog(this.view.getDio(), SAVE_AS_MANDATORY, "Error", 0);
                this.view.getContactDioTagAsTf().requestFocus();
            } else if (this.view.getContactDioValueTf().getText().isBlank()) {
                JOptionPane.showMessageDialog(this.view.getDio(), "Contact No is mandatory", "Error", 0);
                this.view.getContactDioValueTf().requestFocus();
            } else if (AppUtility.isValidatePhoneNo(this.view.getContactDioValueTf().getText())) {
                int row12 = this.view.getContactTable().getSelectedRow();
                int contactNumberId = (Integer)this.view.getContactTable().getValueAt(row12, 4);
                ContactNumber contactNumber = new ContactNumber.Builder().contactTagAs(this.view.getContactDioTagAsTf().getText()).contactValue(this.view.getContactDioValueTf().getText()).isPrimary(this.view.getIsContactDioPrimary().isSelected()).contactNumberId(contactNumberId).contactId(this.view.getContactId()).build();
                try {
                    this.service.updateContact(contactNumber);
                    JOptionPane.showMessageDialog(this.view.getDio(), "Successfully updated !", "Success", 1);
                    this.view.getContactDio().setVisible(false);
                    this.loadContactNumbers();
                }
                catch (Exception ex) {
                    new ErrorDialog(ex, "getContactDioUpdateBtn");
                }
            } else {
                JOptionPane.showMessageDialog(this.view.getDio(), "Please enter valid contact no");
            }
        }
        if (obj == this.view.getContactDioSaveBtn()) {
            if (this.view.getContactDioTagAsTf().getText().isBlank()) {
                JOptionPane.showMessageDialog(this.view.getDio(), SAVE_AS_MANDATORY, "Error", 0);
                this.view.getContactDioTagAsTf().requestFocus();
            } else if (this.view.getContactDioValueTf().getText().isBlank()) {
                JOptionPane.showMessageDialog(this.view.getDio(), "Contact No is mandatory", "Error", 0);
                this.view.getContactDioValueTf().requestFocus();
            } else if (AppUtility.isValidatePhoneNo(this.view.getContactDioValueTf().getText())) {
                ContactNumber contactNumber = new ContactNumber.Builder().contactTagAs(this.view.getContactDioTagAsTf().getText()).contactValue(this.view.getContactDioValueTf().getText()).isPrimary(this.view.getIsContactDioPrimary().isSelected()).contactId(this.view.getContactId()).build();
                try {
                    this.service.saveContact(contactNumber);
                    JOptionPane.showMessageDialog(this.view.getDio(), "Successfully saved !", "Success", 1);
                    this.view.getContactDio().setVisible(false);
                    this.loadContactNumbers();
                }
                catch (Exception ex) {
                    new ErrorDialog(ex, "getContactDioSaveBtn");
                }
            } else {
                JOptionPane.showMessageDialog(this.view.getDio(), "Please enter valid contact no");
            }
        }
        if (obj == this.view.getAddContactBtn() || obj == this.view.getContactAddPopupMenu()) {
            this.view.getContactDioUpdateBtn().setVisible(false);
            this.view.getContactDioSaveBtn().setVisible(true);
            this.view.getContactDioTagAsTf().setText("");
            this.view.getContactDioValueTf().setText("");
            this.view.getIsContactDioPrimary().setSelected(false);
            this.view.getContactDio().setTitle("New Contact");
            this.view.getContactDio().setVisible(true);
        }
        if (obj == this.view.getUpdateContactBtn() || obj == this.view.getContactUpdatePopupMenu()) {
            int row13 = this.view.getContactTable().getSelectedRow();
            this.view.getContactDioTagAsTf().setText((String)this.view.getContactTable().getValueAt(row13, 1));
            this.view.getContactDioValueTf().setText((String)this.view.getContactTable().getValueAt(row13, 2));
            this.view.getIsContactDioPrimary().setSelected("Yes".equals(this.view.getContactTable().getValueAt(row13, 3)));
            this.view.getContactDioUpdateBtn().setVisible(true);
            this.view.getContactDioSaveBtn().setVisible(false);
            this.view.getContactDio().setTitle("Update Contact");
            this.view.getContactDio().setVisible(true);
        }
        if (obj == this.view.getUpdateAddrBtn()) {
            if (this.view.getAddressTagAsTf().getText().isEmpty()) {
                JOptionPane.showMessageDialog(this.view.getAddressDio(), "Address name is mandatory", "Error", 0);
                this.view.getAddressTagAsTf().grabFocus();
            } else if (this.view.getAddressTf().getText().isEmpty()) {
                JOptionPane.showMessageDialog(this.view.getAddressDio(), "Address is mandatory", "Error", 0);
                this.view.getAddressTf().grabFocus();
            } else {
                try {
                    int row14 = this.view.getAddressTable().getSelectedRow();
                    int addressId = (Integer)this.view.getAddressTable().getValueAt(row14, 7);
                    ContactAddress contactAddress = new ContactAddress.Builder().addressTagAs(this.view.getAddressTagAsTf().getText()).address(this.view.getAddressTf().getText()).area(this.view.getAreaTf().getText()).city(this.view.getCityTf().getText()).pin(this.view.getPinTf().getText()).isPrimary(this.view.getIsPrimary().isSelected()).contactId(this.view.getContactId()).addressId(addressId).build();
                    this.service.updateAddress(contactAddress);
                    JOptionPane.showMessageDialog(this.view.getDio(), "Successfully updated !", "Success", 1);
                    this.view.getAddressDio().setVisible(false);
                    this.loadContactAddress();
                }
                catch (Exception ex) {
                    new ErrorDialog(ex, "getUpdateAddrBtn");
                }
            }
        }
        if (obj == this.view.getAddrRefPopupMenu()) {
            try {
                this.loadContactAddress();
            }
            catch (Exception ex) {
                new ErrorDialog(ex, "getAddrRefPopupMenu");
            }
        }
        if (obj == this.view.getDeleteAddressBtn() || obj == this.view.getAddrDeletePopupMenu()) {
            try {
                int choose6;
                int row15 = this.view.getAddressTable().getSelectedRow();
                if (row15 >= 0 && (choose6 = JOptionPane.showConfirmDialog(this.view.getDio(), "Are you sure to delete ?", "Delete", 1)) == 0) {
                    int addressId = (Integer)this.view.getAddressTable().getValueAt(row15, 7);
                    this.service.deleteAddress(addressId);
                    this.loadContactAddress();
                }
            }
            catch (Exception ex) {
                new ErrorDialog(ex, "getDeleteAddressBtn");
            }
        }
        if (obj == this.view.getSaveAddressBtn()) {
            if (this.view.getAddressTagAsTf().getText().isEmpty()) {
                JOptionPane.showMessageDialog(this.view.getAddressDio(), "Address name is mandatory", "Error", 0);
                this.view.getAddressTagAsTf().grabFocus();
            } else if (this.view.getAddressTf().getText().isEmpty()) {
                JOptionPane.showMessageDialog(this.view.getAddressDio(), "Address is mandatory", "Error", 0);
                this.view.getAddressTf().grabFocus();
            } else {
                try {
                    ContactAddress contactAddress = new ContactAddress.Builder().addressTagAs(this.view.getAddressTagAsTf().getText()).address(this.view.getAddressTf().getText()).area(this.view.getAreaTf().getText()).city(this.view.getCityTf().getText()).pin(this.view.getPinTf().getText()).isPrimary(this.view.getIsPrimary().isSelected()).contactId(this.view.getContactId()).build();
                    this.service.saveAddress(contactAddress);
                    JOptionPane.showMessageDialog(this.view.getDio(), "Successfully saved !", "Success", 1);
                    this.view.getAddressDio().setVisible(false);
                    this.loadContactAddress();
                }
                catch (Exception ex) {
                    new ErrorDialog(ex, "getSaveAddressBtn");
                }
            }
        }
        if (obj == this.view.getCloseAddressBtn()) {
            this.view.getAddressDio().setVisible(false);
        }
        if ((obj == this.view.getUpdateAddressBtn() || obj == this.view.getAddrUpdatePopupMenu()) && (row = this.view.getAddressTable().getSelectedRow()) >= 0) {
            this.view.getAddressDio().setTitle("Update Address");
            this.view.getSaveAddressBtn().setVisible(false);
            this.view.getUpdateAddrBtn().setVisible(true);
            this.view.getAddressTagAsTf().setText((String)this.view.getAddressTable().getValueAt(row, 1));
            this.view.getAddressTf().setText((String)this.view.getAddressTable().getValueAt(row, 2));
            this.view.getAreaTf().setText((String)this.view.getAddressTable().getValueAt(row, 3));
            this.view.getCityTf().setText((String)this.view.getAddressTable().getValueAt(row, 4));
            this.view.getPinTf().setText((String)this.view.getAddressTable().getValueAt(row, 5));
            this.view.getIsPrimary().setSelected("Yes".equals(this.view.getAddressTable().getValueAt(row, 6)));
            this.view.getAddressDio().setVisible(true);
        }
        if (obj == this.view.getAddAddressBtn() || obj == this.view.getAddrAddPopupMenu()) {
            this.view.getAddressDio().setTitle("New Address");
            this.view.getSaveAddressBtn().setVisible(true);
            this.view.getUpdateAddrBtn().setVisible(false);
            this.view.getAddressTagAsTf().setText("");
            this.view.getAddressTf().setText("");
            this.view.getAreaTf().setText("");
            this.view.getCityTf().setText("");
            this.view.getPinTf().setText("");
            this.view.getIsPrimary().setSelected(false);
            this.view.getAddressDio().setVisible(true);
        }
        if (obj == this.view.getUpdateBtn()) {
            try {
                if (this.isBasicFormValid()) {
                    this.saveOrUpdateContactBasicDetails();
                    String message = "<html> <b>" + this.view.getNameField().getText() + " </b> basic details have been successfully updated in <b> " + this.view.getGroupNames().getSelectedItem() + "</b> </html> ";
                    JOptionPane.showMessageDialog(this.view.getDio(), message);
                    this.view.getDio().setVisible(false);
                }
            }
            catch (Exception ex) {
                new ErrorDialog(ex, "getUpdateBtn");
            }
        }
        if (obj == this.view.getSaveBtn()) {
            try {
                if (this.isBasicFormValid()) {
                    this.saveOrUpdateContactBasicDetails();
                    String message = "<html> <b>" + this.view.getNameField().getText() + " </b> basic details have been successfully saved in <b> " + this.view.getGroupNames().getSelectedItem() + "</b> </html> \nIf you are done for now, please press 'Yes' and If you would like to add more details, please press 'No'";
                    int choose7 = JOptionPane.showConfirmDialog(this.view.getDio(), message, "Information", 1);
                    if (choose7 == 0) {
                        this.view.getDio().setVisible(false);
                    } else {
                        this.view.getSaveBtn().setVisible(false);
                        this.view.getUpdateBtn().setVisible(true);
                    }
                }
            }
            catch (Exception ex) {
                new ErrorDialog(ex, "getSaveBtn");
            }
        }
        if (obj == this.view.getAddNewGroup()) {
            this.manageGroupView.getDio().setTitle("New group");
            this.manageGroupView.getUpdateBtn().setVisible(false);
            this.manageGroupView.getSaveBtn().setVisible(true);
            this.manageGroupView.getValidationError().setVisible(false);
            this.manageGroupView.getGroupNameField().setText("");
            this.manageGroupView.getDio().setVisible(true);
            this.populateContactGroup();
        }
        if (obj == this.view.getBrowseImageBtn()) {
            JFileChooser chooser = new JFileChooser();
            if (this.lastOpenedDirectory != null && !this.lastOpenedDirectory.isEmpty()) {
                chooser.setCurrentDirectory(new File(this.lastOpenedDirectory));
            }
            FileNameExtensionFilter filter = new FileNameExtensionFilter("JPG & GIF Images", "jpg", "jpeg", "gif", "png");
            chooser.setFileFilter(filter);
            int returnVal = chooser.showOpenDialog(this.view.getBrowseImageBtn());
            if (returnVal == 0) {
                this.lastOpenedDirectory = chooser.getSelectedFile().getParent();
                try {
                    String path = chooser.getSelectedFile().getPath();
                    BufferedImage image = ImageIO.read(new File(path));
                    this.setImagePath(path);
                    ImageIcon icon = new ImageIcon(AutoResize.resize(image, 64, 64));
                    icon.getImage().flush();
                    this.view.getImagePreview().setIcon(icon);
                    this.view.getImagePreview().revalidate();
                    this.view.getRemoveImageBtn().setEnabled(true);
                }
                catch (Exception e1) {
                    new ErrorDialog(e1, "getBrowseImageBtn");
                }
            }
        }
        if (obj == this.view.getRemoveImageBtn() && (choose = JOptionPane.showConfirmDialog(this.view.getDio(), "Warning : Are you sure to delete photo ", "Delete", 1)) == 0) {
            this.view.getImagePreview().setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/photo-l.png"))));
            this.setImagePath("-");
            this.view.getImagePreview().revalidate();
            this.view.getRemoveImageBtn().setEnabled(false);
        }
        if (obj == this.view.getCancelBtn()) {
            this.view.getDio().setVisible(false);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object obj = e.getSource();
        if (obj == this.view.getMainTabs()) {
            int selectedTabIndex = this.view.getMainTabs().getSelectedIndex();
            if (selectedTabIndex == 0) {
                if (this.view.getContactId() > 0) {
                    this.view.getSaveBtn().setVisible(false);
                    this.view.getUpdateBtn().setVisible(true);
                } else {
                    this.view.getSaveBtn().setVisible(true);
                    this.view.getUpdateBtn().setVisible(false);
                }
            }
            if (selectedTabIndex > 0) {
                this.view.getSaveBtn().setVisible(false);
                this.view.getUpdateBtn().setVisible(false);
            }
            if (selectedTabIndex == 1) {
                try {
                    this.loadContactAddress();
                }
                catch (Exception ex) {
                    new ErrorDialog(ex, "loadContactAddress on tab change");
                }
            }
            if (selectedTabIndex == 2) {
                try {
                    this.loadContactNumbers();
                }
                catch (Exception ex) {
                    new ErrorDialog(ex, "loadContactNumbers on tab change");
                }
            }
            if (selectedTabIndex == 3) {
                try {
                    this.loadContactEmails();
                }
                catch (Exception ex) {
                    new ErrorDialog(ex, "loadContactEmails on tab change");
                }
            }
            if (selectedTabIndex == 4) {
                try {
                    this.loadContactEvents();
                }
                catch (Exception ex) {
                    new ErrorDialog(ex, "loadContactEvents on tab change");
                }
            }
            if (selectedTabIndex == 5) {
                try {
                    this.loadContactAdditionalInfo();
                }
                catch (Exception ex) {
                    new ErrorDialog(ex, "loadContactAdditionalInfo on tab change");
                }
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Object obj = e.getSource();
        if (obj == this.view.getContactSelectionModel()) {
            if (this.view.getContactTable().getSelectedRow() >= 0) {
                this.view.getUpdateContactBtn().setEnabled(true);
                this.view.getDeleteContactBtn().setEnabled(true);
                this.view.getContactDeletePopupMenu().setEnabled(true);
                this.view.getContactUpdatePopupMenu().setEnabled(true);
            } else {
                this.view.getUpdateContactBtn().setEnabled(false);
                this.view.getDeleteContactBtn().setEnabled(false);
                this.view.getContactDeletePopupMenu().setEnabled(false);
                this.view.getContactUpdatePopupMenu().setEnabled(false);
            }
        }
        if (obj == this.view.getAddressSelectionModel()) {
            if (this.view.getAddressTable().getSelectedRow() >= 0) {
                this.view.getUpdateAddressBtn().setEnabled(true);
                this.view.getDeleteAddressBtn().setEnabled(true);
                this.view.getAddrUpdatePopupMenu().setEnabled(true);
                this.view.getAddrDeletePopupMenu().setEnabled(true);
            } else {
                this.view.getUpdateAddressBtn().setEnabled(false);
                this.view.getDeleteAddressBtn().setEnabled(false);
                this.view.getAddrUpdatePopupMenu().setEnabled(false);
                this.view.getAddrDeletePopupMenu().setEnabled(false);
            }
        }
        if (obj == this.view.getEmailSelectionModel()) {
            if (this.view.getEmailTable().getSelectedRow() >= 0) {
                this.view.getUpdateEmailBtn().setEnabled(true);
                this.view.getDeleteEmailBtn().setEnabled(true);
                this.view.getEmailUpdatePopupMenu().setEnabled(true);
                this.view.getEmailDeletePopupMenu().setEnabled(true);
            } else {
                this.view.getUpdateEmailBtn().setEnabled(false);
                this.view.getDeleteEmailBtn().setEnabled(false);
                this.view.getEmailUpdatePopupMenu().setEnabled(false);
                this.view.getEmailDeletePopupMenu().setEnabled(false);
            }
        }
        if (obj == this.view.getEventSelectionModel()) {
            if (this.view.getEventTable().getSelectedRow() >= 0) {
                this.view.getUpdateEventBtn().setEnabled(true);
                this.view.getDeleteEventBtn().setEnabled(true);
                this.view.getEventUpdatePopupMenu().setEnabled(true);
                this.view.getEventDeletePopupMenu().setEnabled(true);
            } else {
                this.view.getUpdateEventBtn().setEnabled(false);
                this.view.getDeleteEventBtn().setEnabled(false);
                this.view.getEventUpdatePopupMenu().setEnabled(false);
                this.view.getEventDeletePopupMenu().setEnabled(false);
            }
        }
        if (obj == this.view.getAdditionalInfoSelectionModel()) {
            if (this.view.getAdditionalInfoTable().getSelectedRow() >= 0) {
                this.view.getUpdateAdditionalInfoBtn().setEnabled(true);
                this.view.getDeleteAdditionalInfoBtn().setEnabled(true);
                this.view.getAddiUpdatePopupMenu().setEnabled(true);
                this.view.getAddiDeletePopupMenu().setEnabled(true);
            } else {
                this.view.getUpdateAdditionalInfoBtn().setEnabled(false);
                this.view.getDeleteAdditionalInfoBtn().setEnabled(false);
                this.view.getAddiUpdatePopupMenu().setEnabled(false);
                this.view.getAddiDeletePopupMenu().setEnabled(false);
            }
        }
    }

    public ContactRecordView getView() {
        return this.view;
    }
}

