/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.controller.contact;

import com.arun.bhardwaj.cache.ContactGroupCache;
import com.arun.bhardwaj.exceptions.BusinessException;
import com.arun.bhardwaj.exceptions.ServiceException;
import com.arun.bhardwaj.service.contact.ManageGroupService;
import com.arun.bhardwaj.service.contact.ManageGroupServiceImpl;
import com.arun.bhardwaj.view.common.ErrorDialog;
import com.arun.bhardwaj.view.contact.ManageGroup;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JOptionPane;

public class ManageGroupController
implements ActionListener,
KeyListener {
    private final ManageGroup view;
    private final ManageGroupService service;
    private static final String GROUP_MANDATORY = "Group name is mandatory";

    public ManageGroupController(ManageGroup view) {
        this.view = view;
        this.service = new ManageGroupServiceImpl();
        this.view.getSaveBtn().setToolTipText("save");
        this.view.getUpdateBtn().setToolTipText("update");
        this.view.getCloseBtn().setToolTipText("cancel");
        this.addActionEvent();
        this.addKeyEvent();
    }

    private void addActionEvent() {
        this.view.getCloseBtn().addActionListener(this);
        this.view.getSaveBtn().addActionListener(this);
        this.view.getUpdateBtn().addActionListener(this);
    }

    private void addKeyEvent() {
        this.view.getGroupNameField().addKeyListener(this);
    }

    private void saveGroupName() {
        try {
            String groupName = this.view.getGroupNameField().getText().trim();
            if (!groupName.isEmpty()) {
                this.service.saveContactGroup(groupName);
                ContactGroupCache.loadContactGroups();
                JOptionPane.showMessageDialog(this.view.getDio(), "Successfully saved !", "Success", 1);
                this.view.getDio().setVisible(false);
                this.view.getDio().dispose();
            } else {
                this.view.getValidationError().setVisible(true);
                this.view.getValidationError().setToolTipText(GROUP_MANDATORY);
            }
        }
        catch (ServiceException ex) {
            new ErrorDialog(ex, "Save contact group");
        }
        catch (BusinessException e) {
            this.view.getValidationError().setVisible(true);
            this.view.getValidationError().setToolTipText(e.getMessage());
        }
    }

    private void updateGroupName() {
        try {
            String groupName = this.view.getGroupNameField().getText().trim();
            if (!groupName.isEmpty()) {
                this.service.updateGroup(groupName, this.view.getContactGroupId());
                ContactGroupCache.loadContactGroups();
                JOptionPane.showMessageDialog(this.view.getDio(), "Successfully updated !", "Success", 1);
                this.view.getDio().setVisible(false);
                this.view.getDio().dispose();
            } else {
                this.view.getValidationError().setVisible(true);
                this.view.getValidationError().setToolTipText(GROUP_MANDATORY);
            }
        }
        catch (ServiceException ex) {
            new ServiceException("Update contact group", ex);
        }
        catch (BusinessException e) {
            this.view.getValidationError().setVisible(true);
            this.view.getValidationError().setToolTipText(e.getMessage());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj == this.view.getSaveBtn()) {
            this.saveGroupName();
        }
        if (obj == this.view.getUpdateBtn()) {
            this.updateGroupName();
        }
        if (obj == this.view.getCloseBtn()) {
            this.view.getDio().setVisible(false);
            this.view.getDio().dispose();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        Object obj = e.getSource();
        if (obj == this.view.getGroupNameField() && e.getKeyCode() == 10) {
            if ("New group".equals(this.view.getDio().getTitle())) {
                this.saveGroupName();
            } else {
                this.updateGroupName();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getSource() == this.view.getGroupNameField()) {
            if (this.view.getGroupNameField().getText().trim().isEmpty()) {
                this.view.getValidationError().setVisible(true);
                this.view.getValidationError().setToolTipText(GROUP_MANDATORY);
            } else {
                this.view.getValidationError().setVisible(false);
            }
        }
    }
}

