/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.controller.enquiry;

import com.arun.bhardwaj.cache.PropertyGroupCache;
import com.arun.bhardwaj.model.enquiry.EnquiryFollowupStatistics;
import com.arun.bhardwaj.model.enquiry.EnquiryRecord;
import com.arun.bhardwaj.model.enquiry.EnquiryStatistics;
import com.arun.bhardwaj.model.enquiry.EnquiryStatus;
import com.arun.bhardwaj.service.enquiry.EnquiryService;
import com.arun.bhardwaj.service.enquiry.EnquiryServiceImpl;
import com.arun.bhardwaj.utility.AppUtility;
import com.arun.bhardwaj.view.LoginView;
import com.arun.bhardwaj.view.common.ContactDetailsView;
import com.arun.bhardwaj.view.common.DisplayPieChart;
import com.arun.bhardwaj.view.common.ErrorDialog;
import com.arun.bhardwaj.view.enquiry.EnquiryFollowUpView;
import com.arun.bhardwaj.view.enquiry.EnquiryPropertySearchView;
import com.arun.bhardwaj.view.enquiry.EnquiryRecordView;
import com.arun.bhardwaj.view.enquiry.EnquiryView;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import javax.swing.JOptionPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jfree.data.general.DefaultPieDataset;

public class EnquiryController
implements ListSelectionListener,
ActionListener,
KeyListener,
FocusListener {
    private final EnquiryView view;
    private final EnquiryRecordView enquiryRecordView;
    private final EnquiryService service;
    private final DefaultPieDataset dataset = new DefaultPieDataset();
    private int selectedRowIndex = 0;

    public int getSelectedRowIndex() {
        return this.selectedRowIndex;
    }

    public void setSelectedRowIndex(int selectedRowIndex) {
        this.selectedRowIndex = selectedRowIndex;
    }

    public EnquiryController(EnquiryView view) {
        this.view = view;
        this.enquiryRecordView = new EnquiryRecordView();
        this.service = new EnquiryServiceImpl();
        this.addActionEvent();
        this.view.getSelectionModel().addListSelectionListener(this);
        this.view.getClosedEnquirySelectionModel().addListSelectionListener(this);
        this.view.getSearchTf().addKeyListener(this);
        this.view.getSearchTf().addFocusListener(this);
        this.view.getClosedEnquirySearchTf().addKeyListener(this);
        this.view.getClosedEnquirySearchTf().addFocusListener(this);
        this.addToolTip();
        AppUtility.tableZoomInZoomOut(true, view.getTable());
        AppUtility.tableZoomInZoomOut(true, view.getTable());
        AppUtility.tableZoomInZoomOut(true, view.getClosedEnquiryTable());
        AppUtility.tableZoomInZoomOut(true, view.getClosedEnquiryTable());
        view.getNotificationPanel().addHyperlinkListener(e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                AppUtility.openWebPage(e.getURL().toString());
            }
        });
    }

    public void loadInitialData() {
        try {
            this.loadGroups();
            this.loadInActiveEnquiry();
            this.showEnquiriesStatistics();
            this.loadDetailsOnRowSelection();
            this.loadClosedEnquiryDetailsOnRowSelection();
        }
        catch (Exception e) {
            new ErrorDialog(e, "loadInitialData");
        }
    }

    private void loadChartDataSet(List<EnquiryStatistics> data) {
        this.dataset.clear();
        for (EnquiryStatistics enquiryStatistics : data) {
            this.dataset.setValue((Comparable)((Object)enquiryStatistics.date()), enquiryStatistics.count());
        }
    }

    private void showEnquiriesStatistics() throws Exception {
        List<EnquiryStatistics> data = this.service.loadEnquiryStatistics();
        this.loadChartDataSet(data);
        StringBuilder details = new StringBuilder();
        details.append("<html>\n<head>\n    <style>\n        body {\n            font-family: Arial, sans-serif;\n            text-align: center;\n        }\n        h1 {\n            color: #333;\n        }\n        table {\n            width: 100%;\n            max-width: 600px; /* Adjust as needed for your layout */\n            margin: 0 auto;\n            border-collapse: collapse;\n            border-spacing: 0;\n            overflow: auto;\n        }\n        th, td {\n            padding: 10px;\n            border: 1px solid #5B7687;\n            word-wrap: break-word;\n        }\n        th {\n            background-color: #115676;\n            color: #fff;\n        }\n    </style>\n</head>\n<body>\n    <h3>Open enquiries </h3>\n    <div style=\"overflow-x: auto;\">\n    <table>\n    <tr>\n        <th> Date</th>\n        <th>Count</th>\n    </tr>\n");
        for (EnquiryStatistics enquiryStatistics : data) {
            details.append("<tr> <td>");
            details.append(enquiryStatistics.date());
            details.append("</td>");
            details.append("<td>");
            details.append(enquiryStatistics.count());
            details.append("</td> </tr>");
        }
        details.append(" </table>\n    </div>\n");
        List<EnquiryFollowupStatistics> enquiryFollowupStatistics = this.service.loadEnquiriesFollowupStatistics();
        if (!enquiryFollowupStatistics.isEmpty()) {
            details.append("<h3>Today's FollowUp statistics  </h3>\n    <div style=\"overflow-x: auto;\">\n    <table>\n    <tr>\n        <th> Status</th>\n        <th>Count</th>\n    </tr>\n");
            for (EnquiryFollowupStatistics enquiryFollowupStatistics1 : enquiryFollowupStatistics) {
                details.append("<tr> <td>");
                details.append(enquiryFollowupStatistics1.status());
                details.append("</td>");
                details.append("<td>");
                details.append(enquiryFollowupStatistics1.count());
                details.append("</td> </tr>");
            }
            details.append(" </table>\n    </div>\n");
        }
        details.append(" </body>\n</html>\n");
        this.view.getNotificationPanel().setText(details.toString());
    }

    private void loadGroups() {
        try {
            this.view.getActiveEnquiryGroupNames().removeAllItems();
            this.view.getClosedEnquiryGroupNames().removeAllItems();
            Map<Integer, String> leaseGroupDts = PropertyGroupCache.getGroupIdToNameMap();
            this.view.getActiveEnquiryGroupNames().addItem("All Records");
            this.view.getClosedEnquiryGroupNames().addItem("All Records");
            leaseGroupDts.forEach((key, value) -> {
                this.view.getActiveEnquiryGroupNames().addItem(value);
                this.view.getClosedEnquiryGroupNames().addItem(value);
            });
            this.loadActiveEnquiry();
        }
        catch (Exception e) {
            new ErrorDialog(e, "load property group");
        }
    }

    private void addToolTip() {
        this.view.getNewI().setToolTipText("Add enquiry");
        this.view.getUpdR().setToolTipText("Update enquiry");
        this.view.getDel().setToolTipText("Delete enquiry");
        this.view.getRefBtn().setToolTipText("Refresh");
        this.view.getFollowUpBtn().setToolTipText("Follow up details");
        this.view.getSearchPropertiesBtn().setToolTipText("Search Properties");
        this.view.getSearchCb().setToolTipText("Select option for searching records");
        this.view.getShowPieChartBtn().setToolTipText("Show active enquiries by date");
        this.view.getZoomInBtn().setToolTipText("Zoom in Ctr +");
        this.view.getZoomOutBtn().setToolTipText("Zoom out Ctr -");
        this.view.getEnquiryFor().setToolTipText("Enquiry for");
        this.view.getClosedEnquiryFor().setToolTipText("Enquiry for");
        this.view.getClosedEnquiryViewBtn().setToolTipText("Follow up details");
        this.view.getCloseEnquiryReOpenBtn().setToolTipText("Re-open enquiry");
    }

    private void addActionEvent() {
        this.view.getNewI().addActionListener(this);
        this.view.getUpdR().addActionListener(this);
        this.view.getDel().addActionListener(this);
        this.view.getRefBtn().addActionListener(this);
        this.view.getFollowUpBtn().addActionListener(this);
        this.view.getSearchPropertiesBtn().addActionListener(this);
        this.view.getTodayFollowUpBtn().addActionListener(this);
        this.view.getAllEnquiryBtn().addActionListener(this);
        this.view.getShowPieChartBtn().addActionListener(this);
        this.view.getViewContactPopupMenu().addActionListener(this);
        this.view.getUpdatePopupMenu().addActionListener(this);
        this.view.getDeletePopupMenu().addActionListener(this);
        this.view.getFollowUpPopupMenu().addActionListener(this);
        this.view.getSearchPropertyPopupMenu().addActionListener(this);
        this.view.getShowChartPopupMenu().addActionListener(this);
        this.view.getActiveEnquiryGroupNames().addActionListener(this);
        this.view.getZoomInBtn().addActionListener(this);
        this.view.getZoomOutBtn().addActionListener(this);
        this.view.getClosedEnquiryViewBtn().addActionListener(this);
        this.view.getCloseEnquiryReOpenBtn().addActionListener(this);
        this.view.getClosedEnquiryGroupNames().addActionListener(this);
        this.view.getClosedEnquiryFollowUpPopupMenu().addActionListener(this);
        this.view.getClosedViewContactPopupMenu().addActionListener(this);
        this.view.getClosedEnquiryReOpenPopupMenu().addActionListener(this);
        this.view.getClosedEnquiryZoomInBtn().addActionListener(this);
        this.view.getClosedEnquiryZoomOutBtn().addActionListener(this);
        this.view.getRefreshPopupMenu().addActionListener(this);
        this.view.getEnquiryFor().addActionListener(this);
        this.view.getClosedEnquiryFor().addActionListener(this);
        this.view.getNextButton().addActionListener(this);
        this.view.getPrevButton().addActionListener(this);
    }

    private void resetForm() {
        this.enquiryRecordView.getNameTf().setText("");
        this.enquiryRecordView.setSelectedContactId(0);
        this.enquiryRecordView.getDateTf().setText(AppUtility.getCurrentDateInString());
        this.enquiryRecordView.getLocationTf().setText("");
        this.enquiryRecordView.getBudgetFromTf().setText("");
        this.enquiryRecordView.getBudgetToTf().setText("");
        this.enquiryRecordView.getSizeFromTf().setText("");
        this.enquiryRecordView.getSizeToTf().setText("");
        this.enquiryRecordView.getSourceTf().setText("");
        this.enquiryRecordView.getCommentsTextArea().setText("");
        this.enquiryRecordView.getForRent().setSelected(true);
        this.enquiryRecordView.getAdditionalInfoTf().setText("");
        this.enquiryRecordView.getCloseEnquiry().setVisible(false);
    }

    private void loadActiveEnquiry() {
        try {
            String selectedGroupName = (String)this.view.getActiveEnquiryGroupNames().getSelectedItem();
            int selectedGroupId = PropertyGroupCache.getGroupIdByName(selectedGroupName);
            String searchBy = (String)this.view.getSearchCb().getSelectedItem();
            String enquiryFor = (String)this.view.getEnquiryFor().getSelectedItem();
            String search = "";
            search = "Click here to search enquiries".equals(this.view.getSearchTf().getText().trim()) || this.view.getSearchTf().getText().isEmpty() ? "" : this.view.getSearchTf().getText().trim();
            List<EnquiryRecord> records = this.service.loadEnquiries(selectedGroupId, search, searchBy, EnquiryStatus.ACTIVE.ordinal(), this.view.getTodayFollowUpBtn().isSelected(), enquiryFor, this.view.getCurrentPage(), this.view.getPAGE_SIZE());
            if (!records.isEmpty()) {
                this.view.setTotalRecords(records.get(0).totalRecords());
            }
            this.view.getDefaultTableModel().setRowCount(0);
            IntStream.range(0, records.size()).forEach(index -> {
                this.view.getDefaultTableModel().addRow(new Object[]{"", "", "", "", "", "", "", "", "", "", "", ""});
                this.view.getTable().setValueAt(String.valueOf(index + 1), index, 0);
                this.view.getTable().setValueAt(((EnquiryRecord)records.get(index)).date(), index, 1);
                this.view.getTable().setValueAt(((EnquiryRecord)records.get(index)).contactName(), index, 2);
                this.view.getTable().setValueAt(((EnquiryRecord)records.get(index)).propertyGroupName() + " for " + ((EnquiryRecord)records.get(index)).lookingFor(), index, 3);
                this.view.getTable().setValueAt(this.getDisplayInformationInCurrency(((EnquiryRecord)records.get(index)).budgetFrom(), ((EnquiryRecord)records.get(index)).budgetTo()), index, 4);
                this.view.getTable().setValueAt(this.getDisplayInformation(((EnquiryRecord)records.get(index)).sizeFrom(), ((EnquiryRecord)records.get(index)).sizeTo()), index, 5);
                this.view.getTable().setValueAt(((EnquiryRecord)records.get(index)).location(), index, 6);
                this.view.getTable().setValueAt(((EnquiryRecord)records.get(index)).source(), index, 7);
                this.view.getTable().setValueAt(((EnquiryRecord)records.get(index)).additionalInfo(), index, 8);
                this.view.getTable().setValueAt(((EnquiryRecord)records.get(index)).comments(), index, 9);
                this.view.getTable().setValueAt(((EnquiryRecord)records.get(index)).enquiryId(), index, 10);
                this.view.getTable().setValueAt(((EnquiryRecord)records.get(index)).contactId(), index, 11);
                this.view.getTable().setAutoCreateRowSorter(true);
            });
            AppUtility.tableZoomInZoomOut(true, this.view.getTable());
            AppUtility.tableZoomInZoomOut(false, this.view.getTable());
            if (this.getSelectedRowIndex() != -1 && this.getSelectedRowIndex() < this.view.getTable().getRowCount()) {
                this.view.getTable().setRowSelectionInterval(this.getSelectedRowIndex(), this.getSelectedRowIndex());
                this.loadDetailsOnRowSelection();
            } else if (this.view.getTable().getRowCount() > 0) {
                this.view.getTable().setRowSelectionInterval(0, 0);
                this.loadDetailsOnRowSelection();
            }
            this.showEnquiriesStatistics();
            int startRecord = (this.view.getCurrentPage() - 1) * this.view.getPAGE_SIZE() + 1;
            int endRecord = Math.min(this.view.getCurrentPage() * this.view.getPAGE_SIZE(), this.view.getTotalRecords());
            String resultString = "Result " + startRecord + " - " + endRecord + " of " + this.view.getTotalRecords();
            this.view.getPageLabel().setText(resultString);
            this.view.getPrevButton().setEnabled(this.view.getCurrentPage() > 1);
            this.view.getNextButton().setEnabled(this.view.getCurrentPage() * this.view.getPAGE_SIZE() < this.view.getTotalRecords());
        }
        catch (Exception e) {
            new ErrorDialog(e, "load active enquiries");
        }
    }

    private void loadInActiveEnquiry() {
        try {
            AppUtility.validateUser();
            String selectedGroupName = (String)this.view.getClosedEnquiryGroupNames().getSelectedItem();
            int selectedGroupId = PropertyGroupCache.getGroupIdByName(selectedGroupName);
            String searchBy = (String)this.view.getClosedEnquirySearchCb().getSelectedItem();
            String closedEnquiryFor = (String)this.view.getClosedEnquiryFor().getSelectedItem();
            String search = "";
            search = "Click here to search closed enquiries".equals(this.view.getClosedEnquirySearchTf().getText().trim()) || this.view.getClosedEnquirySearchTf().getText().isEmpty() ? "" : this.view.getClosedEnquirySearchTf().getText().trim();
            List<EnquiryRecord> records = this.service.loadEnquiries(selectedGroupId, search, searchBy, EnquiryStatus.IN_ACTIVE.ordinal(), false, closedEnquiryFor, this.view.getClosedCurrentPage(), this.view.getClosedPAGE_SIZE());
            if (records.size() > 0) {
                this.view.setClosedTotalRecords(records.get(0).totalRecords());
            }
            this.view.getClosedEnquiryDefaultTableModel().setRowCount(0);
            IntStream.range(0, records.size()).forEach(index -> {
                this.view.getClosedEnquiryDefaultTableModel().addRow(new Object[]{"", "", "", "", "", "", "", "", "", "", "", ""});
                this.view.getClosedEnquiryTable().setValueAt(String.valueOf(index + 1), index, 0);
                this.view.getClosedEnquiryTable().setValueAt(((EnquiryRecord)records.get(index)).date(), index, 1);
                this.view.getClosedEnquiryTable().setValueAt(((EnquiryRecord)records.get(index)).contactName(), index, 2);
                this.view.getClosedEnquiryTable().setValueAt(((EnquiryRecord)records.get(index)).propertyGroupName() + " for " + ((EnquiryRecord)records.get(index)).lookingFor(), index, 3);
                this.view.getClosedEnquiryTable().setValueAt(this.getDisplayInformationInCurrency(((EnquiryRecord)records.get(index)).budgetFrom(), ((EnquiryRecord)records.get(index)).budgetTo()), index, 4);
                this.view.getClosedEnquiryTable().setValueAt(this.getDisplayInformation(((EnquiryRecord)records.get(index)).sizeFrom(), ((EnquiryRecord)records.get(index)).sizeTo()), index, 5);
                this.view.getClosedEnquiryTable().setValueAt(((EnquiryRecord)records.get(index)).location(), index, 6);
                this.view.getClosedEnquiryTable().setValueAt(((EnquiryRecord)records.get(index)).source(), index, 7);
                this.view.getClosedEnquiryTable().setValueAt(((EnquiryRecord)records.get(index)).additionalInfo(), index, 8);
                this.view.getClosedEnquiryTable().setValueAt(((EnquiryRecord)records.get(index)).comments(), index, 9);
                this.view.getClosedEnquiryTable().setValueAt(((EnquiryRecord)records.get(index)).enquiryId(), index, 10);
                this.view.getClosedEnquiryTable().setValueAt(((EnquiryRecord)records.get(index)).contactId(), index, 11);
                this.view.getClosedEnquiryTable().setAutoCreateRowSorter(true);
            });
            if (this.view.getClosedEnquiryTable().getRowCount() > 0) {
                this.view.getClosedEnquiryTable().setRowSelectionInterval(0, 0);
            }
            AppUtility.tableZoomInZoomOut(true, this.view.getClosedEnquiryTable());
            AppUtility.tableZoomInZoomOut(false, this.view.getClosedEnquiryTable());
            int startRecord = (this.view.getClosedCurrentPage() - 1) * this.view.getClosedPAGE_SIZE() + 1;
            int endRecord = Math.min(this.view.getClosedCurrentPage() * this.view.getClosedPAGE_SIZE(), this.view.getClosedTotalRecords());
            String resultString = "Result " + startRecord + " - " + endRecord + " of " + this.view.getClosedTotalRecords();
            this.view.getClosedPageLabel().setText(resultString);
            this.view.getClosedPrevButton().setEnabled(this.view.getClosedCurrentPage() > 1);
            this.view.getClosedNextButton().setEnabled(this.view.getClosedCurrentPage() * this.view.getClosedPAGE_SIZE() < this.view.getClosedTotalRecords());
        }
        catch (Exception e) {
            new ErrorDialog(e, "load closed enquiries");
        }
    }

    private String getDisplayInformationInCurrency(int from, int to) {
        Object information = null;
        if (from == 0 && to == 0) {
            information = "";
        } else if (from != 0 && to != 0) {
            information = AppUtility.getFormattedCurrency(String.valueOf(from)) + " to " + AppUtility.getFormattedCurrency(String.valueOf(to));
        } else if (from == 0 && to != 0) {
            information = "Maximum " + AppUtility.getFormattedCurrency(String.valueOf(to));
        } else if (from != 0 && to == 0) {
            information = "Minimum " + AppUtility.getFormattedCurrency(String.valueOf(from));
        }
        return information;
    }

    private String getDisplayInformation(int from, int to) {
        Object information = null;
        if (from == 0 && to == 0) {
            information = "";
        } else if (from != 0 && to != 0) {
            information = from + " to " + to;
        } else if (from == 0 && to != 0) {
            information = "Maximum " + to;
        } else if (from != 0 && to == 0) {
            information = "Minimum " + from;
        }
        return information;
    }

    private void loadForm(int row) {
        this.enquiryRecordView.getDateTf().setText((String)this.view.getTable().getValueAt(row, 1));
        String lookingFor = (String)this.view.getTable().getValueAt(row, 3);
        this.enquiryRecordView.getGroupNames().setSelectedItem(lookingFor.split("for")[0].trim());
        if ("RENT".equals(lookingFor.split("for")[1].trim())) {
            this.enquiryRecordView.getForRent().setSelected(true);
        } else {
            this.enquiryRecordView.getForPurchase().setSelected(true);
        }
        this.enquiryRecordView.getNameTf().setText((String)this.view.getTable().getValueAt(row, 2));
        this.enquiryRecordView.getLocationTf().setText((String)this.view.getTable().getValueAt(row, 6));
        this.enquiryRecordView.getSourceTf().setText((String)this.view.getTable().getValueAt(row, 7));
        this.enquiryRecordView.getCommentsTextArea().setText((String)this.view.getTable().getValueAt(row, 9));
        this.enquiryRecordView.getAdditionalInfoTf().setText((String)this.view.getTable().getValueAt(row, 8));
        this.enquiryRecordView.setSelectedContactId((Integer)this.view.getTable().getValueAt(row, 11));
        this.enquiryRecordView.setEnquiryId((Integer)this.view.getTable().getValueAt(row, 10));
        String budget = (String)this.view.getTable().getValueAt(row, 4);
        if (budget.isEmpty()) {
            this.enquiryRecordView.getBudgetFromTf().setText("MIN");
            this.enquiryRecordView.getBudgetToTf().setText("MAX");
        } else if (budget.contains("Maximum")) {
            this.enquiryRecordView.getBudgetFromTf().setText("MIN");
            this.enquiryRecordView.getBudgetToTf().setText(AppUtility.removeCurrencyAndCommas(budget.split("Maximum ")[1].trim()));
        } else if (budget.contains("Minimum")) {
            this.enquiryRecordView.getBudgetFromTf().setText(AppUtility.removeCurrencyAndCommas(budget.split("Minimum ")[1].trim()));
            this.enquiryRecordView.getBudgetToTf().setText("MAX");
        } else {
            this.enquiryRecordView.getBudgetFromTf().setText(AppUtility.removeCurrencyAndCommas(budget.split("to ")[0].trim()));
            this.enquiryRecordView.getBudgetToTf().setText(AppUtility.removeCurrencyAndCommas(budget.split("to ")[1].trim()));
        }
        String area = (String)this.view.getTable().getValueAt(row, 5);
        if (area.isEmpty()) {
            this.enquiryRecordView.getSizeFromTf().setText("MIN");
            this.enquiryRecordView.getSizeToTf().setText("MAX");
        } else if (area.contains("Maximum")) {
            this.enquiryRecordView.getSizeFromTf().setText("MIN");
            this.enquiryRecordView.getSizeToTf().setText(area.split("Maximum ")[1].trim());
        } else if (area.contains("Minimum")) {
            this.enquiryRecordView.getSizeFromTf().setText(area.split("Minimum ")[1].trim());
            this.enquiryRecordView.getSizeToTf().setText("MAX");
        } else {
            this.enquiryRecordView.getSizeFromTf().setText(area.split("to ")[0].trim());
            this.enquiryRecordView.getSizeToTf().setText(area.split("to ")[1].trim());
        }
        this.enquiryRecordView.getCloseEnquiry().setSelected(false);
        this.enquiryRecordView.getCloseEnquiry().setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int choose;
        int selectedEnquiryId;
        int selectedContactId;
        int row;
        Object obj = e.getSource();
        if (e.getSource() == this.view.getPrevButton() && this.view.getCurrentPage() > 1) {
            this.view.setCurrentPage(this.view.getCurrentPage() - 1);
            this.loadActiveEnquiry();
        }
        if (e.getSource() == this.view.getNextButton() && this.view.getCurrentPage() * this.view.getPAGE_SIZE() < this.view.getTotalRecords()) {
            this.view.setCurrentPage(this.view.getCurrentPage() + 1);
            this.loadActiveEnquiry();
        }
        if (obj == this.view.getShowPieChartBtn() || obj == this.view.getShowChartPopupMenu()) {
            new DisplayPieChart(this.dataset, "Total active enquiries by date");
        }
        if (obj == this.view.getClosedEnquiryFor()) {
            this.loadInActiveEnquiry();
        }
        if (obj == this.view.getEnquiryFor()) {
            this.loadActiveEnquiry();
        }
        if (obj == this.view.getClosedViewContactPopupMenu()) {
            row = this.view.getClosedEnquiryTable().getSelectedRow();
            if (row >= 0) {
                selectedContactId = (Integer)this.view.getClosedEnquiryTable().getValueAt(row, 11);
                new ContactDetailsView(selectedContactId, null);
            } else {
                JOptionPane.showMessageDialog(LoginView.frame, "Select any record to delete");
            }
        }
        if (obj == this.view.getViewContactPopupMenu()) {
            row = this.view.getTable().getSelectedRow();
            if (row >= 0) {
                selectedContactId = (Integer)this.view.getTable().getValueAt(row, 11);
                new ContactDetailsView(selectedContactId, null);
            } else {
                JOptionPane.showMessageDialog(LoginView.frame, "Select any record to delete");
            }
        }
        if (obj == this.view.getClosedEnquiryGroupNames()) {
            this.loadInActiveEnquiry();
        }
        if (obj == this.view.getActiveEnquiryGroupNames() || obj == this.view.getTodayFollowUpBtn() || obj == this.view.getAllEnquiryBtn()) {
            this.loadActiveEnquiry();
        }
        if (obj == this.view.getClosedEnquiryZoomInBtn()) {
            AppUtility.tableZoomInZoomOut(true, this.view.getClosedEnquiryTable());
        }
        if (obj == this.view.getClosedEnquiryZoomOutBtn()) {
            AppUtility.tableZoomInZoomOut(false, this.view.getClosedEnquiryTable());
        }
        if (obj == this.view.getZoomInBtn()) {
            AppUtility.tableZoomInZoomOut(true, this.view.getTable());
        }
        if (obj == this.view.getZoomOutBtn()) {
            AppUtility.tableZoomInZoomOut(false, this.view.getTable());
        }
        if (obj == this.view.getCloseEnquiryReOpenBtn() || obj == this.view.getClosedEnquiryReOpenPopupMenu()) {
            row = this.view.getClosedEnquiryTable().getSelectedRow();
            if (row >= 0) {
                String selectedName = (String)this.view.getClosedEnquiryTable().getValueAt(row, 2);
                selectedEnquiryId = (Integer)this.view.getClosedEnquiryTable().getValueAt(row, 10);
                choose = JOptionPane.showConfirmDialog(this.view, "Are you sure to re-open enquiry for " + selectedName + " ?", "Re-open enquiry", 1);
                if (choose == 0) {
                    try {
                        this.service.reOpenEnquiry(selectedEnquiryId);
                        JOptionPane.showMessageDialog(LoginView.frame, "Enquiry re-open for " + selectedName + " successfully");
                        this.loadGroups();
                        this.loadInActiveEnquiry();
                        this.loadActiveEnquiry();
                        this.loadClosedEnquiryDetailsOnRowSelection();
                    }
                    catch (Exception ex) {
                        new ErrorDialog(ex, "enquiry re-open ");
                    }
                }
            } else {
                JOptionPane.showMessageDialog(LoginView.frame, "Select any record to re-open");
            }
        }
        if (obj == this.view.getClosedEnquiryViewBtn() || obj == this.view.getClosedEnquiryFollowUpPopupMenu()) {
            row = this.view.getClosedEnquiryTable().getSelectedRow();
            if (row >= 0) {
                int selectedEnquiryId2 = (Integer)this.view.getClosedEnquiryTable().getValueAt(row, 10);
                EnquiryFollowUpView enquiryFollowUpView = new EnquiryFollowUpView(selectedEnquiryId2);
                enquiryFollowUpView.getEnquiryAuditDio().setTitle("Closed: Enquiry follow up :" + (String)this.view.getClosedEnquiryTable().getValueAt(row, 2));
                enquiryFollowUpView.getEnquiryTopToolBar().setVisible(false);
                enquiryFollowUpView.getEnquiryAuditDio().setSize(900, 450);
                AppUtility.setDialogLocationInCenter(enquiryFollowUpView.getEnquiryAuditDio());
                enquiryFollowUpView.getEnquiryAuditDio().setVisible(true);
            } else {
                JOptionPane.showMessageDialog(LoginView.frame, "Select any record to review follow-up");
            }
        }
        if (obj == this.view.getSearchPropertiesBtn() || obj == this.view.getSearchPropertyPopupMenu()) {
            row = this.view.getTable().getSelectedRow();
            int selectedEnquiryId3 = (Integer)this.view.getTable().getValueAt(row, 10);
            EnquiryRecord enquiryRecord = new EnquiryRecord.Builder().enquiryId(selectedEnquiryId3).contactName((String)this.view.getTable().getValueAt(row, 2)).lookingFor((String)this.view.getTable().getValueAt(row, 3)).location((String)this.view.getTable().getValueAt(row, 6)).budgetDescription((String)this.view.getTable().getValueAt(row, 4)).areaDescription((String)this.view.getTable().getValueAt(row, 5)).additionalInfo((String)this.view.getTable().getValueAt(row, 8)).contactId((Integer)this.view.getTable().getValueAt(row, 11)).build();
            EnquiryPropertySearchView enquiryPropertySearchView = new EnquiryPropertySearchView(enquiryRecord);
            enquiryPropertySearchView.getEnquiryPropertySearchDioDio().setTitle("Property search for " + this.view.getTable().getValueAt(row, 2));
            enquiryPropertySearchView.getShowAllProperties().setSelected(false);
            enquiryPropertySearchView.getEnquiryPropertySearchDioDio().setSize(900, 450);
            AppUtility.setDialogLocationInCenter(enquiryPropertySearchView.getEnquiryPropertySearchDioDio());
            enquiryPropertySearchView.getEnquiryPropertySearchDioDio().setVisible(true);
        }
        if (obj == this.view.getFollowUpBtn() || obj == this.view.getFollowUpPopupMenu()) {
            row = this.view.getTable().getSelectedRow();
            int selectedEnquiryId4 = (Integer)this.view.getTable().getValueAt(row, 10);
            EnquiryFollowUpView enquiryFollowUpView = new EnquiryFollowUpView(selectedEnquiryId4);
            enquiryFollowUpView.getEnquiryAuditDio().setTitle("Enquiry follow up :" + (String)this.view.getTable().getValueAt(row, 2));
            enquiryFollowUpView.getEnquiryTopToolBar().setVisible(true);
            enquiryFollowUpView.getEnquiryAuditDio().setSize(900, 450);
            AppUtility.setDialogLocationInCenter(enquiryFollowUpView.getEnquiryAuditDio());
            enquiryFollowUpView.getEnquiryAuditDio().setVisible(true);
        }
        if (obj == this.view.getUpdR() || obj == this.view.getUpdatePopupMenu()) {
            row = this.view.getTable().getSelectedRow();
            String selectedName = (String)this.view.getTable().getValueAt(row, 2);
            this.enquiryRecordView.getDio().setTitle("Update Enquiry -" + selectedName);
            this.loadForm(row);
            this.enquiryRecordView.getUpdateBtn().setVisible(true);
            this.enquiryRecordView.getSaveBtn().setVisible(false);
            this.enquiryRecordView.getDio().setVisible(true);
            this.loadGroups();
            this.loadInActiveEnquiry();
        }
        if (obj == this.view.getDel() || obj == this.view.getDeletePopupMenu()) {
            row = this.view.getTable().getSelectedRow();
            if (row >= 0) {
                String selectedName = (String)this.view.getTable().getValueAt(row, 2);
                selectedEnquiryId = (Integer)this.view.getTable().getValueAt(row, 10);
                choose = JOptionPane.showConfirmDialog(this.view, "Are you sure to delete ?", "Delete record", 1);
                if (choose == 0) {
                    try {
                        this.service.deleteEnquiry(selectedEnquiryId);
                        JOptionPane.showMessageDialog(LoginView.frame, "Enquiry by " + selectedName + " deleted successfully");
                        this.loadGroups();
                    }
                    catch (Exception ex) {
                        new ErrorDialog(ex, "Delete enquiry");
                    }
                }
            } else {
                JOptionPane.showMessageDialog(LoginView.frame, "Select any record to delete");
            }
        }
        if (obj == this.view.getRefBtn() || obj == this.view.getRefreshPopupMenu()) {
            this.loadGroups();
        }
        if (obj == this.view.getNewI()) {
            this.enquiryRecordView.getDio().setTitle("New Enquiry");
            this.resetForm();
            this.enquiryRecordView.getEnquiryRecordController().loadGroups();
            this.enquiryRecordView.getUpdateBtn().setVisible(false);
            this.enquiryRecordView.getSaveBtn().setVisible(true);
            this.enquiryRecordView.getDio().setVisible(true);
            this.loadActiveEnquiry();
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (e.getSource() == this.view.getSearchTf() && "Click here to search enquiries".equals(this.view.getSearchTf().getText().trim())) {
            this.view.getSearchTf().setText("");
        }
        if (e.getSource() == this.view.getClosedEnquirySearchTf() && "Click here to search closed enquiries".equals(this.view.getClosedEnquirySearchTf().getText().trim())) {
            this.view.getClosedEnquirySearchTf().setText("");
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getSource() == this.view.getSearchTf() && this.view.getSearchTf().getText().isBlank()) {
            this.view.getSearchTf().setText("Click here to search enquiries");
        }
        if (e.getSource() == this.view.getClosedEnquirySearchTf() && this.view.getClosedEnquirySearchTf().getText().isBlank()) {
            this.view.getClosedEnquirySearchTf().setText("Click here to search closed enquiries");
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getSource() == this.view.getSearchTf()) {
            this.loadActiveEnquiry();
        }
        if (e.getSource() == this.view.getClosedEnquirySearchTf()) {
            this.loadInActiveEnquiry();
        }
    }

    private void loadClosedEnquiryDetailsOnRowSelection() {
        if (this.view.getClosedEnquiryTable().getSelectedRow() >= 0) {
            this.view.getClosedEnquiryViewBtn().setEnabled(true);
            this.view.getCloseEnquiryReOpenBtn().setEnabled(true);
        } else {
            this.view.getClosedEnquiryViewBtn().setEnabled(false);
            this.view.getCloseEnquiryReOpenBtn().setEnabled(false);
        }
    }

    private void loadDetailsOnRowSelection() {
        if (this.view.getTable().getSelectedRow() >= 0) {
            this.setSelectedRowIndex(this.view.getTable().getSelectedRow());
            this.view.getUpdR().setEnabled(true);
            this.view.getDel().setEnabled(true);
            this.view.getFollowUpBtn().setEnabled(true);
            this.view.getSearchPropertiesBtn().setEnabled(true);
        } else {
            this.view.getNotificationPanel().removeAll();
            this.view.getNotificationPanel().revalidate();
            this.view.getNotificationPanel().repaint();
            this.view.getUpdR().setEnabled(false);
            this.view.getDel().setEnabled(false);
            this.view.getFollowUpBtn().setEnabled(false);
            this.view.getSearchPropertiesBtn().setEnabled(false);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.view.getSelectionModel()) {
            this.loadDetailsOnRowSelection();
        }
        if (e.getSource() == this.view.getClosedEnquirySelectionModel()) {
            this.loadClosedEnquiryDetailsOnRowSelection();
        }
    }
}

