/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.controller.enquiry;

import com.arun.bhardwaj.model.enquiry.EnquiryFollowUp;
import com.arun.bhardwaj.service.enquiry.EnquiryFollowUpService;
import com.arun.bhardwaj.service.enquiry.EnquiryFollowUpServiceImpl;
import com.arun.bhardwaj.utility.AppUtility;
import com.arun.bhardwaj.view.LoginView;
import com.arun.bhardwaj.view.common.CustomDatePicker;
import com.arun.bhardwaj.view.common.ErrorDialog;
import com.arun.bhardwaj.view.enquiry.EnquiryFollowUpView;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.stream.IntStream;
import javax.swing.JOptionPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class EnquiryFollowUpController
implements ListSelectionListener,
ActionListener {
    private final EnquiryFollowUpView view;
    private final EnquiryFollowUpService service;

    public EnquiryFollowUpController(EnquiryFollowUpView view) {
        this.view = view;
        this.service = new EnquiryFollowUpServiceImpl();
        this.loadEnquiryFollowUpDetails();
        this.view.getSelectionModel().addListSelectionListener(this);
        this.view.getCreateBtn().addActionListener(this);
        this.view.getUpdateBtn().addActionListener(this);
        this.view.getDeleteBtn().addActionListener(this);
        this.view.getEnquiryDioSaveBtn().addActionListener(this);
        this.view.getEnquiryDioUpdateBtn().addActionListener(this);
        this.view.getEnquiryDioCloseBtn().addActionListener(this);
        this.view.getEnquiryDioDateBtn().addActionListener(this);
        this.view.getEnquiryDioFollowUpDateBtn().addActionListener(this);
        view.getZoomInBtn().addActionListener(this);
        view.getZoomOutBtn().addActionListener(this);
        view.getAddPopupMenu().addActionListener(this);
        view.getUpdatePopupMenu().addActionListener(this);
        view.getDeletePopupMenu().addActionListener(this);
        view.getEnquiryDioClearFolloupDateBtn().addActionListener(this);
        this.loadDetailsOnRowSelection();
        view.getEnquiryDetailsTextArea().addHyperlinkListener(e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                AppUtility.openWebPage(e.getURL().toString());
            }
        });
        AppUtility.tableZoomInZoomOut(true, view.getTable());
        AppUtility.tableZoomInZoomOut(true, view.getTable());
    }

    public void loadEnquiryFollowUpDetails() {
        try {
            List<EnquiryFollowUp> details = this.service.loadFollowUpDetails(this.view.getEnquiryId());
            this.view.getDefaultTableModel().setRowCount(0);
            IntStream.range(0, details.size()).forEach(index -> {
                this.view.getDefaultTableModel().addRow(new Object[]{"", "", "", "", ""});
                this.view.getTable().setValueAt(String.valueOf(index + 1), index, 0);
                this.view.getTable().setValueAt(((EnquiryFollowUp)details.get(index)).date(), index, 1);
                this.view.getTable().setValueAt(((EnquiryFollowUp)details.get(index)).followUpDate(), index, 2);
                this.view.getTable().setValueAt(((EnquiryFollowUp)details.get(index)).comments(), index, 3);
                this.view.getTable().setValueAt(((EnquiryFollowUp)details.get(index)).followUpId(), index, 4);
                this.view.getTable().setAutoCreateRowSorter(true);
            });
            AppUtility.tableZoomInZoomOut(true, this.view.getTable());
            AppUtility.tableZoomInZoomOut(false, this.view.getTable());
            if (this.view.getTable().getRowCount() > 0) {
                this.view.getTable().setRowSelectionInterval(0, 0);
                this.loadDetailsOnRowSelection();
            }
        }
        catch (Exception e) {
            new ErrorDialog(e, "loadEnquiryFollowUpDetails");
        }
    }

    public EnquiryFollowUpView getView() {
        return this.view;
    }

    private void loadDetailsOnRowSelection() {
        if (this.view.getTable().getSelectedRow() >= 0) {
            this.view.getUpdateBtn().setEnabled(true);
            this.view.getDeleteBtn().setEnabled(true);
            this.view.getUpdatePopupMenu().setEnabled(true);
            this.view.getDeletePopupMenu().setEnabled(true);
            String followUpDate = (String)this.view.getTable().getValueAt(this.view.getTable().getSelectedRow(), 2);
            String comments = (String)this.view.getTable().getValueAt(this.view.getTable().getSelectedRow(), 3);
            this.view.getEnquiryDetailsTextArea().setText("");
            StringBuilder details = new StringBuilder();
            details.append("<html lang=\"en\">\n<head>\n    <style>\n        body {\n            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;\n            margin: 5px;\n            color: #333;\n        }\n\n        #details {\n            margin-top: 2px;\n            padding: 2px;\n            border-radius: 4px;\n            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);\n            background-color: #fff;\n        }\n\n        h1, h2 {\n            color: #2c3e50;\n        }\n\n    </style>\n</head>\n<body>\n    <div id=\"details\">\n\n");
            if (!followUpDate.isEmpty()) {
                details.append(" <h2>Follow-up Date:</h2>");
                details.append("<p id='details'>").append(followUpDate).append("</p>");
            }
            if (!comments.isEmpty()) {
                details.append(" <h2>Comments:</h2>");
                details.append("<p id='details'>").append(comments).append("</p>");
            }
            details.append("</div>\n</body>\n</html>\n");
            this.view.getEnquiryDetailsTextArea().setText(details.toString());
        } else {
            this.view.getUpdateBtn().setEnabled(false);
            this.view.getDeleteBtn().setEnabled(false);
            this.view.getUpdatePopupMenu().setEnabled(false);
            this.view.getDeletePopupMenu().setEnabled(false);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.view.getSelectionModel() && this.view.getTable().getSelectedRow() >= 0) {
            this.loadDetailsOnRowSelection();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int followUpId;
        int row;
        Object obj = e.getSource();
        if (obj == this.view.getEnquiryDioClearFolloupDateBtn()) {
            this.view.getEnquiryFollowUpDateTf().setText("");
            this.view.getEnquiryDioClearFolloupDateBtn().setVisible(false);
        }
        if (obj == this.view.getZoomInBtn()) {
            AppUtility.tableZoomInZoomOut(true, this.view.getTable());
        }
        if (obj == this.view.getZoomOutBtn()) {
            AppUtility.tableZoomInZoomOut(false, this.view.getTable());
        }
        if (obj == this.view.getEnquiryDioUpdateBtn()) {
            row = this.view.getTable().getSelectedRow();
            followUpId = (Integer)this.view.getTable().getValueAt(row, 4);
            try {
                this.service.updateEnquiryFollowUp(new EnquiryFollowUp(this.view.getEnquiryDateTf().getText(), this.view.getEnquiryFollowUpDateTf().getText(), this.view.getEnquiryComments().getText(), this.view.getEnquiryId(), followUpId));
                JOptionPane.showMessageDialog(this.view.getEnquiryDio(), "Updated successfully");
                this.view.getEnquiryDio().setVisible(false);
                this.loadEnquiryFollowUpDetails();
            }
            catch (Exception ex) {
                new ErrorDialog(ex, "EnquiryDioUpdateBtn");
            }
        }
        if (obj == this.view.getDeleteBtn() || obj == this.view.getDeletePopupMenu()) {
            row = this.view.getTable().getSelectedRow();
            if (row >= 0) {
                followUpId = (Integer)this.view.getTable().getValueAt(row, 4);
                int choose = JOptionPane.showConfirmDialog(this.view.getEnquiryAuditDio(), "Warning : Are you sure to delete ?", "Delete record", 1);
                if (choose == 0) {
                    try {
                        this.service.deleteEnquiryFollowUp(followUpId);
                        JOptionPane.showMessageDialog(LoginView.frame, "deleted successfully");
                        this.loadEnquiryFollowUpDetails();
                    }
                    catch (Exception ex) {
                        new ErrorDialog(ex, "Delete enquiry follow-up");
                    }
                }
            } else {
                JOptionPane.showMessageDialog(LoginView.frame, "Select any record to delete");
            }
        }
        if (obj == this.view.getEnquiryDioCloseBtn()) {
            this.view.getEnquiryDio().setVisible(false);
        }
        if (obj == this.view.getEnquiryDioSaveBtn()) {
            try {
                this.service.saveEnquiryFollowUp(new EnquiryFollowUp(this.view.getEnquiryDateTf().getText(), this.view.getEnquiryFollowUpDateTf().getText(), this.view.getEnquiryComments().getText(), this.view.getEnquiryId(), 0));
                JOptionPane.showMessageDialog(this.view.getEnquiryDio(), "Saved successfully");
                this.view.getEnquiryDio().setVisible(false);
                this.loadEnquiryFollowUpDetails();
            }
            catch (Exception ex) {
                new ErrorDialog(ex, "getEnquiryDioSaveBtn");
            }
        }
        if (obj == this.view.getEnquiryDioFollowUpDateBtn()) {
            CustomDatePicker customDatePicker = new CustomDatePicker(this, "followUpDate");
            AppUtility.setDialogLocationInCenter(customDatePicker.getDio());
            customDatePicker.getDio().setVisible(true);
        }
        if (obj == this.view.getEnquiryDioDateBtn()) {
            CustomDatePicker customDatePicker = new CustomDatePicker(this, "date");
            AppUtility.setDialogLocationInCenter(customDatePicker.getDio());
            customDatePicker.getDio().setVisible(true);
        }
        if (obj == this.view.getUpdateBtn() || obj == this.view.getUpdatePopupMenu()) {
            this.view.getEnquiryDioUpdateBtn().setVisible(true);
            this.view.getEnquiryDioSaveBtn().setVisible(false);
            int row2 = this.view.getTable().getSelectedRow();
            this.view.getEnquiryDateTf().setText((String)this.view.getTable().getValueAt(row2, 1));
            this.view.getEnquiryFollowUpDateTf().setText((String)this.view.getTable().getValueAt(row2, 2));
            this.view.getEnquiryComments().setText((String)this.view.getTable().getValueAt(row2, 3));
            this.view.getEnquiryDioClearFolloupDateBtn().setVisible(!this.view.getEnquiryFollowUpDateTf().getText().isEmpty());
            this.view.getEnquiryDio().setVisible(true);
        }
        if (obj == this.view.getCreateBtn() || obj == this.view.getAddPopupMenu()) {
            this.view.getEnquiryDioUpdateBtn().setVisible(false);
            this.view.getEnquiryDioSaveBtn().setVisible(true);
            this.view.getEnquiryDateTf().setText(AppUtility.getCurrentDateInString());
            this.view.getEnquiryFollowUpDateTf().setText("");
            this.view.getEnquiryComments().setText("");
            this.view.getEnquiryDio().setVisible(true);
        }
    }
}

