/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.controller.enquiry;

import com.arun.bhardwaj.cache.PropertyGroupCache;
import com.arun.bhardwaj.model.contact.ContactRecord;
import com.arun.bhardwaj.model.enquiry.EnquiryRecord;
import com.arun.bhardwaj.model.property.PropertyRecord;
import com.arun.bhardwaj.service.contact.ContactRecordService;
import com.arun.bhardwaj.service.contact.ContactRecordServiceImpl;
import com.arun.bhardwaj.service.enquiry.EnquiryPropertySearchService;
import com.arun.bhardwaj.service.enquiry.EnquiryPropertySearchServiceImpl;
import com.arun.bhardwaj.utility.AppUtility;
import com.arun.bhardwaj.utility.UserCache;
import com.arun.bhardwaj.view.LoginView;
import com.arun.bhardwaj.view.common.ContactDetailsView;
import com.arun.bhardwaj.view.common.ErrorDialog;
import com.arun.bhardwaj.view.common.PreviewAndShareView;
import com.arun.bhardwaj.view.enquiry.EnquiryPropertySearchView;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.stream.IntStream;
import javax.swing.JOptionPane;
import javax.swing.event.HyperlinkEvent;

public class EnquiryPropertySearchController
implements ActionListener {
    private final EnquiryPropertySearchView view;
    private final EnquiryPropertySearchService service;
    private final ContactRecordService contactRecordService;

    public EnquiryPropertySearchController(EnquiryPropertySearchView view) {
        this.view = view;
        this.service = new EnquiryPropertySearchServiceImpl();
        this.contactRecordService = new ContactRecordServiceImpl();
        this.loadEnquiryCriteria();
        try {
            this.loadPropertyDetails();
            AppUtility.tableZoomInZoomOut(true, view.getTable());
            AppUtility.tableZoomInZoomOut(true, view.getTable());
        }
        catch (Exception e2) {
            new ErrorDialog(e2, "loadPropertyDetails as per criteria");
        }
        view.getEnquiryCriteriaTextArea().addHyperlinkListener(e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                AppUtility.openWebPage(e.getURL().toString());
            }
        });
        view.getViewOwnerDetailsPopupMenu().addActionListener(this);
        view.getZoomInBtn().addActionListener(this);
        view.getZoomOutBtn().addActionListener(this);
        view.getShowAllProperties().addActionListener(this);
        view.getShareBtn().addActionListener(this);
    }

    private void loadPropertyDetails() throws Exception {
        List<PropertyRecord> details = this.service.loadPropertiesForEnquiry(this.view.getEnquiryRecord(), this.view.getShowAllProperties().isSelected());
        if (!details.isEmpty() && this.fetchContactNumber() != null) {
            String clientName = this.view.getEnquiryRecord().contactName();
            this.view.getShareBtn().setText("Share with " + clientName);
            this.view.getShareBtn().setVisible(true);
        } else {
            this.view.getShareBtn().setVisible(false);
        }
        this.view.getDefaultTableModel().setRowCount(0);
        IntStream.range(0, details.size()).forEach(index -> {
            StringBuilder location = new StringBuilder();
            location.append(((PropertyRecord)details.get(index)).location());
            location.append(" ");
            location.append(((PropertyRecord)details.get(index)).city());
            location.append(" ");
            location.append(((PropertyRecord)details.get(index)).pin());
            this.view.getDefaultTableModel().addRow(new Object[]{"", "", "", "", "", "", "", ""});
            this.view.getTable().setValueAt(String.valueOf(index + 1), index, 0);
            this.view.getTable().setValueAt(PropertyGroupCache.getGroupName(((PropertyRecord)details.get(index)).fkGroupId()), index, 1);
            this.view.getTable().setValueAt(((PropertyRecord)details.get(index)).address(), index, 2);
            this.view.getTable().setValueAt(location, index, 3);
            this.view.getTable().setValueAt(((PropertyRecord)details.get(index)).areaInSqFt(), index, 4);
            this.view.getTable().setValueAt(AppUtility.getFormattedCurrency(String.valueOf(((PropertyRecord)details.get(index)).price())), index, 5);
            this.view.getTable().setValueAt(AppUtility.getFormattedCurrency(String.valueOf(((PropertyRecord)details.get(index)).deposit())), index, 6);
            this.view.getTable().setValueAt(AppUtility.getFormattedCurrency(String.valueOf(((PropertyRecord)details.get(index)).rent())), index, 7);
            this.view.getTable().setValueAt(((PropertyRecord)details.get(index)).fkContactId(), index, 8);
            this.view.getTable().setAutoCreateRowSorter(true);
        });
        AppUtility.tableZoomInZoomOut(true, this.view.getTable());
        AppUtility.tableZoomInZoomOut(false, this.view.getTable());
    }

    private void loadEnquiryCriteria() {
        this.view.getEnquiryCriteriaTextArea().setText("");
        StringBuilder details = new StringBuilder();
        details.append("<html lang=\"en\">\n<head>\n    <style>\n        body {\n            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;\n            margin: 5px;\n            color: #333;\n        }\n\n        #details {\n            margin-top: 2px;\n            padding: 2px;\n            border-radius: 4px;\n            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);\n            background-color: #fff;\n        }\n\n        h1, h2 {\n            color: #2c3e50;\n        }\n\n    </style>\n</head>\n<body>\n    <div id=\"details\">\n\n");
        details.append(" <h2>Requirement:</h2>");
        details.append("<p id='details'>").append(this.getRequirementDetails()).append("</p>");
        details.append("</div>\n</body>\n</html>\n");
        this.view.getEnquiryCriteriaTextArea().setText(details.toString());
    }

    private String getRequirementDetails() {
        StringBuilder requirement = new StringBuilder();
        EnquiryRecord enquiryRecord = this.view.getEnquiryRecord();
        requirement.append(enquiryRecord.contactName());
        requirement.append(" is looking ");
        requirement.append(enquiryRecord.lookingFor());
        if (!enquiryRecord.areaDescription().isEmpty()) {
            requirement.append(" of ");
            requirement.append(enquiryRecord.areaDescription());
            requirement.append(" Sq. ft.");
        }
        if (!enquiryRecord.location().isEmpty()) {
            requirement.append(" in ");
            requirement.append(enquiryRecord.location());
        }
        if (!enquiryRecord.budgetDescription().isEmpty()) {
            requirement.append(" budget would be ");
            requirement.append(enquiryRecord.budgetDescription());
        }
        if (enquiryRecord.additionalInfo() != null && !"".equals(enquiryRecord.additionalInfo())) {
            requirement.append(" and specifically search for  ").append(enquiryRecord.additionalInfo());
        }
        return requirement.toString();
    }

    public EnquiryPropertySearchView getView() {
        return this.view;
    }

    private String generatePropertiesDetailMessage() {
        int[] selectedRows = this.view.getTable().getSelectedRows();
        StringBuilder details = new StringBuilder();
        details.append("Dear ").append(this.view.getEnquiryRecord().contactName());
        details.append("\n\n");
        details.append("We've carefully curated a selection of properties that align with your specified preferences. Below are brief details of the shortlisted options:");
        for (int row : selectedRows) {
            details.append("\n\n");
            details.append("*Property Type :* ").append(this.view.getTable().getValueAt(row, 1));
            details.append("\n");
            details.append("*Location :* ").append(this.view.getTable().getValueAt(row, 3));
            details.append("\n");
            details.append("*Area in Sq.ft. :* ").append(this.view.getTable().getValueAt(row, 4));
            if (this.view.getEnquiryRecord().lookingFor().contains("RENT")) {
                details.append("\n");
                details.append("*Deposit :* ").append(this.view.getTable().getValueAt(row, 6));
                details.append("\n");
                details.append("*Rent :* ").append(this.view.getTable().getValueAt(row, 7));
                continue;
            }
            details.append("\n");
            details.append("*Price :*").append(this.view.getTable().getValueAt(row, 5));
        }
        details.append("\n\n");
        details.append("If you have any specific questions or would like more detailed information about any of these properties, please feel free to reach out. We are here to assist you in making an informed decision.\n\nLooking forward to hearing from you soon.\n");
        details.append(UserCache.getUserSignature());
        return details.toString();
    }

    private String fetchContactNumber() throws Exception {
        ContactRecord contactRecord = this.contactRecordService.fetchContactBasicDetails(this.view.getEnquiryRecord().contactId());
        if (contactRecord.primaryNumber() != null) {
            return contactRecord.primaryNumber().contactValue();
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj == this.view.getShareBtn()) {
            int[] selectedRows = this.view.getTable().getSelectedRows();
            if (selectedRows.length > 0) {
                try {
                    String message = this.generatePropertiesDetailMessage();
                    String contactNo = this.fetchContactNumber();
                    new PreviewAndShareView(message, contactNo);
                }
                catch (Exception ex) {
                    new ErrorDialog(ex, "Share properties with client");
                }
            } else {
                JOptionPane.showMessageDialog(this.view.getEnquiryPropertySearchDioDio(), "Please select at least one row.", "Selection Required", 1);
            }
        }
        if (obj == this.view.getShowAllProperties()) {
            try {
                this.loadPropertyDetails();
            }
            catch (Exception ex) {
                new ErrorDialog(ex, "getShowAllProperties");
            }
        }
        if (obj == this.view.getZoomInBtn()) {
            AppUtility.tableZoomInZoomOut(true, this.view.getTable());
        }
        if (obj == this.view.getZoomOutBtn()) {
            AppUtility.tableZoomInZoomOut(false, this.view.getTable());
        }
        if (obj == this.view.getViewOwnerDetailsPopupMenu()) {
            int row = this.view.getTable().getSelectedRow();
            if (row >= 0) {
                int selectedContactId = (Integer)this.view.getTable().getValueAt(row, 7);
                new ContactDetailsView(selectedContactId, this);
            } else {
                JOptionPane.showMessageDialog(LoginView.frame, "Select any record to delete");
            }
        }
    }
}

