/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.controller.enquiry;

import com.arun.bhardwaj.cache.PropertyGroupCache;
import com.arun.bhardwaj.model.enquiry.EnquiryRecord;
import com.arun.bhardwaj.service.enquiry.EnquiryRecordService;
import com.arun.bhardwaj.service.enquiry.EnquiryRecordServiceImpl;
import com.arun.bhardwaj.utility.AppUtility;
import com.arun.bhardwaj.view.common.ContactDialogView;
import com.arun.bhardwaj.view.common.CustomDatePicker;
import com.arun.bhardwaj.view.common.ErrorDialog;
import com.arun.bhardwaj.view.enquiry.EnquiryRecordView;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.JOptionPane;

public class EnquiryRecordController
implements ActionListener {
    private final EnquiryRecordView view;
    private final EnquiryRecordService service;

    public EnquiryRecordController(EnquiryRecordView view) {
        this.view = view;
        this.service = new EnquiryRecordServiceImpl();
        this.addActionEvent();
        this.addToolTip();
        this.loadGroups();
    }

    private void addToolTip() {
        this.view.getForPurchase().setToolTipText("Looking for purchase");
        this.view.getForRent().setToolTipText("Looking for rent");
        this.view.getSaveBtn().setToolTipText("Save record");
        this.view.getUpdateBtn().setToolTipText("Update record");
        this.view.getCloseBtn().setToolTipText("Close");
    }

    private void addActionEvent() {
        this.view.getContactBtn().addActionListener(this);
        this.view.getSaveBtn().addActionListener(this);
        this.view.getUpdateBtn().addActionListener(this);
        this.view.getCloseBtn().addActionListener(this);
        this.view.getDateBtn().addActionListener(this);
    }

    private EnquiryRecord bindForm() {
        String selectedCategory = (String)this.view.getGroupNames().getSelectedItem();
        int groupId = PropertyGroupCache.getGroupIdByName(selectedCategory);
        String lookingFor = this.view.getForRent().isSelected() ? "RENT" : "PURCHASE";
        return new EnquiryRecord.Builder().date(this.view.getDateTf().getText()).location(this.view.getLocationTf().getText()).budgetFrom(Integer.parseInt(this.view.getBudgetFromTf().getText().isEmpty() ? "0" : this.view.getBudgetFromTf().getText())).budgetTo(Integer.parseInt(this.view.getBudgetToTf().getText().isEmpty() ? "0" : this.view.getBudgetToTf().getText())).sizeFrom(Integer.parseInt(this.view.getSizeFromTf().getText().isEmpty() ? "0" : this.view.getSizeFromTf().getText())).sizeTo(Integer.parseInt(this.view.getSizeToTf().getText().isEmpty() ? "0" : this.view.getSizeToTf().getText())).source(this.view.getSourceTf().getText()).comments(this.view.getCommentsTextArea().getText()).contactId(this.view.getSelectedContactId()).propertyGroupId(groupId).lookingFor(lookingFor).enquiryId(this.view.getEnquiryId()).additionalInfo(this.view.getAdditionalInfoTf().getText()).build();
    }

    public void loadGroups() {
        this.view.getGroupNames().removeAllItems();
        Map<Integer, String> leaseGroupDts = PropertyGroupCache.getGroupIdToNameMap();
        leaseGroupDts.forEach((key, value) -> this.view.getGroupNames().addItem(value));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj == this.view.getUpdateBtn()) {
            try {
                if (this.isValidForm()) {
                    this.service.update(this.bindForm(), this.view.getCloseEnquiry().isSelected());
                    JOptionPane.showMessageDialog(this.view.getDio(), "Updated successfully");
                    this.view.getDio().setVisible(false);
                }
            }
            catch (Exception ex) {
                new ErrorDialog(ex, "Update enquiry");
            }
        }
        if (obj == this.view.getSaveBtn()) {
            try {
                if (this.isValidForm()) {
                    this.service.save(this.bindForm());
                    JOptionPane.showMessageDialog(this.view.getDio(), "Saved successfully");
                    this.view.getDio().setVisible(false);
                }
            }
            catch (Exception ex) {
                new ErrorDialog(ex, "Save enquiry");
            }
        }
        if (obj == this.view.getDateBtn()) {
            CustomDatePicker customDatePicker = new CustomDatePicker(this, "dateTf");
            AppUtility.setDialogLocationInCenter(customDatePicker.getDio());
            customDatePicker.getDio().setVisible(true);
        }
        if (obj == this.view.getContactBtn()) {
            ContactDialogView contactDialogView = new ContactDialogView(this, "contact", "Select a client name");
            AppUtility.setDialogLocationInCenter(contactDialogView.getDio());
            contactDialogView.getDio().setVisible(true);
        }
        if (obj == this.view.getCloseBtn()) {
            this.view.getDio().setVisible(false);
            this.view.getDio().dispose();
        }
    }

    private boolean isValidForm() {
        boolean isValid = true;
        String selectedGroupName = (String)this.view.getGroupNames().getSelectedItem();
        if (selectedGroupName == null) {
            JOptionPane.showMessageDialog(this.view.getDio(), "Group is mandatory", "Error", 0);
            isValid = false;
        }
        if (this.view.getNameTf().getText().isEmpty()) {
            JOptionPane.showMessageDialog(this.view.getDio(), "Name is mandatory", "Error", 0);
            isValid = false;
        }
        if (this.view.getGroupNames().getSelectedItem() == null) {
            JOptionPane.showMessageDialog(this.view.getDio(), "Property type is mandatory", "Error", 0);
            isValid = false;
        }
        return isValid;
    }

    public EnquiryRecordView getView() {
        return this.view;
    }
}

