/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.controller.project;

import com.arun.bhardwaj.cache.ArchitectNamesCache;
import com.arun.bhardwaj.cache.BuilderNamesCache;
import com.arun.bhardwaj.cache.ProjectGroupCache;
import com.arun.bhardwaj.cache.PropertyGroupCache;
import com.arun.bhardwaj.exceptions.BusinessException;
import com.arun.bhardwaj.exceptions.ServiceException;
import com.arun.bhardwaj.model.project.AmenitiesRecord;
import com.arun.bhardwaj.model.project.ProjectAdditionalDetails;
import com.arun.bhardwaj.model.project.ProjectRecord;
import com.arun.bhardwaj.model.project.UnitPricingAndPaymentDetails;
import com.arun.bhardwaj.service.contact.ContactService;
import com.arun.bhardwaj.service.contact.ContactServiceImpl;
import com.arun.bhardwaj.service.project.ManageProjectService;
import com.arun.bhardwaj.service.project.ManagerProjectServiceImpl;
import com.arun.bhardwaj.utility.AppUtility;
import com.arun.bhardwaj.view.common.ContactDialogView;
import com.arun.bhardwaj.view.common.CustomDatePicker;
import com.arun.bhardwaj.view.common.ErrorDialog;
import com.arun.bhardwaj.view.project.ManageProjectView;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ManageProjectViewController
implements ActionListener,
ChangeListener {
    private ManageProjectView view;
    private ManageProjectService service;
    private ContactService contactService;

    public ManageProjectViewController(ManageProjectView view) {
        this.view = view;
        this.service = new ManagerProjectServiceImpl();
        this.contactService = new ContactServiceImpl();
        this.loadProjectType();
        this.setActionEvent();
        view.getTabbedPane().addChangeListener(this);
        IntStream.rangeClosed(1, 3).forEachOrdered(index -> view.getTabbedPane().setEnabledAt(index, false));
    }

    private void loadProjectType() {
        this.view.getProjectTypeCb().removeAllItems();
        Map<Integer, String> projectGroupDts = ProjectGroupCache.getGroupIdToNameMap();
        projectGroupDts.forEach((key, value) -> this.view.getProjectTypeCb().addItem(value));
    }

    private void setActionEvent() {
        this.view.getSaveBtn().addActionListener(this);
        this.view.getUpdateBtn().addActionListener(this);
        this.view.getCloseBtn().addActionListener(this);
        this.view.getLaunchDateButton().addActionListener(this);
        this.view.getCompletionDateButton().addActionListener(this);
        this.view.getBuilderNameButton().addActionListener(this);
        this.view.getArchitectNameButton().addActionListener(this);
        this.view.getAddPricingDetailButton().addActionListener(this);
        this.view.getUpdatePopupMenu().addActionListener(this);
        this.view.getDeletePopupMenu().addActionListener(this);
        this.view.getUpdatePricingDetailButton().addActionListener(this);
        this.view.getAddAmenitiesButton().addActionListener(this);
        this.view.getClearAmenitiesButton().addActionListener(this);
        this.view.getDeleteAmenitiesPopupMenu().addActionListener(this);
        this.view.getAddAdditionalDetailsButton().addActionListener(this);
        this.view.getClearAdditionalDetailsButton().addActionListener(this);
        this.view.getDeleteAdditionalDetailsPopupMenu().addActionListener(this);
    }

    private boolean validateProjectDetails() {
        boolean flag = true;
        if (this.view.getProjectNameTf().getText().trim().isEmpty()) {
            JOptionPane.showMessageDialog(this.view.getDio(), "Project name is mandatory", "Error", 0);
            this.view.getProjectNameTf().requestFocus();
            flag = false;
        } else if (this.view.getProjectTypeCb().getSelectedItem() == null) {
            JOptionPane.showMessageDialog(this.view.getDio(), "Project type is mandatory", "Error", 0);
            this.view.getProjectNameTf().requestFocus();
            flag = false;
        }
        return flag;
    }

    public void clearForm() {
        this.view.getProjectNameTf().setText("");
        this.view.getTotalProjectAreaTf().setText("");
        this.view.getTotalUnitsTf().setText("");
        this.view.getNumberOfFloorsTf().setText("");
        this.view.getDescriptionTextArea().setText("");
        this.view.getLocationDetailsTf().setText("");
        this.view.getReraRegistrationNoTf().setText("");
        this.view.getLaunchDateTf().setText("");
        this.view.getCompletionDateTf().setText("");
        this.view.getBuilderNameTf().setText("");
        this.view.getArchitectNameTf().setText("");
        this.view.setBuilderContactId(0);
        this.view.setArchitectContactId(0);
    }

    public void loadProjectDetails(ProjectRecord projectRecord) throws ServiceException {
        this.view.getProjectNameTf().setText(projectRecord.projectName());
        this.view.getTotalProjectAreaTf().setText(String.valueOf(projectRecord.totalArea()));
        this.view.getTotalUnitsTf().setText(String.valueOf(projectRecord.totalUnits()));
        this.view.getNumberOfFloorsTf().setText(String.valueOf(projectRecord.numberOfFloors()));
        this.view.getDescriptionTextArea().setText(projectRecord.description());
        this.view.getLocationDetailsTf().setText(projectRecord.locationDetails());
        this.view.getReraRegistrationNoTf().setText(projectRecord.reraRegistrationNumber());
        this.view.getLaunchDateTf().setText(projectRecord.launchDate());
        this.view.getCompletionDateTf().setText(projectRecord.completionDate());
        this.view.getProjectTypeCb().setSelectedItem(ProjectGroupCache.getGroupName(projectRecord.fkProjectType()));
        this.view.getProjectStatusCb().setSelectedItem(projectRecord.projectStatus());
        this.view.setBuilderContactId(projectRecord.fkBuilderContactId());
        this.view.setArchitectContactId(projectRecord.fkArchitectContactId());
        Map<Integer, String> contactDetails = this.contactService.loadContactByIds(Arrays.asList(projectRecord.fkBuilderContactId(), projectRecord.fkArchitectContactId()));
        this.view.getBuilderNameTf().setText(contactDetails.get(projectRecord.fkBuilderContactId()));
        this.view.getArchitectNameTf().setText(contactDetails.get(projectRecord.fkArchitectContactId()));
        IntStream.rangeClosed(1, 3).forEachOrdered(index -> this.view.getTabbedPane().setEnabledAt(index, true));
    }

    private ProjectRecord bindFormFields() throws ServiceException {
        try {
            return new ProjectRecord.Builder().projectId(this.view.getProjectId()).projectName(this.view.getProjectNameTf().getText()).fkProjectType(ProjectGroupCache.getGroupIdByName((String)this.view.getProjectTypeCb().getSelectedItem())).projectStatus((String)this.view.getProjectStatusCb().getSelectedItem()).totalArea(Float.parseFloat(this.view.getTotalProjectAreaTf().getText().trim().isEmpty() ? "0F" : this.view.getTotalProjectAreaTf().getText().trim())).totalUnits(Integer.parseInt(this.view.getTotalUnitsTf().getText().trim().isEmpty() ? "0" : this.view.getTotalUnitsTf().getText().trim())).numberOfFloors(Integer.parseInt(this.view.getNumberOfFloorsTf().getText().trim().isEmpty() ? "0" : this.view.getNumberOfFloorsTf().getText().trim())).description(this.view.getDescriptionTextArea().getText()).launchDate(this.view.getLaunchDateTf().getText()).completionDate(this.view.getCompletionDateTf().getText()).locationDetails(this.view.getLocationDetailsTf().getText().trim()).fkBuilderContactId(this.view.getBuilderContactId()).fkArchitectContactId(this.view.getArchitectContactId()).reraRegistrationNumber(this.view.getReraRegistrationNoTf().getText().trim()).build();
        }
        catch (Exception e) {
            throw new ServiceException("bindFormFields of Projects", e);
        }
    }

    private void handleSaveProjectDetails() {
        if (this.validateProjectDetails()) {
            try {
                this.view.setProjectId(this.service.saveProjectDetails(this.bindFormFields()));
                JOptionPane.showMessageDialog(this.view.getDio(), "Successfully saved !", "Success", 1);
                IntStream.rangeClosed(1, 3).forEachOrdered(index -> this.view.getTabbedPane().setEnabledAt(index, true));
                this.view.getSaveBtn().setVisible(false);
                this.view.getUpdateBtn().setVisible(true);
                this.view.getDio().setTitle("Update Project -" + this.view.getProjectNameTf().getText().trim());
                BuilderNamesCache.loadBuilderName();
                ArchitectNamesCache.loadArchitectName();
            }
            catch (ServiceException e) {
                new ErrorDialog(e, "Save project details");
            }
            catch (BusinessException e) {
                JOptionPane.showMessageDialog(this.view.getDio(), e.getMessage(), "Error", 0);
            }
        }
    }

    private void handleUpdateProjectDetails() {
        if (this.validateProjectDetails()) {
            try {
                this.service.updateProjectDetails(this.bindFormFields());
                JOptionPane.showMessageDialog(this.view.getDio(), "Successfully updated !", "Success", 1);
                this.view.getDio().dispose();
                this.view.getDio().setVisible(false);
                BuilderNamesCache.loadBuilderName();
                ArchitectNamesCache.loadArchitectName();
            }
            catch (ServiceException e) {
                new ErrorDialog(e, "Save project details");
            }
        }
    }

    private boolean validatePricingForm() {
        return !this.view.getPropertyTypeCb().getSelectedItem().equals("");
    }

    private UnitPricingAndPaymentDetails bindPricingFormFields() throws RuntimeException {
        return new UnitPricingAndPaymentDetails.Builder().unitId(this.view.getUnitId()).propertyType((String)this.view.getPropertyTypeCb().getSelectedItem()).unitSize(Integer.parseInt(this.view.getUnitSizeTf().getText().trim().isBlank() ? "0" : this.view.getUnitSizeTf().getText().trim())).unitBasePrice(Integer.parseInt(this.view.getUnitBasePriceTf().getText().trim().isBlank() ? "0" : this.view.getUnitBasePriceTf().getText().trim())).paymentPlan(this.view.getPaymentPlanTf().getText().trim()).comments(this.view.getPricingAndPaymentComments().getText().trim()).fkProjectId(this.view.getProjectId()).build();
    }

    private void clearUnitPricingForm() {
        this.view.getUnitSizeTf().setText("");
        this.view.getUnitBasePriceTf().setText("");
        this.view.getPaymentPlanTf().setText("");
        this.view.getPricingAndPaymentComments().setText("");
        this.view.setUnitId(0);
    }

    private void handleAddUnitPricingDetails() {
        if (this.validatePricingForm()) {
            try {
                this.service.addUnitDetails(this.bindPricingFormFields());
                this.clearUnitPricingForm();
                JOptionPane.showMessageDialog(this.view.getDio(), "Successfully saved !", "Success", 1);
                this.loadUnitDetails(this.view.getProjectId());
            }
            catch (ServiceException e) {
                new ErrorDialog(e, e.getMessage());
            }
            catch (BusinessException e) {
                JOptionPane.showMessageDialog(this.view.getDio(), e.getMessage(), "Error", 1);
            }
        }
    }

    private void handleDeleteProjectUnit() {
        try {
            int row = this.view.getPricingDetailsTable().getSelectedRow();
            int unitId = (Integer)this.view.getPricingDetailsTable().getValueAt(row, 0);
            String propertyType = (String)this.view.getPricingDetailsTable().getValueAt(row, 1);
            int choose = JOptionPane.showConfirmDialog(this.view.getDio(), String.format("Are you sure you want to delete the unit   \"%s\" ?", propertyType), "Delete", 1);
            if (choose == 0) {
                this.service.deleteUnitDetails(unitId);
                JOptionPane.showMessageDialog(this.view.getDio(), "Successfully deleted !", "Success", 1);
                this.loadUnitDetails(this.view.getProjectId());
            }
        }
        catch (ServiceException e) {
            new ErrorDialog(e, "Delete project unit");
        }
    }

    private void loadUpdateProjectUnitDetails() {
        try {
            int row = this.view.getPricingDetailsTable().getSelectedRow();
            int unitId = (Integer)this.view.getPricingDetailsTable().getValueAt(row, 0);
            String propertyType = (String)this.view.getPricingDetailsTable().getValueAt(row, 1);
            int choose = JOptionPane.showConfirmDialog(this.view.getDio(), String.format("Are you sure you want to update the unit   \"%s\" ?", propertyType), "Delete", 1);
            if (choose == 0) {
                UnitPricingAndPaymentDetails unitPricingAndPaymentDetails = this.service.loadUnitDetails(unitId);
                this.view.getPropertyTypeCb().setSelectedItem(unitPricingAndPaymentDetails.propertyType());
                this.view.getUnitSizeTf().setText(String.valueOf(unitPricingAndPaymentDetails.unitSize()));
                this.view.getUnitBasePriceTf().setText(String.valueOf(unitPricingAndPaymentDetails.unitBasePrice()));
                this.view.getPricingAndPaymentComments().setText(unitPricingAndPaymentDetails.comments());
                this.view.getPaymentPlanTf().setText(unitPricingAndPaymentDetails.paymentPlan());
                this.view.setUnitId(unitId);
                this.view.getUpdatePricingDetailButton().setVisible(true);
                this.view.getAddPricingDetailButton().setVisible(false);
            }
        }
        catch (ServiceException e) {
            new ErrorDialog(e, e.getMessage());
        }
    }

    private void updateProjectUnitDetails() {
        if (this.validatePricingForm()) {
            try {
                this.service.updateUnitDetails(this.bindPricingFormFields());
                this.clearUnitPricingForm();
                JOptionPane.showMessageDialog(this.view.getDio(), "Successfully updated !", "Success", 1);
                this.view.getUpdatePricingDetailButton().setVisible(false);
                this.view.getAddPricingDetailButton().setVisible(true);
                this.loadUnitDetails(this.view.getProjectId());
            }
            catch (ServiceException e) {
                new ErrorDialog(e, e.getMessage());
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int choose;
        int row;
        Object object = e.getSource();
        if (object == this.view.getDeleteAdditionalDetailsPopupMenu()) {
            try {
                row = this.view.getAdditionalDetailsTable().getSelectedRow();
                int additionalId = (Integer)this.view.getAdditionalDetailsTable().getValueAt(row, 0);
                String name = (String)this.view.getAdditionalDetailsTable().getValueAt(row, 1);
                choose = JOptionPane.showConfirmDialog(this.view.getDio(), String.format("Are you sure you want to delete the record   \"%s\" ?", name), "Delete", 1);
                if (choose == 0) {
                    ProjectAdditionalDetails projectAdditionalDetails = new ProjectAdditionalDetails(additionalId, "", "", this.view.getProjectId());
                    this.service.deleteAdditionalDetails(projectAdditionalDetails);
                    JOptionPane.showMessageDialog(this.view.getDio(), "Successfully deleted !", "Success", 1);
                    this.loadAdditionalDetails(this.view.getProjectId());
                }
            }
            catch (ServiceException ex) {
                new ErrorDialog(ex, "Delete Additional details");
            }
        }
        if (object == this.view.getAddAdditionalDetailsButton()) {
            try {
                if (this.view.getAdditionalDetailsValueTf().getText().trim().isEmpty() || this.view.getAdditionalDetailsNameTf().getText().trim().isEmpty()) {
                    JOptionPane.showMessageDialog(this.view.getDio(), "Name and value both are mandatory", "Error", 0);
                    if (this.view.getAdditionalDetailsNameTf().getText().trim().isEmpty()) {
                        this.view.getAdditionalDetailsNameTf().requestFocus();
                    } else {
                        this.view.getAdditionalDetailsValueTf().requestFocus();
                    }
                } else {
                    ProjectAdditionalDetails projectAdditionalDetails = new ProjectAdditionalDetails(0, this.view.getAdditionalDetailsNameTf().getText().trim(), this.view.getAdditionalDetailsValueTf().getText().trim(), this.view.getProjectId());
                    this.service.addAdditionalDetails(projectAdditionalDetails);
                    JOptionPane.showMessageDialog(this.view.getDio(), "Successfully saved !", "Success", 1);
                    this.loadAdditionalDetails(this.view.getProjectId());
                    this.view.getAdditionalDetailsValueTf().setText("");
                    this.view.getAdditionalDetailsNameTf().setText("");
                }
            }
            catch (ServiceException ex) {
                new ErrorDialog(ex, "Add amenities");
            }
        }
        if (object == this.view.getClearAdditionalDetailsButton()) {
            this.view.getAdditionalDetailsNameTf().setText("");
            this.view.getAdditionalDetailsValueTf().setText("");
        }
        if (object == this.view.getDeleteAmenitiesPopupMenu()) {
            try {
                row = this.view.getAmenitiesDetailsTable().getSelectedRow();
                int amenitiesId = (Integer)this.view.getAmenitiesDetailsTable().getValueAt(row, 0);
                String amenities = (String)this.view.getAmenitiesDetailsTable().getValueAt(row, 1);
                choose = JOptionPane.showConfirmDialog(this.view.getDio(), String.format("Are you sure you want to delete the record   \"%s\" ?", amenities), "Delete", 1);
                if (choose == 0) {
                    AmenitiesRecord amenitiesRecord = new AmenitiesRecord(amenitiesId, amenities, this.view.getProjectId());
                    this.service.deleteAmenities(amenitiesRecord);
                    JOptionPane.showMessageDialog(this.view.getDio(), "Successfully deleted !", "Success", 1);
                    this.loadAmenitiesDetails(this.view.getProjectId());
                }
            }
            catch (ServiceException ex) {
                new ErrorDialog(ex, "Delete Amenities");
            }
        }
        if (object == this.view.getAddAmenitiesButton()) {
            try {
                if (this.view.getAmenitiesTf().getText().trim().isEmpty()) {
                    JOptionPane.showMessageDialog(this.view.getDio(), "Amenities is mandatory", "Error", 0);
                    this.view.getAmenitiesTf().requestFocus();
                } else {
                    AmenitiesRecord amenitiesRecord = new AmenitiesRecord(0, this.view.getAmenitiesTf().getText().trim(), this.view.getProjectId());
                    this.service.addAmenities(amenitiesRecord);
                    JOptionPane.showMessageDialog(this.view.getDio(), "Successfully saved !", "Success", 1);
                    this.loadAmenitiesDetails(this.view.getProjectId());
                    this.view.getAmenitiesTf().setText("");
                }
            }
            catch (ServiceException ex) {
                new ErrorDialog(ex, "Add amenities");
            }
        }
        if (object == this.view.getClearAmenitiesButton()) {
            this.view.getAmenitiesTf().setText("");
        }
        if (object == this.view.getUpdatePricingDetailButton()) {
            this.updateProjectUnitDetails();
        }
        if (object == this.view.getUpdatePopupMenu()) {
            this.loadUpdateProjectUnitDetails();
        }
        if (object == this.view.getDeletePopupMenu()) {
            this.handleDeleteProjectUnit();
        }
        if (object == this.view.getAddPricingDetailButton()) {
            this.handleAddUnitPricingDetails();
        }
        if (object == this.view.getUpdateBtn()) {
            this.handleUpdateProjectDetails();
        }
        if (object == this.view.getSaveBtn()) {
            this.handleSaveProjectDetails();
        }
        if (object == this.view.getCloseBtn()) {
            this.view.getDio().setVisible(false);
            this.view.getDio().dispose();
        }
        if (object == this.view.getLaunchDateButton()) {
            CustomDatePicker customDatePicker = new CustomDatePicker(this, "launchDate");
            AppUtility.setDialogLocationInCenter(customDatePicker.getDio());
            customDatePicker.getDio().setVisible(true);
        }
        if (object == this.view.getCompletionDateButton()) {
            CustomDatePicker customDatePicker = new CustomDatePicker(this, "completionDate");
            AppUtility.setDialogLocationInCenter(customDatePicker.getDio());
            customDatePicker.getDio().setVisible(true);
        }
        if (object == this.view.getBuilderNameButton()) {
            ContactDialogView contactDialogView = new ContactDialogView(this, "builder", "Select a builder name");
            AppUtility.setDialogLocationInCenter(contactDialogView.getDio());
            contactDialogView.getDio().setVisible(true);
        }
        if (object == this.view.getArchitectNameButton()) {
            ContactDialogView contactDialogView = new ContactDialogView(this, "architect", "Select an architect name");
            AppUtility.setDialogLocationInCenter(contactDialogView.getDio());
            contactDialogView.getDio().setVisible(true);
        }
    }

    public ManageProjectView getView() {
        return this.view;
    }

    private void hideSaveAndUpdateButton() {
        this.view.getSaveBtn().setVisible(false);
        this.view.getUpdateBtn().setVisible(false);
    }

    private void loadUnitDetails(int projectId) {
        try {
            List<UnitPricingAndPaymentDetails> unitPricingAndPaymentDetailsList = this.service.loadAllUnitDetailsByProjectId(projectId);
            this.view.getDefaultTableModel().setRowCount(0);
            IntStream.range(0, unitPricingAndPaymentDetailsList.size()).forEach(index -> {
                this.view.getDefaultTableModel().addRow(new Object[]{"", "", "", "", "", ""});
                this.view.getPricingDetailsTable().setValueAt(((UnitPricingAndPaymentDetails)unitPricingAndPaymentDetailsList.get(index)).unitId(), index, 0);
                this.view.getPricingDetailsTable().setValueAt(((UnitPricingAndPaymentDetails)unitPricingAndPaymentDetailsList.get(index)).propertyType(), index, 1);
                this.view.getPricingDetailsTable().setValueAt(((UnitPricingAndPaymentDetails)unitPricingAndPaymentDetailsList.get(index)).unitSize(), index, 2);
                this.view.getPricingDetailsTable().setValueAt(((UnitPricingAndPaymentDetails)unitPricingAndPaymentDetailsList.get(index)).unitBasePrice(), index, 3);
                this.view.getPricingDetailsTable().setValueAt(((UnitPricingAndPaymentDetails)unitPricingAndPaymentDetailsList.get(index)).paymentPlan(), index, 4);
                this.view.getPricingDetailsTable().setValueAt(((UnitPricingAndPaymentDetails)unitPricingAndPaymentDetailsList.get(index)).comments(), index, 5);
                this.view.getPricingDetailsTable().setAutoCreateRowSorter(true);
            });
            if (this.view.getPricingDetailsTable().getRowCount() > 0) {
                this.view.getPricingDetailsTable().setRowSelectionInterval(0, 0);
            }
        }
        catch (ServiceException e) {
            new ErrorDialog(e, "loadUnitDetails");
        }
    }

    private void loadAmenitiesDetails(int projectId) {
        try {
            List<AmenitiesRecord> amenitiesRecordList = this.service.loadAllAmenities(projectId);
            this.view.getAmenitiesDefaultTableModel().setRowCount(0);
            IntStream.range(0, amenitiesRecordList.size()).forEach(index -> {
                this.view.getAmenitiesDefaultTableModel().addRow(new Object[]{"", ""});
                this.view.getAmenitiesDetailsTable().setValueAt(((AmenitiesRecord)amenitiesRecordList.get(index)).amenitiesId(), index, 0);
                this.view.getAmenitiesDetailsTable().setValueAt(((AmenitiesRecord)amenitiesRecordList.get(index)).amenities(), index, 1);
                this.view.getAmenitiesDetailsTable().setAutoCreateRowSorter(true);
            });
            if (this.view.getAmenitiesDetailsTable().getRowCount() > 0) {
                this.view.getAmenitiesDetailsTable().setRowSelectionInterval(0, 0);
            }
        }
        catch (ServiceException e) {
            new ErrorDialog(e, "loadAmenitiesDetails");
        }
    }

    private void loadAdditionalDetails(int projectId) {
        try {
            List<ProjectAdditionalDetails> projectAdditionalDetailsList = this.service.loadAllAdditionalDetails(projectId);
            this.view.getAdditionalDetailsDefaultTableModel().setRowCount(0);
            IntStream.range(0, projectAdditionalDetailsList.size()).forEach(index -> {
                this.view.getAdditionalDetailsDefaultTableModel().addRow(new Object[]{"", "", ""});
                this.view.getAdditionalDetailsTable().setValueAt(((ProjectAdditionalDetails)projectAdditionalDetailsList.get(index)).additionalId(), index, 0);
                this.view.getAdditionalDetailsTable().setValueAt(((ProjectAdditionalDetails)projectAdditionalDetailsList.get(index)).name(), index, 1);
                this.view.getAdditionalDetailsTable().setValueAt(((ProjectAdditionalDetails)projectAdditionalDetailsList.get(index)).value(), index, 2);
                this.view.getAdditionalDetailsTable().setAutoCreateRowSorter(true);
            });
            if (this.view.getAdditionalDetailsTable().getRowCount() > 0) {
                this.view.getAdditionalDetailsTable().setRowSelectionInterval(0, 0);
            }
        }
        catch (ServiceException ex) {
            new ErrorDialog(ex, "loadAdditionalDetails");
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.view.getTabbedPane()) {
            int selectedTabIndex = this.view.getTabbedPane().getSelectedIndex();
            if (selectedTabIndex == 0) {
                if (this.view.getProjectId() > 0) {
                    this.view.getUpdateBtn().setVisible(true);
                } else {
                    this.view.getSaveBtn().setVisible(true);
                }
            } else if (selectedTabIndex == 1) {
                this.hideSaveAndUpdateButton();
                this.view.getPropertyTypeCb().removeAllItems();
                Map<Integer, String> leaseGroupDts = PropertyGroupCache.getGroupIdToNameMap();
                leaseGroupDts.forEach((key, value) -> this.view.getPropertyTypeCb().addItem(value));
                this.loadUnitDetails(this.view.getProjectId());
            } else if (selectedTabIndex == 2) {
                this.hideSaveAndUpdateButton();
                this.loadAmenitiesDetails(this.view.getProjectId());
            } else if (selectedTabIndex == 3) {
                this.hideSaveAndUpdateButton();
                this.loadAdditionalDetails(this.view.getProjectId());
            }
        }
    }
}

