/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.controller.project;

import com.arun.bhardwaj.cache.ArchitectNamesCache;
import com.arun.bhardwaj.cache.BuilderNamesCache;
import com.arun.bhardwaj.cache.ProjectGroupCache;
import com.arun.bhardwaj.cache.PropertyGroupCache;
import com.arun.bhardwaj.exceptions.ServiceException;
import com.arun.bhardwaj.model.project.ProjectRecord;
import com.arun.bhardwaj.model.project.UnitPricingAndPaymentDetails;
import com.arun.bhardwaj.service.contact.ContactService;
import com.arun.bhardwaj.service.contact.ContactServiceImpl;
import com.arun.bhardwaj.service.project.ManageProjectService;
import com.arun.bhardwaj.service.project.ManagerProjectServiceImpl;
import com.arun.bhardwaj.service.project.ProjectCategoryService;
import com.arun.bhardwaj.service.project.ProjectCategoryServiceImpl;
import com.arun.bhardwaj.service.project.ProjectDetailsService;
import com.arun.bhardwaj.service.project.ProjectDetailsServiceImpl;
import com.arun.bhardwaj.utility.AppUtility;
import com.arun.bhardwaj.utility.UserCache;
import com.arun.bhardwaj.view.LoginView;
import com.arun.bhardwaj.view.common.ErrorDialog;
import com.arun.bhardwaj.view.common.ManageDocuments;
import com.arun.bhardwaj.view.common.PreviewAndShareView;
import com.arun.bhardwaj.view.project.ManageProjectView;
import com.arun.bhardwaj.view.project.ProjectCategory;
import com.arun.bhardwaj.view.project.ProjectDetailsView;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ProjectDetailsViewController
implements ActionListener,
ListSelectionListener,
KeyListener {
    private ProjectDetailsView view;
    private ProjectCategoryService projectCategoryService;
    private ManageProjectService manageProjectService;
    private ProjectDetailsService service;
    private ContactService contactService;
    private String projectDetailsToShare;
    private int selectedRowIndex = 0;

    public int getSelectedRowIndex() {
        return this.selectedRowIndex;
    }

    public void setSelectedRowIndex(int selectedRowIndex) {
        this.selectedRowIndex = selectedRowIndex;
    }

    public ProjectDetailsViewController(ProjectDetailsView view) {
        this.view = view;
        this.projectCategoryService = new ProjectCategoryServiceImpl();
        this.service = new ProjectDetailsServiceImpl();
        this.manageProjectService = new ManagerProjectServiceImpl();
        this.contactService = new ContactServiceImpl();
        this.loadInitialData();
        this.addActionListener();
        this.addToolTip();
        AppUtility.tableZoomInZoomOut(true, view.getTable());
        AppUtility.tableZoomInZoomOut(true, view.getTable());
    }

    private void addActionListener() {
        this.view.getAddProjectButton().addActionListener(this);
        this.view.getUpdateProjectButton().addActionListener(this);
        this.view.getDeleteProjectButton().addActionListener(this);
        this.view.getAddProjectTypeButton().addActionListener(this);
        this.view.getUpdateProjectTypeButton().addActionListener(this);
        this.view.getDeleteProjectTypeButton().addActionListener(this);
        this.view.getRefreshButton().addActionListener(this);
        this.view.getProjectTypeList().addActionListener(this);
        this.view.getZoomInBtn().addActionListener(this);
        this.view.getZoomOutBtn().addActionListener(this);
        this.view.getNextButton().addActionListener(this);
        this.view.getPrevButton().addActionListener(this);
        this.view.getSelectionModel().addListSelectionListener(this);
        this.view.getDeleteProjectDetailsPopupMenu().addActionListener(this);
        this.view.getUpdateProjectDetailsPopupMenu().addActionListener(this);
        this.view.getDocumentProjectDetailsPopupMenu().addActionListener(this);
        this.view.getShareProjectDetails().addActionListener(this);
        this.view.getManageDocumentBtn().addActionListener(this);
        this.view.getPropertyTypeFilter().addActionListener(this);
        this.view.getSearchBy().addActionListener(this);
        this.view.getProjectStatusFilter().addActionListener(this);
        this.view.getSearchDataTf().addKeyListener(this);
        this.view.getBuilderNameFilter().addActionListener(this);
        this.view.getArchitectNameFilter().addActionListener(this);
    }

    private void addToolTip() {
        this.view.getAddProjectButton().setToolTipText("Add Project Details");
        this.view.getUpdateProjectButton().setToolTipText("Update Project Details");
        this.view.getDeleteProjectButton().setToolTipText("Delete Project Details");
        this.view.getAddProjectTypeButton().setToolTipText("Add Project Type");
        this.view.getUpdateProjectTypeButton().setToolTipText("Update Project Type");
        this.view.getDeleteProjectTypeButton().setToolTipText("Delete Project Type");
        this.view.getManageDocumentBtn().setToolTipText("Manage Documents");
        this.view.getRefreshButton().setToolTipText("Refresh");
        this.view.getProjectTypeList().setToolTipText("Select project type to filter records");
        this.view.getPropertyTypeFilter().setToolTipText("Filter projects by selected property types");
    }

    public void loadInitialData() {
        try {
            this.loadGroups();
            this.loadPropertyGroups();
            this.loadRecords();
        }
        catch (ServiceException e) {
            new ErrorDialog(e, e.getMessage());
        }
    }

    private void loadRecords() throws ServiceException {
        AppUtility.validateUser();
        String filterType = (String)this.view.getSearchBy().getSelectedItem();
        Object filterValue = "";
        if ("Project Type".equals(filterType)) {
            filterValue = ProjectGroupCache.getGroupIdByName((String)this.view.getProjectTypeList().getSelectedItem());
        } else if ("Property Type".equals(filterType)) {
            filterValue = this.view.getPropertyTypeFilter().getSelectedItem();
        } else if ("Project Status".equals(filterType)) {
            filterValue = this.view.getProjectStatusFilter().getSelectedItem();
        } else if ("Project Name".equals(filterType) || "Location".equals(filterType) || "RERA Registration No".equals(filterType)) {
            filterValue = this.view.getSearchDataTf().getText();
        } else if ("Builder Name".equals(filterType)) {
            filterValue = BuilderNamesCache.getBuilderIdByName((String)this.view.getBuilderNameFilter().getSelectedItem());
        } else if ("Architect Name".equals(filterType)) {
            filterValue = ArchitectNamesCache.getArchitectIdByName((String)this.view.getArchitectNameFilter().getSelectedItem());
        }
        List<ProjectRecord> projects = this.service.loadAllProjects(filterType, filterValue, this.view.getCurrentPage(), this.view.getPAGE_SIZE());
        if (projects.size() > 0) {
            this.view.setTotalRecords(projects.get(0).totalRecords());
        }
        this.view.getDefaultTableModel().setRowCount(0);
        IntStream.range(0, projects.size()).forEach(index -> {
            this.view.getDefaultTableModel().addRow(new Object[]{"", "", "", "", "", "", ""});
            this.view.getTable().setValueAt(((ProjectRecord)projects.get(index)).projectId(), index, 0);
            this.view.getTable().setValueAt(((ProjectRecord)projects.get(index)).projectName(), index, 1);
            this.view.getTable().setValueAt(((ProjectRecord)projects.get(index)).description(), index, 2);
            this.view.getTable().setValueAt(ProjectGroupCache.getGroupName(((ProjectRecord)projects.get(index)).fkProjectType()), index, 3);
            this.view.getTable().setValueAt(((ProjectRecord)projects.get(index)).projectStatus(), index, 4);
            String launchDate = ((ProjectRecord)projects.get(index)).launchDate().isBlank() ? "-" : ((ProjectRecord)projects.get(index)).launchDate();
            String completionDate = ((ProjectRecord)projects.get(index)).completionDate().isBlank() ? "-" : ((ProjectRecord)projects.get(index)).completionDate();
            this.view.getTable().setValueAt(launchDate, index, 5);
            this.view.getTable().setValueAt(completionDate, index, 6);
            this.view.getTable().setAutoCreateRowSorter(true);
        });
        if (this.getSelectedRowIndex() != -1 && this.getSelectedRowIndex() < this.view.getTable().getRowCount()) {
            this.view.getTable().setRowSelectionInterval(this.getSelectedRowIndex(), this.getSelectedRowIndex());
            this.loadDetailsOnRowSelection();
        } else if (this.view.getTable().getRowCount() > 0) {
            this.view.getTable().setRowSelectionInterval(0, 0);
            this.loadDetailsOnRowSelection();
        }
        AppUtility.tableZoomInZoomOut(true, this.view.getTable());
        AppUtility.tableZoomInZoomOut(false, this.view.getTable());
        int startRecord = (this.view.getCurrentPage() - 1) * this.view.getPAGE_SIZE() + 1;
        int endRecord = Math.min(this.view.getCurrentPage() * this.view.getPAGE_SIZE(), this.view.getTotalRecords());
        String resultString = "Result " + startRecord + " - " + endRecord + " of " + this.view.getTotalRecords();
        this.view.getPageLabel().setText(resultString);
        this.view.getPrevButton().setEnabled(this.view.getCurrentPage() > 1);
        this.view.getNextButton().setEnabled(this.view.getCurrentPage() * this.view.getPAGE_SIZE() < this.view.getTotalRecords());
    }

    private void loadGroups() {
        JComboBox projectTypeList = this.view.getProjectTypeList();
        projectTypeList.removeAllItems();
        projectTypeList.addItem("All Records");
        Map<Integer, String> projectTypes = ProjectGroupCache.getGroupIdToNameMap();
        projectTypes.values().forEach(projectTypeList::addItem);
    }

    private void loadPropertyGroups() {
        JComboBox propertyTypeFilter = this.view.getPropertyTypeFilter();
        propertyTypeFilter.removeAllItems();
        propertyTypeFilter.addItem("All Records");
        Map<Integer, String> propertyTypes = PropertyGroupCache.getGroupIdToNameMap();
        propertyTypes.values().forEach(propertyTypeFilter::addItem);
    }

    private void loadBuilderName() {
        JComboBox builderNameFilter = this.view.getBuilderNameFilter();
        builderNameFilter.removeAllItems();
        builderNameFilter.addItem("All Records");
        Map<Integer, String> builderNames = BuilderNamesCache.getBuilderNames();
        builderNames.values().forEach(builderNameFilter::addItem);
    }

    private void loadArchitectName() {
        JComboBox architectNameFilter = this.view.getArchitectNameFilter();
        architectNameFilter.removeAllItems();
        architectNameFilter.addItem("All Records");
        Map<Integer, String> architectNames = ArchitectNamesCache.getArchitectNames();
        architectNames.values().forEach(architectNameFilter::addItem);
    }

    private void handleProjectUpdate() {
        try {
            ManageProjectView manageProjectView = new ManageProjectView();
            manageProjectView.getDio().setTitle("Update project");
            manageProjectView.getSaveBtn().setVisible(false);
            manageProjectView.getUpdateBtn().setVisible(true);
            int row = this.view.getTable().getSelectedRow();
            int projectId = (Integer)this.view.getTable().getValueAt(row, 0);
            ProjectRecord projectRecord = this.service.loadProjectsDetails(projectId);
            manageProjectView.getController().loadProjectDetails(projectRecord);
            manageProjectView.setProjectId(projectId);
            manageProjectView.getTabbedPane().setSelectedIndex(0);
            manageProjectView.getDio().setTitle("Update project -" + projectRecord.projectName());
            manageProjectView.getDio().setVisible(true);
            this.loadRecords();
        }
        catch (ServiceException ex) {
            new ErrorDialog(ex, "load project details by id ");
        }
    }

    private void handleDeleteProject() {
        int choose;
        int[] selectedRows = this.view.getTable().getSelectedRows();
        StringBuilder projectNames = new StringBuilder();
        for (int row : selectedRows) {
            projectNames.append((String)this.view.getTable().getValueAt(row, 1));
            projectNames.append(", ");
        }
        int lastCommaIndex = projectNames.lastIndexOf(",");
        if (lastCommaIndex != -1) {
            projectNames.deleteCharAt(lastCommaIndex);
            int secondLastCommaIndex = projectNames.lastIndexOf(",", lastCommaIndex - 1);
            if (secondLastCommaIndex != -1) {
                projectNames.replace(secondLastCommaIndex, secondLastCommaIndex + 1, " and");
            }
        }
        if ((choose = JOptionPane.showConfirmDialog(this.view, String.format("Are you sure you want to delete the project   \"%s\" ?", projectNames), "Delete", 1)) == 0) {
            try {
                ArrayList<Integer> selectedRowIdsList = new ArrayList<Integer>();
                for (int row : selectedRows) {
                    selectedRowIdsList.add((int)((Integer)this.view.getTable().getValueAt(row, 0)));
                }
                this.manageProjectService.deleteProjectDetails(selectedRowIdsList);
                JOptionPane.showMessageDialog(LoginView.frame, "Successfully deleted !", "Success", 1);
                this.loadRecords();
            }
            catch (ServiceException ex) {
                new ErrorDialog(ex, "Deleting existing project type");
            }
        }
    }

    private void resetAllFilters() {
        this.view.getProjectStatusFilter().setSelectedIndex(0);
        this.view.getPropertyTypeFilter().setSelectedIndex(0);
        this.view.getProjectTypeList().setSelectedIndex(0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String selectedProjectType;
        int choose;
        ProjectCategory projectCategory;
        Object object = e.getSource();
        if (object == this.view.getSearchBy()) {
            String searchBy = (String)this.view.getSearchBy().getSelectedItem();
            this.resetAllFilters();
            if (searchBy.equals("Project Type")) {
                this.view.getSearchByLabel().setText("Project Type");
                this.view.getProjectTypeList().setVisible(true);
                this.view.getPropertyTypeFilter().setVisible(false);
                this.view.getProjectStatusFilter().setVisible(false);
                this.view.getSearchDataTf().setVisible(false);
                this.view.getArchitectNameFilter().setVisible(false);
                this.view.getBuilderNameFilter().setVisible(false);
            } else if (searchBy.equals("Property Type")) {
                this.view.getSearchByLabel().setText("Property Type");
                this.view.getPropertyTypeFilter().setVisible(true);
                this.view.getProjectTypeList().setVisible(false);
                this.view.getProjectStatusFilter().setVisible(false);
                this.view.getSearchDataTf().setVisible(false);
                this.view.getArchitectNameFilter().setVisible(false);
                this.view.getBuilderNameFilter().setVisible(false);
            } else if (searchBy.equals("Project Status")) {
                this.view.getSearchByLabel().setText("Project Status");
                this.view.getProjectStatusFilter().setVisible(true);
                this.view.getPropertyTypeFilter().setVisible(false);
                this.view.getProjectTypeList().setVisible(false);
                this.view.getSearchDataTf().setVisible(false);
                this.view.getArchitectNameFilter().setVisible(false);
                this.view.getBuilderNameFilter().setVisible(false);
            } else if (searchBy.equals("Builder Name")) {
                this.view.getSearchByLabel().setText("Builder Names");
                this.view.getBuilderNameFilter().setVisible(true);
                this.view.getProjectStatusFilter().setVisible(false);
                this.view.getPropertyTypeFilter().setVisible(false);
                this.view.getProjectTypeList().setVisible(false);
                this.view.getSearchDataTf().setVisible(false);
                this.view.getArchitectNameFilter().setVisible(false);
                this.loadBuilderName();
            } else if (searchBy.equals("Architect Name")) {
                this.view.getSearchByLabel().setText("Architect Names");
                this.view.getArchitectNameFilter().setVisible(true);
                this.view.getProjectStatusFilter().setVisible(false);
                this.view.getPropertyTypeFilter().setVisible(false);
                this.view.getProjectTypeList().setVisible(false);
                this.view.getSearchDataTf().setVisible(false);
                this.view.getBuilderNameFilter().setVisible(false);
                this.loadArchitectName();
            } else if (searchBy.equals("Project Name") || searchBy.equals("Location") || searchBy.equals("RERA Registration No")) {
                this.view.getSearchByLabel().setText(searchBy);
                this.view.getSearchDataTf().setVisible(true);
                this.view.getProjectStatusFilter().setVisible(false);
                this.view.getPropertyTypeFilter().setVisible(false);
                this.view.getProjectTypeList().setVisible(false);
                this.view.getArchitectNameFilter().setVisible(false);
                this.view.getBuilderNameFilter().setVisible(false);
            } else {
                this.view.getSearchByLabel().setText("");
                this.view.getProjectStatusFilter().setVisible(false);
                this.view.getPropertyTypeFilter().setVisible(false);
                this.view.getProjectTypeList().setVisible(false);
                this.view.getSearchDataTf().setVisible(false);
                this.view.getArchitectNameFilter().setVisible(false);
                this.view.getBuilderNameFilter().setVisible(false);
            }
        }
        if (object == this.view.getPropertyTypeFilter() || object == this.view.getProjectStatusFilter() || object == this.view.getBuilderNameFilter() || object == this.view.getArchitectNameFilter()) {
            try {
                this.loadRecords();
            }
            catch (ServiceException ex) {
                new ErrorDialog(ex, ex.getMessage());
            }
        }
        if (object == this.view.getManageDocumentBtn() || object == this.view.getDocumentProjectDetailsPopupMenu()) {
            Integer projectId = (Integer)this.view.getTable().getValueAt(this.view.getTable().getSelectedRow(), 0);
            String projectName = (String)this.view.getTable().getValueAt(this.view.getTable().getSelectedRow(), 1);
            ManageDocuments manageDocuments = new ManageDocuments("Project", projectId);
            manageDocuments.getDocumentDio().setTitle("Manage documents for - " + projectName);
            manageDocuments.getDocumentDio().setVisible(true);
        }
        if (object == this.view.getShareProjectDetails()) {
            new PreviewAndShareView(this.getProjectDetailsToShare(), "");
        }
        if (object == this.view.getDeleteProjectDetailsPopupMenu()) {
            this.handleDeleteProject();
        }
        if (object == this.view.getUpdateProjectDetailsPopupMenu()) {
            this.handleProjectUpdate();
        }
        if (object == this.view.getRefreshButton()) {
            this.loadInitialData();
        }
        if (object == this.view.getDeleteProjectButton()) {
            this.handleDeleteProject();
        }
        if (object == this.view.getPrevButton() && this.view.getCurrentPage() > 1) {
            this.view.setCurrentPage(this.view.getCurrentPage() - 1);
            try {
                this.loadRecords();
            }
            catch (ServiceException ex) {
                new ErrorDialog(ex, "Previous Button");
            }
        }
        if (object == this.view.getNextButton() && this.view.getCurrentPage() * this.view.getPAGE_SIZE() < this.view.getTotalRecords()) {
            this.view.setCurrentPage(this.view.getCurrentPage() + 1);
            try {
                this.loadRecords();
            }
            catch (ServiceException ex) {
                new ErrorDialog(ex, "Next button");
            }
        }
        if (object == this.view.getZoomInBtn()) {
            AppUtility.tableZoomInZoomOut(true, this.view.getTable());
        }
        if (object == this.view.getZoomOutBtn()) {
            AppUtility.tableZoomInZoomOut(false, this.view.getTable());
        }
        if (object == this.view.getAddProjectButton()) {
            try {
                ManageProjectView manageProjectView = new ManageProjectView();
                manageProjectView.getDio().setTitle("Add project");
                manageProjectView.getSaveBtn().setVisible(true);
                manageProjectView.getUpdateBtn().setVisible(false);
                manageProjectView.getController().clearForm();
                manageProjectView.getTabbedPane().setSelectedIndex(0);
                manageProjectView.setProjectId(0);
                manageProjectView.getDio().setVisible(true);
                this.loadRecords();
            }
            catch (ServiceException ex) {
                new ErrorDialog(ex, "load project details ");
            }
        }
        if (object == this.view.getUpdateProjectButton()) {
            this.handleProjectUpdate();
        }
        if (object == this.view.getAddProjectTypeButton()) {
            projectCategory = new ProjectCategory();
            projectCategory.getSaveBtn().setVisible(true);
            projectCategory.getUpdateBtn().setVisible(false);
            projectCategory.setProjectTypeId(0);
            projectCategory.getGroupNameField().setText("");
            projectCategory.getDio().setTitle("New Project Type");
            projectCategory.getDio().setVisible(true);
            this.loadGroups();
        }
        if (object == this.view.getProjectTypeList()) {
            try {
                if ("All Records".equals(this.view.getProjectTypeList().getSelectedItem())) {
                    this.view.getUpdateProjectTypeButton().setEnabled(false);
                    this.view.getDeleteProjectTypeButton().setEnabled(false);
                } else {
                    this.view.getUpdateProjectTypeButton().setEnabled(true);
                    this.view.getDeleteProjectTypeButton().setEnabled(true);
                }
                this.loadRecords();
            }
            catch (ServiceException ex) {
                new ErrorDialog(ex, "loadRecords on type selection");
            }
        }
        if (object == this.view.getUpdateProjectTypeButton()) {
            projectCategory = new ProjectCategory();
            projectCategory.getSaveBtn().setVisible(false);
            projectCategory.getUpdateBtn().setVisible(true);
            String selectedProjectType2 = (String)this.view.getProjectTypeList().getSelectedItem();
            projectCategory.getGroupNameField().setText(selectedProjectType2);
            projectCategory.setProjectTypeId(ProjectGroupCache.getGroupIdByName(selectedProjectType2));
            projectCategory.getDio().setTitle("Update Project Type");
            projectCategory.getDio().setVisible(true);
            this.loadGroups();
        }
        if (object == this.view.getDeleteProjectTypeButton() && (choose = JOptionPane.showConfirmDialog(this.view, String.format("Are you sure you want to delete the project type  \"%s\" ?", selectedProjectType = (String)this.view.getProjectTypeList().getSelectedItem()), "Delete", 1)) == 0) {
            int selectedProjectTypeId = ProjectGroupCache.getGroupIdByName(selectedProjectType);
            try {
                this.projectCategoryService.deleteCategory(selectedProjectTypeId);
                ProjectGroupCache.loadProjectType();
                this.loadGroups();
                JOptionPane.showMessageDialog(LoginView.frame, "Successfully deleted !", "Success", 1);
            }
            catch (ServiceException ex) {
                new ErrorDialog(ex, "Deleting existing project type");
            }
            this.loadGroups();
        }
    }

    private void loadDetailsOnRowSelection() throws ServiceException {
        int row = this.view.getTable().getSelectedRow();
        int projectId = (Integer)this.view.getTable().getValueAt(row, 0);
        this.setSelectedRowIndex(this.view.getTable().getSelectedRow());
        ProjectRecord projectRecord = this.service.loadProjectsDetails(projectId);
        Map<Integer, String> contactDetails = this.contactService.loadContactByIds(Arrays.asList(projectRecord.fkBuilderContactId(), projectRecord.fkArchitectContactId()));
        StringBuilder projectDetails = new StringBuilder();
        StringBuilder projectDetailsToShare = new StringBuilder();
        projectDetails.append("<html lang=\"en\">\n<head>\n    <meta charset=\"UTF-8\">\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n    <title>Real Estate Project</title>\n    <style>\n        body {\n            font-family: Arial, sans-serif;\n            font-size: 11px;\n            margin: 0;\n            padding: 0;\n        }\n        .container {\n            width: auto;\n            margin: auto;\n            padding: 20px;\n            box-shadow: 0px 0px 10px rgba(0, 0, 0, 0.1);\n        }\n        .details {\n            display: flex;\n            flex-direction: column;\n            padding: 20px 0;\n        }\n        .details div {\n            padding: 8px 0;\n            border-bottom: 1px solid #ddd;\n        }\n        p {\n            text-align: justify;\n        }\n        h1, h2 {\n              color: #333;\n        }\n        table {\n                width: 100%;\n                max-width: 600px; /* Adjust as needed for your layout */\n                margin: 0 auto;\n                border-collapse: collapse;\n                border-spacing: 0;\n                overflow: auto;\n        }\n        th, td {\n            padding: 8px;\n            border: 1px solid #5B7687;\n            word-wrap: break-word;\n        }\n        th {\n            background-color: #115676;\n            color: #fff;\n        }\n\n\n    </style>\n</head>\n<body>\n    <div class=\"container\">\n\n");
        projectDetailsToShare.append("Just wanted to reach out with some exciting updates from our latest real estate development you\u2019ll find them both intriguing and worth exploring \n\n ");
        if (projectRecord.fkArchitectContactId() != 0 && projectRecord.fkBuilderContactId() != 0) {
            projectDetails.append("<strong>").append(projectRecord.projectName()).append(" </strong> Developed by <strong>").append(contactDetails.get(projectRecord.fkBuilderContactId())).append(" </strong> and Architect by <strong>").append(contactDetails.get(projectRecord.fkArchitectContactId())).append("</strong>");
            projectDetailsToShare.append(projectRecord.projectName()).append(" Developed by ").append(contactDetails.get(projectRecord.fkBuilderContactId())).append(" and Architect by ").append(contactDetails.get(projectRecord.fkArchitectContactId()));
        } else if (projectRecord.fkBuilderContactId() != 0) {
            projectDetails.append("<strong>").append(projectRecord.projectName()).append(" </strong> Developed by <strong>").append(contactDetails.get(projectRecord.fkBuilderContactId())).append(" </strong>");
            projectDetailsToShare.append(projectRecord.projectName()).append(" Developed by").append(contactDetails.get(projectRecord.fkBuilderContactId()));
        } else {
            projectDetails.append("<strong>").append(projectRecord.projectName()).append("</strong>");
            projectDetailsToShare.append(projectRecord.projectName());
        }
        if (!projectRecord.locationDetails().isEmpty()) {
            projectDetails.append("<p><strong>Location:</strong>").append(projectRecord.locationDetails()).append("</p>");
            projectDetailsToShare.append("\n\n *Location:* ").append(projectRecord.locationDetails());
        }
        if (!projectRecord.description().isEmpty()) {
            projectDetails.append("<p><strong>Description:</strong>").append(projectRecord.description()).append("</p>");
            projectDetailsToShare.append("\n\n *Description:* ").append(projectRecord.description());
        }
        projectDetails.append("<div class='details'>");
        projectDetails.append(" <div><strong>Project type:</strong>").append(ProjectGroupCache.getGroupName(projectRecord.fkProjectType())).append("</div>");
        projectDetails.append(" <div><strong>Project status:</strong>").append(projectRecord.projectStatus()).append("</div>");
        projectDetailsToShare.append("\n\n*Project type:* ").append(ProjectGroupCache.getGroupName(projectRecord.fkProjectType()));
        projectDetailsToShare.append("\n\n*Project status:* ").append(projectRecord.projectStatus());
        if (projectRecord.totalArea() != 0.0f) {
            projectDetails.append(" <div><strong>Total Area (Acres):</strong>").append(projectRecord.totalArea()).append("</div>");
            projectDetailsToShare.append("\n\n*Total Area (Acres):* ").append(projectRecord.totalArea());
        }
        if (projectRecord.totalUnits() != 0) {
            projectDetails.append(" <div><strong>Total Units:</strong>").append(projectRecord.totalUnits()).append("</div>");
            projectDetailsToShare.append("\n\n*Total Units:* ").append(projectRecord.totalUnits());
        }
        if (projectRecord.numberOfFloors() != 0) {
            projectDetails.append(" <div><strong>No of floors:</strong>").append(projectRecord.numberOfFloors()).append("</div>");
            projectDetailsToShare.append("\n\n*No of floors:* ").append(projectRecord.numberOfFloors());
        }
        if (!projectRecord.launchDate().isEmpty()) {
            projectDetails.append(" <div><strong>Launch date:</strong>").append(projectRecord.launchDate()).append("</div>");
            projectDetailsToShare.append("\n\n *Launch date:* ").append(projectRecord.launchDate());
        }
        if (!projectRecord.completionDate().isEmpty()) {
            projectDetails.append(" <div><strong>Completion date:</strong>").append(projectRecord.completionDate()).append("</div>");
            projectDetailsToShare.append("\n\n*Completion date:* ").append(projectRecord.completionDate());
        }
        if (!projectRecord.reraRegistrationNumber().isEmpty()) {
            projectDetails.append(" <div><strong>RERA registration number:</strong>").append(projectRecord.reraRegistrationNumber()).append("</div>");
            projectDetailsToShare.append("\n\n*RERA registration number:* ").append(projectRecord.reraRegistrationNumber());
        }
        if (!projectRecord.unitPricingAndPaymentDetails().isEmpty()) {
            projectDetails.append("<p><h2>Units pricing and payment details:</h2></p> </br>");
            projectDetailsToShare.append("\n\n *Units pricing and payment details:* \n\n");
            projectDetails.append("<table> <tr>\n<th> Property Type </th>\n<th> Unit Size </th>\n<th> Base Price </th>\n<th> Payment Plan </th>\n<th> Comments </th>\n</tr>\n");
            for (UnitPricingAndPaymentDetails unitPricingAndPaymentDetails : projectRecord.unitPricingAndPaymentDetails()) {
                projectDetails.append("<tr>");
                projectDetails.append("<td>").append(unitPricingAndPaymentDetails.propertyType()).append("</td>");
                projectDetailsToShare.append("*Property Type:* ").append(unitPricingAndPaymentDetails.propertyType()).append("\n");
                projectDetails.append("<td>").append(unitPricingAndPaymentDetails.unitSize()).append("</td>");
                projectDetailsToShare.append("*Unit Size:* ").append(unitPricingAndPaymentDetails.unitSize()).append("\n");
                projectDetails.append("<td style='text-align:right'>").append(AppUtility.getFormattedCurrency(String.valueOf(unitPricingAndPaymentDetails.unitBasePrice()))).append("</td>");
                projectDetailsToShare.append("*Base Price:* ").append(unitPricingAndPaymentDetails.unitBasePrice()).append("\n");
                projectDetails.append("<td>").append(unitPricingAndPaymentDetails.paymentPlan()).append("</td>");
                projectDetailsToShare.append("*Payment Plan:* ").append(unitPricingAndPaymentDetails.paymentPlan()).append("\n");
                projectDetails.append("<td>").append(unitPricingAndPaymentDetails.comments()).append("</td>");
                projectDetailsToShare.append("*Comments:* ").append(unitPricingAndPaymentDetails.comments()).append("\n\n");
                projectDetails.append("</tr>");
            }
            projectDetails.append("</table> </div>");
        }
        if (!projectRecord.amenitiesRecordList().isEmpty()) {
            projectDetails.append("<p><h2>Amenities:</h2></p> </br>");
            projectDetailsToShare.append("\n\n *Amenities:* \n\n");
            projectDetails.append(" <div style=display: flex; flex-wrap: wrap; gap: 10px'>");
            for (String string : projectRecord.amenitiesRecordList()) {
                projectDetails.append("<div style='flex: 1 1 200px; box-sizing: border-box; padding: 10px; border: 1px solid #ccc; background-color: #f9f9f9; text-align: center'>").append(string).append("</div>");
                projectDetailsToShare.append(string).append("\n");
            }
            projectDetails.append("</div>");
        }
        if (!projectRecord.projectAdditionalDetails().isEmpty()) {
            projectDetails.append("<p><h2>Additional Details:</h2></p> </br>");
            projectDetailsToShare.append("\n\n*Additional Details:* \n");
            projectDetails.append("<table> <tr>\n<th> Name </th>\n<th> Value </th>\n</tr>\n");
            projectRecord.projectAdditionalDetails();
            for (Map.Entry entry : projectRecord.projectAdditionalDetails().entrySet()) {
                projectDetails.append("<tr>");
                projectDetails.append("<td>").append((String)entry.getKey()).append("</td>");
                projectDetailsToShare.append("\n").append(" *Name:* ").append((String)entry.getKey()).append("\n");
                projectDetails.append("<td>").append((String)entry.getValue()).append("</td>");
                projectDetailsToShare.append("\n").append(" *Value:* ").append((String)entry.getValue()).append("\n");
                projectDetails.append("</tr>");
            }
        }
        projectDetailsToShare.append("\n\nIf you're interested in more details or would like to schedule a visit, please feel free to reach out to me \n Looking forward to hearing from you!");
        projectDetailsToShare.append(UserCache.getUserSignature());
        projectDetails.append(" </body> </html>");
        this.view.getProjectDetailsEditorPane().setText(projectDetails.toString());
        this.setProjectDetailsToShare(projectDetailsToShare.toString());
        this.view.getProjectDetailsEditorPane().setCaretPosition(0);
    }

    public String getProjectDetailsToShare() {
        return this.projectDetailsToShare;
    }

    public void setProjectDetailsToShare(String projectDetailsToShare) {
        this.projectDetailsToShare = projectDetailsToShare;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.view.getSelectionModel()) {
            int[] selectedRows = this.view.getTable().getSelectedRows();
            if (selectedRows.length == 0) {
                this.view.getProjectDetailsEditorPane().setText("");
                this.setProjectDetailsToShare("");
                this.view.getUpdateProjectButton().setEnabled(false);
                this.view.getDeleteProjectButton().setEnabled(false);
                this.view.getManageDocumentBtn().setEnabled(false);
                this.view.getShareProjectDetails().setEnabled(false);
            } else if (selectedRows.length == 1) {
                try {
                    this.loadDetailsOnRowSelection();
                    this.view.getUpdateProjectButton().setEnabled(true);
                    this.view.getDeleteProjectButton().setEnabled(true);
                    this.view.getManageDocumentBtn().setEnabled(true);
                    this.view.getShareProjectDetails().setEnabled(true);
                    this.view.getUpdateProjectDetailsPopupMenu().setVisible(true);
                    this.view.getDocumentProjectDetailsPopupMenu().setVisible(true);
                }
                catch (ServiceException ex) {
                    new ErrorDialog(ex, ex.getMessage());
                }
            } else {
                this.view.getProjectDetailsEditorPane().setText("");
                this.setProjectDetailsToShare("");
                this.view.getUpdateProjectButton().setEnabled(false);
                this.view.getDeleteProjectButton().setEnabled(true);
                this.view.getManageDocumentBtn().setEnabled(false);
                this.view.getShareProjectDetails().setEnabled(false);
                this.view.getUpdateProjectDetailsPopupMenu().setVisible(false);
                this.view.getDocumentProjectDetailsPopupMenu().setVisible(false);
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        Object obj = e.getSource();
        if (obj == this.view.getSearchDataTf()) {
            try {
                this.loadRecords();
            }
            catch (ServiceException ex) {
                new ErrorDialog(ex, ex.getMessage());
            }
        }
    }
}

