/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.controller.property;

import com.arun.bhardwaj.utility.AppUtility;
import com.arun.bhardwaj.view.property.HomeLoanCalculator;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JOptionPane;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;

public class HomeLoanCalculatorController
implements KeyListener {
    private final HomeLoanCalculator view;

    public HomeLoanCalculatorController(HomeLoanCalculator view) {
        this.view = view;
        int twentyPercentLess = (int)((double)view.getPropertyPrice() - (double)view.getPropertyPrice() * 0.2);
        view.getLoanAmount().setText(String.valueOf(twentyPercentLess));
        view.getTenureInYears().setText("15");
        view.getIntrestRatePA().setText("9.0");
        this.addActionEvent();
        this.generateResults();
    }

    private void addActionEvent() {
        this.view.getLoanAmount().addKeyListener(this);
        this.view.getIntrestRatePA().addKeyListener(this);
        this.view.getTenureInYears().addKeyListener(this);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getSource() == this.view.getLoanAmount() || e.getSource() == this.view.getTenureInYears() || e.getSource() == this.view.getIntrestRatePA()) {
            this.generateResults();
        }
    }

    private void generateResults() {
        try {
            double loanAmount = Double.parseDouble(this.view.getLoanAmount().getText());
            double interestRate = Double.parseDouble(this.view.getIntrestRatePA().getText());
            int loanPeriodYears = Integer.parseInt(this.view.getTenureInYears().getText());
            int paymentsPerYear = 12;
            double monthlyInterestRate = interestRate / (double)(paymentsPerYear * 100);
            int totalPayments = loanPeriodYears * paymentsPerYear;
            double monthlyPayment = loanAmount * monthlyInterestRate / (1.0 - Math.pow(1.0 + monthlyInterestRate, -totalPayments));
            int numberOfPayments = Integer.parseInt(this.view.getTenureInYears().getText()) * 12;
            int downPayment = this.view.getPropertyPrice() - (int)loanAmount;
            double totalAmountPaid = monthlyPayment * (double)numberOfPayments + (double)downPayment;
            double interestComponent = monthlyPayment * (double)numberOfPayments - loanAmount;
            StringBuilder details = new StringBuilder();
            StringBuilder detailsForMessage = new StringBuilder();
            details.append(" <html>\n <head>\n     <meta charset=\"UTF-8\">\n     <title>Contract Details</title>\n    <style>\n        table {\n          width: 100%;\n          max-width: 600px; /* Adjust as needed for your layout */\n          margin: 0 auto;\n          border-collapse: collapse;\n          border-spacing: 0;\n          overflow: auto;\n        }\n\n        th, td {\n            padding: 2px;\n            border: 1px solid #5B7687;\n            word-wrap: break-word;\n        }\n        th {\n        background-color: #115676;\n        color: #fff;\n    }\n</style>\n </head>\n <body>\n");
            details.append("<table> <tr> <th>Loan Component</th><th>Amount</th></tr>").append("<tr><td> Monthly Home Loan EMI </td> <td style='text-align:right'>").append(AppUtility.getFormattedCurrency(String.format("%.2f", monthlyPayment))).append("</td> </tr>").append("<tr><td> Down payment </td> <td style='text-align:right'>").append(AppUtility.getFormattedCurrency(String.valueOf(downPayment))).append("</td></tr>").append("<tr><td> Principal Amount </td> <td style='text-align:right'>").append(AppUtility.getFormattedCurrency(String.valueOf(loanAmount))).append("</td></tr>").append("<tr><td> Interest Amount </td> <td style='text-align:right'>").append(AppUtility.getFormattedCurrency(String.valueOf(interestComponent))).append("</td> </tr>").append("<tr><td> Total Amount Payable </td> <td style='text-align:right'>").append(AppUtility.getFormattedCurrency(String.valueOf(totalAmountPaid))).append("</td> </tr> </table> </body> </html>");
            this.view.getResultTextArea().setText(details.toString());
            this.view.getResultTextArea().setCaretPosition(0);
            DefaultPieDataset dataset = new DefaultPieDataset();
            dataset.clear();
            dataset.setValue((Comparable)((Object)"Interest payable"), interestComponent);
            dataset.setValue((Comparable)((Object)"Principal"), loanAmount);
            JFreeChart chart = ChartFactory.createPieChart("Investment", (PieDataset)dataset, true, true, false);
            this.view.getChartPanel().revalidate();
            this.view.getChartPanel().removeAll();
            this.view.getChartPanel().repaint();
            this.view.getChartPanel().add(new ChartPanel(chart));
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(this.view.getDio(), "Please enter valid numbers.", "Error", 0);
        }
    }
}

