/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.controller.property;

import com.arun.bhardwaj.model.property.DepositTrackerDetails;
import com.arun.bhardwaj.model.property.ModeOfPayment;
import com.arun.bhardwaj.model.property.PaymentTrackerDetails;
import com.arun.bhardwaj.model.property.PropertyAuditStatus;
import com.arun.bhardwaj.model.property.PropertyOnRentDetails;
import com.arun.bhardwaj.model.property.PropertySoldDetails;
import com.arun.bhardwaj.model.property.RentDetails;
import com.arun.bhardwaj.service.property.PropertyAuditService;
import com.arun.bhardwaj.service.property.PropertyAuditServiceImpl;
import com.arun.bhardwaj.service.property.PropertyOnRentService;
import com.arun.bhardwaj.service.property.PropertyOnRentServiceImpl;
import com.arun.bhardwaj.utility.AppUtility;
import com.arun.bhardwaj.utility.UserCache;
import com.arun.bhardwaj.view.common.ErrorDialog;
import com.arun.bhardwaj.view.common.ManageDocuments;
import com.arun.bhardwaj.view.common.PreviewAndShareView;
import com.arun.bhardwaj.view.property.PropertyAudit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.stream.IntStream;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PropertyAuditController
implements ListSelectionListener,
ActionListener {
    private final PropertyAudit view;
    private final PropertyAuditService service;
    private final PropertyOnRentService propertyOnRentService;
    private String message;
    private String ownerMobileNo;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getOwnerMobileNo() {
        return this.ownerMobileNo;
    }

    public void setOwnerMobileNo(String ownerMobileNo) {
        this.ownerMobileNo = ownerMobileNo;
    }

    public PropertyAuditController(PropertyAudit view) {
        this.view = view;
        this.service = new PropertyAuditServiceImpl();
        this.propertyOnRentService = new PropertyOnRentServiceImpl();
        this.loadPropertyStatusHistory();
        this.view.getSelectionModel().addListSelectionListener(this);
        this.view.getShareWithOwnerBtn().addActionListener(this);
        view.getZoomInBtn().addActionListener(this);
        view.getZoomOutBtn().addActionListener(this);
        view.getManageDocumentBtn().addActionListener(this);
        AppUtility.tableZoomInZoomOut(true, view.getTable());
        AppUtility.tableZoomInZoomOut(true, view.getTable());
        view.getPropDetailsTextArea().addHyperlinkListener(e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                AppUtility.openWebPage(e.getURL().toString());
            }
        });
    }

    public void loadPropertyStatusHistory() {
        try {
            List<PropertyAuditStatus> details = this.service.getPropertyStatusHistory(this.view.getPropertyId());
            this.view.getDefaultTableModel().setRowCount(0);
            IntStream.range(0, details.size()).forEach(index -> {
                this.view.getDefaultTableModel().addRow(new Object[]{"", "", "", ""});
                this.view.getTable().setValueAt(String.valueOf(index + 1), index, 0);
                this.view.getTable().setValueAt(((PropertyAuditStatus)details.get(index)).date().split(" ")[0], index, 1);
                this.view.getTable().setValueAt(((PropertyAuditStatus)details.get(index)).status(), index, 2);
                this.view.getTable().setValueAt(((PropertyAuditStatus)details.get(index)).statusId(), index, 3);
                this.view.getTable().setAutoCreateRowSorter(true);
            });
            if (this.view.getTable().getRowCount() > 0) {
                this.view.getTable().setRowSelectionInterval(0, 0);
                this.loadDetailsOnRowSelection();
            }
        }
        catch (Exception e) {
            new ErrorDialog(e, "loadPropertyStatusHistory");
        }
    }

    private void showPropertyOnRentDetails(Integer statusId) {
        try {
            List<DepositTrackerDetails> depositTrackerDetails;
            PropertyOnRentDetails details = this.service.getPropertyOnRentDetails(statusId);
            int row = this.view.getTable().getSelectedRow();
            String transactionDate = (String)this.view.getTable().getValueAt(row, 1);
            StringBuilder rentDetails = new StringBuilder();
            StringBuilder rentDetailsForMessage = new StringBuilder();
            this.view.getManageDocumentBtn().setVisible(true);
            rentDetails.append("<html>\n<head>\n    <meta charset=\"UTF-8\">\n    <title>Contract Details</title>\n    <style>\n         body {\n              font-family: Arial, sans-serif;\n              margin: 5px;\n          }\n          h1, h2 {\n              color: #333;\n          }\n          table {\n            width: 100%;\n            max-width: 600px; /* Adjust as needed for your layout */\n            margin: 0 auto;\n            border-collapse: collapse;\n            border-spacing: 0;\n            overflow: auto;\n        }\n        th, td {\n            padding: 10px;\n            border: 1px solid #5B7687;\n            word-wrap: break-word;\n        }\n        th {\n            background-color: #115676;\n            color: #fff;\n        }\n    </style>\n</head>\n<body>\n");
            rentDetails.append("<h2>Property on rent details as on:").append(transactionDate.split(" ")[0]).append(" </h2>");
            rentDetailsForMessage.append("Dear ").append(details.ownerName()).append(",");
            rentDetailsForMessage.append("\n\nPlease verify the agreement details as on  ").append(transactionDate).append(" are as follows:");
            rentDetails.append("<h2>Address:</h2> <a href='https://www.google.com/maps/search/?api=1&query=").append(AppUtility.getEncodedText(this.view.getPropertyAddress())).append("'>").append(this.view.getPropertyAddress()).append("</a>");
            rentDetailsForMessage.append("\n\n*Address:* ").append(this.view.getPropertyAddress());
            rentDetailsForMessage.append("\n\n*Tenant Name:* ").append(details.tenantName());
            String ownerContactNumber = "";
            String tenantContactNumber = "";
            if (details.ownerContactNumber() != null) {
                ownerContactNumber = details.ownerContactNumber();
                this.view.getShareWithOwnerBtn().setEnabled(true);
                this.setOwnerMobileNo(ownerContactNumber);
            } else {
                this.view.getShareWithOwnerBtn().setEnabled(false);
            }
            if (details.tenantContactNumber() != null) {
                tenantContactNumber = details.tenantContactNumber();
                rentDetailsForMessage.append("\n*Tenant Contact No:* ").append(details.tenantContactNumber());
            }
            rentDetails.append("<h2>Party Details :</h2> <table><tr><th>Party Type</th><th>Name</th><th>Phone Number</th></tr><tr><td>Owner</td><td>").append(details.ownerName()).append("</td>").append("<td>").append("<a href='https://wa.me/").append(ownerContactNumber).append("'>").append(ownerContactNumber).append("</a>").append("</td>").append("</tr>").append("<tr>").append("<td>Tenant</td>").append("<td>").append(details.tenantName()).append("</td>").append("<td>").append("<a href='https://wa.me/").append(tenantContactNumber).append("'>").append(tenantContactNumber).append("</a>").append("</td>").append("</tr>").append("</table>");
            if (details.rentedByContactId() != 0) {
                String rentedByContactNumber = "";
                if (details.rentedByContactNumber() != null) {
                    rentedByContactNumber = details.rentedByContactNumber();
                }
                rentDetails.append("<h2>Rented By : </h2> <table><tr><th>Name</th><th>Phone Number</th></tr><tr><td>").append(details.rentedByName()).append("</td>").append("<td>").append("<a href='https://wa.me/").append(rentedByContactNumber).append("'>").append(rentedByContactNumber).append("</a>").append("</td>").append("</tr>").append("</table>");
            }
            rentDetailsForMessage.append("\n\n*Contract Details :* ");
            rentDetailsForMessage.append("\n*Start Date:* ").append(details.startDate());
            rentDetailsForMessage.append("\n*Deposit:* ").append(AppUtility.getFormattedCurrency(String.valueOf(details.deposit())));
            rentDetailsForMessage.append("\n*Rent:* ").append(AppUtility.getFormattedCurrency(String.valueOf(details.rent())));
            rentDetailsForMessage.append("\n*Tenure:* ").append(details.tenureIntMonths()).append(" Months");
            rentDetailsForMessage.append("\n*End Date:* ").append(details.endDate());
            rentDetails.append("<h2>Contract Details :</h2>\n    <table>\n        <tr>\n            <th>Start Date</th>\n            <th>Deposit</th>\n            <th>Rent</th>\n            <th>Tenure</th>\n            <th>End Date</th>\n        </tr>\n\n");
            rentDetails.append("<tr> <td>").append(details.startDate()).append("</td>").append(" <td style='text-align:right'>").append(AppUtility.getFormattedCurrency(String.valueOf(details.deposit()))).append("</td>").append(" <td style='text-align:right'>").append(AppUtility.getFormattedCurrency(String.valueOf(details.rent()))).append("</td>").append(" <td>").append(details.tenureIntMonths()).append(" Months</td>").append(" <td>").append(details.endDate()).append("</td>").append(" </tr>");
            rentDetails.append("</table>");
            List<RentDetails> rentDetailsList = details.rentDetails();
            if (!rentDetailsList.isEmpty()) {
                rentDetailsForMessage.append("\n\n*Rent details as per agreement :* ");
                rentDetails.append("<h2>Rent details as per agreement :</h2>\n    <table>\n        <tr>\n            <th>Start Month</th>\n            <th>End Month</th>\n            <th>Rent</th>\n\n        </tr>\n\n");
                for (RentDetails rentDetails2 : rentDetailsList) {
                    rentDetailsForMessage.append("\n*Start Month:* ").append(rentDetails2.startMonth());
                    rentDetailsForMessage.append("\n*End Month:* ").append(rentDetails2.endMonth());
                    rentDetailsForMessage.append("\n*Rent:* ").append(rentDetails2.rentAmount());
                    rentDetails.append("<tr> <td>").append(rentDetails2.startMonth()).append("</td>").append(" <td>").append(rentDetails2.endMonth()).append("</td>").append(" <td style='text-align:right'>").append(AppUtility.getFormattedCurrency(String.valueOf(rentDetails2.rentAmount()))).append("</td>").append(" </tr>");
                }
                rentDetails.append("</table>");
            }
            if (details.terminationReason() != null) {
                rentDetails.append("<h2>Termination Details :</h2><table><tr><th>Reason</th><th>Date</th></tr><tr><td>").append(details.terminationReason()).append("</td>").append("<td>").append(details.terminationDate()).append("</td>").append("</tr>").append("</table>");
                depositTrackerDetails = this.propertyOnRentService.loadDepositDetails(details.propertyOnRentId(), "Owner");
                rentDetailsForMessage.append("\n\n*Deposit Refund Details :* ");
                if (!depositTrackerDetails.isEmpty()) {
                    rentDetails.append(" <h2>Deposit Refund Details :</h2>\n    <table>\n        <tr>\n            <th>Paid On</th>\n            <th> Mode</th>\n             <th>Reference</th>\n            <th>Amount</th>\n        </tr>\n");
                    for (DepositTrackerDetails paymentDetails : depositTrackerDetails) {
                        rentDetails.append("<tr> <td>").append(paymentDetails.paymentDate()).append("</td>").append(" <td>").append(ModeOfPayment.paymentCode(paymentDetails.modeOfPayment()).name()).append("</td>").append(" <td>").append(paymentDetails.paymentReference()).append("</td>").append(" <td style='text-align:right'>").append(AppUtility.getFormattedCurrency(String.valueOf(paymentDetails.amount()))).append("</td>").append(" </tr>");
                        rentDetailsForMessage.append("\n*Paid On:* " + paymentDetails.paymentDate());
                        if ("CASH".equals(ModeOfPayment.paymentCode(paymentDetails.modeOfPayment()).name())) {
                            rentDetailsForMessage.append("\n*Amount Details* : " + ModeOfPayment.paymentCode(paymentDetails.modeOfPayment()).name() + " - " + AppUtility.getFormattedCurrency(String.valueOf(paymentDetails.amount())));
                            continue;
                        }
                        rentDetailsForMessage.append("\n*Amount Details* : " + ModeOfPayment.paymentCode(paymentDetails.modeOfPayment()).name() + " - " + paymentDetails.paymentReference() + " - " + AppUtility.getFormattedCurrency(String.valueOf(paymentDetails.amount())));
                    }
                    rentDetails.append("</table>");
                }
            }
            depositTrackerDetails = this.propertyOnRentService.loadDepositDetails(details.propertyOnRentId(), "Tenant");
            rentDetailsForMessage.append("\n\n*Deposit Details :* ");
            if (!depositTrackerDetails.isEmpty()) {
                rentDetails.append(" <h2>Deposit Details :</h2>\n    <table>\n        <tr>\n            <th>Received On</th>\n            <th> Mode</th>\n             <th>Reference</th>\n            <th>Amount</th>\n            <th>Comments</th>\n        </tr>\n");
                for (DepositTrackerDetails paymentDetails : depositTrackerDetails) {
                    rentDetails.append("<tr> <td>").append(paymentDetails.paymentDate()).append("</td>").append(" <td>").append(ModeOfPayment.paymentCode(paymentDetails.modeOfPayment()).name()).append("</td>").append(" <td>").append(paymentDetails.paymentReference()).append("</td>").append(" <td style='text-align:right'>").append(AppUtility.getFormattedCurrency(String.valueOf(paymentDetails.amount()))).append("</td>").append(" <td>").append(paymentDetails.comments()).append("</td>").append(" </tr>");
                    rentDetailsForMessage.append("\n*Received On:* " + paymentDetails.paymentDate());
                    if ("CASH".equals(ModeOfPayment.paymentCode(paymentDetails.modeOfPayment()).name())) {
                        rentDetailsForMessage.append("\n*Amount Details* : " + ModeOfPayment.paymentCode(paymentDetails.modeOfPayment()).name() + " - " + AppUtility.getFormattedCurrency(String.valueOf(paymentDetails.amount())));
                        continue;
                    }
                    rentDetailsForMessage.append("\n*Amount Details* : " + ModeOfPayment.paymentCode(paymentDetails.modeOfPayment()).name() + " - " + paymentDetails.paymentReference() + " - " + AppUtility.getFormattedCurrency(String.valueOf(paymentDetails.amount())));
                }
                rentDetails.append("</table>");
            }
            List<PaymentTrackerDetails> list = this.propertyOnRentService.loadPaymentDetails(details.propertyOnRentId());
            rentDetailsForMessage.append("\n\n*Rent Details :* ");
            if (!list.isEmpty()) {
                rentDetails.append(" <h2>Rent Details :</h2>\n    <table>\n        <tr>\n            <th>Received On</th>\n            <th>Month-Year</th>\n            <th> Mode</th>\n             <th>Reference</th>\n            <th>Amount</th>\n            <th>Comments</th>\n        </tr>\n");
                for (PaymentTrackerDetails paymentDetails : list) {
                    rentDetails.append("<tr> <td>").append(paymentDetails.paymentDate()).append("</td>").append(" <td>").append(paymentDetails.monthYear()).append("</td>").append(" <td>").append(ModeOfPayment.paymentCode(paymentDetails.modeOfPayment()).name()).append("</td>").append(" <td>").append(paymentDetails.paymentReference()).append("</td>").append(" <td style='text-align:right'>").append(AppUtility.getFormattedCurrency(String.valueOf(paymentDetails.amount()))).append("</td>").append(" <td>").append(paymentDetails.comments()).append("</td>").append(" </tr>");
                    rentDetailsForMessage.append("\n\n*Month-Year:* " + paymentDetails.monthYear());
                    rentDetailsForMessage.append("\n*Received On:* " + paymentDetails.paymentDate());
                    if ("CASH".equals(ModeOfPayment.paymentCode(paymentDetails.modeOfPayment()).name())) {
                        rentDetailsForMessage.append("\n*Amount Details* : " + ModeOfPayment.paymentCode(paymentDetails.modeOfPayment()).name() + " - " + AppUtility.getFormattedCurrency(String.valueOf(paymentDetails.amount())));
                        continue;
                    }
                    rentDetailsForMessage.append("\n*Amount Details* : " + ModeOfPayment.paymentCode(paymentDetails.modeOfPayment()).name() + " - " + paymentDetails.paymentReference() + " - " + AppUtility.getFormattedCurrency(String.valueOf(paymentDetails.amount())));
                }
                rentDetails.append("</table>");
            }
            rentDetails.append("</body> </html>");
            rentDetailsForMessage.append(UserCache.getUserSignature());
            this.setMessage(rentDetailsForMessage.toString());
            this.view.getPropDetailsTextArea().setText(rentDetails.toString());
            this.view.getPropDetailsTextArea().setCaretPosition(0);
        }
        catch (Exception ex) {
            new ErrorDialog(ex, "Show Property on rent details");
        }
    }

    private void showPropertySoldDetails(Integer statusId) {
        try {
            PropertySoldDetails details = this.service.getPropertySellDetails(statusId);
            int row = this.view.getTable().getSelectedRow();
            String transactionDate = (String)this.view.getTable().getValueAt(row, 1);
            this.view.getManageDocumentBtn().setVisible(true);
            StringBuilder tranDetails = new StringBuilder();
            tranDetails.append("   <html>\n   <head>\n       <meta charset=\"UTF-8\">\n       <title>Contract Details</title>\n       <style>\n            body {\n                     font-family: Arial, sans-serif;\n                     margin: 5px;\n                 }\n                 h1, h2 {\n                     color: #333;\n                 }\n                 table {\n                   width: 100%;\n                   max-width: 600px; /* Adjust as needed for your layout */\n                   margin: 0 auto;\n                   border-collapse: collapse;\n                   border-spacing: 0;\n                   overflow: auto;\n               }\n               th, td {\n                   padding: 10px;\n                   border: 1px solid #5B7687;\n                   word-wrap: break-word;\n               }\n               th {\n                   background-color: #115676;\n                   color: #fff;\n               }\n       </style>\n   </head>\n   <body>\n");
            tranDetails.append("<h2>Property transaction details as on:").append(transactionDate.split(" ")[0]).append(" </h2>");
            tranDetails.append("<h2>Address:</h2> <a href='https://www.google.com/maps/search/?api=1&query=").append(AppUtility.getEncodedText(this.view.getPropertyAddress())).append("'>").append(this.view.getPropertyAddress()).append("</a>");
            tranDetails.append("<h2> Transaction details</h2>");
            tranDetails.append("<h2>Party Details :</h2> <table><tr><th>Transaction Date</th><th>Amount</th></tr><tr><td>").append(details.contractDate()).append("</td>").append("<td style='text-align:right'>").append(AppUtility.getFormattedCurrency(String.valueOf(details.amount()))).append("</td>").append("</tr>").append("</table>");
            String buyerContactNumber = "";
            String sellerContactNumber = "";
            if (details.buyerContact() != null) {
                buyerContactNumber = details.buyerContact();
            }
            if (details.sellerContact() != null) {
                sellerContactNumber = details.sellerContact();
            }
            tranDetails.append("<h2>Party Details :</h2> <table><tr><th>Party Type</th><th>Name</th><th>Phone Number</th></tr><tr><td>Buyer</td><td>").append(details.buyerName()).append("</td>").append("<a href='https://wa.me/").append(buyerContactNumber).append("'>").append(buyerContactNumber).append("</a>").append("</td>").append("</tr>").append("<tr>").append("<td>Seller</td>").append("<td>").append(details.sellerName()).append("</td>").append("<td>").append("<a href='https://wa.me/").append(sellerContactNumber).append("'>").append(sellerContactNumber).append("</a>").append("</tr>").append("</table>");
            if (details.sellBy() == 1) {
                String sellByContactNumber = "";
                if (details.sellByContact() != null) {
                    sellByContactNumber = details.sellByContact();
                }
                tranDetails.append("<h2>Sold by details : </h2> <table><tr><th>Name</th><th>Phone Number</th></tr><tr><td>").append(details.sellByName()).append("</td>").append("<td>").append("<a href='https://wa.me/").append(sellByContactNumber).append("'>").append(sellByContactNumber).append("</a>").append("</td>").append("</tr>").append("</table>");
            }
            this.view.getPropDetailsTextArea().setText(tranDetails.toString());
        }
        catch (Exception ex) {
            new ErrorDialog(ex, "Show property sell transaction details");
        }
    }

    private void loadDetailsOnRowSelection() {
        String status = (String)this.view.getTable().getValueAt(this.view.getTable().getSelectedRow(), 2);
        Integer statusId = (Integer)this.view.getTable().getValueAt(this.view.getTable().getSelectedRow(), 3);
        this.view.getPropDetailsTextArea().setText("");
        this.view.getShareWithOwnerBtn().setEnabled(false);
        this.view.getManageDocumentBtn().setVisible(false);
        switch (status) {
            case "FOR SELL": {
                this.view.getPropDetailsTextArea().setText("Property was available for sell");
                break;
            }
            case "FOR RENT": {
                this.view.getPropDetailsTextArea().setText("Property was available for rent");
                break;
            }
            case "NOT FOR RENT OR SELL": {
                this.view.getPropDetailsTextArea().setText("Property was not available for rent or sell");
                break;
            }
            case "FOR RENT AND SELL": {
                this.view.getPropDetailsTextArea().setText("Property was  available for rent and sell");
                break;
            }
            case "ON RENT": {
                this.showPropertyOnRentDetails(statusId);
                break;
            }
            case "SOLD": {
                this.showPropertySoldDetails(statusId);
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.view.getSelectionModel() && this.view.getTable().getSelectedRow() >= 0) {
            this.loadDetailsOnRowSelection();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj == this.view.getManageDocumentBtn()) {
            int row = this.view.getTable().getSelectedRow();
            String selectedDate = (String)this.view.getTable().getValueAt(row, 1);
            int selectedStatusId = (Integer)this.view.getTable().getValueAt(row, 3);
            ManageDocuments manageDocuments = new ManageDocuments("propertyAudit", selectedStatusId);
            manageDocuments.getDocumentDio().setTitle("Manage documents as on - " + selectedDate);
            manageDocuments.getDocumentDio().setVisible(true);
        }
        if (obj == this.view.getShareWithOwnerBtn()) {
            String contactNo = this.getOwnerMobileNo();
            new PreviewAndShareView(this.getMessage(), contactNo);
        }
        if (obj == this.view.getZoomInBtn()) {
            AppUtility.tableZoomInZoomOut(true, this.view.getTable());
        }
        if (obj == this.view.getZoomOutBtn()) {
            AppUtility.tableZoomInZoomOut(false, this.view.getTable());
        }
    }
}

