/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.controller.property;

import com.arun.bhardwaj.cache.PropertyGroupCache;
import com.arun.bhardwaj.exceptions.BusinessException;
import com.arun.bhardwaj.exceptions.ServiceException;
import com.arun.bhardwaj.service.property.PropertyCategoryService;
import com.arun.bhardwaj.service.property.PropertyCategoryServiceImpl;
import com.arun.bhardwaj.view.common.ErrorDialog;
import com.arun.bhardwaj.view.property.PropertyCategory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JOptionPane;

public class PropertyCategoryController
implements ActionListener,
KeyListener {
    private final PropertyCategory view;
    private final PropertyCategoryService service;
    private static final String GROUP_NAME_MANDATORY = "Group name is mandatory";

    public PropertyCategoryController(PropertyCategory view) {
        this.view = view;
        this.service = new PropertyCategoryServiceImpl();
        this.view.getGroupNameField().addKeyListener(this);
        this.addActionEvent();
        this.addToolTips();
    }

    private void addActionEvent() {
        this.view.getCloseBtn().addActionListener(this);
        this.view.getSaveBtn().addActionListener(this);
        this.view.getUpdateBtn().addActionListener(this);
    }

    private void addToolTips() {
        this.view.getSaveBtn().setToolTipText("Save");
        this.view.getUpdateBtn().setToolTipText("Update");
        this.view.getCloseBtn().setToolTipText("Close");
    }

    private void saveGroupName() {
        String groupName = this.view.getGroupNameField().getText().trim();
        if (groupName.isBlank()) {
            this.view.getValidationError().setVisible(true);
            this.view.getValidationError().setToolTipText(GROUP_NAME_MANDATORY);
        } else {
            try {
                this.service.saveCategory(groupName);
                PropertyGroupCache.loadPropertyGroup();
                JOptionPane.showMessageDialog(this.view.getDio(), "Successfully saved !", "Success", 1);
                this.view.getDio().setVisible(false);
                this.view.getDio().dispose();
            }
            catch (ServiceException ex) {
                new ErrorDialog(ex, "Create new property group");
            }
            catch (BusinessException e) {
                this.view.getValidationError().setVisible(true);
                this.view.getValidationError().setToolTipText(e.getMessage());
            }
        }
    }

    private void updateGroupName() {
        String groupName = this.view.getGroupNameField().getText().trim();
        if (groupName.isBlank()) {
            this.view.getValidationError().setVisible(true);
            this.view.getValidationError().setToolTipText(GROUP_NAME_MANDATORY);
        } else {
            try {
                this.service.updateCategory(groupName, this.view.getPropertyGroupId());
                PropertyGroupCache.loadPropertyGroup();
                JOptionPane.showMessageDialog(this.view.getDio(), "Successfully updated !", "Success", 1);
                this.view.getDio().setVisible(false);
                this.view.getDio().dispose();
            }
            catch (ServiceException ex) {
                new ErrorDialog(ex, "Updating existing property group");
            }
            catch (BusinessException e) {
                this.view.getValidationError().setVisible(true);
                this.view.getValidationError().setToolTipText(e.getMessage());
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj == this.view.getCloseBtn()) {
            this.view.getDio().setVisible(false);
            this.view.getDio().dispose();
        }
        if (obj == this.view.getSaveBtn()) {
            this.saveGroupName();
        }
        if (obj == this.view.getUpdateBtn()) {
            this.updateGroupName();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        Object obj = e.getSource();
        if (obj == this.view.getGroupNameField() && e.getKeyCode() == 10) {
            if ("New Group".equals(this.view.getDio().getTitle())) {
                this.saveGroupName();
            } else {
                this.updateGroupName();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getSource() == this.view.getGroupNameField()) {
            if (this.view.getGroupNameField().getText().isEmpty()) {
                this.view.getValidationError().setVisible(true);
                this.view.getValidationError().setToolTipText(GROUP_NAME_MANDATORY);
            } else {
                this.view.getValidationError().setVisible(false);
            }
        }
    }
}

