/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.controller.property;

import com.arun.bhardwaj.cache.PropertyGroupCache;
import com.arun.bhardwaj.model.property.Address;
import com.arun.bhardwaj.model.property.FurnitureStatus;
import com.arun.bhardwaj.model.property.PropertyDetails;
import com.arun.bhardwaj.model.property.PropertyFilterCriteria;
import com.arun.bhardwaj.model.property.PropertyForRentDetails;
import com.arun.bhardwaj.model.property.PropertyOfferedBy;
import com.arun.bhardwaj.model.property.PropertyOnRentDetails;
import com.arun.bhardwaj.model.property.PropertyRecord;
import com.arun.bhardwaj.model.property.PropertySearchCriteria;
import com.arun.bhardwaj.model.property.PropertyStatistics;
import com.arun.bhardwaj.model.property.PropertyStatus;
import com.arun.bhardwaj.model.property.RentDetails;
import com.arun.bhardwaj.service.property.PropertyCategoryService;
import com.arun.bhardwaj.service.property.PropertyCategoryServiceImpl;
import com.arun.bhardwaj.service.property.PropertyRecordService;
import com.arun.bhardwaj.service.property.PropertyRecordServiceImpl;
import com.arun.bhardwaj.service.property.PropertyService;
import com.arun.bhardwaj.service.property.PropertyServiceImpl;
import com.arun.bhardwaj.utility.AppUtility;
import com.arun.bhardwaj.utility.NumberToWordsConverter;
import com.arun.bhardwaj.view.LoginView;
import com.arun.bhardwaj.view.common.ContactDetailsView;
import com.arun.bhardwaj.view.common.ContactDialogView;
import com.arun.bhardwaj.view.common.DisplayPieChart;
import com.arun.bhardwaj.view.common.ErrorDialog;
import com.arun.bhardwaj.view.common.ManageDocuments;
import com.arun.bhardwaj.view.property.HomeLoanCalculator;
import com.arun.bhardwaj.view.property.PropertyAudit;
import com.arun.bhardwaj.view.property.PropertyCategory;
import com.arun.bhardwaj.view.property.PropertyForSell;
import com.arun.bhardwaj.view.property.PropertyOnRent;
import com.arun.bhardwaj.view.property.PropertyRecordView;
import com.arun.bhardwaj.view.property.PropertyView;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jfree.data.general.DefaultPieDataset;

public class PropertyController
implements ActionListener,
ListSelectionListener,
FocusListener,
KeyListener {
    private final PropertyView view;
    private final PropertyService service;
    private final PropertyCategory propertyCategory;
    private final PropertyRecordView propertyRecord;
    private final PropertyOnRent managePropertyView;
    private final PropertyForSell propertyForSellView;
    private final PropertyRecordService propertyRecordService;
    private final PropertyCategoryService propertyCategoryService;
    private int agenetContactId;
    private int ownerContactId;
    private int tenantContactId;
    private final DefaultPieDataset dataset = new DefaultPieDataset();
    private int selectedRowIndex = 0;

    public int getAgenetContactId() {
        return this.agenetContactId;
    }

    public void setAgenetContactId(int agenetContactId) {
        this.agenetContactId = agenetContactId;
    }

    public int getOwnerContactId() {
        return this.ownerContactId;
    }

    public void setOwnerContactId(int ownerContactId) {
        this.ownerContactId = ownerContactId;
    }

    public int getTenantContactId() {
        return this.tenantContactId;
    }

    public void setTenantContactId(int tenantContactId) {
        this.tenantContactId = tenantContactId;
    }

    public int getSelectedRowIndex() {
        return this.selectedRowIndex;
    }

    public void setSelectedRowIndex(int selectedRowIndex) {
        this.selectedRowIndex = selectedRowIndex;
    }

    public PropertyController(PropertyView view) {
        this.view = view;
        this.propertyCategory = new PropertyCategory();
        this.propertyRecord = new PropertyRecordView();
        this.managePropertyView = new PropertyOnRent();
        this.propertyForSellView = new PropertyForSell();
        this.service = new PropertyServiceImpl();
        this.propertyRecordService = new PropertyRecordServiceImpl();
        this.propertyCategoryService = new PropertyCategoryServiceImpl();
        this.addActionEvent();
        view.getAvailableWithinTextField().addKeyListener(this);
        this.addToolTips();
        this.addFocusEvent();
        AppUtility.tableZoomInZoomOut(true, view.getTable());
        AppUtility.tableZoomInZoomOut(true, view.getTable());
        this.view.getSelectionModel().addListSelectionListener(this);
    }

    public void loadInitialData() {
        this.loadGroups();
        this.loadRecords(null);
        this.loadDefaultFilters();
    }

    private void loadDefaultFilters() {
        this.view.getFurnishingStatusFilterCb().removeAllItems();
        this.view.getFurnishingStatusFilterCb().addItem("All Records");
        for (FurnitureStatus furnitureStatus : FurnitureStatus.values()) {
            this.view.getFurnishingStatusFilterCb().addItem(furnitureStatus.toString());
        }
        this.view.getOfferedTypeFilterCb().removeAllItems();
        this.view.getOfferedTypeFilterCb().addItem("All Records");
        for (Enum enum_ : PropertyOfferedBy.values()) {
            this.view.getOfferedTypeFilterCb().addItem(enum_.toString());
        }
    }

    private void showRenewalStatus() {
        try {
            String status = this.service.generateRenewalStatus();
            this.view.getPendingForRenewalLabel().setText(status);
            if (!status.isEmpty()) {
                this.view.getPendingForRenewal().setVisible(true);
            } else {
                this.view.getPendingForRenewal().setVisible(false);
            }
        }
        catch (Exception e) {
            new ErrorDialog(e, "Show property renewal status");
        }
    }

    private void loadChartDataSet(List<PropertyStatistics> data) {
        this.dataset.clear();
        for (PropertyStatistics propertyStatistics : data) {
            this.dataset.setValue((Comparable)((Object)propertyStatistics.statusName()), propertyStatistics.statusCount());
        }
    }

    private void showPropertyStatistics() {
        try {
            List<PropertyStatistics> statistics = this.service.fetchPropertyStatistics();
            this.loadChartDataSet(statistics);
            StringBuilder statisticsDts = new StringBuilder();
            for (PropertyStatistics propertyStatistics : statistics) {
                statisticsDts.append(propertyStatistics.statusName());
                statisticsDts.append(": ");
                statisticsDts.append(propertyStatistics.statusCount());
                statisticsDts.append("   ");
            }
            this.view.getStatisticsLabel().setText(statisticsDts.toString());
        }
        catch (Exception e) {
            new ErrorDialog(e, "Show property statistics");
        }
    }

    private void addToolTips() {
        this.view.getNewBtn().setToolTipText("Add property");
        this.view.getNewGBtn().setToolTipText("Add group");
        this.view.getUpdRBtn().setToolTipText("Update property");
        this.view.getUpdGBtn().setToolTipText("Update group");
        this.view.getDelBtn().setToolTipText("Delete property");
        this.view.getDelGBtn().setToolTipText("Delete group");
        this.view.getPropertyOnRentBtn().setToolTipText("Manage property:rent");
        this.view.getSellOfAssetBtn().setToolTipText("Manage property:sell");
        this.view.getPropertyHistoryBtn().setToolTipText("Property history");
        this.view.getRefBtn().setToolTipText("Refresh");
        this.view.getShowPieChartBtn().setToolTipText("Show properties count by status");
        this.view.getManageDocumentBtn().setToolTipText("Manage documents");
        this.view.getRentCB().setToolTipText("Populate properties for rent");
        this.view.getSellCB().setToolTipText("Populate properties for sell");
        this.view.getPendingForRenewal().setToolTipText("Populate properties which are pending for renewal within 30 days");
        this.view.getOnRentCB().setToolTipText("Populate property on rent");
        this.view.getGroupList().setToolTipText("Select property group to filter records");
        this.view.getSearchCb().setToolTipText("Select option for search");
        this.view.getAddressTf().setToolTipText("Address");
        this.view.getLocationTf().setToolTipText("Location");
        this.view.getCityTf().setToolTipText("City");
        this.view.getPinTf().setToolTipText("Pin");
        this.view.getDepositFromTf().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateTooltip();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateTooltip();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateTooltip();
            }

            private void updateTooltip() {
                String text = PropertyController.this.view.getDepositFromTf().getText();
                if (AppUtility.isValidNumber(text)) {
                    PropertyController.this.view.getDepositFromTf().setToolTipText("Deposit from -" + NumberToWordsConverter.convertToIndianWords(Long.parseLong(text)));
                } else {
                    PropertyController.this.view.getDepositFromTf().setToolTipText("Deposit from");
                }
            }
        });
        this.view.getDepositTo().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateTooltip();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateTooltip();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateTooltip();
            }

            private void updateTooltip() {
                String text = PropertyController.this.view.getDepositTo().getText();
                if (AppUtility.isValidNumber(text)) {
                    PropertyController.this.view.getDepositTo().setToolTipText("Deposit to -" + NumberToWordsConverter.convertToIndianWords(Long.parseLong(text)));
                } else {
                    PropertyController.this.view.getDepositTo().setToolTipText("Deposit to");
                }
            }
        });
        this.view.getRentFromTf().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateTooltip();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateTooltip();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateTooltip();
            }

            private void updateTooltip() {
                String text = PropertyController.this.view.getRentFromTf().getText();
                if (AppUtility.isValidNumber(text)) {
                    PropertyController.this.view.getRentFromTf().setToolTipText("Rent from -" + NumberToWordsConverter.convertToIndianWords(Long.parseLong(text)));
                } else {
                    PropertyController.this.view.getRentFromTf().setToolTipText("Rent from");
                }
            }
        });
        this.view.getRentTo().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateTooltip();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateTooltip();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateTooltip();
            }

            private void updateTooltip() {
                String text = PropertyController.this.view.getRentTo().getText();
                if (AppUtility.isValidNumber(text)) {
                    PropertyController.this.view.getRentTo().setToolTipText("Rent to -" + NumberToWordsConverter.convertToIndianWords(Long.parseLong(text)));
                } else {
                    PropertyController.this.view.getRentTo().setToolTipText("Rent to");
                }
            }
        });
        this.view.getPriceFrom().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateTooltip();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateTooltip();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateTooltip();
            }

            private void updateTooltip() {
                String text = PropertyController.this.view.getPriceFrom().getText();
                if (AppUtility.isValidNumber(text)) {
                    PropertyController.this.view.getPriceFrom().setToolTipText("Price from -" + NumberToWordsConverter.convertToIndianWords(Long.parseLong(text)));
                } else {
                    PropertyController.this.view.getPriceFrom().setToolTipText("Price from");
                }
            }
        });
        this.view.getPriceTo().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateTooltip();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateTooltip();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateTooltip();
            }

            private void updateTooltip() {
                String text = PropertyController.this.view.getPriceTo().getText();
                if (AppUtility.isValidNumber(text)) {
                    PropertyController.this.view.getPriceTo().setToolTipText("Price to -" + NumberToWordsConverter.convertToIndianWords(Long.parseLong(text)));
                } else {
                    PropertyController.this.view.getPriceTo().setToolTipText("Price to");
                }
            }
        });
        this.view.getCommentsTf().setToolTipText("Comments");
        this.view.getOfferedTypeFilterCb().setToolTipText("Offered Type");
        this.view.getFurnishingStatusFilterCb().setToolTipText("Furnishing Status");
        this.view.getZoomInBtn().setToolTipText("Zoom in Ctr +");
        this.view.getZoomOutBtn().setToolTipText("Zoom out Ctr -");
        this.view.getHomeLoanCalculator().setToolTipText("Home loan calculator");
        this.view.getCalculator().setToolTipText("Calculator");
    }

    private void addActionEvent() {
        this.view.getNewBtn().addActionListener(this);
        this.view.getNewGBtn().addActionListener(this);
        this.view.getUpdRBtn().addActionListener(this);
        this.view.getUpdGBtn().addActionListener(this);
        this.view.getDelBtn().addActionListener(this);
        this.view.getDelGBtn().addActionListener(this);
        this.view.getPropertyOnRentBtn().addActionListener(this);
        this.view.getSearchCb().addActionListener(this);
        this.view.getRentCB().addActionListener(this);
        this.view.getSellCB().addActionListener(this);
        this.view.getPendingForRenewal().addActionListener(this);
        this.view.getNotForRentAndSell().addActionListener(this);
        this.view.getOnRentCB().addActionListener(this);
        this.view.getGroupList().addActionListener(this);
        this.view.getSellOfAssetBtn().addActionListener(this);
        this.view.getPropertyHistoryBtn().addActionListener(this);
        this.view.getSearchBtn().addActionListener(this);
        this.view.getRefBtn().addActionListener(this);
        this.view.getManageDocumentBtn().addActionListener(this);
        this.view.getOfferedTypeFilterCb().addActionListener(this);
        this.view.getFurnishingStatusFilterCb().addActionListener(this);
        this.view.getChooseContactSearchBtn().addActionListener(this);
        this.view.getZoomInBtn().addActionListener(this);
        this.view.getZoomOutBtn().addActionListener(this);
        this.view.getShowPieChartBtn().addActionListener(this);
        this.view.getNewPopupMenu().addActionListener(this);
        this.view.getUpdatePopupMenu().addActionListener(this);
        this.view.getDeletePopupMenu().addActionListener(this);
        this.view.getManageRentPopupMenu().addActionListener(this);
        this.view.getManageSellPopupMenu().addActionListener(this);
        this.view.getRefPopupMenu().addActionListener(this);
        this.view.getHistoryPopupMenu().addActionListener(this);
        this.view.getAgentDetailsPopupMenu().addActionListener(this);
        this.view.getOwnerDetailsPopupMenu().addActionListener(this);
        this.view.getTenantDetailsPopupMenu().addActionListener(this);
        this.view.getShowChartPopupMenu().addActionListener(this);
        this.view.getManageDocumentPopupMenu().addActionListener(this);
        this.view.getCalculator().addActionListener(this);
        this.view.getHomeLoanCalculator().addActionListener(this);
        this.view.getNextButton().addActionListener(this);
        this.view.getPrevButton().addActionListener(this);
        this.view.getAlreadyAvailableCheckBox().addActionListener(this);
        this.view.getAvailableWithinCheckBox().addActionListener(this);
    }

    private void addFocusEvent() {
        this.view.getAddressTf().addFocusListener(this);
        this.view.getLocationTf().addFocusListener(this);
        this.view.getCityTf().addFocusListener(this);
        this.view.getPinTf().addFocusListener(this);
        this.view.getDepositFromTf().addFocusListener(this);
        this.view.getDepositTo().addFocusListener(this);
        this.view.getRentFromTf().addFocusListener(this);
        this.view.getRentTo().addFocusListener(this);
        this.view.getPriceFrom().addFocusListener(this);
        this.view.getPriceTo().addFocusListener(this);
        this.view.getCommentsTf().addFocusListener(this);
        this.view.getAdditionalInfoTf().addFocusListener(this);
    }

    private void showOrHideLeaseDurationColumn() {
        if (this.view.getOnRentCB().isSelected() && !this.view.getRentCB().isSelected() && !this.view.getSellCB().isSelected()) {
            this.view.getTable().getColumnModel().getColumn(12).setMaxWidth(Integer.MAX_VALUE);
            this.view.getTable().getColumnModel().getColumn(12).setMinWidth(10);
            this.view.getTable().getColumnModel().getColumn(12).setPreferredWidth(200);
        } else {
            this.view.getTable().getColumnModel().getColumn(12).setPreferredWidth(0);
            this.view.getTable().getColumnModel().getColumn(12).setWidth(0);
            this.view.getTable().getColumnModel().getColumn(12).setMinWidth(0);
            this.view.getTable().getColumnModel().getColumn(12).setMaxWidth(0);
        }
        this.view.getTable().getTableHeader().revalidate();
        this.view.getTable().getTableHeader().repaint();
    }

    private void loadRecords(PropertySearchCriteria searchCriteria) {
        try {
            AppUtility.validateUser();
            this.showOrHideLeaseDurationColumn();
            String selectedGroupName = (String)this.view.getGroupList().getSelectedItem();
            String OfferedType = (String)this.view.getOfferedTypeFilterCb().getSelectedItem();
            String furnishingStatus = (String)this.view.getFurnishingStatusFilterCb().getSelectedItem();
            PropertyFilterCriteria filterCriteria = new PropertyFilterCriteria(this.view.getRentCB().isSelected(), this.view.getSellCB().isSelected(), this.view.getOnRentCB().isSelected(), OfferedType, furnishingStatus, this.view.getPendingForRenewal().isSelected(), this.view.getNotForRentAndSell().isSelected(), this.view.getAlreadyAvailableCheckBox().isSelected(), this.view.getAvailableWithinCheckBox().isSelected(), Integer.parseInt(this.view.getAvailableWithinTextField().getText().trim().length() == 0 ? "0" : this.view.getAvailableWithinTextField().getText().trim()));
            if ("All Records".equals(selectedGroupName)) {
                this.view.getUpdRBtn().setEnabled(false);
                this.view.getUpdGBtn().setEnabled(false);
                this.view.getDelBtn().setEnabled(false);
                this.view.getDelGBtn().setEnabled(false);
                this.view.getPropertyHistoryBtn().setEnabled(false);
                this.view.getSellOfAssetBtn().setEnabled(false);
                this.view.getPropertyOnRentBtn().setEnabled(false);
                this.view.getManageRentPopupMenu().setVisible(false);
                this.view.getManageSellPopupMenu().setVisible(false);
            } else {
                this.view.getUpdGBtn().setEnabled(true);
                this.view.getDelGBtn().setEnabled(true);
            }
            List<PropertyRecord> records = this.service.loadRecords(selectedGroupName, searchCriteria, filterCriteria, this.view.getCurrentPage(), this.view.getPAGE_SIZE());
            if (!records.isEmpty()) {
                this.view.setTotalRecords(records.get(0).totalRecords());
            }
            this.view.getDefaultTableModel().setRowCount(0);
            IntStream.range(0, records.size()).forEach(index -> {
                this.view.getDefaultTableModel().addRow(new Object[]{"", "", "", "", "", "", "", "", "", "", "", ""});
                StringBuilder address = new StringBuilder();
                address.append(((PropertyRecord)records.get(index)).address());
                address.append(" ");
                address.append(((PropertyRecord)records.get(index)).location());
                address.append(" ");
                address.append(((PropertyRecord)records.get(index)).city());
                address.append(" ");
                address.append(((PropertyRecord)records.get(index)).pin());
                this.view.getTable().setValueAt(String.valueOf(index + 1), index, 0);
                this.view.getTable().setValueAt(((PropertyRecord)records.get(index)).date(), index, 1);
                this.view.getTable().setValueAt(PropertyGroupCache.getGroupName(((PropertyRecord)records.get(index)).fkGroupId()), index, 2);
                this.view.getTable().setValueAt(address, index, 3);
                this.view.getTable().setValueAt(PropertyStatus.propertyCode(((PropertyRecord)records.get(index)).propertyStatus()).name().replaceAll("_", " "), index, 4);
                this.view.getTable().setValueAt(((PropertyRecord)records.get(index)).areaInSqFt(), index, 5);
                this.view.getTable().setValueAt(AppUtility.getFormattedCurrency(String.valueOf(((PropertyRecord)records.get(index)).price())), index, 6);
                this.view.getTable().setValueAt(AppUtility.getFormattedCurrency(String.valueOf(((PropertyRecord)records.get(index)).deposit())), index, 7);
                this.view.getTable().setValueAt(AppUtility.getFormattedCurrency(String.valueOf(((PropertyRecord)records.get(index)).rent())), index, 8);
                this.view.getTable().setValueAt(((PropertyRecord)records.get(index)).comments(), index, 9);
                this.view.getTable().setValueAt(((PropertyRecord)records.get(index)).leaseId(), index, 10);
                this.view.getTable().setValueAt(((PropertyRecord)records.get(index)).contractExpiryFlag(), index, 11);
                this.view.getTable().setValueAt(((PropertyRecord)records.get(index)).leaseDuration() == null ? "-" : ((PropertyRecord)records.get(index)).leaseDuration(), index, 12);
                this.view.getTable().setAutoCreateRowSorter(true);
            });
            this.showPropertyStatistics();
            this.showRenewalStatus();
            AppUtility.tableZoomInZoomOut(true, this.view.getTable());
            AppUtility.tableZoomInZoomOut(false, this.view.getTable());
            if (this.getSelectedRowIndex() != -1 && this.getSelectedRowIndex() < this.view.getTable().getRowCount()) {
                this.view.getTable().setRowSelectionInterval(this.getSelectedRowIndex(), this.getSelectedRowIndex());
                this.loadDetailsOnRowSelection();
            } else if (this.view.getTable().getRowCount() > 0) {
                this.view.getTable().setRowSelectionInterval(0, 0);
                this.loadDetailsOnRowSelection();
            }
            int startRecord = (this.view.getCurrentPage() - 1) * this.view.getPAGE_SIZE() + 1;
            int endRecord = Math.min(this.view.getCurrentPage() * this.view.getPAGE_SIZE(), this.view.getTotalRecords());
            String resultString = "Result " + startRecord + " - " + endRecord + " of " + this.view.getTotalRecords();
            this.view.getPageLabel().setText(resultString);
            this.view.getPrevButton().setEnabled(this.view.getCurrentPage() > 1);
            this.view.getNextButton().setEnabled(this.view.getCurrentPage() * this.view.getPAGE_SIZE() < this.view.getTotalRecords());
        }
        catch (Exception e) {
            new ErrorDialog(e, "Load properties");
        }
    }

    public void loadGroups() {
        JComboBox projectTypeList = this.view.getGroupList();
        projectTypeList.removeAllItems();
        projectTypeList.addItem("All Records");
        Map<Integer, String> leaseGroupDts = PropertyGroupCache.getGroupIdToNameMap();
        leaseGroupDts.values().forEach(projectTypeList::addItem);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String selectedGroupName;
        StringBuilder address;
        Integer propertyId;
        Object obj = e.getSource();
        if (obj == this.view.getAlreadyAvailableCheckBox()) {
            if (this.view.getAlreadyAvailableCheckBox().isSelected()) {
                this.view.getAvailableWithinCheckBox().setSelected(false);
            }
            this.loadRecords(null);
        }
        if (obj == this.view.getAvailableWithinCheckBox()) {
            if (this.view.getAvailableWithinCheckBox().isSelected()) {
                this.view.getAlreadyAvailableCheckBox().setSelected(false);
            }
            this.loadRecords(null);
        }
        if (obj == this.view.getPrevButton() && this.view.getCurrentPage() > 1) {
            this.view.setCurrentPage(this.view.getCurrentPage() - 1);
            this.loadRecords(null);
        }
        if (obj == this.view.getNextButton() && this.view.getCurrentPage() * this.view.getPAGE_SIZE() < this.view.getTotalRecords()) {
            this.view.setCurrentPage(this.view.getCurrentPage() + 1);
            this.loadRecords(null);
        }
        if (obj == this.view.getNotForRentAndSell()) {
            if (this.view.getNotForRentAndSell().isSelected()) {
                this.view.getSellCB().setSelected(false);
                this.view.getRentCB().setSelected(false);
                this.view.getOnRentCB().setSelected(false);
                this.view.getPendingForRenewal().setSelected(false);
                this.view.getSellCB().setVisible(false);
                this.view.getRentCB().setVisible(false);
                this.view.getOnRentCB().setVisible(false);
                this.view.getAlreadyAvailableCheckBox().setVisible(true);
                this.view.getAvailableWithinCheckBox().setVisible(true);
                this.view.getAvailableWithinTextField().setVisible(true);
                this.view.getAlreadyAvailableCheckBox().setSelected(false);
                this.view.getAvailableWithinCheckBox().setSelected(false);
                this.view.getAvailableWithinTextField().setText("15");
            } else {
                this.view.getSellCB().setSelected(true);
                this.view.getRentCB().setSelected(true);
                this.view.getOnRentCB().setSelected(true);
                this.view.getSellCB().setVisible(true);
                this.view.getRentCB().setVisible(true);
                this.view.getOnRentCB().setVisible(true);
                this.view.getAlreadyAvailableCheckBox().setVisible(false);
                this.view.getAvailableWithinCheckBox().setVisible(false);
                this.view.getAvailableWithinTextField().setVisible(false);
            }
            this.loadRecords(null);
        }
        if (obj == this.view.getHomeLoanCalculator()) {
            String sellingPrice = (String)this.view.getTable().getValueAt(this.view.getTable().getSelectedRow(), 6);
            new HomeLoanCalculator(AppUtility.removeCurrencyAndCommas(sellingPrice)).getDio().setVisible(true);
        }
        if (obj == this.view.getCalculator()) {
            try {
                String command;
                String osName = System.getProperty("os.name").toLowerCase();
                if (osName.contains("win")) {
                    command = "calc";
                } else if (osName.contains("mac")) {
                    command = "open -a Calculator";
                } else {
                    new ErrorDialog(new RuntimeException("Unsupported operating system: \" + osName"), "calculator");
                    return;
                }
                Runtime.getRuntime().exec(command);
            }
            catch (Exception ex) {
                new ErrorDialog(ex, "open calculator");
            }
        }
        if (obj == this.view.getManageDocumentPopupMenu() || obj == this.view.getManageDocumentBtn()) {
            propertyId = (Integer)this.view.getTable().getValueAt(this.view.getTable().getSelectedRow(), 10);
            address = (StringBuilder)this.view.getTable().getValueAt(this.view.getTable().getSelectedRow(), 3);
            ManageDocuments manageDocuments = new ManageDocuments("Property", propertyId);
            manageDocuments.getDocumentDio().setTitle("Manage documents for - " + address);
            manageDocuments.getDocumentDio().setVisible(true);
        }
        if (obj == this.view.getShowPieChartBtn() || obj == this.view.getShowChartPopupMenu()) {
            new DisplayPieChart(this.dataset, "Properties count by status");
        }
        if (obj == this.view.getAgentDetailsPopupMenu()) {
            new ContactDetailsView(this.getAgenetContactId(), null);
        }
        if (obj == this.view.getOwnerDetailsPopupMenu()) {
            new ContactDetailsView(this.getOwnerContactId(), null);
        }
        if (obj == this.view.getTenantDetailsPopupMenu()) {
            new ContactDetailsView(this.getTenantContactId(), null);
        }
        if (obj == this.view.getZoomInBtn()) {
            AppUtility.tableZoomInZoomOut(true, this.view.getTable());
        }
        if (obj == this.view.getZoomOutBtn()) {
            AppUtility.tableZoomInZoomOut(false, this.view.getTable());
        }
        if (obj == this.view.getChooseContactSearchBtn()) {
            ContactDialogView contactDialogView = new ContactDialogView(this, "selectedName", "Select a contact");
            AppUtility.setDialogLocationInCenter(contactDialogView.getDio());
            contactDialogView.getDio().setVisible(true);
        }
        if (obj == this.view.getOfferedTypeFilterCb()) {
            this.loadRecords(null);
        }
        if (obj == this.view.getFurnishingStatusFilterCb()) {
            this.loadRecords(null);
        }
        if (obj == this.view.getRefBtn() || obj == this.view.getRefPopupMenu()) {
            this.loadRecords(null);
        }
        if ((obj == this.view.getPropertyHistoryBtn() || obj == this.view.getHistoryPopupMenu()) && this.view.getTable().getSelectedRow() >= 0) {
            propertyId = (Integer)this.view.getTable().getValueAt(this.view.getTable().getSelectedRow(), 10);
            address = (StringBuilder)this.view.getTable().getValueAt(this.view.getTable().getSelectedRow(), 3);
            PropertyAudit propertyAuditView = new PropertyAudit(propertyId, address.toString());
            propertyAuditView.getPropertyAuditDio().setTitle("Property Audit :" + address.toString());
            propertyAuditView.getPropertyAuditDio().setSize(900, 450);
            AppUtility.setDialogLocationInCenter(propertyAuditView.getPropertyAuditDio());
            propertyAuditView.getPropertyAuditDio().setVisible(true);
        }
        if ((obj == this.view.getSellOfAssetBtn() || obj == this.view.getManageSellPopupMenu()) && this.view.getTable().getSelectedRow() >= 0) {
            propertyId = (Integer)this.view.getTable().getValueAt(this.view.getTable().getSelectedRow(), 10);
            String strAmountInCurrency = (String)this.view.getTable().getValueAt(this.view.getTable().getSelectedRow(), 6);
            String strAmount = AppUtility.removeCurrencyAndCommas(strAmountInCurrency);
            Integer amount = Integer.parseInt(strAmount);
            this.propertyForSellView.getSelf().setSelected(true);
            this.propertyForSellView.getSellByTf().setText("");
            this.propertyForSellView.setSaleByContactId(0);
            this.propertyForSellView.setPropertyId(propertyId);
            PropertyForRentDetails details = null;
            try {
                details = this.service.fetchPropertyDetailsForRent(propertyId);
            }
            catch (Exception ex) {
                new ErrorDialog(ex, "Fetch property basic details for sell");
            }
            assert (details != null);
            if (PropertyOfferedBy.DIRECT.ordinal() == details.offeredBy()) {
                this.propertyForSellView.getSellerTf().setText(details.contactName());
                this.propertyForSellView.setSellerContactId(details.contactId());
                this.propertyForSellView.getSellerContactBtn().setEnabled(false);
                this.propertyForSellView.getSelf().setEnabled(true);
                this.propertyForSellView.getOthers().setEnabled(true);
            } else {
                this.propertyForSellView.getSelf().setEnabled(false);
                this.propertyForSellView.getOthers().setEnabled(false);
                this.propertyForSellView.getSellerTf().setText("");
                this.propertyForSellView.setSellerContactId(0);
                this.propertyForSellView.getSellerContactBtn().setEnabled(true);
            }
            this.propertyForSellView.getDateTf().setText(AppUtility.getCurrentDateInString());
            this.propertyForSellView.getAmountTf().setText(String.valueOf(amount));
            this.propertyForSellView.getBrokerageTf().setText(String.valueOf(Math.round((double)amount.intValue() * 0.01)));
            this.propertyForSellView.getDio().setVisible(true);
            this.loadRecords(null);
        }
        if (obj == this.view.getRentCB() || obj == this.view.getSellCB() || obj == this.view.getOnRentCB()) {
            if (!(this.view.getRentCB().isSelected() || this.view.getSellCB().isSelected() || this.view.getOnRentCB().isSelected())) {
                this.view.getNotForRentAndSell().setSelected(true);
            } else {
                this.view.getPendingForRenewal().setSelected(false);
                this.view.getNotForRentAndSell().setSelected(false);
            }
            this.loadRecords(null);
        }
        if (obj == this.view.getPendingForRenewal()) {
            if (this.view.getPendingForRenewal().isSelected()) {
                this.view.getSellCB().setSelected(false);
                this.view.getRentCB().setSelected(false);
                this.view.getOnRentCB().setSelected(false);
                this.view.getNotForRentAndSell().setSelected(false);
            } else {
                this.view.getSellCB().setSelected(true);
                this.view.getRentCB().setSelected(true);
                this.view.getOnRentCB().setSelected(true);
                this.view.getSellCB().setVisible(true);
                this.view.getRentCB().setVisible(true);
                this.view.getOnRentCB().setVisible(true);
                this.view.getAlreadyAvailableCheckBox().setSelected(false);
                this.view.getAlreadyAvailableCheckBox().setVisible(false);
                this.view.getAvailableWithinCheckBox().setVisible(false);
                this.view.getAvailableWithinTextField().setVisible(false);
            }
            this.loadRecords(null);
        }
        if ((obj == this.view.getPropertyOnRentBtn() || obj == this.view.getManageRentPopupMenu()) && this.view.getTable().getSelectedRow() >= 0) {
            propertyId = (Integer)this.view.getTable().getValueAt(this.view.getTable().getSelectedRow(), 10);
            String selectedPropStatus = (String)this.view.getTable().getValueAt(this.view.getTable().getSelectedRow(), 4);
            selectedPropStatus = selectedPropStatus.replaceAll(" ", "_");
            this.managePropertyView.setPropertyId(propertyId);
            PropertyForRentDetails details = null;
            try {
                details = this.service.fetchPropertyDetailsForRent(propertyId);
            }
            catch (Exception ex) {
                new ErrorDialog(ex, "Fetch property details for rent");
            }
            assert (details != null);
            if (details.offeredBy() == PropertyOfferedBy.DIRECT.ordinal()) {
                this.managePropertyView.getOwnerTf().setText(details.contactName());
                this.managePropertyView.setOwnerContactId(details.contactId());
                this.managePropertyView.getOwnerContactBtn().setEnabled(false);
                this.managePropertyView.getOwnerTf().setToolTipText("Owner");
                this.managePropertyView.getSelf().setEnabled(true);
                this.managePropertyView.getOthers().setEnabled(true);
                this.managePropertyView.getBrokerageTf().setText(String.valueOf(details.rent()));
            } else {
                this.managePropertyView.getOwnerTf().setText("");
                this.managePropertyView.setOwnerContactId(0);
                this.managePropertyView.getOwnerContactBtn().setEnabled(true);
                this.managePropertyView.getOwnerTf().setToolTipText("Choose the owner from right side button");
                this.managePropertyView.getBrokerageTf().setText(String.valueOf(details.rent() / 2));
                this.managePropertyView.getSelf().setEnabled(false);
                this.managePropertyView.getOthers().setEnabled(false);
            }
            if (selectedPropStatus.equals(PropertyStatus.FOR_RENT.name()) || selectedPropStatus.equals(PropertyStatus.FOR_RENT_AND_SELL.name())) {
                this.managePropertyView.getSaveBtn().setVisible(true);
                this.managePropertyView.getUpdateBtn().setVisible(false);
                this.managePropertyView.getRenewalBtn().setVisible(false);
                this.managePropertyView.getTerminateBtn().setVisible(false);
                this.managePropertyView.getPaymentTrackerBtn().setVisible(false);
                this.managePropertyView.getSelf().setSelected(true);
                this.managePropertyView.getRentedByTf().setText("");
                this.managePropertyView.setRentedByContactId(0);
                this.managePropertyView.getRentedByTf().setVisible(false);
                this.managePropertyView.getRentedByContactBtn().setVisible(false);
                this.managePropertyView.getRentedByContactBtn().setEnabled(true);
                this.managePropertyView.setPropOnRentId(0);
                this.managePropertyView.setTenantContactId(0);
                this.managePropertyView.getTenantTf().setText("");
                this.managePropertyView.getDepositTf().setText(String.valueOf(details.deposit()));
                this.managePropertyView.getRentTf().setText(String.valueOf(details.rent()));
                this.managePropertyView.getDateTf().setText(AppUtility.getCurrentDateInString());
                this.managePropertyView.getTenureInMonthsTf().setText("11");
                String agreementStartDate = this.managePropertyView.getDateTf().getText().trim();
                LocalDate date = AppUtility.convertStringToDate(agreementStartDate).plusMonths(11L).minusDays(1L);
                this.managePropertyView.getTenureEndDateLabel().setText(AppUtility.convertDatetoString(date));
                this.managePropertyView.getRentChangeModel().setRowCount(0);
                this.managePropertyView.getRentChangeInMonthsTf().setText("");
            }
            if (selectedPropStatus.equals(PropertyStatus.ON_RENT.name())) {
                this.managePropertyView.getSaveBtn().setVisible(false);
                this.managePropertyView.getUpdateBtn().setVisible(true);
                this.managePropertyView.getTerminateBtn().setVisible(true);
                this.managePropertyView.getPaymentTrackerBtn().setVisible(true);
                this.managePropertyView.getRentedByContactBtn().setEnabled(false);
                try {
                    PropertyOnRentDetails propertyOnRentDetails = this.service.fetchPropertyDetailsOnRent(propertyId);
                    this.managePropertyView.setPropertyId(propertyOnRentDetails.propertyId());
                    this.managePropertyView.setPropOnRentId(propertyOnRentDetails.propertyOnRentId());
                    if (propertyOnRentDetails.rentedBy() == 0) {
                        this.managePropertyView.getSelf().setSelected(true);
                        this.managePropertyView.setRentedByContactId(0);
                        this.managePropertyView.getRentedByTf().setVisible(false);
                        this.managePropertyView.getRentedByContactBtn().setVisible(false);
                    } else {
                        this.managePropertyView.getOthers().setSelected(true);
                        this.managePropertyView.setRentedByContactId(propertyOnRentDetails.rentedByContactId());
                        this.managePropertyView.getRentedByTf().setVisible(true);
                        this.managePropertyView.getRentedByContactBtn().setVisible(true);
                        this.managePropertyView.getRentedByTf().setText(propertyOnRentDetails.rentedByName());
                    }
                    this.managePropertyView.getDateTf().setText(propertyOnRentDetails.startDate());
                    this.managePropertyView.setOwnerContactId(propertyOnRentDetails.ownerContactId());
                    this.managePropertyView.getOwnerTf().setText(propertyOnRentDetails.ownerName());
                    this.managePropertyView.setTenantContactId(propertyOnRentDetails.tenantContactId());
                    this.managePropertyView.getTenantTf().setText(propertyOnRentDetails.tenantName());
                    this.managePropertyView.getDepositTf().setText(String.valueOf(propertyOnRentDetails.deposit()));
                    this.managePropertyView.getRentTf().setText(String.valueOf(propertyOnRentDetails.rent()));
                    this.managePropertyView.getBrokerageTf().setText(String.valueOf(propertyOnRentDetails.brokerage()));
                    this.managePropertyView.getTenureInMonthsTf().setText(String.valueOf(propertyOnRentDetails.tenureIntMonths()));
                    this.managePropertyView.getTenureEndDateLabel().setText(propertyOnRentDetails.endDate());
                    this.managePropertyView.setPropOnRentId(propertyOnRentDetails.propertyOnRentId());
                    LocalDate endDate = AppUtility.convertStringToDate(propertyOnRentDetails.endDate());
                    long days = ChronoUnit.DAYS.between(LocalDate.now(), endDate);
                    this.managePropertyView.getRenewalBtn().setVisible(days <= 30L);
                    List<RentDetails> rentDetailsList = propertyOnRentDetails.rentDetails();
                    if (!rentDetailsList.isEmpty()) {
                        int choose;
                        this.managePropertyView.getRentChangeModel().setRowCount(0);
                        this.managePropertyView.getRentChangeInMonthsTf().setText(rentDetailsList.get(0).rentRevisedInMonths());
                        int count = 1;
                        for (RentDetails rentDetails : rentDetailsList) {
                            this.managePropertyView.getRentChangeModel().addRow(new Object[]{count, rentDetails.startMonth(), rentDetails.endMonth(), String.valueOf(rentDetails.rentAmount()), rentDetails.rentConditionId()});
                            ++count;
                        }
                        LocalDate currentDate = LocalDate.now();
                        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MMMM-yyyy");
                        int rentForCurrentMonth = 0;
                        for (RentDetails rentDetails : rentDetailsList) {
                            YearMonth startMonth = YearMonth.parse(rentDetails.startMonth(), formatter);
                            YearMonth endMonth = YearMonth.parse(rentDetails.endMonth(), formatter);
                            LocalDate startDate = startMonth.atDay(1);
                            LocalDate endDate1 = endMonth.atEndOfMonth();
                            if (!currentDate.isEqual(startDate) && !currentDate.isAfter(startDate) || !currentDate.isEqual(endDate1) && !currentDate.isBefore(endDate1)) continue;
                            rentForCurrentMonth = rentDetails.rentAmount();
                        }
                        if (rentForCurrentMonth > 0 && rentForCurrentMonth != propertyOnRentDetails.rent() && (choose = JOptionPane.showConfirmDialog(this.view, "Warning : The rent is being updated to " + rentForCurrentMonth + " Would you like to confirm the change?", "Update record", 1)) == 0) {
                            this.managePropertyView.getRentTf().setText(String.valueOf(rentForCurrentMonth));
                            JOptionPane.showMessageDialog(this.view, "Please click the Update button to apply the changes.", "Suggestion", 1);
                        }
                    } else {
                        this.managePropertyView.getRentChangeInMonthsTf().setText("");
                        this.managePropertyView.getRentChangeModel().setRowCount(0);
                    }
                }
                catch (Exception ex) {
                    new ErrorDialog(ex, "load property rented details");
                }
            }
            this.managePropertyView.getTenantContactBtn().setEnabled(true);
            this.managePropertyView.getDio().setTitle("Rent agreement details for " + this.view.getTable().getValueAt(this.view.getTable().getSelectedRow(), 3));
            this.managePropertyView.getDio().setSize(new Dimension(620, 410));
            this.managePropertyView.getDio().setVisible(true);
            this.loadRecords(null);
        }
        if (obj == this.view.getSearchBtn()) {
            String searchBy = (String)this.view.getSearchCb().getSelectedItem();
            if ("Address".equals(searchBy)) {
                Address address2 = new Address(this.view.getAddressTf().getText(), this.view.getLocationTf().getText(), this.view.getCityTf().getText(), this.view.getPinTf().getText());
                criteria = new PropertySearchCriteria(searchBy, address2);
                this.loadRecords(criteria);
            } else if ("Deposit".equals(searchBy)) {
                if ("deposit from".equals(this.view.getDepositFromTf().getText()) || "deposit to".equals(this.view.getDepositTo().getText())) {
                    JOptionPane.showMessageDialog(LoginView.frame, "Deposit from and to are mandatory");
                } else if (AppUtility.isValidNumber(this.view.getDepositFromTf().getText()) || AppUtility.isValidNumber(this.view.getDepositTo().getText())) {
                    Integer depositFrom = Integer.valueOf(this.view.getDepositFromTf().getText());
                    Integer depositTo = Integer.valueOf(this.view.getDepositTo().getText());
                    if (depositFrom > depositTo) {
                        JOptionPane.showMessageDialog(LoginView.frame, "Deposit from must be smaller then deposit to");
                    } else {
                        criteria = new PropertySearchCriteria(searchBy, depositFrom, depositTo);
                        this.loadRecords(criteria);
                    }
                } else {
                    JOptionPane.showMessageDialog(LoginView.frame, "Deposit from and to must be numbers");
                }
            } else if ("Rent".equals(searchBy)) {
                if ("rent from".equals(this.view.getRentFromTf().getText()) || "rent to".equals(this.view.getRentTo().getText())) {
                    JOptionPane.showMessageDialog(LoginView.frame, "Rent from and to are mandatory");
                } else if (AppUtility.isValidNumber(this.view.getRentFromTf().getText()) || AppUtility.isValidNumber(this.view.getRentTo().getText())) {
                    Integer rentFrom = Integer.valueOf(this.view.getRentFromTf().getText());
                    Integer rentTo = Integer.valueOf(this.view.getRentTo().getText());
                    if (rentFrom > rentTo) {
                        JOptionPane.showMessageDialog(LoginView.frame, "Rent from must be smaller then rent to");
                    } else {
                        criteria = new PropertySearchCriteria(searchBy, rentFrom, rentTo);
                        this.loadRecords(criteria);
                    }
                } else {
                    JOptionPane.showMessageDialog(LoginView.frame, "Rent from and to must be numbers");
                }
            } else if ("Price".equals(searchBy)) {
                if ("price from".equals(this.view.getPriceFrom().getText()) || "price to".equals(this.view.getPriceTo().getText())) {
                    JOptionPane.showMessageDialog(LoginView.frame, "Price from and to are mandatory");
                } else if (AppUtility.isValidNumber(this.view.getPriceFrom().getText()) || AppUtility.isValidNumber(this.view.getPriceTo().getText())) {
                    Object priceFrom = Integer.valueOf(this.view.getPriceFrom().getText());
                    Integer priceTo = Integer.valueOf(this.view.getPriceTo().getText());
                    if ((Integer)priceFrom > priceTo) {
                        JOptionPane.showMessageDialog(LoginView.frame, "Price from must be smaller then price to");
                    } else {
                        criteria = new PropertySearchCriteria(searchBy, (Integer)priceFrom, priceTo);
                        this.loadRecords(criteria);
                    }
                } else {
                    JOptionPane.showMessageDialog(LoginView.frame, "Price from and to must be numbers");
                }
            } else if ("Comments".equals(searchBy)) {
                criteria = new PropertySearchCriteria(searchBy, this.view.getCommentsTf().getText());
                this.loadRecords(criteria);
            } else if ("Offered by".equals(searchBy) || "Tenant".equals(searchBy)) {
                if ("".equals(this.view.getSelectedContactName().getText())) {
                    JOptionPane.showMessageDialog(LoginView.frame, "Please select contact for search");
                } else {
                    criteria = new PropertySearchCriteria(searchBy, String.valueOf(this.view.getSelectedContactId()));
                    this.loadRecords(criteria);
                }
            } else if ("Additional Info".equals(searchBy)) {
                criteria = new PropertySearchCriteria(searchBy, this.view.getAdditionalInfoTf().getText());
                this.loadRecords(criteria);
            }
        }
        if (obj == this.view.getDelBtn() || obj == this.view.getDeletePopupMenu()) {
            int choose;
            int[] selectedRows = this.view.getTable().getSelectedRows();
            StringBuilder propAddress = new StringBuilder();
            for (int row : selectedRows) {
                propAddress.append(this.view.getTable().getValueAt(row, 3));
                propAddress.append(", ");
            }
            int lastCommaIndex = propAddress.lastIndexOf(",");
            if (lastCommaIndex != -1) {
                propAddress.deleteCharAt(lastCommaIndex);
                int secondLastCommaIndex = propAddress.lastIndexOf(",", lastCommaIndex - 1);
                if (secondLastCommaIndex != -1) {
                    propAddress.replace(secondLastCommaIndex, secondLastCommaIndex + 1, " and");
                }
            }
            if ((choose = JOptionPane.showConfirmDialog(this.view, String.format("Are you sure you want to delete  \"%s\" ?", propAddress), "Delete record", 1)) == 0) {
                ArrayList<Integer> selectedRowIdsList = new ArrayList<Integer>();
                for (int row : selectedRows) {
                    selectedRowIdsList.add((int)((Integer)this.view.getTable().getValueAt(row, 10)));
                }
                try {
                    this.propertyRecordService.deleteLeaseRecord(selectedRowIdsList);
                    JOptionPane.showMessageDialog(LoginView.frame, "Deleted successfully");
                    this.loadRecords(null);
                }
                catch (Exception ex) {
                    new ErrorDialog(ex, "Delete property record");
                }
            }
        }
        if (obj == this.view.getDelGBtn()) {
            selectedGroupName = (String)this.view.getGroupList().getSelectedItem();
            if ("All Records".equals(selectedGroupName)) {
                JOptionPane.showMessageDialog(LoginView.frame, "Select group name from the groupList");
            } else {
                int choose = JOptionPane.showConfirmDialog(this.view, "Warning : All the record tag to this group will also delete \n  Are you sure to delete ?", "Delete group", 1);
                if (choose == 0) {
                    try {
                        this.propertyCategoryService.deleteCategory(PropertyGroupCache.getGroupIdByName(selectedGroupName));
                        PropertyGroupCache.loadPropertyGroup();
                        JOptionPane.showMessageDialog(LoginView.frame, "Deleted successfully");
                        this.loadGroups();
                    }
                    catch (Exception ex) {
                        new ErrorDialog(ex, "Delete property group");
                    }
                }
            }
        }
        if (obj == this.view.getSearchCb()) {
            String selectedOption = (String)this.view.getSearchCb().getSelectedItem();
            if ("Select".equals(selectedOption)) {
                this.view.getSearchBtn().setVisible(false);
                this.loadRecords(null);
            } else {
                this.view.getSearchBtn().setVisible(true);
            }
            if ("Address".equals(selectedOption)) {
                this.view.getAddressTf().setVisible(true);
                this.view.getLocationTf().setVisible(true);
                this.view.getCityTf().setVisible(true);
                this.view.getPinTf().setVisible(true);
            } else {
                this.view.getAddressTf().setVisible(false);
                this.view.getLocationTf().setVisible(false);
                this.view.getCityTf().setVisible(false);
                this.view.getPinTf().setVisible(false);
            }
            if ("Deposit".equals(selectedOption)) {
                this.view.getDepositFromTf().setVisible(true);
                this.view.getDepositTo().setVisible(true);
            } else {
                this.view.getDepositFromTf().setVisible(false);
                this.view.getDepositTo().setVisible(false);
            }
            if ("Rent".equals(selectedOption)) {
                this.view.getRentFromTf().setVisible(true);
                this.view.getRentTo().setVisible(true);
            } else {
                this.view.getRentFromTf().setVisible(false);
                this.view.getRentTo().setVisible(false);
            }
            if ("Price".equals(selectedOption)) {
                this.view.getPriceFrom().setVisible(true);
                this.view.getPriceTo().setVisible(true);
            } else {
                this.view.getPriceFrom().setVisible(false);
                this.view.getPriceTo().setVisible(false);
            }
            if ("Offered by".equals(selectedOption) || "Tenant".equals(selectedOption)) {
                this.view.getSelectedContactName().setVisible(true);
                this.view.getChooseContactSearchBtn().setVisible(true);
            } else {
                this.view.getSelectedContactName().setVisible(false);
                this.view.getChooseContactSearchBtn().setVisible(false);
            }
            if ("Additional Info".equals(selectedOption)) {
                this.view.getAdditionalInfoTf().setVisible(true);
            } else {
                this.view.getAdditionalInfoTf().setVisible(false);
            }
            this.view.getCommentsTf().setVisible("Comments".equals(selectedOption));
            this.view.getFilterPanel().revalidate();
        }
        if (obj == this.view.getGroupList()) {
            this.loadRecords(null);
        }
        if (obj == this.view.getNewBtn() || obj == this.view.getNewPopupMenu()) {
            this.propertyRecord.getSaveBtn().setVisible(true);
            this.propertyRecord.getUpdateBtn().setVisible(false);
            this.propertyRecord.getDio().setTitle("New record");
            this.resetNewRecordForm();
            this.propertyRecord.getPropertyRecordController().loadGroups();
            this.propertyRecord.getTabbedPane().setSelectedIndex(0);
            this.propertyRecord.getTabbedPane().setEnabledAt(1, false);
            this.propertyRecord.getDio().setVisible(true);
            this.loadRecords(null);
        }
        if (obj == this.view.getUpdRBtn() || obj == this.view.getUpdatePopupMenu()) {
            if (this.view.getTable().getSelectedRow() >= 0) {
                Integer leaseId = (Integer)this.view.getTable().getValueAt(this.view.getTable().getSelectedRow(), 10);
                try {
                    this.propertyRecord.getSaveBtn().setVisible(false);
                    this.propertyRecord.getUpdateBtn().setVisible(true);
                    this.propertyRecord.getTabbedPane().setSelectedIndex(0);
                    PropertyDetails details = this.service.fetchPropertyDetails(leaseId);
                    PropertyRecord record = this.service.fetchPropertyRecord(leaseId);
                    this.fillLeaseForm(record, details);
                    this.propertyRecord.getTabbedPane().setEnabledAt(1, true);
                    this.propertyRecord.getDio().setVisible(true);
                    this.loadRecords(null);
                }
                catch (Exception ex) {
                    new ErrorDialog(ex, "load property details for update");
                }
            } else {
                JOptionPane.showMessageDialog(LoginView.frame, "Please select record for update");
            }
        }
        if (obj == this.view.getNewGBtn()) {
            this.propertyCategory.getDio().setTitle("New Group");
            this.propertyCategory.getSaveBtn().setVisible(true);
            this.propertyCategory.getUpdateBtn().setVisible(false);
            this.propertyCategory.setPropertyGroupId(0);
            this.propertyCategory.getValidationError().setVisible(false);
            this.propertyCategory.getGroupNameField().setText("");
            this.propertyCategory.getDio().setVisible(true);
            this.loadGroups();
        }
        if (obj == this.view.getUpdGBtn()) {
            selectedGroupName = (String)this.view.getGroupList().getSelectedItem();
            this.propertyCategory.getDio().setTitle("Update Group");
            int propertyGroupId = PropertyGroupCache.getGroupIdByName(selectedGroupName);
            this.propertyCategory.setPropertyGroupId(propertyGroupId);
            this.propertyCategory.getSaveBtn().setVisible(false);
            this.propertyCategory.getUpdateBtn().setVisible(true);
            this.propertyCategory.getValidationError().setVisible(false);
            this.propertyCategory.getGroupNameField().setText(selectedGroupName);
            this.propertyCategory.getDio().setVisible(true);
            this.loadGroups();
        }
    }

    private void resetNewRecordForm() {
        this.propertyRecord.getDateTf().setText(AppUtility.getCurrentDateInString());
        this.propertyRecord.getAddressTf().setText("");
        this.propertyRecord.getLocationTf().setText("");
        this.propertyRecord.getCityTf().setText("");
        this.propertyRecord.getPinTf().setText("");
        this.propertyRecord.getDepositTf().setText("");
        this.propertyRecord.getRentTf().setText("");
        PropertyRecordView.getOfferedByNameTf().setText("");
        PropertyRecordView.getOfferedByNameIdTf().setText("");
        this.propertyRecord.getCommentsTextArea().setText("");
        this.propertyRecord.setLeaseId(0);
        this.propertyRecord.getPriceTf().setText("");
        this.propertyRecord.getAreaInSqftTf().setText("");
        this.propertyRecord.getForRent().setSelected(true);
        this.propertyRecord.getForSell().setSelected(false);
        this.propertyRecord.getForRent().setVisible(true);
        this.propertyRecord.getForSell().setVisible(true);
        this.propertyRecord.getOnRent().setVisible(false);
        this.propertyRecord.getForSell().setEnabled(true);
        this.propertyRecord.getContactBtn().setEnabled(true);
        this.propertyRecord.getDepositLabel().setText("<html>Deposit<span style='color: red;'>*</span></html>");
        this.propertyRecord.getRentLabel().setText("<html>Rent<span style='color: red;'>*</span> </html>");
        this.propertyRecord.getSellingPriceLabel().setText("Selling Price : ");
        this.defaultAvailableFor();
    }

    private void defaultAvailableFor() {
        this.propertyRecord.getAvailabilityLabel().setText("<html>Available for <span style='color: red;'>*</span> </html>");
        this.propertyRecord.getUnAvailable().setSelected(false);
        this.propertyRecord.getUnAvailable().setVisible(true);
        this.propertyRecord.getUnAvailableUntilTf().setText("");
        this.propertyRecord.getUnAvailableUntilTf().setVisible(false);
        this.propertyRecord.getUnAvailableUntilBtn().setVisible(false);
    }

    private void fillLeaseForm(PropertyRecord record, PropertyDetails details) {
        this.propertyRecord.getDio().setTitle("Update - " + record.address());
        this.propertyRecord.getDateTf().setText(record.date());
        this.propertyRecord.getAddressTf().setText(record.address());
        this.propertyRecord.getLocationTf().setText(record.location());
        this.propertyRecord.getCityTf().setText(record.city());
        this.propertyRecord.getPinTf().setText(record.pin());
        this.propertyRecord.getDepositTf().setText(String.valueOf(record.deposit()));
        this.propertyRecord.getRentTf().setText(String.valueOf(record.rent()));
        this.propertyRecord.getPriceTf().setText(String.valueOf(record.price()));
        this.propertyRecord.getAreaInSqftTf().setText(String.valueOf(record.areaInSqFt()));
        this.propertyRecord.getOfferedByCB().setSelectedItem(PropertyOfferedBy.PropertyOfferedByCode(record.offeredByType()).name());
        this.propertyRecord.getFurnishingStatusCB().setSelectedItem(FurnitureStatus.furnitureCode(record.furnishingStatus()).name());
        PropertyRecordView.getOfferedByNameTf().setText(details.name());
        PropertyRecordView.getOfferedByNameIdTf().setText(String.valueOf(record.fkContactId()));
        PropertyRecordView.getGroupNames().setSelectedItem(details.groupName());
        this.propertyRecord.setLeaseId(record.leaseId());
        this.propertyRecord.getCommentsTextArea().setText(record.comments());
        this.propertyRecord.getContactBtn().setEnabled(true);
        this.propertyRecord.getContactBtn().setToolTipText("Choose name from contacts");
        if (PropertyStatus.propertyCode(record.propertyStatus()).name().equals("FOR_RENT")) {
            this.propertyRecord.getOnRent().setSelected(false);
            this.propertyRecord.getForRent().setSelected(true);
            this.propertyRecord.getForSell().setSelected(false);
            this.propertyRecord.getForRent().setVisible(true);
            this.propertyRecord.getForSell().setVisible(true);
            this.propertyRecord.getOnRent().setVisible(false);
            this.defaultAvailableFor();
        } else if (PropertyStatus.propertyCode(record.propertyStatus()).name().equals("FOR_SELL")) {
            this.propertyRecord.getOnRent().setSelected(false);
            this.propertyRecord.getForRent().setSelected(false);
            this.propertyRecord.getForSell().setSelected(true);
            this.propertyRecord.getForRent().setVisible(true);
            this.propertyRecord.getForSell().setVisible(true);
            this.propertyRecord.getOnRent().setVisible(false);
            this.defaultAvailableFor();
        } else if (PropertyStatus.propertyCode(record.propertyStatus()).name().equals("FOR_RENT_AND_SELL")) {
            this.propertyRecord.getOnRent().setSelected(false);
            this.propertyRecord.getForRent().setSelected(true);
            this.propertyRecord.getForSell().setSelected(true);
            this.propertyRecord.getForRent().setVisible(true);
            this.propertyRecord.getForSell().setVisible(true);
            this.propertyRecord.getOnRent().setVisible(false);
            this.defaultAvailableFor();
        } else if (PropertyStatus.propertyCode(record.propertyStatus()).name().equals("NOT_FOR_RENT_OR_SELL")) {
            this.propertyRecord.getOnRent().setSelected(false);
            this.propertyRecord.getForRent().setSelected(false);
            this.propertyRecord.getForSell().setSelected(false);
            this.propertyRecord.getForRent().setVisible(false);
            this.propertyRecord.getForSell().setVisible(false);
            this.propertyRecord.getOnRent().setVisible(false);
            this.propertyRecord.getAvailabilityLabel().setText("<html>Unavailable until <span style='color: red;'>*</span> </html>");
            this.propertyRecord.getUnAvailable().setSelected(true);
            this.propertyRecord.getUnAvailableUntilTf().setVisible(true);
            this.propertyRecord.getUnAvailableUntilBtn().setVisible(true);
            this.propertyRecord.getUnAvailableUntilTf().setText(record.unAvailableUntil());
        } else if (PropertyStatus.propertyCode(record.propertyStatus()).name().equals("ON_RENT")) {
            this.propertyRecord.getOnRent().setSelected(true);
            this.propertyRecord.getForRent().setSelected(false);
            this.propertyRecord.getForSell().setSelected(false);
            this.propertyRecord.getForRent().setVisible(false);
            this.propertyRecord.getForSell().setVisible(false);
            this.propertyRecord.getOnRent().setVisible(true);
            this.propertyRecord.getAvailabilityLabel().setText("<html>Currently rented <span style='color: red;'>*</span> </html>");
            this.propertyRecord.getUnAvailable().setSelected(false);
            this.propertyRecord.getUnAvailable().setVisible(false);
            this.propertyRecord.getUnAvailableUntilTf().setVisible(false);
            this.propertyRecord.getUnAvailableUntilBtn().setVisible(false);
            this.propertyRecord.getContactBtn().setEnabled(false);
            this.propertyRecord.getContactBtn().setToolTipText("Action not allowed: The property is currently rented.");
        }
    }

    private void loadDetailsOnRowSelection() {
        Integer propertyId = (Integer)this.view.getTable().getValueAt(this.view.getTable().getSelectedRow(), 10);
        this.setSelectedRowIndex(this.view.getTable().getSelectedRow());
        try {
            PropertyDetails details = this.service.fetchPropertyDetails(propertyId);
            if (details != null) {
                long days;
                StringBuilder propertyDetails = new StringBuilder();
                propertyDetails.append("<html>\n<head>\n    <meta charset=\"UTF-8\">\n    <title>Contract Details</title>\n    <style>\n          body {\n               font-family: Arial, sans-serif;\n               margin: 5px;\n           }\n           h2 {\n             color: #333;\n               margin-top: 5px;\n               margin-bottom: 2px; /* Reduced margin between h2 and p */\n           }\n           .details {\n               margin-bottom: 5px;\n           }\n           .details p {\n               margin: 5px 0;\n           }\n           .highlight {\n              font-weight: bold;\n           }\n\n    </style>\n</head>\n<body>\n");
                this.view.getAgentDetailsPopupMenu().setVisible(false);
                this.view.getOwnerDetailsPopupMenu().setVisible(false);
                this.view.getTenantDetailsPopupMenu().setVisible(false);
                this.setOwnerContactId(0);
                this.setAgenetContactId(0);
                this.setTenantContactId(0);
                String offeredByType = PropertyOfferedBy.PropertyOfferedByCode(details.offeredBy()).name().replaceAll("_", " ");
                propertyDetails.append("<div class='details'> <h2>").append(details.groupName() + " - " + offeredByType).append(" </h2>");
                JLabel furnishingStatus = new JLabel(FurnitureStatus.furnitureCode(details.furnishing()).name());
                furnishingStatus.setToolTipText("Furnishing Status");
                propertyDetails.append(" <p><span class='highlight'>Status: </span> ").append(FurnitureStatus.furnitureCode(details.furnishing()).name()).append(" </p> </div>");
                if (offeredByType.equals("DIRECT")) {
                    propertyDetails.append("<div class='details'><h2> Owners details : </h2> ");
                    this.view.getOwnerDetailsPopupMenu().setVisible(true);
                    this.setOwnerContactId(details.contactId());
                } else {
                    propertyDetails.append("<div class='details'><h2> Offered by : </h2> ");
                    this.view.getAgentDetailsPopupMenu().setVisible(true);
                    this.setAgenetContactId(details.contactId());
                }
                propertyDetails.append(" <p><span class='highlight'>Name: </span> ").append(details.name()).append(" </p>");
                if (details.contact() != null) {
                    propertyDetails.append("<p><span class='highlight'>Contact: </span> <a href='https://wa.me/").append(details.contact()).append("'>").append(details.contact()).append("</a> </p>");
                }
                propertyDetails.append("</div>");
                if (details.tenantName() != null) {
                    propertyDetails.append("<div class='details'><h2> Tenant details : </h2> ");
                    this.view.getTenantDetailsPopupMenu().setVisible(true);
                    this.setTenantContactId(details.tenantContactId());
                    propertyDetails.append("<p><span class='highlight'>Name: </span>").append(details.tenantName()).append(" </p>");
                    if (details.tenantContact() != null) {
                        propertyDetails.append("<p><span class='highlight'>Contact: </span> <a href='https://wa.me/").append(details.tenantContact()).append("'>").append(details.tenantContact()).append("</a> </h2>");
                    }
                    propertyDetails.append("<p><span class='highlight'>Lease Duration : </span> ").append(details.contractStartDate()).append(" - ").append(details.contractEndDate()).append(" </h2>");
                    LocalDate endDateObj = AppUtility.convertStringToDate(details.contractEndDate());
                    days = ChronoUnit.DAYS.between(LocalDate.now(), endDateObj);
                    if (days == 0L) {
                        propertyDetails.append("<p><span class='highlight'>Expire today </span> </p>");
                    } else if (days > 0L) {
                        propertyDetails.append("<p><span class='highlight'>Expire in </span>").append(days).append(" days </p> ");
                    } else {
                        propertyDetails.append("<p><span class='highlight'> Already expired by </span>").append(days).append(" days </p> ");
                    }
                    propertyDetails.append("</div>");
                }
                if (details.unAvailableUntil() != null && !details.unAvailableUntil().isBlank()) {
                    propertyDetails.append("<p><span class='highlight'>Unavailable until: </span>").append(details.unAvailableUntil()).append(" </p>");
                    LocalDate dateObj = AppUtility.convertStringToDate(details.unAvailableUntil());
                    days = ChronoUnit.DAYS.between(LocalDate.now(), dateObj);
                    if (days == 0L) {
                        propertyDetails.append("<p><span class='highlight'>Available from today </span> </p>");
                    } else if (days > 0L) {
                        propertyDetails.append("<p><span class='highlight'>Available in: </span>").append(days).append(" days </p>");
                    } else {
                        propertyDetails.append("<p><span class='highlight'>Available for the last: </span>").append(days).append(" days </p>");
                    }
                }
                if (!details.propertyAdditionalDetails().isEmpty()) {
                    propertyDetails.append("<div class='details'><h2> Additional Details : </h2> ");
                    for (Map.Entry<String, String> entry : details.propertyAdditionalDetails().entrySet()) {
                        propertyDetails.append("<p><span class='highlight'> ").append(entry.getKey()).append(" : </span>").append(entry.getValue()).append("</p> ");
                    }
                    propertyDetails.append("</div>");
                }
                this.view.getNotificationEditorPanel().setText(propertyDetails.toString());
                this.view.getNotificationEditorPanel().setCaretPosition(0);
            }
        }
        catch (Exception ex) {
            new ErrorDialog(ex, "load details on row selection");
        }
        this.view.getUpdRBtn().setEnabled(true);
        this.view.getDelBtn().setEnabled(true);
        this.view.getPropertyHistoryBtn().setEnabled(true);
        this.view.getPropertyOnRentBtn().setEnabled(false);
        this.view.getSellOfAssetBtn().setEnabled(false);
        this.view.getManageRentPopupMenu().setVisible(false);
        this.view.getManageSellPopupMenu().setVisible(false);
        String selectedPropStatus = (String)this.view.getTable().getValueAt(this.view.getTable().getSelectedRow(), 4);
        selectedPropStatus = selectedPropStatus.replaceAll(" ", "_");
        if (selectedPropStatus.equals(PropertyStatus.FOR_RENT.name())) {
            this.view.getPropertyOnRentBtn().setEnabled(true);
            this.view.getSellOfAssetBtn().setEnabled(false);
            this.view.getManageRentPopupMenu().setVisible(true);
            this.view.getManageSellPopupMenu().setVisible(false);
        } else if (selectedPropStatus.equals(PropertyStatus.FOR_SELL.name())) {
            this.view.getPropertyOnRentBtn().setEnabled(false);
            this.view.getSellOfAssetBtn().setEnabled(true);
            this.view.getManageRentPopupMenu().setVisible(false);
            this.view.getManageSellPopupMenu().setVisible(true);
        } else if (selectedPropStatus.equals(PropertyStatus.FOR_RENT_AND_SELL.name())) {
            this.view.getPropertyOnRentBtn().setEnabled(true);
            this.view.getSellOfAssetBtn().setEnabled(true);
            this.view.getManageRentPopupMenu().setVisible(true);
            this.view.getManageSellPopupMenu().setVisible(true);
        } else if (selectedPropStatus.equals(PropertyStatus.NOT_FOR_RENT_OR_SELL.name())) {
            this.view.getPropertyOnRentBtn().setEnabled(false);
            this.view.getSellOfAssetBtn().setEnabled(false);
            this.view.getManageRentPopupMenu().setVisible(false);
            this.view.getManageSellPopupMenu().setVisible(false);
        } else if (selectedPropStatus.equals(PropertyStatus.ON_RENT.name())) {
            this.view.getPropertyOnRentBtn().setEnabled(true);
            this.view.getSellOfAssetBtn().setEnabled(false);
            this.view.getManageRentPopupMenu().setVisible(true);
            this.view.getManageSellPopupMenu().setVisible(false);
        }
        String selectedPrice = (String)this.view.getTable().getValueAt(this.view.getTable().getSelectedRow(), 6);
        int selectedIntPrice = Integer.parseInt(selectedPrice.substring(1).replace(",", ""));
        this.view.getHomeLoanCalculator().setEnabled(selectedIntPrice > 0);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.view.getSelectionModel()) {
            int[] selectedRows = this.view.getTable().getSelectedRows();
            if (selectedRows.length == 0) {
                this.view.getUpdRBtn().setEnabled(false);
                this.view.getDelBtn().setEnabled(false);
                this.view.getSellOfAssetBtn().setEnabled(false);
                this.view.getPropertyOnRentBtn().setEnabled(false);
                this.view.getPropertyHistoryBtn().setEnabled(false);
                this.view.getSellOfAssetBtn().setEnabled(false);
                this.view.getManageRentPopupMenu().setVisible(false);
                this.view.getManageSellPopupMenu().setVisible(false);
                this.view.getNotificationEditorPanel().setText("");
                this.view.getNotificationEditorPanel().setCaretPosition(0);
            } else if (selectedRows.length == 1) {
                this.loadDetailsOnRowSelection();
                this.view.getUpdatePopupMenu().setVisible(true);
                this.view.getManageDocumentPopupMenu().setVisible(true);
                this.view.getHistoryPopupMenu().setVisible(true);
            } else {
                this.view.getUpdRBtn().setEnabled(false);
                this.view.getDelBtn().setEnabled(true);
                this.view.getSellOfAssetBtn().setEnabled(false);
                this.view.getPropertyOnRentBtn().setEnabled(false);
                this.view.getPropertyHistoryBtn().setEnabled(false);
                this.view.getSellOfAssetBtn().setEnabled(false);
                this.view.getManageRentPopupMenu().setVisible(false);
                this.view.getManageSellPopupMenu().setVisible(false);
                this.view.getNotificationEditorPanel().setText("");
                this.view.getNotificationEditorPanel().setCaretPosition(0);
                this.view.getUpdatePopupMenu().setVisible(false);
                this.view.getManageRentPopupMenu().setVisible(false);
                this.view.getManageSellPopupMenu().setVisible(false);
                this.view.getAgentDetailsPopupMenu().setVisible(false);
                this.view.getOwnerDetailsPopupMenu().setVisible(false);
                this.view.getTenantDetailsPopupMenu().setVisible(false);
                this.view.getManageDocumentPopupMenu().setVisible(false);
                this.view.getHistoryPopupMenu().setVisible(false);
            }
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (e.getSource() == this.view.getAddressTf() && "address".equals(this.view.getAddressTf().getText())) {
            this.view.getAddressTf().setText("");
        }
        if (e.getSource() == this.view.getLocationTf() && "location".equals(this.view.getLocationTf().getText())) {
            this.view.getLocationTf().setText("");
        }
        if (e.getSource() == this.view.getCityTf() && "city".equals(this.view.getCityTf().getText())) {
            this.view.getCityTf().setText("");
        }
        if (e.getSource() == this.view.getPinTf() && "pin".equals(this.view.getPinTf().getText())) {
            this.view.getPinTf().setText("");
        }
        if (e.getSource() == this.view.getDepositFromTf() && "deposit from".equals(this.view.getDepositFromTf().getText())) {
            this.view.getDepositFromTf().setText("");
        }
        if (e.getSource() == this.view.getDepositTo() && "deposit to".equals(this.view.getDepositTo().getText())) {
            this.view.getDepositTo().setText("");
        }
        if (e.getSource() == this.view.getRentFromTf() && "rent from".equals(this.view.getRentFromTf().getText())) {
            this.view.getRentFromTf().setText("");
        }
        if (e.getSource() == this.view.getRentTo() && "rent to".equals(this.view.getRentTo().getText())) {
            this.view.getRentTo().setText("");
        }
        if (e.getSource() == this.view.getPriceFrom() && "price from".equals(this.view.getPriceFrom().getText())) {
            this.view.getPriceFrom().setText("");
        }
        if (e.getSource() == this.view.getPriceTo() && "price to".equals(this.view.getPriceTo().getText())) {
            this.view.getPriceTo().setText("");
        }
        if (e.getSource() == this.view.getCommentsTf() && "comments".equals(this.view.getCommentsTf().getText())) {
            this.view.getCommentsTf().setText("");
        }
        if (e.getSource() == this.view.getAdditionalInfoTf() && "Additional Info".equals(this.view.getAdditionalInfoTf().getText())) {
            this.view.getAdditionalInfoTf().setText("");
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getSource() == this.view.getAddressTf() && "".equals(this.view.getAddressTf().getText())) {
            this.view.getAddressTf().setText("address");
        }
        if (e.getSource() == this.view.getLocationTf() && "".equals(this.view.getLocationTf().getText())) {
            this.view.getLocationTf().setText("location");
        }
        if (e.getSource() == this.view.getCityTf() && "".equals(this.view.getCityTf().getText())) {
            this.view.getCityTf().setText("city");
        }
        if (e.getSource() == this.view.getPinTf() && "".equals(this.view.getPinTf().getText())) {
            this.view.getPinTf().setText("pin");
        }
        if (e.getSource() == this.view.getDepositFromTf() && "".equals(this.view.getDepositFromTf().getText())) {
            this.view.getDepositFromTf().setText("deposit from");
        }
        if (e.getSource() == this.view.getDepositTo() && "".equals(this.view.getDepositTo().getText())) {
            this.view.getDepositTo().setText("deposit to");
        }
        if (e.getSource() == this.view.getRentFromTf() && "".equals(this.view.getRentFromTf().getText())) {
            this.view.getRentFromTf().setText("rent from");
        }
        if (e.getSource() == this.view.getRentTo() && "".equals(this.view.getRentTo().getText())) {
            this.view.getRentTo().setText("rent to");
        }
        if (e.getSource() == this.view.getPriceFrom() && "".equals(this.view.getPriceFrom().getText())) {
            this.view.getPriceFrom().setText("price from");
        }
        if (e.getSource() == this.view.getPriceTo() && "".equals(this.view.getPriceTo().getText())) {
            this.view.getPriceTo().setText("price from");
        }
        if (e.getSource() == this.view.getCommentsTf() && "".equals(this.view.getCommentsTf().getText())) {
            this.view.getCommentsTf().setText("comments");
        }
        if (e.getSource() == this.view.getAdditionalInfoTf() && "".equals(this.view.getAdditionalInfoTf().getText())) {
            this.view.getAdditionalInfoTf().setText("Additional Info");
        }
    }

    public PropertyView getView() {
        return this.view;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getSource() == this.view.getAvailableWithinTextField() && this.view.getAvailableWithinCheckBox().isSelected() && !this.view.getAvailableWithinTextField().getText().trim().isEmpty()) {
            this.loadRecords(null);
        }
    }
}

