/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.controller.property;

import com.arun.bhardwaj.model.property.PropertySellDetails;
import com.arun.bhardwaj.model.property.PropertyStatus;
import com.arun.bhardwaj.service.property.PropertySellDetailsService;
import com.arun.bhardwaj.service.property.PropertySellDetailsServiceImpl;
import com.arun.bhardwaj.utility.AppUtility;
import com.arun.bhardwaj.view.common.ContactDialogView;
import com.arun.bhardwaj.view.common.CustomDatePicker;
import com.arun.bhardwaj.view.common.ErrorDialog;
import com.arun.bhardwaj.view.property.PropertyForSell;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Optional;
import javax.swing.JOptionPane;

public class PropertyForSellController
implements ActionListener {
    private PropertyForSell view;
    private PropertySellDetailsService service;

    public PropertyForSellController(PropertyForSell view) {
        this.view = view;
        this.service = new PropertySellDetailsServiceImpl();
        this.addToolTips();
        this.addActionEvent();
        this.view.getStatusCb().addItem(PropertyStatus.FOR_RENT.name());
        this.view.getStatusCb().addItem(PropertyStatus.FOR_SELL.name());
        this.view.getStatusCb().addItem(PropertyStatus.NOT_FOR_RENT_OR_SELL.name());
        this.view.getStatusCb().addItem(PropertyStatus.FOR_RENT_AND_SELL.name());
    }

    private void addActionEvent() {
        this.view.getSaveBtn().addActionListener(this);
        this.view.getCloseBtn().addActionListener(this);
        this.view.getDateBtn().addActionListener(this);
        this.view.getBuyerContactBtn().addActionListener(this);
        this.view.getSellerContactBtn().addActionListener(this);
        this.view.getSelf().addActionListener(this);
        this.view.getOthers().addActionListener(this);
        this.view.getSaleByContactBtn().addActionListener(this);
    }

    private void addToolTips() {
        this.view.getDateTf().setToolTipText("Agreement Date");
        this.view.getBuyerTf().setToolTipText("Choose buyer from right side button");
        this.view.getAmountTf().setToolTipText("Amount");
        this.view.getBuyerContactBtn().setToolTipText("Select buyer");
        this.view.getDateBtn().setToolTipText("agreement date");
        this.view.getSelf().setToolTipText("Sell by self");
        this.view.getOthers().setToolTipText("Sell by other");
        this.view.getSaleByContactBtn().setToolTipText("Select agent involved in deal");
        this.view.getSellerContactBtn().setToolTipText("Select seller");
        this.view.getSaveBtn().setToolTipText("Sell the property");
        this.view.getCloseBtn().setToolTipText("Close");
        this.view.getStatusCb().setToolTipText("Select new property status after sell");
        this.view.getBrokerageTf().setToolTipText("Brokerage is calculated 1% of property value");
    }

    private boolean isValidForm() {
        if (this.view.getOthers().isSelected() && this.view.getSaleByContactId() == 0) {
            JOptionPane.showMessageDialog(this.view.getDio(), "Sell by contact name is mandatory", "Error", 0);
            return false;
        }
        if (this.view.getBuyerContactId() == 0) {
            JOptionPane.showMessageDialog(this.view.getDio(), "Buyer is mandatory", "Error", 0);
            return false;
        }
        if (this.view.getSellerContactId() == 0) {
            JOptionPane.showMessageDialog(this.view.getDio(), "Seller is mandatory", "Error", 0);
            return false;
        }
        if (this.view.getBuyerContactId() == this.view.getSellerContactId()) {
            JOptionPane.showMessageDialog(this.view.getDio(), "Buyer and Seller cannot be same", "Error", 0);
            return false;
        }
        if (this.view.getAmountTf().getText().isEmpty()) {
            JOptionPane.showMessageDialog(this.view.getDio(), "Amount is mandatory", "Error", 0);
            this.view.getAmountTf().requestFocus();
            return false;
        }
        return true;
    }

    private PropertySellDetails bindFormFields() throws Exception {
        int saleBy = 0;
        if (this.view.getOthers().isSelected()) {
            saleBy = 1;
        }
        String status = (String)this.view.getStatusCb().getSelectedItem();
        Optional<PropertyStatus> propertyStatus = Arrays.stream(PropertyStatus.values()).filter(propStatus -> propStatus.name().equals(status)).findAny();
        return new PropertySellDetails(this.view.getDateTf().getText(), this.view.getBuyerContactId(), this.view.getSellerContactId(), saleBy, this.view.getSaleByContactId(), Integer.parseInt(this.view.getAmountTf().getText()), Integer.parseInt(this.view.getBrokerageTf().getText()), this.view.getPropertyId(), propertyStatus.get().ordinal());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ContactDialogView contactDio;
        Object obj = e.getSource();
        if (obj == this.view.getSelf()) {
            this.view.getSaleByContactBtn().setVisible(false);
            this.view.getSellByTf().setVisible(false);
            this.view.getSellByTf().setText("");
            this.view.setSaleByContactId(0);
        }
        if (obj == this.view.getOthers()) {
            this.view.getSaleByContactBtn().setVisible(true);
            this.view.getSellByTf().setVisible(true);
        }
        if (obj == this.view.getSaleByContactBtn()) {
            contactDio = new ContactDialogView(this, "saleBy", "Select an agent name");
            AppUtility.setDialogLocationInCenter(contactDio.getDio());
            contactDio.getDio().setVisible(true);
        }
        if (obj == this.view.getSaveBtn() && this.isValidForm()) {
            try {
                this.service.saveRecord(this.bindFormFields());
                JOptionPane.showMessageDialog(this.view.getDio(), "Saved successfully");
                this.view.getDio().setVisible(false);
            }
            catch (Exception ex) {
                new ErrorDialog(ex, "Save sell transaction");
            }
        }
        if (obj == this.view.getBuyerContactBtn()) {
            contactDio = new ContactDialogView(this, "buyer", "Select a buyer name");
            AppUtility.setDialogLocationInCenter(contactDio.getDio());
            contactDio.getDio().setVisible(true);
        }
        if (obj == this.view.getSellerContactBtn()) {
            contactDio = new ContactDialogView(this, "seller", "Select a seller name");
            AppUtility.setDialogLocationInCenter(contactDio.getDio());
            contactDio.getDio().setVisible(true);
        }
        if (obj == this.view.getDateBtn()) {
            CustomDatePicker customDatePicker = new CustomDatePicker(this, "agg-Date");
            AppUtility.setDialogLocationInCenter(customDatePicker.getDio());
            customDatePicker.getDio().setVisible(true);
        }
        if (obj == this.view.getCloseBtn()) {
            this.view.getDio().setVisible(false);
        }
    }

    public PropertyForSell getView() {
        return this.view;
    }
}

