/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.controller.property;

import com.arun.bhardwaj.model.property.DepositTrackerDetails;
import com.arun.bhardwaj.model.property.ModeOfPayment;
import com.arun.bhardwaj.model.property.PaymentTrackerDetails;
import com.arun.bhardwaj.model.property.PropertyOnRentDetails;
import com.arun.bhardwaj.model.property.PropertyTerminationDetails;
import com.arun.bhardwaj.model.property.RentDetails;
import com.arun.bhardwaj.service.property.PropertyOnRentService;
import com.arun.bhardwaj.service.property.PropertyOnRentServiceImpl;
import com.arun.bhardwaj.utility.AppUtility;
import com.arun.bhardwaj.view.common.ContactDialogView;
import com.arun.bhardwaj.view.common.CustomDatePicker;
import com.arun.bhardwaj.view.common.DisplayBarChart;
import com.arun.bhardwaj.view.common.ErrorDialog;
import com.arun.bhardwaj.view.property.PropertyOnRent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jfree.data.category.DefaultCategoryDataset;

public class PropertyOnRentController
implements ActionListener,
ListSelectionListener,
ChangeListener,
KeyListener {
    private final PropertyOnRent view;
    private final PropertyOnRentService service;
    private final DefaultCategoryDataset dataset = new DefaultCategoryDataset();

    public PropertyOnRentController(PropertyOnRent view) {
        this.view = view;
        this.service = new PropertyOnRentServiceImpl();
        this.addToolTips();
        this.addActionEvent();
        this.addKeyEvents();
        this.view.getSelectionModel().addListSelectionListener(this);
        view.getSelectionDepositModel().addListSelectionListener(this);
        view.getTerminationDateTf().setText(AppUtility.getCurrentDateInString());
        view.getPaymentDateTf().setText(AppUtility.getCurrentDateInString());
        view.getMainTabs().addChangeListener(this);
        AppUtility.tableZoomInZoomOut(true, view.getTable());
        AppUtility.tableZoomInZoomOut(true, view.getTable());
        AppUtility.tableZoomInZoomOut(true, view.getDepositTable());
        AppUtility.tableZoomInZoomOut(true, view.getDepositTable());
    }

    private void addKeyEvents() {
        this.view.getTenureInMonthsTf().addKeyListener(this);
    }

    private void addActionEvent() {
        this.view.getRenewalBtn().addActionListener(this);
        this.view.getPaymentTrackerBtn().addActionListener(this);
        this.view.getTerminateBtn().addActionListener(this);
        this.view.getSaveBtn().addActionListener(this);
        this.view.getUpdateBtn().addActionListener(this);
        this.view.getCloseBtn().addActionListener(this);
        this.view.getDateBtn().addActionListener(this);
        this.view.getOwnerContactBtn().addActionListener(this);
        this.view.getTenantContactBtn().addActionListener(this);
        this.view.getSelf().addActionListener(this);
        this.view.getOthers().addActionListener(this);
        this.view.getRentedByContactBtn().addActionListener(this);
        this.view.getCreatePaymentBtn().addActionListener(this);
        this.view.getUpdatePaymentBtn().addActionListener(this);
        this.view.getDeletePaymentBtn().addActionListener(this);
        this.view.getSavePaymentTbBtn().addActionListener(this);
        this.view.getUpdatePaymentTbBtn().addActionListener(this);
        this.view.getCancelPaymentTbBtn().addActionListener(this);
        this.view.getTerminationSave().addActionListener(this);
        this.view.getTerminationCancel().addActionListener(this);
        this.view.getPaymentDateBtn().addActionListener(this);
        this.view.getTerminationDateBtn().addActionListener(this);
        this.view.getZoomInBtn().addActionListener(this);
        this.view.getZoomOutBtn().addActionListener(this);
        this.view.getAddPopupMenu().addActionListener(this);
        this.view.getUpdatePopupMenu().addActionListener(this);
        this.view.getDeletePopupMenu().addActionListener(this);
        this.view.getRefPopupMenu().addActionListener(this);
        this.view.getStatisticsPaymentBtn().addActionListener(this);
        this.view.getStatisticPopupMenu().addActionListener(this);
        this.view.getCreateDepositBtn().addActionListener(this);
        this.view.getUpdateDepositBtn().addActionListener(this);
        this.view.getDeleteDepositBtn().addActionListener(this);
        this.view.getDepositDateBtn().addActionListener(this);
        this.view.getSaveDepositTbBtn().addActionListener(this);
        this.view.getUpdateDepositTbBtn().addActionListener(this);
        this.view.getCancelDepositTbBtn().addActionListener(this);
        this.view.getAddDepositPopupMenu().addActionListener(this);
        this.view.getUpdateDepositPopupMenu().addActionListener(this);
        this.view.getDeleteDepositPopupMenu().addActionListener(this);
        this.view.getDepositZoomInBtn().addActionListener(this);
        this.view.getDepositZoomOutBtn().addActionListener(this);
        this.view.getDepositRefundDateBtn().addActionListener(this);
        this.view.getRentConditionsBtn().addActionListener(this);
        this.view.getCalculate().addActionListener(this);
        this.view.getRentChangeZoomIn().addActionListener(this);
        this.view.getRentChangeZoomOut().addActionListener(this);
        this.view.getCloseRentBtn().addActionListener(this);
    }

    private void addToolTips() {
        this.view.getDateTf().setToolTipText("Agreement date");
        this.view.getTenantTf().setToolTipText("Choose tenant from right side button");
        this.view.getTenureInMonthsTf().setToolTipText("Tenure in months");
        this.view.getTenantContactBtn().setToolTipText("Select tenant");
        this.view.getDateBtn().setToolTipText("Select agreement date");
        this.view.getRentedByContactBtn().setToolTipText("Select agent involved in deal");
        this.view.getBrokerageTf().setToolTipText("Brokerage is one month rent");
        this.view.getSelf().setToolTipText("Rented by self");
        this.view.getOthers().setToolTipText("Rented by other");
        this.view.getSaveBtn().setToolTipText("Save details");
        this.view.getUpdateBtn().setToolTipText("Update details");
        this.view.getCloseBtn().setToolTipText("Close");
        this.view.getTerminateBtn().setToolTipText("Terminate contract");
        this.view.getNewPropertyStatusCb().setToolTipText("Select new property status after termination");
        this.view.getTerminationSave().setToolTipText("Terminate contract");
        this.view.getTerminationCancel().setToolTipText("Close");
        this.view.getRenewalBtn().setToolTipText("Renewal contract");
        this.view.getPaymentTrackerBtn().setToolTipText("Manage payments details");
        this.view.getCreatePaymentBtn().setToolTipText("Add new payment details");
        this.view.getUpdatePaymentBtn().setToolTipText("Update selected record");
        this.view.getDeletePaymentBtn().setToolTipText("Delete selected record");
        this.view.getPaymentDateBtn().setToolTipText("Choose payment received date");
        this.view.getSavePaymentTbBtn().setToolTipText("Save record");
        this.view.getUpdatePaymentTbBtn().setToolTipText("Update record");
        this.view.getCancelPaymentTbBtn().setToolTipText("Close");
        this.view.getStatisticsPaymentBtn().setToolTipText("Display statistics");
        this.view.getRentConditionsBtn().setToolTipText("Rent conditions");
    }

    private PropertyOnRentDetails bindFormFields() {
        int rentedBy = 0;
        int rentedByContactId = 0;
        if (this.view.getOthers().isSelected()) {
            rentedBy = 1;
            rentedByContactId = this.view.getRentedByContactId();
        }
        if (this.view.getOthers().isSelected()) {
            rentedByContactId = this.view.getRentedByContactId();
            rentedBy = 1;
        }
        ArrayList<RentDetails> rentDetailList = new ArrayList<RentDetails>();
        int rowCount = this.view.getRentChangeModel().getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            RentDetails rentDetails = new RentDetails((String)this.view.getRentChangeModel().getValueAt(i, 1), (String)this.view.getRentChangeModel().getValueAt(i, 2), Integer.parseInt((String)this.view.getRentChangeModel().getValueAt(i, 3)), this.view.getRentChangeInMonthsTf().getText(), (Integer)this.view.getRentChangeModel().getValueAt(i, 4));
            rentDetailList.add(rentDetails);
        }
        return new PropertyOnRentDetails(this.view.getDateTf().getText(), this.view.getOwnerContactId(), this.view.getTenantContactId(), rentedByContactId, this.view.getOwnerTf().getText(), this.view.getTenantTf().getText(), this.view.getRentedByTf().getText(), Integer.parseInt(this.getView().getDepositTf().getText()), Integer.parseInt(this.getView().getRentTf().getText()), Integer.parseInt(this.view.getBrokerageTf().getText()), Integer.parseInt(this.getView().getTenureInMonthsTf().getText()), rentedBy, this.view.getTenureEndDateLabel().getText(), this.view.getPropOnRentId(), this.view.getPropertyId(), null, null, null, null, null, rentDetailList);
    }

    private boolean isValidForm() {
        boolean isValid = true;
        if (this.view.getOthers().isSelected() && this.view.getRentedByContactId() == 0) {
            JOptionPane.showMessageDialog(this.view.getDio(), "Rented by is mandatory");
            isValid = false;
        }
        if (this.view.getOwnerContactId() == 0) {
            JOptionPane.showMessageDialog(this.view.getDio(), "Owner is mandatory");
            isValid = false;
        } else if (this.view.getTenantContactId() == 0) {
            JOptionPane.showMessageDialog(this.view.getDio(), "Tenant is mandatory");
            isValid = false;
        } else if (this.view.getOwnerContactId() == this.view.getTenantContactId()) {
            JOptionPane.showMessageDialog(this.view.getDio(), "Owner and Tenant cannot be same");
            isValid = false;
        }
        if (this.view.getDepositTf().getText().isEmpty()) {
            JOptionPane.showMessageDialog(this.view.getDio(), "Deposit is mandatory");
            isValid = false;
        } else if (!AppUtility.isValidNumber(this.view.getDepositTf().getText())) {
            isValid = false;
        }
        if (this.view.getTenureInMonthsTf().getText().isEmpty()) {
            JOptionPane.showMessageDialog(this.view.getDio(), "Tenure in months is mandatory");
            isValid = false;
        } else if (!AppUtility.isValidNumber(this.view.getTenureInMonthsTf().getText())) {
            isValid = false;
        }
        return isValid;
    }

    private void populateManagePaymentForm(int paymentTrackerId) {
        this.view.setPaymentTrackerId(paymentTrackerId);
        if (paymentTrackerId > 0) {
            int row = this.view.getTable().getSelectedRow();
            String paymentDate = (String)this.view.getTable().getValueAt(row, 1);
            String selectedMonthYear = (String)this.view.getTable().getValueAt(row, 2);
            String modeOfPayment = (String)this.view.getTable().getValueAt(row, 3);
            String paymentReference = (String)this.view.getTable().getValueAt(row, 4);
            String strAmountInCurrency = (String)this.view.getTable().getValueAt(row, 5);
            String comments = (String)this.view.getTable().getValueAt(row, 6);
            this.view.getPaymentDateTf().setText(paymentDate);
            this.view.getPaymentMonthsAndYearCb().setSelectedItem(selectedMonthYear);
            this.view.getModeOfPaymentCb().setSelectedItem(modeOfPayment);
            this.view.getAmountReferenceTf().setText(paymentReference);
            this.view.getAmountTf().setText(AppUtility.removeCurrencyAndCommas(strAmountInCurrency));
            this.view.getComments().setText(String.valueOf(comments));
        } else {
            int rowCount = this.view.getTable().getRowCount();
            if (rowCount > 0) {
                String monthYear = (String)this.view.getTable().getValueAt(0, 2);
                this.view.getPaymentMonthsAndYearCb().setSelectedItem(monthYear);
                int index = this.view.getPaymentMonthsAndYearCb().getSelectedIndex();
                if (index < this.view.getPaymentMonthsAndYearCb().getItemCount() - 1) {
                    this.view.getPaymentMonthsAndYearCb().setSelectedIndex(index + 1);
                } else {
                    this.view.getPaymentMonthsAndYearCb().setSelectedIndex(index);
                }
            }
            String selectedMonth = Objects.requireNonNull(this.view.getPaymentMonthsAndYearCb().getSelectedItem()).toString().split(" ")[0];
            String selectedYear = this.view.getPaymentMonthsAndYearCb().getSelectedItem().toString().split(" ")[1];
            List<String> MONTHS = Arrays.asList("JANUARY", "FEBRUARY", "MARCH", "APRIL", "MAY", "JUNE", "JULY", "AUGUST", "SEPTEMBER", "OCTOBER", "NOVEMBER", "DECEMBER");
            Calendar calendar = Calendar.getInstance();
            calendar.set(2, MONTHS.indexOf(selectedMonth));
            calendar.set(1, Integer.parseInt(selectedYear));
            String strDate = "1-" + new SimpleDateFormat("MMM").format(calendar.getTime()) + "-" + calendar.get(1);
            this.view.getPaymentDateTf().setText(strDate);
            this.view.getAmountReferenceTf().setText("");
            this.view.getComments().setText("");
            this.view.getAmountTf().setText(this.view.getRentTf().getText());
        }
    }

    private void populateManageDepositForm(int depositId) {
        this.view.setDepositTrackerId(depositId);
        if (depositId > 0) {
            int row = this.view.getDepositTable().getSelectedRow();
            String paymentDate = (String)this.view.getDepositTable().getValueAt(row, 1);
            String modeOfPayment = (String)this.view.getDepositTable().getValueAt(row, 2);
            String paymentReference = (String)this.view.getDepositTable().getValueAt(row, 3);
            String strAmountInCurrency = (String)this.view.getDepositTable().getValueAt(row, 4);
            String comments = (String)this.view.getDepositTable().getValueAt(row, 5);
            this.view.getDepositDateTf().setText(paymentDate);
            this.view.getModeOfDepositCb().setSelectedItem(modeOfPayment);
            this.view.getDepositAmountReferenceTf().setText(paymentReference);
            this.view.getDepositAmountTf().setText(AppUtility.removeCurrencyAndCommas(strAmountInCurrency));
            this.view.getDepositComments().setText(String.valueOf(comments));
        } else {
            this.view.getDepositDateTf().setText(this.view.getDateTf().getText());
            this.view.getDepositAmountReferenceTf().setText("");
            this.view.getDepositComments().setText("");
            this.view.getDepositAmountTf().setText(this.view.getDepositTf().getText());
        }
    }

    private PaymentTrackerDetails bindPaymentDetails() {
        String monthYear = (String)this.view.getPaymentMonthsAndYearCb().getSelectedItem();
        String modeOfPayment = (String)this.view.getModeOfPaymentCb().getSelectedItem();
        int modeOfPaymentId = 0;
        for (ModeOfPayment payment : ModeOfPayment.values()) {
            if (!payment.name().equals(modeOfPayment)) continue;
            modeOfPaymentId = payment.ordinal();
        }
        return new PaymentTrackerDetails(this.view.getPaymentDateTf().getText(), monthYear, modeOfPaymentId, this.view.getAmountReferenceTf().getText(), Integer.parseInt(this.view.getAmountTf().getText()), this.view.getPaymentTrackerId(), this.view.getPropOnRentId(), null, null, this.view.getComments().getText(), AppUtility.convertStringToDate(this.view.getPaymentDateTf().getText()));
    }

    private DepositTrackerDetails bindDepositDetails() {
        String modeOfPayment = (String)this.view.getModeOfDepositCb().getSelectedItem();
        int modeOfPaymentId = 0;
        for (ModeOfPayment payment : ModeOfPayment.values()) {
            if (!payment.name().equals(modeOfPayment)) continue;
            modeOfPaymentId = payment.ordinal();
        }
        return new DepositTrackerDetails(this.view.getDepositDateTf().getText(), modeOfPaymentId, this.view.getDepositAmountReferenceTf().getText(), Integer.parseInt(this.view.getDepositAmountTf().getText()), this.view.getDepositTrackerId(), this.view.getPropOnRentId(), this.view.getDepositComments().getText(), null, "Tenant");
    }

    private void loadChartDataSet(int amountReceived) {
        this.dataset.clear();
        int expectedAmount = Integer.parseInt(this.view.getRentTf().getText()) * Integer.parseInt(this.view.getTenureInMonthsTf().getText());
        this.dataset.addValue(amountReceived, (Comparable)((Object)"Received amount"), (Comparable)((Object)""));
        this.dataset.addValue(expectedAmount, (Comparable)((Object)"Expected amount"), (Comparable)((Object)""));
    }

    private void loadPaymentDetails() {
        try {
            List<PaymentTrackerDetails> details = this.service.loadPaymentDetails(this.view.getPropOnRentId());
            this.view.getStatisticsPaymentBtn().setEnabled(!details.isEmpty());
            this.view.getStatisticPopupMenu().setEnabled(!details.isEmpty());
            this.view.getDefaultTableModel().setRowCount(0);
            AtomicInteger receivedAmount = new AtomicInteger();
            IntStream.range(0, details.size()).forEach(index -> {
                this.view.getDefaultTableModel().addRow(new Object[]{"", "", "", "", "", "", "", ""});
                int amount = ((PaymentTrackerDetails)details.get(index)).amount();
                this.view.getTable().setValueAt(String.valueOf(index + 1), index, 0);
                this.view.getTable().setValueAt(((PaymentTrackerDetails)details.get(index)).paymentDate(), index, 1);
                this.view.getTable().setValueAt(((PaymentTrackerDetails)details.get(index)).monthYear(), index, 2);
                this.view.getTable().setValueAt(ModeOfPayment.paymentCode(((PaymentTrackerDetails)details.get(index)).modeOfPayment()).name(), index, 3);
                this.view.getTable().setValueAt(((PaymentTrackerDetails)details.get(index)).paymentReference(), index, 4);
                this.view.getTable().setValueAt(AppUtility.getFormattedCurrency(String.valueOf(amount)), index, 5);
                this.view.getTable().setValueAt(((PaymentTrackerDetails)details.get(index)).comments(), index, 6);
                this.view.getTable().setValueAt(((PaymentTrackerDetails)details.get(index)).paymentTrackerId(), index, 7);
                receivedAmount.set(receivedAmount.get() + amount);
                this.view.getTable().setAutoCreateRowSorter(true);
            });
            AppUtility.tableZoomInZoomOut(true, this.view.getTable());
            AppUtility.tableZoomInZoomOut(false, this.view.getTable());
            this.loadChartDataSet(receivedAmount.get());
        }
        catch (Exception e) {
            new ErrorDialog(e, "Load payment details");
        }
    }

    private void loadDepositDetails() {
        try {
            List<DepositTrackerDetails> details = this.service.loadDepositDetails(this.view.getPropOnRentId(), "Tenant");
            this.view.getDefaultDepositTableModel().setRowCount(0);
            IntStream.range(0, details.size()).forEach(index -> {
                this.view.getDefaultDepositTableModel().addRow(new Object[]{"", "", "", "", "", "", "", ""});
                int amount = ((DepositTrackerDetails)details.get(index)).amount();
                this.view.getDepositTable().setValueAt(String.valueOf(index + 1), index, 0);
                this.view.getDepositTable().setValueAt(((DepositTrackerDetails)details.get(index)).paymentDate(), index, 1);
                this.view.getDepositTable().setValueAt(ModeOfPayment.paymentCode(((DepositTrackerDetails)details.get(index)).modeOfPayment()).name(), index, 2);
                this.view.getDepositTable().setValueAt(((DepositTrackerDetails)details.get(index)).paymentReference(), index, 3);
                this.view.getDepositTable().setValueAt(AppUtility.getFormattedCurrency(String.valueOf(amount)), index, 4);
                this.view.getDepositTable().setValueAt(((DepositTrackerDetails)details.get(index)).comments(), index, 5);
                this.view.getDepositTable().setValueAt(((DepositTrackerDetails)details.get(index)).depositTrackerId(), index, 6);
                this.view.getDepositTable().setAutoCreateRowSorter(true);
            });
            AppUtility.tableZoomInZoomOut(true, this.view.getDepositTable());
            AppUtility.tableZoomInZoomOut(false, this.view.getDepositTable());
        }
        catch (Exception e) {
            new ErrorDialog(e, "load deposit details");
        }
    }

    private PropertyTerminationDetails bindTerminationForm() {
        String modeOfPayment = (String)this.view.getDepositRefundMode().getSelectedItem();
        int modeOfPaymentId = 0;
        for (ModeOfPayment payment : ModeOfPayment.values()) {
            if (!payment.name().equals(modeOfPayment)) continue;
            modeOfPaymentId = payment.ordinal();
        }
        return new PropertyTerminationDetails(this.view.getTerminationReasonTextArea().getText(), this.view.getPropOnRentId(), this.view.getPropertyId(), (String)this.view.getNewPropertyStatusCb().getSelectedItem(), this.view.getTerminationDateTf().getText(), new DepositTrackerDetails(this.view.getDepositRefundDate().getText(), modeOfPaymentId, this.view.getDepositRefundReference().getText(), Integer.parseInt(this.view.getDepositRefundAmount().getText()), 0, this.view.getPropOnRentId(), "", null, "Owner"));
    }

    private boolean isValidTerminationForm() {
        if (this.view.getDepositRefundAmount().getText().isEmpty()) {
            JOptionPane.showMessageDialog(this.view.getDio(), "Refund amount is mandatory", "Error", 0);
            return false;
        }
        if (this.view.getTerminationReasonTextArea().getText().isEmpty()) {
            JOptionPane.showMessageDialog(this.view.getDio(), "Reason is mandatory", "Error", 0);
            this.view.getTerminationReasonTextArea().requestFocus();
            return false;
        }
        return true;
    }

    private List<String[]> divideDateRange(String startDateStr, int numberOfCycles) throws ParseException {
        ArrayList<String[]> cycleMonths = new ArrayList<String[]>();
        SimpleDateFormat sdfInput = new SimpleDateFormat("dd-MMM-yyyy");
        SimpleDateFormat sdfOutput = new SimpleDateFormat("MMMM-yyyy");
        if (startDateStr.split("-")[0].length() == 2) {
            startDateStr = startDateStr.replaceFirst("\\d{2}", "1");
        }
        LocalDate endDate = AppUtility.convertStringToDate(startDateStr).plusMonths(Long.parseLong(this.view.getTenureInMonthsTf().getText())).minusDays(1L);
        String endDateStr = AppUtility.convertDatetoString(endDate);
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.setTime(sdfInput.parse(startDateStr));
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(sdfInput.parse(endDateStr));
        long totalMonths = (long)(endCalendar.get(1) - startCalendar.get(1)) * 12L + (long)endCalendar.get(2) - (long)startCalendar.get(2) + 1L;
        int monthsPerCycle = (int)Math.ceil((double)totalMonths / (double)numberOfCycles);
        for (int i = 0; i < numberOfCycles; ++i) {
            String cycleStart = sdfOutput.format(startCalendar.getTime());
            startCalendar.add(2, monthsPerCycle - 1);
            if (startCalendar.after(endCalendar)) {
                startCalendar.setTime(endCalendar.getTime());
            }
            String cycleEnd = sdfOutput.format(startCalendar.getTime());
            cycleMonths.add(new String[]{cycleStart, cycleEnd});
            startCalendar.add(2, 1);
        }
        return cycleMonths;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int selection;
        int row;
        Object obj = e.getSource();
        if (obj == this.view.getCloseRentBtn()) {
            this.view.getRentConditionDialog().setVisible(false);
        }
        if (obj == this.view.getRentChangeZoomIn()) {
            AppUtility.tableZoomInZoomOut(true, this.view.getRentChangeTable());
        }
        if (obj == this.view.getRentChangeZoomOut()) {
            AppUtility.tableZoomInZoomOut(false, this.view.getRentChangeTable());
        }
        if (obj == this.view.getCalculate()) {
            int tenureInMonths;
            int rentRevisedInMonths = Integer.parseInt(this.view.getRentChangeInMonthsTf().getText());
            if (rentRevisedInMonths > (tenureInMonths = Integer.parseInt(this.view.getTenureInMonthsTf().getText()))) {
                JOptionPane.showMessageDialog(this.view.getRentConditionDialog(), "Rent revised in months must be less than agreement tenure in months", "Error Message", 0);
            } else if (tenureInMonths % rentRevisedInMonths != 0) {
                JOptionPane.showMessageDialog(this.view.getRentConditionDialog(), "No of rent revision must be equal durations ", "Error Message", 0);
            } else {
                int numberOfCycles = tenureInMonths / rentRevisedInMonths;
                this.view.getRentChangeModel().setRowCount(0);
                String startDate = this.view.getDateTf().getText();
                try {
                    List<String[]> cycleDates = this.divideDateRange(startDate, numberOfCycles);
                    int count = 1;
                    for (String[] dates : cycleDates) {
                        this.view.getRentChangeModel().addRow(new Object[]{count, dates[0], dates[1], this.view.getRentTf().getText(), 0});
                        ++count;
                    }
                }
                catch (ParseException ex) {
                    JOptionPane.showMessageDialog(this.view.getRentConditionDialog(), ex.getMessage(), "Error Message", 0);
                }
            }
        }
        if (obj == this.view.getRentConditionsBtn()) {
            this.view.getRentConditionDialog().setVisible(true);
        }
        if (obj == this.view.getDepositRefundDateBtn()) {
            CustomDatePicker customDatePicker = new CustomDatePicker(this, "depositRefundDate");
            AppUtility.setDialogLocationInCenter(customDatePicker.getDio());
            customDatePicker.getDio().setVisible(true);
        }
        if (obj == this.view.getDepositZoomInBtn()) {
            AppUtility.tableZoomInZoomOut(true, this.view.getDepositTable());
        }
        if (obj == this.view.getDepositZoomOutBtn()) {
            AppUtility.tableZoomInZoomOut(false, this.view.getDepositTable());
        }
        if (obj == this.view.getCreateDepositBtn() || obj == this.view.getAddDepositPopupMenu()) {
            this.view.getSaveDepositTbBtn().setVisible(true);
            this.view.getUpdateDepositTbBtn().setVisible(false);
            this.populateManageDepositForm(0);
            this.view.getManageDepositDio().setVisible(true);
        }
        if (obj == this.view.getUpdateDepositBtn() || obj == this.view.getUpdateDepositPopupMenu()) {
            int row2 = this.view.getDepositTable().getSelectedRow();
            if (row2 >= 0) {
                int depositId = (Integer)this.view.getDepositTable().getValueAt(row2, 6);
                try {
                    this.view.getSaveDepositTbBtn().setVisible(false);
                    this.view.getUpdateDepositTbBtn().setVisible(true);
                    this.populateManageDepositForm(depositId);
                    this.view.getManageDepositDio().setVisible(true);
                    this.loadDepositDetails();
                }
                catch (Exception ex) {
                    new ErrorDialog(ex, "updateDepositBtn");
                }
            } else {
                JOptionPane.showMessageDialog(this.view.getPaymentTrackerDio(), "Select any record to delete");
            }
        }
        if (obj == this.view.getUpdateDepositTbBtn()) {
            if (this.view.getDepositAmountTf().getText().isEmpty()) {
                JOptionPane.showMessageDialog(this.view.getManagePaymentDio(), "Amount is mandatory", "Warning Message", 2);
            } else {
                try {
                    this.service.updateDepositDetails(this.bindDepositDetails());
                    JOptionPane.showMessageDialog(this.view.getManagePaymentDio(), "Updated successfully");
                    this.loadDepositDetails();
                    this.view.getManageDepositDio().setVisible(false);
                }
                catch (Exception ex) {
                    new ErrorDialog(ex, "updateDepositTbBtn");
                }
            }
        }
        if ((obj == this.view.getDeleteDepositBtn() || obj == this.view.getDeleteDepositPopupMenu()) && (row = this.view.getDepositTable().getSelectedRow()) >= 0) {
            int depositTrackerId = (Integer)this.view.getDepositTable().getValueAt(row, 6);
            int choose = JOptionPane.showConfirmDialog(this.view.getPaymentTrackerDio(), "Are you sure to delete ?", "Delete record", 1);
            if (choose == 0) {
                try {
                    this.service.deleteDepositDetails(depositTrackerId);
                    JOptionPane.showMessageDialog(this.view.getPaymentTrackerDio(), "Deleted successfully");
                    this.loadDepositDetails();
                }
                catch (Exception ex) {
                    new ErrorDialog(ex, "deleteDepositBtn");
                }
            }
        }
        if (obj == this.view.getSaveDepositTbBtn()) {
            if (this.view.getDepositAmountTf().getText().isEmpty()) {
                JOptionPane.showMessageDialog(this.view.getManagePaymentDio(), "Amount is mandatory", "Warning Message", 2);
                this.view.getDepositAmountTf().requestFocus();
            } else {
                try {
                    this.view.setDepositTrackerId(0);
                    this.service.saveDepositDetails(this.bindDepositDetails());
                    JOptionPane.showMessageDialog(this.view.getManagePaymentDio(), "Saved successfully");
                    this.loadDepositDetails();
                    this.view.getManageDepositDio().setVisible(false);
                }
                catch (Exception ex) {
                    new ErrorDialog(ex, "saveDepositTbBtn");
                }
            }
        }
        if (obj == this.view.getCancelDepositTbBtn()) {
            this.view.getManageDepositDio().setVisible(false);
        }
        if (obj == this.view.getDepositDateBtn()) {
            CustomDatePicker customDatePicker = new CustomDatePicker(this, "depositDate");
            AppUtility.setDialogLocationInCenter(customDatePicker.getDio());
            customDatePicker.getDio().setVisible(true);
        }
        if (obj == this.view.getStatisticsPaymentBtn() || obj == this.view.getStatisticPopupMenu()) {
            new DisplayBarChart(this.dataset, "Comparison of received and expected amount", this, 600, 400);
        }
        if (obj == this.view.getZoomInBtn()) {
            AppUtility.tableZoomInZoomOut(true, this.view.getTable());
        }
        if (obj == this.view.getZoomOutBtn()) {
            AppUtility.tableZoomInZoomOut(false, this.view.getTable());
        }
        if (obj == this.view.getTerminationDateBtn()) {
            CustomDatePicker customDatePicker = new CustomDatePicker(this, "terminationDate");
            AppUtility.setDialogLocationInCenter(customDatePicker.getDio());
            customDatePicker.getDio().setVisible(true);
        }
        if (obj == this.view.getPaymentDateBtn()) {
            CustomDatePicker customDatePicker = new CustomDatePicker(this, "paymentDate");
            AppUtility.setDialogLocationInCenter(customDatePicker.getDio());
            customDatePicker.getDio().setVisible(true);
        }
        if (obj == this.view.getTerminationSave() && this.isValidTerminationForm() && (selection = JOptionPane.showConfirmDialog(this.view.getTerminationDialog(), "Are you sure to terminate ", "Termination Record", 0)) == 0) {
            try {
                this.service.terminateRecord(this.bindTerminationForm());
                JOptionPane.showMessageDialog(this.view.getTerminationDialog(), "Terminated successfully");
                this.view.getTerminationDialog().setVisible(false);
                this.view.getDio().setVisible(false);
            }
            catch (Exception ex) {
                new ErrorDialog(ex, "terminationSave");
            }
        }
        if (obj == this.view.getTerminationCancel()) {
            this.view.getTerminationDialog().setVisible(false);
        }
        if (obj == this.view.getRenewalBtn()) {
            this.view.getRenewalBtn().setVisible(false);
            this.view.getTerminateBtn().setVisible(false);
            this.view.getPaymentTrackerBtn().setVisible(false);
            this.view.getUpdateBtn().setVisible(false);
            this.view.getSaveBtn().setVisible(true);
            this.view.getTenantContactBtn().setEnabled(false);
            this.view.getDepositTf().setEditable(true);
            this.view.getRentTf().setEditable(true);
            this.view.getBrokerageTf().setEditable(true);
            this.view.getTenureInMonthsTf().setEditable(true);
            LocalDate startDate = AppUtility.convertStringToDate(this.view.getTenureEndDateLabel().getText()).plusDays(1L);
            this.view.getDateTf().setText(AppUtility.convertDatetoString(startDate));
            this.view.getDateBtn().setEnabled(true);
            String agreementStartDate = this.view.getDateTf().getText().trim();
            LocalDate date = AppUtility.convertStringToDate(agreementStartDate).plusMonths(11L).minusDays(1L);
            this.view.getTenureEndDateLabel().setText(AppUtility.convertDatetoString(date));
        }
        if (obj == this.view.getUpdatePaymentTbBtn()) {
            if (this.view.getAmountTf().getText().isEmpty()) {
                JOptionPane.showMessageDialog(this.view.getManagePaymentDio(), "Amount is mandatory", "Error Message", 0);
            } else {
                try {
                    this.service.updatePaymentDetails(this.bindPaymentDetails());
                    JOptionPane.showMessageDialog(this.view.getManagePaymentDio(), "Updated successfully");
                    this.loadPaymentDetails();
                    this.view.getManagePaymentDio().setVisible(false);
                }
                catch (Exception ex) {
                    new ErrorDialog(ex, "updatePaymentTbBtn");
                }
            }
        }
        if (obj == this.view.getSavePaymentTbBtn()) {
            if (this.view.getAmountTf().getText().isEmpty()) {
                JOptionPane.showMessageDialog(this.view.getManagePaymentDio(), "Amount is mandatory", "Warning Message", 2);
                this.view.getAmountTf().requestFocus();
            } else {
                try {
                    this.service.savePaymentDetails(this.bindPaymentDetails());
                    JOptionPane.showMessageDialog(this.view.getManagePaymentDio(), "Saved successfully");
                    this.loadPaymentDetails();
                    this.view.getManagePaymentDio().setVisible(false);
                }
                catch (Exception ex) {
                    new ErrorDialog(ex, "savePaymentTbBtn");
                }
            }
        }
        if (obj == this.view.getCancelPaymentTbBtn()) {
            this.view.getManagePaymentDio().setVisible(false);
        }
        if (obj == this.view.getRefPopupMenu()) {
            this.loadPaymentDetails();
        }
        if (obj == this.view.getDeletePaymentBtn() || obj == this.view.getDeletePopupMenu()) {
            int row3 = this.view.getTable().getSelectedRow();
            if (row3 >= 0) {
                int paymentTrackerId = (Integer)this.view.getTable().getValueAt(row3, 7);
                int choose = JOptionPane.showConfirmDialog(this.view.getPaymentTrackerDio(), "Are you sure to delete ?", "Delete record", 1);
                if (choose == 0) {
                    try {
                        this.service.deletePaymentDetails(paymentTrackerId);
                        JOptionPane.showMessageDialog(this.view.getPaymentTrackerDio(), "Deleted successfully");
                        this.loadPaymentDetails();
                    }
                    catch (Exception ex) {
                        new ErrorDialog(ex, "deletePaymentBtn");
                    }
                }
            } else {
                JOptionPane.showMessageDialog(this.view.getPaymentTrackerDio(), "Select any record to delete");
            }
        }
        if (obj == this.view.getUpdatePaymentBtn() || obj == this.view.getUpdatePopupMenu()) {
            int row4 = this.view.getTable().getSelectedRow();
            if (row4 >= 0) {
                int paymentTrackerId = (Integer)this.view.getTable().getValueAt(row4, 7);
                try {
                    this.view.getSavePaymentTbBtn().setVisible(false);
                    this.view.getUpdatePaymentTbBtn().setVisible(true);
                    this.populateManagePaymentForm(paymentTrackerId);
                    this.view.getManagePaymentDio().setVisible(true);
                    this.loadPaymentDetails();
                }
                catch (Exception ex) {
                    new ErrorDialog(ex, "updatePaymentBtn");
                }
            } else {
                JOptionPane.showMessageDialog(this.view.getPaymentTrackerDio(), "Select any record to delete");
            }
        }
        if (obj == this.view.getCreatePaymentBtn() || obj == this.view.getAddPopupMenu()) {
            this.view.getSavePaymentTbBtn().setVisible(true);
            this.view.getUpdatePaymentTbBtn().setVisible(false);
            this.populateManagePaymentForm(0);
            this.view.getManagePaymentDio().setVisible(true);
            this.loadPaymentDetails();
        }
        if (obj == this.view.getPaymentTrackerBtn()) {
            this.view.getPaymentTrackerDio().setTitle("Payment Tracker :" + this.view.getDateTf().getText() + " to " + this.view.getTenureEndDateLabel().getText());
            this.view.getPartyDetailsLabel().setText("Owner : " + this.view.getOwnerTf().getText() + " , Tenant : " + this.view.getTenantTf().getText() + "  ");
            this.view.getMainTabs().setSelectedIndex(1);
            this.view.getPaymentTrackerDio().setVisible(true);
            LocalDate startDate = AppUtility.convertStringToDate(this.view.getDateTf().getText());
            YearMonth startYearMonth = YearMonth.from(startDate);
            YearMonth endYearMonth = YearMonth.from(LocalDate.now());
            this.view.getPaymentMonthsAndYearCb().removeAllItems();
            while (startYearMonth.isBefore(endYearMonth) || startYearMonth.equals(endYearMonth)) {
                this.view.getPaymentMonthsAndYearCb().addItem(startYearMonth.getMonth().toString() + " " + startYearMonth.getYear());
                startYearMonth = startYearMonth.plusMonths(1L);
            }
            this.view.getModeOfPaymentCb().removeAllItems();
            this.view.getModeOfDepositCb().removeAllItems();
            for (ModeOfPayment payment : ModeOfPayment.values()) {
                this.view.getModeOfPaymentCb().addItem(payment.toString());
                this.view.getModeOfDepositCb().addItem(payment.toString());
            }
            this.loadPaymentDetails();
        }
        if (obj == this.view.getTerminateBtn()) {
            this.view.getDepositRefundMode().removeAllItems();
            for (ModeOfPayment payment : ModeOfPayment.values()) {
                this.view.getDepositRefundMode().addItem(payment.toString());
            }
            this.view.getTerminationDateTf().setText(AppUtility.getCurrentDateInString());
            this.view.getDepositRefundDate().setText(AppUtility.getCurrentDateInString());
            this.view.getDepositAmountReferenceTf().setText("");
            this.view.getDepositRefundAmount().setText(this.view.getDepositTf().getText());
            this.view.getTerminationReasonTextArea().setText("");
            this.view.getTerminationDialog().setVisible(true);
        }
        if (obj == this.view.getSelf()) {
            this.view.getRentedByContactBtn().setVisible(false);
            this.view.getRentedByTf().setVisible(false);
            this.view.getRentedByTf().setText("");
            this.view.setRentedByContactId(0);
        }
        if (obj == this.view.getOthers()) {
            this.view.getRentedByContactBtn().setVisible(true);
            this.view.getRentedByTf().setVisible(true);
        }
        if (obj == this.view.getRentedByContactBtn()) {
            ContactDialogView contactDio = new ContactDialogView(this, "rentedBy", "Select an agent name");
            AppUtility.setDialogLocationInCenter(contactDio.getDio());
            contactDio.getDio().setVisible(true);
        }
        if (obj == this.view.getUpdateBtn() && this.isValidForm()) {
            try {
                this.service.updateOnRentDetails(this.bindFormFields());
                JOptionPane.showMessageDialog(this.view.getDio(), "Updated successfully");
                this.view.getDio().setVisible(false);
            }
            catch (Exception ex) {
                new ErrorDialog(ex, "updateBtn");
            }
        }
        if (obj == this.view.getSaveBtn() && this.isValidForm()) {
            try {
                this.service.saveOnRentDetails(this.bindFormFields());
                JOptionPane.showMessageDialog(this.view.getDio(), "Saved successfully");
                this.view.getDio().setVisible(false);
            }
            catch (Exception ex) {
                new ErrorDialog(ex, "saveBtn");
            }
        }
        if (obj == this.view.getOwnerContactBtn()) {
            ContactDialogView contactDio = new ContactDialogView(this, "owner", "Select a owner name");
            AppUtility.setDialogLocationInCenter(contactDio.getDio());
            contactDio.getDio().setVisible(true);
        }
        if (obj == this.view.getTenantContactBtn()) {
            ContactDialogView contactDio = new ContactDialogView(this, "Tenant", "Select a tenant name");
            AppUtility.setDialogLocationInCenter(contactDio.getDio());
            contactDio.getDio().setVisible(true);
        }
        if (obj == this.view.getDateBtn()) {
            CustomDatePicker customDatePicker = new CustomDatePicker(this, "startDate");
            AppUtility.setDialogLocationInCenter(customDatePicker.getDio());
            customDatePicker.getDio().setVisible(true);
        }
        if (obj == this.view.getCloseBtn()) {
            this.view.getDio().setVisible(false);
        }
    }

    public void calculateTenureEndDate() {
        String months = this.view.getTenureInMonthsTf().getText();
        if (AppUtility.isValidNumber(months) && !this.view.getDateTf().getText().isEmpty()) {
            try {
                String agreementStartDate = this.view.getDateTf().getText().trim();
                LocalDate date = AppUtility.convertStringToDate(agreementStartDate).plusMonths(Long.parseLong(months)).minusDays(1L);
                this.view.getTenureEndDateLabel().setText(AppUtility.convertDatetoString(date));
            }
            catch (Exception ex) {
                new ErrorDialog(ex, "calculateTenureEndDate");
            }
        }
    }

    public PropertyOnRent getView() {
        return this.view;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.view.getSelectionModel()) {
            if (this.view.getTable().getSelectedRow() >= 0) {
                this.view.getUpdatePaymentBtn().setEnabled(true);
                this.view.getDeletePaymentBtn().setEnabled(true);
                this.view.getDeletePopupMenu().setEnabled(true);
                this.view.getUpdatePopupMenu().setEnabled(true);
            } else {
                this.view.getUpdatePaymentBtn().setEnabled(false);
                this.view.getDeletePaymentBtn().setEnabled(false);
                this.view.getDeletePopupMenu().setEnabled(false);
                this.view.getUpdatePopupMenu().setEnabled(false);
            }
        }
        if (e.getSource() == this.view.getSelectionDepositModel()) {
            if (this.view.getDepositTable().getSelectedRow() >= 0) {
                this.view.getUpdateDepositBtn().setEnabled(true);
                this.view.getDeleteDepositBtn().setEnabled(true);
            } else {
                this.view.getUpdateDepositBtn().setEnabled(false);
                this.view.getDeleteDepositBtn().setEnabled(false);
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        String strTitle;
        Object obj = e.getSource();
        if (obj == this.view.getMainTabs() && "Deposit Details".equals(strTitle = this.view.getMainTabs().getTitleAt(this.view.getMainTabs().getSelectedIndex()))) {
            this.loadDepositDetails();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        Object obj = e.getSource();
        if (obj == this.getView().getTenureInMonthsTf()) {
            this.calculateTenureEndDate();
        }
    }
}

