/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.controller.property;

import com.arun.bhardwaj.cache.PropertyGroupCache;
import com.arun.bhardwaj.exceptions.ServiceException;
import com.arun.bhardwaj.model.property.FurnitureStatus;
import com.arun.bhardwaj.model.property.PropertyAdditionalDetails;
import com.arun.bhardwaj.model.property.PropertyOfferedBy;
import com.arun.bhardwaj.model.property.PropertyRecord;
import com.arun.bhardwaj.model.property.PropertyStatus;
import com.arun.bhardwaj.service.property.PropertyRecordService;
import com.arun.bhardwaj.service.property.PropertyRecordServiceImpl;
import com.arun.bhardwaj.utility.AppUtility;
import com.arun.bhardwaj.view.common.ContactDialogView;
import com.arun.bhardwaj.view.common.CustomDatePicker;
import com.arun.bhardwaj.view.common.ErrorDialog;
import com.arun.bhardwaj.view.property.PropertyCategory;
import com.arun.bhardwaj.view.property.PropertyRecordView;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PropertyRecordController
implements ActionListener,
ChangeListener {
    private final PropertyRecordView view;
    private final PropertyCategory propertyCategory;
    private final PropertyRecordService service;

    public PropertyRecordController(PropertyRecordView view) {
        this.view = view;
        this.propertyCategory = new PropertyCategory();
        this.service = new PropertyRecordServiceImpl();
        this.addActionEvent();
        this.addToolTip();
        this.view.getFurnishingStatusCB().removeAllItems();
        for (FurnitureStatus furnitureStatus : FurnitureStatus.values()) {
            this.view.getFurnishingStatusCB().addItem(furnitureStatus.toString());
        }
        this.view.getOfferedByCB().removeAllItems();
        for (Enum enum_ : PropertyOfferedBy.values()) {
            this.view.getOfferedByCB().addItem(enum_.toString());
        }
        view.getTabbedPane().setEnabledAt(1, false);
        this.loadGroups();
    }

    private PropertyRecord bindFormFields() {
        String profferedByType = (String)this.view.getOfferedByCB().getSelectedItem();
        Optional<PropertyOfferedBy> offeredByType = Arrays.stream(PropertyOfferedBy.values()).filter(offBy -> offBy.name().equals(profferedByType)).findAny();
        String strFurnitureStatus = (String)this.view.getFurnishingStatusCB().getSelectedItem();
        Optional<FurnitureStatus> furnitureStatus = Arrays.stream(FurnitureStatus.values()).filter(furStatus -> furStatus.name().equals(strFurnitureStatus)).findAny();
        String selectedCategory = (String)PropertyRecordView.getGroupNames().getSelectedItem();
        int groupId = PropertyGroupCache.getGroupIdByName(selectedCategory);
        int propertyStatus = this.getPropertyStatus();
        return new PropertyRecord.Builder().date(this.view.getDateTf().getText()).address(this.view.getAddressTf().getText()).location(this.view.getLocationTf().getText()).city(this.view.getCityTf().getText()).pin(this.view.getPinTf().getText()).deposit(Integer.parseInt(this.view.getDepositTf().getText().isEmpty() ? "0" : this.view.getDepositTf().getText())).rent(Integer.parseInt(this.view.getRentTf().getText().isEmpty() ? "0" : this.view.getRentTf().getText())).price(Integer.parseInt(this.view.getPriceTf().getText().isEmpty() ? "0" : this.view.getPriceTf().getText())).areaInSqFt(Integer.parseInt(this.view.getAreaInSqftTf().getText().isEmpty() ? "0" : this.view.getAreaInSqftTf().getText())).offeredByType(offeredByType.get().ordinal()).furnishingStatus(furnitureStatus.get().ordinal()).comments(this.view.getCommentsTextArea().getText()).fkGroupId(groupId).fkContactId(Integer.parseInt(PropertyRecordView.getOfferedByNameIdTf().getText())).leaseId(this.view.getLeaseId()).localDate(AppUtility.convertStringToDate(this.view.getDateTf().getText())).propertyStatus(propertyStatus).unAvailableUntil(this.view.getUnAvailableUntilTf().getText()).build();
    }

    private int getPropertyStatus() {
        int propertyStatus = this.view.getForRent().isSelected() && this.view.getForSell().isSelected() ? PropertyStatus.FOR_RENT_AND_SELL.ordinal() : (this.view.getForRent().isSelected() ? PropertyStatus.FOR_RENT.ordinal() : (this.view.getForSell().isSelected() ? PropertyStatus.FOR_SELL.ordinal() : (this.view.getOnRent().isSelected() ? PropertyStatus.ON_RENT.ordinal() : PropertyStatus.NOT_FOR_RENT_OR_SELL.ordinal())));
        return propertyStatus;
    }

    private void addToolTip() {
        this.view.getContactBtn().setToolTipText("Choose name from contacts");
        this.view.getForSell().setToolTipText("Available for sell");
        this.view.getForRent().setToolTipText("Available for rent");
        this.view.getSaveBtn().setToolTipText("Save");
        this.view.getUpdateBtn().setToolTipText("Update");
        this.view.getCloseBtn().setToolTipText("Close");
        this.view.getAddNewGroup().setToolTipText("Add new property group");
        this.view.getAreaConversionBtn().setToolTipText("Area conversion");
        PropertyRecordView.getGroupNames().setToolTipText("Select group name");
    }

    private void addActionEvent() {
        this.view.getContactBtn().addActionListener(this);
        this.view.getSaveBtn().addActionListener(this);
        this.view.getUpdateBtn().addActionListener(this);
        this.view.getCloseBtn().addActionListener(this);
        this.view.getDateBtn().addActionListener(this);
        this.view.getAddNewGroup().addActionListener(this);
        this.view.getAreaConversionBtn().addActionListener(this);
        this.view.getForRent().addActionListener(this);
        this.view.getForSell().addActionListener(this);
        this.view.getOfferedByCB().addActionListener(this);
        this.view.getAddAdditionalDetailsButton().addActionListener(this);
        this.view.getClearAdditionalDetailsButton().addActionListener(this);
        this.view.getDeleteAdditionalDetailsPopupMenu().addActionListener(this);
        this.view.getTabbedPane().addChangeListener(this);
        this.view.getUnAvailable().addActionListener(this);
        this.view.getUnAvailableUntilBtn().addActionListener(this);
    }

    public void loadGroups() {
        PropertyRecordView.getGroupNames().removeAllItems();
        Map<Integer, String> leaseGroupDts = PropertyGroupCache.getGroupIdToNameMap();
        leaseGroupDts.forEach((key, value) -> PropertyRecordView.getGroupNames().addItem(value));
    }

    private void changeLabels() {
        if (this.view.getForRent().isSelected() && this.view.getForSell().isSelected()) {
            this.view.getDepositLabel().setText("<html>Deposit<span style='color: red;'>*</span></html>");
            this.view.getRentLabel().setText("<html>Rent<span style='color: red;'>*</span></html>");
            this.view.getSellingPriceLabel().setText("<html>Selling Price<span style='color: red;'>*</span></html>");
        } else if (this.view.getForRent().isSelected()) {
            this.view.getDepositLabel().setText("<html>Deposit<span style='color: red;'>*</span></html>");
            this.view.getRentLabel().setText("<html>Rent<span style='color: red;'>*</span> </html>");
            this.view.getSellingPriceLabel().setText("Selling Price");
        } else if (this.view.getForSell().isSelected()) {
            this.view.getDepositLabel().setText("Deposit");
            this.view.getRentLabel().setText("Rent : ");
            this.view.getSellingPriceLabel().setText("<html>Selling Price<span style='color: red;'>*</span></html>");
        } else {
            this.view.getDepositLabel().setText("Deposit");
            this.view.getRentLabel().setText("Rent  ");
            this.view.getSellingPriceLabel().setText("Selling Price");
            this.view.getUnAvailable().setSelected(true);
            this.unAvailableProperty();
        }
        if (this.view.getOfferedByCB().getSelectedItem().equals("DIRECT")) {
            this.view.getPartyNameLabel().setText("<html>Owner's Name<span style='color: red;'>*</span></html>");
        } else {
            this.view.getPartyNameLabel().setText("<html>Agent's Name<span style='color: red;'>*</span></html>");
        }
    }

    private void unAvailableProperty() {
        this.view.getForSell().setVisible(false);
        this.view.getForRent().setVisible(false);
        this.view.getUnAvailableUntilTf().setVisible(true);
        this.view.getUnAvailableUntilBtn().setVisible(true);
        this.view.getForRent().setSelected(false);
        this.view.getForSell().setSelected(false);
        this.view.getAvailabilityLabel().setText("<html>Unavailable until <span style='color: red;'>*</span> </html>");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj == this.view.getUnAvailableUntilBtn()) {
            CustomDatePicker customDatePicker = new CustomDatePicker(this, "unavailableUntil");
            AppUtility.setDialogLocationInCenter(customDatePicker.getDio());
            customDatePicker.getDio().setVisible(true);
        }
        if (obj == this.view.getUnAvailable()) {
            this.view.getUnAvailableUntilTf().setText("");
            if (this.view.getUnAvailable().isSelected()) {
                this.unAvailableProperty();
            } else {
                this.view.getForSell().setVisible(true);
                this.view.getForRent().setVisible(true);
                this.view.getUnAvailableUntilTf().setVisible(false);
                this.view.getUnAvailableUntilBtn().setVisible(false);
                this.view.getForRent().setSelected(true);
                this.view.getForSell().setSelected(false);
                this.view.getAvailabilityLabel().setText("<html>Available for <span style='color: red;'>*</span> </html>");
            }
            this.changeLabels();
        }
        if (obj == this.view.getDeleteAdditionalDetailsPopupMenu()) {
            try {
                int row = this.view.getAdditionalDetailsTable().getSelectedRow();
                int additionalId = (Integer)this.view.getAdditionalDetailsTable().getValueAt(row, 0);
                String name = (String)this.view.getAdditionalDetailsTable().getValueAt(row, 1);
                int choose = JOptionPane.showConfirmDialog(this.view.getDio(), String.format("Are you sure you want to delete the record   \"%s\" ?", name), "Delete", 1);
                if (choose == 0) {
                    PropertyAdditionalDetails propertyAdditionalDetails = new PropertyAdditionalDetails(additionalId, "", "", this.view.getLeaseId());
                    this.service.deleteAdditionalDetails(propertyAdditionalDetails);
                    JOptionPane.showMessageDialog(this.view.getDio(), "Successfully deleted !", "Success", 1);
                    this.loadAdditionalDetails(this.view.getLeaseId());
                }
            }
            catch (ServiceException ex) {
                new ErrorDialog(ex, "Delete Additional details");
            }
        }
        if (obj == this.view.getAddAdditionalDetailsButton()) {
            try {
                if (this.view.getAdditionalDetailsValueTf().getText().trim().isEmpty() || this.view.getAdditionalDetailsNameTf().getText().trim().isEmpty()) {
                    JOptionPane.showMessageDialog(this.view.getDio(), "Name and value both are mandatory", "Error", 0);
                    if (this.view.getAdditionalDetailsNameTf().getText().trim().isBlank()) {
                        this.view.getAdditionalDetailsNameTf().requestFocus();
                    } else {
                        this.view.getAdditionalDetailsValueTf().requestFocus();
                    }
                } else {
                    PropertyAdditionalDetails propertyAdditionalDetails = new PropertyAdditionalDetails(0, this.view.getAdditionalDetailsNameTf().getText().trim(), this.view.getAdditionalDetailsValueTf().getText().trim(), this.view.getLeaseId());
                    this.service.addAdditionalDetails(propertyAdditionalDetails);
                    JOptionPane.showMessageDialog(this.view.getDio(), "Successfully saved !", "Success", 1);
                    this.loadAdditionalDetails(this.view.getLeaseId());
                    this.view.getAdditionalDetailsValueTf().setText("");
                    this.view.getAdditionalDetailsNameTf().setText("");
                }
            }
            catch (ServiceException ex) {
                new ErrorDialog(ex, "Add amenities");
            }
        }
        if (obj == this.view.getClearAdditionalDetailsButton()) {
            this.view.getAdditionalDetailsNameTf().setText("");
            this.view.getAdditionalDetailsValueTf().setText("");
        }
        if (obj == this.view.getOfferedByCB()) {
            this.changeLabels();
        }
        if (obj == this.view.getForRent()) {
            this.changeLabels();
        }
        if (obj == this.view.getForSell()) {
            this.changeLabels();
        }
        if (obj == this.view.getAreaConversionBtn() && !this.view.getAreaInSqftTf().getText().trim().isEmpty()) {
            double sqft = Double.parseDouble(this.view.getAreaInSqftTf().getText());
            double sqm = sqft * 0.092903;
            double sqin = sqft * 144.0;
            double sqyd = sqft * 0.111111;
            double acres = sqft * 2.2957E-5;
            double hectares = sqft * 9.2903E-6;
            String message = String.format("<html><body><h2>Conversions for %.2f sqft:</h2><table border='1' cellpadding='4' cellspacing='0'><tr><td>Square Meters:</td><td>%.4f sqm</td></tr><tr><td>Square Inches:</td><td>%.2f sqin</td></tr><tr><td>Square Yards:</td><td>%.4f sqyd</td></tr><tr><td>Acres:</td><td>%.6f acres</td></tr><tr><td>Hectares:</td><td>%.6f hectares</td></tr></table></body></html>", sqft, sqm, sqin, sqyd, acres, hectares);
            JEditorPane editorPane = new JEditorPane("text/html", message);
            editorPane.setEditable(false);
            JScrollPane scrollPane = new JScrollPane(editorPane);
            JOptionPane.showMessageDialog(null, scrollPane, "Area Conversions", 1);
        }
        if (obj == this.view.getAddNewGroup()) {
            this.propertyCategory.getDio().setTitle("New Group");
            this.propertyCategory.getSaveBtn().setVisible(true);
            this.propertyCategory.getUpdateBtn().setVisible(false);
            this.propertyCategory.getValidationError().setVisible(false);
            this.propertyCategory.getGroupNameField().setText("");
            this.propertyCategory.getDio().setVisible(true);
            this.loadGroups();
        }
        if (obj == this.view.getDateBtn()) {
            CustomDatePicker customDatePicker = new CustomDatePicker(this, "dateTf");
            AppUtility.setDialogLocationInCenter(customDatePicker.getDio());
            customDatePicker.getDio().setVisible(true);
        }
        if (obj == this.getView().getUpdateBtn()) {
            try {
                if (this.isValidForm()) {
                    PropertyRecord record = this.bindFormFields();
                    this.service.updateLeaseRecord(record);
                    JOptionPane.showMessageDialog(this.view.getDio(), "Updated successfully");
                    this.view.getDio().setVisible(false);
                    this.view.getDio().dispose();
                }
            }
            catch (Exception ex) {
                new ErrorDialog(ex, "Updating lease record");
            }
        }
        if (obj == this.getView().getSaveBtn()) {
            try {
                if (this.isValidForm()) {
                    PropertyRecord record = this.bindFormFields();
                    this.view.setLeaseId(this.service.saveLeaseRecord(record));
                    JOptionPane.showMessageDialog(this.view.getDio(), "Successfully saved !", "Success", 1);
                    this.view.getTabbedPane().setEnabledAt(1, true);
                    this.view.getSaveBtn().setVisible(false);
                    this.view.getUpdateBtn().setVisible(true);
                    this.view.getDio().setTitle("Update - " + this.view.getAddressTf().getText());
                }
            }
            catch (Exception ex) {
                new ErrorDialog(ex, "Save lease transaction");
            }
        }
        if (obj == this.view.getContactBtn()) {
            ContactDialogView contactDialogView = new ContactDialogView(this, "contact", "Select a contact");
            AppUtility.setDialogLocationInCenter(contactDialogView.getDio());
            contactDialogView.getDio().setVisible(true);
        }
        if (obj == this.view.getCloseBtn()) {
            this.view.getDio().setVisible(false);
            this.view.getDio().dispose();
        }
    }

    private boolean isValidForm() {
        String selectedGroupName = (String)PropertyRecordView.getGroupNames().getSelectedItem();
        if (selectedGroupName == null) {
            JOptionPane.showMessageDialog(this.view.getDio(), "Group is mandatory", "Error", 0);
            return false;
        }
        if (PropertyRecordView.getOfferedByNameTf().getText().isEmpty()) {
            String errorMessage = "";
            errorMessage = this.view.getOfferedByCB().getSelectedItem().equals("DIRECT") ? "Owner's name is mandatory" : "Agent's name is mandatory";
            JOptionPane.showMessageDialog(this.view.getDio(), errorMessage, "Error", 0);
            return false;
        }
        if (this.view.getAddressTf().getText().trim().isEmpty()) {
            JOptionPane.showMessageDialog(this.view.getDio(), "Address is mandatory", "Error", 0);
            this.view.getAddressTf().requestFocus();
            return false;
        }
        if (this.view.getForRent().isSelected()) {
            if (!this.view.getDepositTf().getText().trim().isEmpty()) {
                if (!AppUtility.isValidNumber(this.view.getDepositTf().getText().trim())) {
                    return false;
                }
            } else {
                JOptionPane.showMessageDialog(this.view.getDio(), "Deposit is mandatory", "Error", 0);
                this.view.getDepositTf().requestFocus();
                return false;
            }
            if (!this.view.getRentTf().getText().trim().isEmpty()) {
                if (!AppUtility.isValidNumber(this.view.getRentTf().getText().trim())) {
                    return false;
                }
            } else {
                JOptionPane.showMessageDialog(this.view.getDio(), "Rent is mandatory", "Error", 0);
                this.view.getRentTf().requestFocus();
                return false;
            }
        }
        if (this.view.getForSell().isSelected()) {
            if (!this.view.getPriceTf().getText().trim().isEmpty()) {
                if (!AppUtility.isValidNumber(this.view.getPriceTf().getText().trim())) {
                    return false;
                }
            } else {
                JOptionPane.showMessageDialog(this.view.getDio(), "Price is mandatory", "Error", 0);
                this.view.getPriceTf().requestFocus();
                return false;
            }
        }
        if (this.view.getAreaInSqftTf().getText().isEmpty()) {
            this.view.getAreaInSqftTf().setText("0");
        }
        if (this.view.getPriceTf().getText().isEmpty()) {
            this.view.getPriceTf().setText("0");
        }
        if (this.view.getDepositTf().getText().isEmpty()) {
            this.view.getDepositTf().setText("0");
        }
        if (this.view.getRentTf().getText().isEmpty()) {
            this.view.getRentTf().setText("0");
        }
        if (this.view.getUnAvailable().isSelected() && this.view.getUnAvailableUntilTf().getText().trim().isEmpty()) {
            JOptionPane.showMessageDialog(this.view.getDio(), "Unavailable until is mandatory", "Error", 0);
            return false;
        }
        return true;
    }

    public PropertyRecordView getView() {
        return this.view;
    }

    private void loadAdditionalDetails(int leaseId) {
        try {
            List<PropertyAdditionalDetails> propertyAdditionalDetailsList = this.service.loadAllAdditionalDetails(leaseId);
            this.view.getAdditionalDetailsDefaultTableModel().setRowCount(0);
            IntStream.range(0, propertyAdditionalDetailsList.size()).forEach(index -> {
                this.view.getAdditionalDetailsDefaultTableModel().addRow(new Object[]{"", "", ""});
                this.view.getAdditionalDetailsTable().setValueAt(((PropertyAdditionalDetails)propertyAdditionalDetailsList.get(index)).additionalId(), index, 0);
                this.view.getAdditionalDetailsTable().setValueAt(((PropertyAdditionalDetails)propertyAdditionalDetailsList.get(index)).name(), index, 1);
                this.view.getAdditionalDetailsTable().setValueAt(((PropertyAdditionalDetails)propertyAdditionalDetailsList.get(index)).value(), index, 2);
                this.view.getAdditionalDetailsTable().setAutoCreateRowSorter(true);
            });
            if (this.view.getAdditionalDetailsTable().getRowCount() > 0) {
                this.view.getAdditionalDetailsTable().setRowSelectionInterval(0, 0);
            }
        }
        catch (ServiceException ex) {
            new ErrorDialog(ex, "loadAdditionalDetails from property");
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.view.getTabbedPane()) {
            int selectedTabIndex = this.view.getTabbedPane().getSelectedIndex();
            if (selectedTabIndex == 0) {
                if (this.view.getLeaseId() > 0) {
                    this.view.getUpdateBtn().setVisible(true);
                } else {
                    this.view.getSaveBtn().setVisible(true);
                }
            } else if (selectedTabIndex == 1) {
                this.view.getUpdateBtn().setVisible(false);
                this.view.getSaveBtn().setVisible(false);
                this.loadAdditionalDetails(this.view.getLeaseId());
            }
        }
    }
}

