/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.controller.settings;

import com.arun.bhardwaj.cache.PropertyGroupCache;
import com.arun.bhardwaj.model.enquiry.EnquiryRecord;
import com.arun.bhardwaj.model.property.PropertyRecord;
import com.arun.bhardwaj.model.team.EmailConfig;
import com.arun.bhardwaj.model.team.PropertyInfo;
import com.arun.bhardwaj.model.team.TeamConversationDetails;
import com.arun.bhardwaj.model.team.TeamDetails;
import com.arun.bhardwaj.service.enquiry.EnquiryPropertySearchService;
import com.arun.bhardwaj.service.enquiry.EnquiryPropertySearchServiceImpl;
import com.arun.bhardwaj.service.settings.ManageTeamService;
import com.arun.bhardwaj.service.settings.ManageTeamServiceImpl;
import com.arun.bhardwaj.utility.AppUtility;
import com.arun.bhardwaj.utility.UserCache;
import com.arun.bhardwaj.view.LoginView;
import com.arun.bhardwaj.view.common.ContactDialogView;
import com.arun.bhardwaj.view.common.ErrorDialog;
import com.arun.bhardwaj.view.settings.ManageTeamView;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import javax.mail.Authenticator;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.search.FlagTerm;
import javax.swing.JOptionPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ManageTeamController
implements ActionListener,
ListSelectionListener {
    private final ManageTeamView view;
    private final ManageTeamService service;
    private final EnquiryPropertySearchService enquiryPropertySearchService;
    private Integer contactId;
    private int selectedRowIndex = 0;
    private int emailConfigId;
    private final Map<Integer, List<String>> teamMemberEmails = new HashMap<Integer, List<String>>();

    public int getEmailConfigId() {
        return this.emailConfigId;
    }

    public void setEmailConfigId(int emailConfigId) {
        this.emailConfigId = emailConfigId;
    }

    public int getSelectedRowIndex() {
        return this.selectedRowIndex;
    }

    public void setSelectedRowIndex(int selectedRowIndex) {
        this.selectedRowIndex = selectedRowIndex;
    }

    public Map<Integer, List<String>> getTeamMemberEmails() {
        return this.teamMemberEmails;
    }

    public Integer getContactId() {
        return this.contactId;
    }

    public void setContactId(Integer contactId) {
        this.contactId = contactId;
    }

    public ManageTeamController(ManageTeamView view) {
        this.view = view;
        this.service = new ManageTeamServiceImpl();
        this.enquiryPropertySearchService = new EnquiryPropertySearchServiceImpl();
        this.addActionEvent();
        view.getSelectionModel().addListSelectionListener(this);
        view.getConversationSelectionModel().addListSelectionListener(this);
        this.loadTeamDetails();
        AppUtility.tableZoomInZoomOut(true, view.getTable());
        AppUtility.tableZoomInZoomOut(true, view.getTable());
        AppUtility.tableZoomInZoomOut(true, view.getConversationTable());
        AppUtility.tableZoomInZoomOut(true, view.getConversationTable());
        try {
            EmailConfig emailConfig = null;
            if (emailConfig != null) {
                this.setEmailConfigId(emailConfig.emailconfigId());
                view.getEmail().setText(emailConfig.email());
                view.getEmailPassword().setText(emailConfig.password());
                view.getImapHostTf().setText(emailConfig.imapHost());
                view.getImapPort().setText(emailConfig.imapPort());
                view.getSmtpHostTf().setText(emailConfig.smtpHost());
                view.getSmtpPort().setText(emailConfig.smtpPort());
            }
        }
        catch (Exception ex) {
            new ErrorDialog(ex, "load Email config id ");
        }
        if (this.getEmailConfigId() == 0) {
            view.getAddTeamMember().setEnabled(false);
            view.getDeleteMember().setEnabled(false);
        } else {
            view.getAddTeamMember().setEnabled(true);
            view.getDeleteMember().setEnabled(true);
            this.checkForRequestFromTeamMembers();
        }
    }

    private void checkForRequestFromTeamMembers() {
        if (!this.getTeamMemberEmails().isEmpty()) {
            ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
            Runnable task = this::checkEnquiryByTeamMember;
            scheduler.scheduleAtFixedRate(task, 0L, 3L, TimeUnit.MINUTES);
        }
    }

    private Session getEmailSession() throws Exception {
        Session session = null;
        try {
            Properties props = new Properties();
            props.setProperty("mail.imap.host", this.view.getImapHostTf().getText());
            props.setProperty("mail.imap.port", this.view.getImapPort().getText());
            props.setProperty("mail.imap.ssl.enable", "true");
            props.setProperty("mail.store.protocol", "imap");
            session = Session.getInstance(props, new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(ManageTeamController.this.view.getEmail().getText(), new String(ManageTeamController.this.view.getEmailPassword().getPassword()));
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return session;
    }

    private void sendEmail(String subject, String content, String messageTo) throws Exception {
        Properties props = new Properties();
        props.put("mail.smtp.auth", "true");
        props.put("mail.smtp.starttls.enable", "true");
        props.put("mail.smtp.host", this.view.getSmtpHostTf().getText());
        props.put("mail.smtp.port", this.view.getSmtpPort().getText());
        Session session = Session.getInstance(props, new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(ManageTeamController.this.view.getEmail().getText(), new String(ManageTeamController.this.view.getEmailPassword().getPassword()));
            }
        });
        try {
            MimeMessage message = new MimeMessage(session);
            ((Message)message).setFrom(new InternetAddress(this.view.getEmail().getText()));
            ((Message)message).setRecipients(Message.RecipientType.TO, InternetAddress.parse(messageTo));
            ((Message)message).setSubject(subject);
            message.setContent(content, "text/plain; charset=utf-8");
            Transport.send(message);
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
    }

    private void checkEnquiryByTeamMember() {
        if (AppUtility.isInternetConnected()) {
            try {
                Message[] messages;
                Session session = this.getEmailSession();
                Store store = session.getStore();
                store.connect();
                Folder inbox = store.getFolder("INBOX");
                inbox.open(2);
                for (Message message : messages = inbox.search(new FlagTerm(new Flags(Flags.Flag.SEEN), false))) {
                    String subject = message.getSubject();
                    String messageFrom = Arrays.toString(message.getFrom());
                    if (!subject.contains("Find") || !this.validateEmail(messageFrom)) continue;
                    PropertyInfo propertyInfo = ManageTeamController.extractInformation(subject);
                    int teamAuditId = this.service.saveTeamRequest(subject, this.extractEmail(messageFrom));
                    if (propertyInfo.getLookingFor() != null) {
                        EnquiryRecord enquiryRecord = new EnquiryRecord.Builder().lookingFor(propertyInfo.getPropertyType() + " for " + propertyInfo.getLookingFor()).location(propertyInfo.getLocation()).build();
                        List<PropertyRecord> propertyRecordList = this.enquiryPropertySearchService.loadPropertiesForEnquiry(enquiryRecord, false);
                        String propertyDetails = "No record found !";
                        if (!propertyRecordList.isEmpty()) {
                            propertyDetails = this.generatePropertiesDetailMessage(propertyRecordList);
                        }
                        this.sendEmail("RE:" + subject, propertyDetails, this.extractEmail(messageFrom));
                        this.service.updateTeamResponse(propertyDetails, teamAuditId);
                        message.setFlag(Flags.Flag.SEEN, true);
                        continue;
                    }
                    String sendCorrectSyntex = "Please send the subject eg. Find <Property category> for<rent/purchase> in <location>";
                    this.sendEmail("RE:" + subject, sendCorrectSyntex, this.extractEmail(messageFrom));
                    this.service.updateTeamResponse(sendCorrectSyntex, teamAuditId);
                    message.setFlag(Flags.Flag.SEEN, true);
                }
                inbox.close(false);
                store.close();
            }
            catch (Exception ex) {
                new ErrorDialog(ex, "reading email");
            }
        }
    }

    private String generatePropertiesDetailMessage(List<PropertyRecord> propertyRecordList) {
        StringBuilder details = new StringBuilder();
        details.append("We've carefully curated a selection of properties that align with your specified preferences. Below are brief details of the shortlisted options:");
        for (PropertyRecord propertyRecord : propertyRecordList) {
            details.append("\n\n");
            details.append("Property Type : ").append(PropertyGroupCache.getGroupName(propertyRecord.fkGroupId()));
            details.append("\n");
            details.append("Address : ").append(propertyRecord.address());
            details.append("\n");
            details.append("Area in Sq.ft. :").append(propertyRecord.areaInSqFt());
            details.append("\n");
            details.append("Deposit :").append(propertyRecord.deposit());
            details.append("\n");
            details.append("Rent :").append(propertyRecord.rent());
            details.append("\n");
            details.append("Price :").append(propertyRecord.price());
            details.append("\n");
            details.append("Owner contact Number :").append(propertyRecord.ownerContactNumbers());
        }
        details.append("\n\n");
        details.append(UserCache.getUserSignature());
        return details.toString();
    }

    private static PropertyInfo extractInformation(String input) {
        Pattern pattern = Pattern.compile("Find\\s+(\\w+)\\s+for\\s+(\\w+)\\s+in\\s+(.+)");
        Matcher matcher = pattern.matcher(input);
        PropertyInfo propertyInfo = new PropertyInfo();
        if (matcher.find()) {
            propertyInfo.setPropertyType(matcher.group(1));
            propertyInfo.setLookingFor(matcher.group(2));
            propertyInfo.setLocation(matcher.group(3));
        }
        return propertyInfo;
    }

    private boolean validateEmail(String fromString) {
        String extractedEmail = this.extractEmail(fromString);
        for (List<String> emails : this.getTeamMemberEmails().values()) {
            if (!emails.contains(extractedEmail)) continue;
            return true;
        }
        return false;
    }

    private String extractEmail(String fromString) {
        int startIndex = fromString.indexOf("<");
        int endIndex = fromString.indexOf(">");
        if (startIndex != -1 && endIndex != -1) {
            return fromString.substring(startIndex + 1, endIndex);
        }
        return fromString;
    }

    private void addActionEvent() {
        this.view.getAddTeamMember().addActionListener(this);
        this.view.getSelectTeamMemberBtn().addActionListener(this);
        this.view.getSaveBtn().addActionListener(this);
        this.view.getCloseBtn().addActionListener(this);
        this.view.getDeleteMember().addActionListener(this);
        this.view.getConfigureEmail().addActionListener(this);
        this.view.getEmailConfigSubmit().addActionListener(this);
        this.view.getEmailConfigCancel().addActionListener(this);
        this.view.getDeleteMemberPopupMenu().addActionListener(this);
        this.view.getRefreshPopupMenu().addActionListener(this);
    }

    private void loadTeamDetails() {
        try {
            List<TeamDetails> teamDetails = this.service.loadTeamDetails();
            this.view.getDefaultTableModel().setRowCount(0);
            assert (teamDetails != null);
            List<TeamDetails> finalTeamDetails = teamDetails;
            this.getTeamMemberEmails().clear();
            IntStream.range(0, teamDetails.size()).forEach(index -> {
                this.view.getDefaultTableModel().addRow(new Object[]{"", "", "", "", "", "", "", "", "", "", "", "", ""});
                this.view.getTable().setValueAt(String.valueOf(index + 1), index, 0);
                this.view.getTable().setValueAt(((TeamDetails)finalTeamDetails.get(index)).name(), index, 1);
                this.view.getTable().setValueAt(((TeamDetails)finalTeamDetails.get(index)).address(), index, 2);
                this.view.getTable().setValueAt(((TeamDetails)finalTeamDetails.get(index)).phoneNo(), index, 3);
                this.view.getTable().setValueAt(((TeamDetails)finalTeamDetails.get(index)).emails(), index, 4);
                this.view.getTable().setValueAt(((TeamDetails)finalTeamDetails.get(index)).comments(), index, 5);
                this.view.getTable().setValueAt(((TeamDetails)finalTeamDetails.get(index)).contactId(), index, 6);
                if (((TeamDetails)finalTeamDetails.get(index)).emails() != null) {
                    List<String> emails = Arrays.stream(((TeamDetails)finalTeamDetails.get(index)).emails().split(";")).toList();
                    this.getTeamMemberEmails().put(((TeamDetails)finalTeamDetails.get(index)).contactId(), emails);
                }
                this.view.getTable().setAutoCreateRowSorter(true);
            });
            if (this.getSelectedRowIndex() != -1 && this.getSelectedRowIndex() < this.view.getTable().getRowCount()) {
                this.view.getTable().setRowSelectionInterval(this.getSelectedRowIndex(), this.getSelectedRowIndex());
                this.loadTeamSystemConversation();
            } else if (this.view.getTable().getRowCount() > 0) {
                this.view.getTable().setRowSelectionInterval(0, 0);
                this.loadTeamSystemConversation();
            }
        }
        catch (Exception e) {
            new ErrorDialog(e, "Load team details");
        }
    }

    private boolean isEmailConfigValid() {
        if (this.view.getEmail().getText().isEmpty()) {
            JOptionPane.showMessageDialog(this.view.getEmailConfigDio(), "Email is mandatory", "Error", 0);
            this.view.getEmail().requestFocus();
            return false;
        }
        if (!this.view.getEmail().getText().isEmpty() && !AppUtility.isValidEmail(this.view.getEmail().getText())) {
            JOptionPane.showMessageDialog(this.view.getEmailConfigDio(), "Email is not valid", "Error", 0);
            this.view.getEmail().requestFocus();
            return false;
        }
        if (this.view.getEmailPassword().getText().isEmpty()) {
            JOptionPane.showMessageDialog(this.view.getEmailConfigDio(), "Email password is mandatory", "Error", 0);
            this.view.getEmailPassword().requestFocus();
            return false;
        }
        if (this.view.getImapHostTf().getText().isEmpty()) {
            JOptionPane.showMessageDialog(this.view.getEmailConfigDio(), "IMAP Host is mandatory", "Error", 0);
            this.view.getImapHostTf().requestFocus();
            return false;
        }
        if (this.view.getImapPort().getText().isEmpty()) {
            JOptionPane.showMessageDialog(this.view.getEmailConfigDio(), "IMAP Port is mandatory", "Error", 0);
            this.view.getImapPort().requestFocus();
            return false;
        }
        if (this.view.getSmtpHostTf().getText().isEmpty()) {
            JOptionPane.showMessageDialog(this.view.getEmailConfigDio(), "SMTP Host is mandatory", "Error", 0);
            this.view.getSmtpHostTf().requestFocus();
            return false;
        }
        if (this.view.getSmtpPort().getText().isEmpty()) {
            JOptionPane.showMessageDialog(this.view.getEmailConfigDio(), "SMTP Port is mandatory", "Error", 0);
            this.view.getSmtpPort().requestFocus();
            return false;
        }
        return true;
    }

    private boolean authenticateEmail() {
        Properties properties = new Properties();
        properties.setProperty("mail.smtp.host", this.view.getSmtpHostTf().getText());
        properties.setProperty("mail.smtp.port", this.view.getSmtpPort().getText());
        properties.setProperty("mail.tls.auth", "true");
        properties.setProperty("mail.smtp.starttls.enable", "true");
        properties.setProperty("mail.imap.host", this.view.getImapHostTf().getText());
        properties.setProperty("mail.imap.port", this.view.getImapPort().getText());
        properties.setProperty("mail.imap.auth", "true");
        properties.setProperty("mail.imap.ssl.enable", "true");
        Session session = Session.getDefaultInstance(properties, new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                String password = new String(ManageTeamController.this.view.getEmailPassword().getPassword());
                return new PasswordAuthentication(ManageTeamController.this.view.getEmail().getText(), password);
            }
        });
        try {
            Transport smtpTransport = session.getTransport("smtp");
            smtpTransport.connect();
            smtpTransport.close();
            Store imapStore = session.getStore("imap");
            imapStore.connect();
            imapStore.close();
            return true;
        }
        catch (MessagingException e) {
            return false;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj == this.view.getRefreshPopupMenu()) {
            this.loadTeamSystemConversation();
        }
        if (obj == this.view.getEmailConfigSubmit()) {
            if (this.isEmailConfigValid() && this.authenticateEmail()) {
                try {
                    this.service.saveEmailConfig(new EmailConfig(this.getEmailConfigId(), this.view.getEmail().getText(), new String(this.view.getEmailPassword().getPassword()), this.view.getImapHostTf().getText(), this.view.getImapPort().getText(), this.view.getSmtpHostTf().getText(), this.view.getSmtpPort().getText()));
                    JOptionPane.showMessageDialog(this.view.getEmailConfigDio(), "Successfully saved !", "Success", 1);
                    this.view.getEmailConfigDio().dispose();
                    this.view.getAddTeamMember().setEnabled(true);
                }
                catch (Exception ex) {
                    new ErrorDialog(ex, "Save email config");
                }
            } else {
                JOptionPane.showMessageDialog(this.view.getEmailConfigDio(), "Authentication failed", "Error", 0);
            }
        }
        if (obj == this.view.getEmailConfigCancel()) {
            this.view.getEmailConfigDio().dispose();
        }
        if (obj == this.view.getConfigureEmail()) {
            this.view.getEmailConfigDio().setVisible(true);
        }
        if (obj == this.view.getDeleteMember() || obj == this.view.getDeleteMemberPopupMenu()) {
            int row = this.view.getTable().getSelectedRow();
            String selectedName = (String)this.view.getTable().getValueAt(row, 1);
            int selectedContactId = (Integer)this.view.getTable().getValueAt(row, 6);
            int choose = JOptionPane.showConfirmDialog(LoginView.frame, "Are you sure to delete " + selectedName + " ?", "Delete record", 1);
            if (choose == 0) {
                try {
                    this.service.deleteTeamMemberRecord(selectedContactId);
                    JOptionPane.showMessageDialog(LoginView.frame, selectedName + "Successfully deleted !");
                    this.loadTeamDetails();
                }
                catch (Exception ex) {
                    new ErrorDialog(ex, "Delete team member");
                }
            }
        }
        if (obj == this.view.getSelectTeamMemberBtn()) {
            try {
                ContactDialogView contactDialogView = new ContactDialogView(this, "selectedName", "Select a contact");
                AppUtility.setDialogLocationInCenter(contactDialogView.getDio());
                contactDialogView.getDio().setVisible(true);
            }
            catch (Exception ex) {
                new ErrorDialog(ex, "While select team member");
            }
        }
        if (obj == this.view.getAddTeamMember()) {
            this.view.getSaveBtn().setEnabled(false);
            this.view.getTeamMemberNameField().setText("");
            this.setContactId(0);
            this.view.getDio().setVisible(true);
        }
        if (obj == this.view.getCloseBtn()) {
            this.view.getDio().dispose();
        }
        if (obj == this.view.getSaveBtn()) {
            try {
                if (this.service.isTeamMemberExists(this.getContactId())) {
                    JOptionPane.showMessageDialog(this.view.getDio(), "Already exists !", "Warning", 2);
                } else {
                    this.service.save(this.getContactId());
                    JOptionPane.showMessageDialog(this.view.getDio(), "Successfully saved !", "Success", 1);
                    this.view.getDio().dispose();
                    this.loadTeamDetails();
                }
                this.loadTeamDetails();
            }
            catch (Exception ex) {
                new ErrorDialog(ex, "Add team member");
            }
        }
    }

    public ManageTeamView getView() {
        return this.view;
    }

    private void loadTeamSystemConversation() {
        try {
            int contactId = (Integer)this.view.getTable().getValueAt(this.view.getTable().getSelectedRow(), 6);
            this.setSelectedRowIndex(this.view.getTable().getSelectedRow());
            List<TeamConversationDetails> teamConversationDetails = this.service.loadTeamConversationDetails(contactId);
            this.view.getConversationTableModel().setRowCount(0);
            IntStream.range(0, teamConversationDetails.size()).forEach(index -> {
                this.view.getConversationTableModel().addRow(new Object[]{"", "", "", ""});
                this.view.getConversationTable().setValueAt(String.valueOf(index + 1), index, 0);
                this.view.getConversationTable().setValueAt(((TeamConversationDetails)teamConversationDetails.get(index)).requestDateTime(), index, 1);
                this.view.getConversationTable().setValueAt(((TeamConversationDetails)teamConversationDetails.get(index)).request(), index, 2);
                this.view.getConversationTable().setValueAt(((TeamConversationDetails)teamConversationDetails.get(index)).response(), index, 3);
                this.view.getConversationTable().setAutoCreateRowSorter(true);
            });
            if (this.view.getConversationTable().getRowCount() > 0) {
                this.view.getConversationTable().setRowSelectionInterval(0, 0);
            }
        }
        catch (Exception e) {
            new ErrorDialog(e, "Load team details");
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.view.getConversationTable().getSelectedRow() >= 0) {
            this.view.getResponseDetails().setText((String)this.view.getConversationTable().getValueAt(this.view.getConversationTable().getSelectedRow(), 3));
        } else {
            this.view.getResponseDetails().setText("");
        }
        if (e.getSource() == this.view.getSelectionModel() && this.view.getTable().getSelectedRow() >= 0) {
            this.loadTeamSystemConversation();
        }
    }
}

