/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.controller.settings;

import com.arun.bhardwaj.model.UserDetails;
import com.arun.bhardwaj.service.LoginService;
import com.arun.bhardwaj.service.LoginServiceImpl;
import com.arun.bhardwaj.service.settings.UserDetailsService;
import com.arun.bhardwaj.service.settings.UserDetailsServiceImpl;
import com.arun.bhardwaj.utility.AppUtility;
import com.arun.bhardwaj.utility.AutoResize;
import com.arun.bhardwaj.utility.EmailUtility;
import com.arun.bhardwaj.utility.ReadEmailUtility;
import com.arun.bhardwaj.utility.UserCache;
import com.arun.bhardwaj.view.LoginView;
import com.arun.bhardwaj.view.common.ErrorDialog;
import com.arun.bhardwaj.view.settings.UserDetailsView;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Store;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;

public class UserDetailsController
implements ActionListener {
    private final UserDetailsView view;
    private final UserDetailsService service;
    private final LoginService loginService;
    private String lastOpenedDirectory;
    int generatedOtp;
    String clientId;

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public int getGeneratedOtp() {
        return this.generatedOtp;
    }

    public void setGeneratedOtp(int generatedOtp) {
        this.generatedOtp = generatedOtp;
    }

    public UserDetailsController(UserDetailsView view) {
        this.view = view;
        this.service = new UserDetailsServiceImpl();
        this.loginService = new LoginServiceImpl();
        this.addActionEvent();
    }

    private void addActionEvent() {
        this.view.getUpdateDetails().addActionListener(this);
        this.view.getChangeLogoBtn().addActionListener(this);
        this.view.getClosePicDio().addActionListener(this);
        this.view.getBrowseBtn().addActionListener(this);
        this.view.getRemovePicBtn().addActionListener(this);
        this.view.getSendOTP().addActionListener(this);
        this.view.getUpdateBtn().addActionListener(this);
        this.view.getUpdateNow().addActionListener(this);
        this.view.getChangePasswordBtn().addActionListener(this);
        this.view.getUpdatePasswordBtn().addActionListener(this);
        this.view.getBackupBtn().addActionListener(this);
    }

    public void loadUserDetails() {
        try {
            UserDetails userDetails = this.service.loadUserDetails();
            StringBuilder details = new StringBuilder();
            details.append("\n");
            details.append("Member since :");
            details.append(userDetails.createdOn());
            details.append("\n\n");
            details.append("Name : ");
            details.append(userDetails.userName());
            details.append("\n");
            details.append("Address : ");
            details.append(userDetails.address());
            details.append("\n");
            details.append("Mobile No : ");
            details.append(userDetails.mobileNo() == null ? "" : userDetails.mobileNo());
            details.append("\n");
            details.append("Email : ");
            details.append(userDetails.email() == null ? "" : userDetails.email());
            details.append("\n\n");
            details.append("Client id : ");
            details.append(userDetails.clientId());
            details.append("\n");
            this.setClientId(userDetails.clientId());
            this.view.getClientDetailsTextArea().setText(details.toString());
            InputStream inputStream = userDetails.logo();
            if (inputStream != null) {
                BufferedImage image = ImageIO.read(inputStream);
                if (image != null) {
                    AutoResize responsiveImg = new AutoResize(image);
                    this.view.getClientLogo().removeAll();
                    this.view.getClientLogo().add(responsiveImg);
                    this.view.getClientLogo().revalidate();
                    this.view.getClientLogo().repaint();
                    AutoResize responsiveImg1 = new AutoResize(image);
                    LoginView.clientLogo.removeAll();
                    LoginView.clientLogo.add(responsiveImg1);
                    this.view.getTfPic().setText("-");
                    AutoResize responsiveImg2 = new AutoResize(image);
                    this.view.getPicPanel().removeAll();
                    this.view.getPicPanel().add(responsiveImg2);
                    this.view.getPicPanel().revalidate();
                    this.view.getPicPanel().repaint();
                } else {
                    this.view.getClientLogo().removeAll();
                    this.view.getClientLogo().revalidate();
                    this.view.getClientLogo().repaint();
                    LoginView.clientLogo.removeAll();
                }
                LoginView.clientLogo.revalidate();
                LoginView.clientLogo.repaint();
            }
        }
        catch (Exception e) {
            new ErrorDialog(e, "Load user details");
        }
    }

    private void loadUserData() throws Exception {
        UserDetails userDetails = this.service.loadUserDetails();
        this.view.getAddressTf().setText(userDetails.address());
        this.view.getMobileTf().setText(userDetails.mobileNo());
        this.view.getEmailTf().setText(userDetails.email());
        this.view.getErrorLabel().setText("");
    }

    public void checkForUpdate() {
        try {
            Message[] messages;
            Session session = ReadEmailUtility.getSession();
            Store store = session.getStore();
            store.connect();
            Folder inbox = store.getFolder("INBOX");
            inbox.open(1);
            for (Message message : messages = inbox.getMessages()) {
                String messageFrom = String.valueOf(message.getFrom()[0]);
                String subject = message.getSubject();
                if (!"Latest version".equals(subject) || !messageFrom.contains("shreetechnoworld@outlook.com")) continue;
                String latestVersion = ReadEmailUtility.getTextFromMessage(message).trim();
                if (latestVersion.equals(LoginView.version)) {
                    this.view.getSoftwareUpdateStatus().setText("Your software is up to date");
                    continue;
                }
                this.view.getUpdateNow().setText("Click to unlock the power of the latest version " + latestVersion + " The process will take a few minutes");
                this.view.getUpdateNow().setVisible(true);
                this.view.getSoftwareUpdateStatus().setText("");
            }
            inbox.close(false);
            store.close();
        }
        catch (Exception ex) {
            new ErrorDialog(ex, "Check for update");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj == this.view.getBackupBtn()) {
            try {
                AppUtility.createBackup();
                JOptionPane.showMessageDialog(LoginView.frame, "Backup created successfully");
            }
            catch (IOException ex) {
                new ErrorDialog(ex, "While taking backup");
            }
        }
        if (obj == this.view.getUpdatePasswordBtn()) {
            String oldPassword = new String(this.view.getOldPasswordField().getPassword());
            String newPassword = new String(this.view.getNewPasswordField().getPassword());
            String confirmPass = new String(this.view.getConfirmPasswordField().getPassword());
            boolean isValid = true;
            if (oldPassword.isBlank() || !oldPassword.equals(LoginView.password)) {
                JOptionPane.showMessageDialog(this.view.getChangePasswordDio(), "Old password does not match ", "ErrorMessage", 0);
                isValid = false;
            } else if (newPassword.isBlank() || confirmPass.isBlank() || !newPassword.equals(confirmPass)) {
                JOptionPane.showMessageDialog(this.view.getChangePasswordDio(), "New password and confirm Password does not match ", "ErrorMessage", 0);
                isValid = false;
            }
            if (isValid) {
                try {
                    this.service.changePassword(oldPassword, newPassword);
                    long diff = UserCache.getValidity();
                    this.loginService.renewDatabase((int)diff, newPassword);
                    JOptionPane.showMessageDialog(this.view.getChangePasswordDio(), "Password changed successfully \n To continue using the software, Please log in again as it will be closing.");
                    System.exit(0);
                }
                catch (Exception ex) {
                    new ErrorDialog(ex, "Change password");
                }
            }
        }
        if (obj == this.view.getChangePasswordBtn()) {
            this.view.getChangePasswordDio().setVisible(true);
        }
        if (obj == this.view.getUpdateNow()) {
            JOptionPane.showMessageDialog(LoginView.frame, "We're currently downloading and updating the software to enhance your experience.\nThis process may take up to 2 minutes.\nOnce the update is complete, Application will restart. then enjoy the latest features and improvements.\nWe appreciate your patience and thank you for choosing Real estate solution.\n");
            ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
            executorService.schedule(() -> {
                try {
                    AppUtility.downloadAndReplaceJar();
                }
                catch (IOException ex) {
                    new ErrorDialog(ex, "download And Replace ");
                }
            }, 2L, TimeUnit.SECONDS);
            executorService.shutdown();
        }
        if (obj == this.view.getUpdateBtn()) {
            boolean isValid = true;
            if (this.view.getAddressTf().getText().isBlank()) {
                this.view.getErrorLabel().setText("Address is mandatory");
                isValid = false;
            } else if (this.view.getMobileTf().getText().isBlank()) {
                this.view.getErrorLabel().setText("Mobile is mandatory");
                isValid = false;
            } else if (!AppUtility.isValidatePhoneNo(this.view.getMobileTf().getText())) {
                this.view.getErrorLabel().setText("Mobile is not valid");
                isValid = false;
            } else if (this.view.getEmailTf().getText().isBlank()) {
                this.view.getErrorLabel().setText("Email is mandatory");
                isValid = false;
            } else if (this.view.getEmailOTPTf().getText().isBlank()) {
                this.view.getErrorLabel().setText("Email OTP is mandatory");
                isValid = false;
            } else {
                this.view.getErrorLabel().setText("");
            }
            if (!this.view.getMobileTf().getText().isBlank() && !AppUtility.isValidatePhoneNo(this.view.getMobileTf().getText())) {
                this.view.getErrorLabel().setText("Mobile is not valid");
                isValid = false;
            }
            if (!this.view.getEmailOTPTf().getText().isBlank()) {
                if (AppUtility.isInternetConnected()) {
                    if (AppUtility.isValidNumber(this.view.getEmailOTPTf().getText())) {
                        if (this.getGeneratedOtp() != Integer.parseInt(this.view.getEmailOTPTf().getText())) {
                            this.view.getErrorLabel().setText("Entered OTP is not valid");
                            isValid = false;
                        }
                    } else {
                        this.view.getErrorLabel().setText("Email OTP must be 4 digit number");
                        isValid = false;
                    }
                } else {
                    this.view.getErrorLabel().setText("Please check your internet connection.");
                }
            }
            if (isValid) {
                UserDetails userDetails = new UserDetails.Builder().address(this.view.getAddressTf().getText()).email(this.view.getEmailTf().getText()).mobileNo(this.view.getMobileTf().getText()).clientId(this.getClientId()).build();
                try {
                    this.sendUserDetails(userDetails);
                    this.service.updateUserDetails(userDetails);
                    JOptionPane.showMessageDialog(LoginView.frame, "the update is done ! \nTo continue using the software, Please log in again as it will be closing.");
                    System.exit(0);
                }
                catch (Exception ex) {
                    new ErrorDialog(ex, "update user details");
                }
            }
        }
        if (obj == this.view.getSendOTP()) {
            try {
                if (!this.view.getEmailTf().getText().isBlank()) {
                    if (AppUtility.isValidEmail(this.view.getEmailTf().getText())) {
                        String message = "<html>Please confirm your email is <b>" + this.view.getEmailTf().getText() + "</b> to receive the OTP.</html>";
                        int choose = JOptionPane.showConfirmDialog(LoginView.frame, message, "Send OTP", 1);
                        if (choose == 0) {
                            this.generateOTPAndSendEmail();
                            JOptionPane.showMessageDialog(this.view.getUserDio(), "An OTP has been sent. \n Please also check your junk or span folder if you don't see it in your inbox.");
                            this.view.getEmailOTPTf().requestFocus();
                            this.view.getErrorLabel().setText("");
                        }
                    } else {
                        this.view.getErrorLabel().setText("Email is not valid");
                    }
                } else {
                    this.view.getErrorLabel().setText("Email is mandatory");
                }
            }
            catch (Exception ex) {
                this.view.getErrorLabel().setText("unable to send OTP please check your connection");
            }
        }
        if (obj == this.view.getRemovePicBtn()) {
            this.view.getTfPic().setText("-");
            this.view.getPicPanel().removeAll();
            this.view.getPicPanel().revalidate();
            this.view.getPicPanel().repaint();
            try {
                this.service.changeLogo("-");
                this.loadUserDetails();
            }
            catch (Exception ex) {
                new ErrorDialog(ex, "Remove logo");
            }
        }
        if (obj == this.view.getBrowseBtn()) {
            JFileChooser chooser = new JFileChooser();
            if (this.lastOpenedDirectory != null && !this.lastOpenedDirectory.isEmpty()) {
                chooser.setCurrentDirectory(new File(this.lastOpenedDirectory));
            }
            FileNameExtensionFilter filter = new FileNameExtensionFilter("JPG & GIF Images", "jpg", "jpeg", "gif", "png");
            chooser.setFileFilter(filter);
            int returnVal = chooser.showOpenDialog(this.view.getBrowseBtn());
            if (returnVal == 0) {
                this.lastOpenedDirectory = chooser.getSelectedFile().getParent();
                try {
                    String path = chooser.getSelectedFile().getPath();
                    BufferedImage image = ImageIO.read(new File(path));
                    if (image != null) {
                        AutoResize responsiveImg = new AutoResize(image);
                        this.view.getTfPic().setText(path);
                        this.view.getPicPanel().removeAll();
                        this.view.getPicPanel().add(responsiveImg);
                        this.view.getPicPanel().revalidate();
                        this.view.getPicPanel().repaint();
                        this.service.changeLogo(path);
                        this.loadUserDetails();
                    }
                }
                catch (Exception e1) {
                    JOptionPane.showMessageDialog(this.view.getPicPanel(), "Error while Choose file choosePicBtn" + e1.getMessage(), "Error Message", 0);
                }
            }
        }
        if (obj == this.view.getChangeLogoBtn()) {
            this.view.getPicDio().setVisible(true);
        }
        if (obj == this.view.getClosePicDio()) {
            this.view.getPicDio().setVisible(false);
        }
        if (obj == this.view.getUpdateDetails()) {
            try {
                this.loadUserData();
                this.view.getUserDio().setVisible(true);
            }
            catch (Exception ex) {
                new ErrorDialog(ex, "Load user details");
            }
        }
    }

    private void generateOTPAndSendEmail() throws Exception {
        StringBuilder message = new StringBuilder();
        char[] generatedOTP = AppUtility.generateOTP(4);
        this.setGeneratedOtp(Integer.parseInt(String.valueOf(generatedOTP)));
        message.append("<p>Your  OTP to verify your email for Real Estate Solutions. </p>");
        message.append("<h2>");
        message.append(generatedOTP);
        message.append("</h2>");
        message.append("<p>Sincerely, </p> <p>Team Real Estate Solution </p> <p> Mob: <a href='https://wa.me/8800776704'>8800776704 </a> </p>");
        message.append("<p> Email <a href='mailto:support@shreetechnoworld.com'>support@shreetechnoworld.com </a></p>");
        message.append("<p> Website <a href='https://www.shreetechnoworld.com'>shreetechnoworld.com </a></p>");
        message.append("<p> <h3 style='color:#E75A3C'> Real estate solution for real estate people. </h3> </p>");
        message.append("<p><h6> This is a system generated mail. Please don't reply. </h6> </p>");
        EmailUtility.sendEmailToClient(this.view.getEmailTf().getText(), "Your Real Estate Solution One Time Password ", message.toString());
    }

    private void sendUserDetails(UserDetails userDetails) throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        JsonNode jsonNode = objectMapper.readTree(objectMapper.writeValueAsString(userDetails));
        if (jsonNode.has("password")) {
            ((ObjectNode)jsonNode).remove("password");
        }
        if (jsonNode.has("createdOn")) {
            ((ObjectNode)jsonNode).remove("createdOn");
        }
        if (jsonNode.has("logoPath")) {
            ((ObjectNode)jsonNode).remove("logoPath");
        }
        if (jsonNode.has("logo")) {
            ((ObjectNode)jsonNode).remove("logo");
        }
        if (jsonNode.has("userName")) {
            ((ObjectNode)jsonNode).remove("userName");
        }
        if (jsonNode.has("effectiveTill")) {
            ((ObjectNode)jsonNode).remove("effectiveTill");
        }
        if (jsonNode.has("productName")) {
            ((ObjectNode)jsonNode).remove("productName");
        }
        if (jsonNode.has("softwareVersion")) {
            ((ObjectNode)jsonNode).remove("softwareVersion");
        }
        EmailUtility.sendEmailToRES("user details has been updated " + userDetails.clientId(), objectMapper.writeValueAsString(jsonNode));
    }
}

