/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.customcomponent;

import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class AddressTextField
extends JTextField {
    private final int maxLength;

    public AddressTextField(int maxLength) {
        this.maxLength = maxLength;
        this.setDocument(new CustomDocument());
    }

    private class CustomDocument
    extends PlainDocument {
        private CustomDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            String currentText = this.getText(0, this.getLength());
            String newText = currentText.substring(0, offs) + str + currentText.substring(offs);
            if (this.isValidInput(newText)) {
                super.insertString(offs, str, a);
            }
        }

        private boolean isValidInput(String text) {
            return text.length() <= AddressTextField.this.maxLength && text.matches("^[a-zA-Z0-9\\s\\.,#/-]+$");
        }
    }
}

