/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.customcomponent;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.Timer;

public class ContinuousProgressBar
extends JComponent {
    private int progressPosition = 0;

    public ContinuousProgressBar() {
        Timer timer = new Timer(20, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContinuousProgressBar.this.incrementProgress();
            }
        });
        timer.start();
    }

    private void incrementProgress() {
        this.progressPosition += 2;
        if (this.progressPosition > this.getWidth()) {
            this.progressPosition = 0;
        }
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g.create();
        int height = this.getHeight();
        int progressBarWidth = 100;
        int progressBarHeight = 50;
        g2d.setColor(Color.WHITE);
        g2d.fillRect(0, 0, this.getWidth(), height);
        g2d.setColor(Color.BLACK);
        g2d.drawRect(0, 0, this.getWidth() - 1, height - 1);
        g2d.setColor(new Color(63, 151, 255, 255));
        g2d.fillRect(this.progressPosition, (height - progressBarHeight) / 2, progressBarWidth, progressBarHeight);
        g2d.dispose();
    }
}

