/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.customcomponent;

import javax.swing.JTextField;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public class CustomTextField
extends JTextField {
    private int limit;

    public CustomTextField(int limit, int width) {
        this.limit = limit;
        this.setColumns(width);
        ((AbstractDocument)this.getDocument()).setDocumentFilter(new CustomDocumentFilter());
    }

    private class CustomDocumentFilter
    extends DocumentFilter {
        private CustomDocumentFilter() {
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
            if (string == null) {
                return;
            }
            if (fb.getDocument().getLength() + string.length() <= CustomTextField.this.limit && string.matches("[a-zA-Z0-9 .\\-]*")) {
                super.insertString(fb, offset, string, attr);
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            if (text == null) {
                return;
            }
            if (fb.getDocument().getLength() - length + text.length() <= CustomTextField.this.limit && text.matches("[a-zA-Z0-9 .\\-]*")) {
                super.replace(fb, offset, length, text, attrs);
            }
        }
    }
}

