/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.customcomponent;

import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class DecimalTextField
extends JTextField {
    private final int maxLength;

    public DecimalTextField(int maxLength) {
        this.maxLength = maxLength;
        this.setDocument(new CurrencyDocument());
    }

    private class CurrencyDocument
    extends PlainDocument {
        private CurrencyDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            String currentText = this.getText(0, this.getLength());
            String newText = currentText.substring(0, offs) + str + currentText.substring(offs);
            if (this.isValidNumber(newText)) {
                super.insertString(offs, str, a);
            }
        }

        private boolean isValidNumber(String text) {
            try {
                return text.length() <= DecimalTextField.this.maxLength && text.matches("[0-9.]+");
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    }
}

