/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.dao;

import com.arun.bhardwaj.dao.LoginDao;
import com.arun.bhardwaj.exceptions.DatabaseException;
import com.arun.bhardwaj.model.UserDetails;
import com.arun.bhardwaj.utility.AppUtility;
import com.arun.bhardwaj.utility.DbUtility;
import com.arun.bhardwaj.view.LoginView;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;
import org.mindrot.jbcrypt.BCrypt;

public class LoginDaoImpl
implements LoginDao {
    private static final String CREATE_DATABASE_TABLES = "\n        CREATE TABLE CONTACT_GROUP (\n            GROUP_ID INTEGER PRIMARY KEY ASC AUTOINCREMENT,\n            GROUP_NAME TEXT UNIQUE NOT NULL,\n            CREATED_ON TEXT NOT NULL ,\n            MODIFY_ON  TEXT NULL\n        );\n\n        CREATE TABLE CONTACTS (\n            CONTACT_ID  INTEGER    PRIMARY KEY ASC AUTOINCREMENT,\n            NAME        TEXT  NOT NULL,\n            COMMENTS    TEXT NULL,\n            IMAGE       BLOB NULL,\n            CREATED_ON  TEXT  NOT NULL,\n            MODIFY_ON   TEXT NULL,\n            FK_GROUP_ID INTEGER NOT NULL ,\n            CONSTRAINT FK_GROUP_ID_CONSTRAINT FOREIGN KEY (FK_GROUP_ID)\n                REFERENCES CONTACT_GROUP(GROUP_ID) ON DELETE CASCADE\n        );\n        CREATE INDEX idx_fk_contact_group ON CONTACTS (FK_GROUP_ID);\n\n        CREATE TABLE CONTACT_ADDRESS (\n            ADDRESS_ID  INTEGER    PRIMARY KEY ASC AUTOINCREMENT,\n            ADDRESS_TAG_AS TEXt NOT NULL,\n            ADDRESS     TEXT NOT NULL,\n            AREA        TEXT NULL,\n            CITY        TEXT NULL,\n            PIN         TEXT NULL,\n            IS_PRIMARY TEXT NULL,\n            CREATED_ON  TEXT  NOT NULL,\n            MODIFY_ON   TEXT NULL,\n            FK_CONTACT_ID INTEGER NOT NULL ,\n            CONSTRAINT FK_CONTACT_ID_CONSTRAINT\n            FOREIGN KEY (FK_CONTACT_ID)\n            REFERENCES CONTACTS(CONTACT_ID)\n            ON DELETE CASCADE\n        );\n\n         CREATE INDEX idx_fk_contact_address_contactId ON CONTACT_ADDRESS (FK_CONTACT_ID);\n\n\n        CREATE TABLE CONTACT_NUMBERS (\n            NUMBER_ID  INTEGER    PRIMARY KEY ASC AUTOINCREMENT,\n            TAG_AS  TEXT NOT NULL,\n            VALUE        TEXT NULL,\n            IS_PRIMARY TEXT NULL,\n            CREATED_ON  TEXT  NOT NULL,\n            MODIFY_ON   TEXT NULL,\n            FK_CONTACT_ID INTEGER NOT NULL ,\n            CONSTRAINT FK_CONTACT_ID_CONSTRAINT\n            FOREIGN KEY (FK_CONTACT_ID)\n            REFERENCES CONTACTS(CONTACT_ID)\n            ON DELETE CASCADE\n        );\n\n        CREATE INDEX idx_fk_contact_numbers_contactId ON CONTACT_NUMBERS (FK_CONTACT_ID);\n\n        CREATE TABLE CONTACT_EMAILS (\n            EMAIL_ID  INTEGER    PRIMARY KEY ASC AUTOINCREMENT,\n            TYPE TEXT NOT NULL,\n            TAG_AS TEXT NOT NULL,\n            VALUE TEXT NOT NULL,\n            CREATED_ON  TEXT  NOT NULL,\n            MODIFY_ON   TEXT NULL,\n            FK_CONTACT_ID INTEGER NOT NULL ,\n            CONSTRAINT FK_CONTACT_ID_CONSTRAINT\n            FOREIGN KEY (FK_CONTACT_ID)\n            REFERENCES CONTACTS(CONTACT_ID)\n            ON DELETE CASCADE\n        );\n        CREATE INDEX idx_fk_contact_email_contactId ON CONTACT_EMAILS (FK_CONTACT_ID);\n\n        CREATE TABLE CONTACT_EVENTS (\n            EVENT_ID  INTEGER    PRIMARY KEY ASC AUTOINCREMENT,\n            TAG_AS     TEXT NOT NULL,\n            VALUE        TEXT NOT NULL,\n            CREATED_ON  TEXT  NOT NULL,\n            MODIFY_ON   TEXT NULL,\n            FK_CONTACT_ID INTEGER NOT NULL ,\n            CONSTRAINT FK_CONTACT_ID_CONSTRAINT\n            FOREIGN KEY (FK_CONTACT_ID)\n            REFERENCES CONTACTS(CONTACT_ID)\n            ON DELETE CASCADE\n        );\n        CREATE INDEX idx_fk_contact_event_contactId ON CONTACT_EVENTS (FK_CONTACT_ID);\n\n        CREATE TABLE CONTACT_ADDITIONAL_INFO (\n            ADDITIONAL_INFO_ID  INTEGER    PRIMARY KEY ASC AUTOINCREMENT,\n            TAG_AS TEXT NOT NULL,\n            VALUE  TEXT NOT NULL,\n            COMMENTS TEXT NULL,\n            CREATED_ON  TEXT  NOT NULL,\n            MODIFY_ON   TEXT NULL,\n            FK_CONTACT_ID INTEGER NOT NULL ,\n            CONSTRAINT FK_CONTACT_ID_CONSTRAINT\n            FOREIGN KEY (FK_CONTACT_ID)\n            REFERENCES CONTACTS(CONTACT_ID)\n            ON DELETE CASCADE\n        );\n        CREATE INDEX idx_fk_contact_add_info_contactId ON CONTACT_ADDITIONAL_INFO (FK_CONTACT_ID);\n\n        CREATE TABLE PROPERTY_GROUP (\n            GROUP_ID   INTEGER  PRIMARY KEY ASC AUTOINCREMENT,\n            GROUP_NAME TEXT  UNIQUE NOT NULL,\n            CREATED_ON TEXT NOT NULL ,\n            MODIFY_ON  TEXT NULL\n        );\n\n        CREATE TABLE PROPERTY_RECORDS (\n            DATE                  TEXT  NOT NULL,\n            PROPERTY_ID           INTEGER    PRIMARY KEY ASC AUTOINCREMENT,\n            ADDRESS               TEXT  NOT NULL,\n            LOCATION              TEXT NULL,\n            CITY                  TEXT NULL,\n            PIN                   TEXT NULL,\n            PRICE                 INTEGER NULL,\n            DEPOSIT               INTEGER NULL,\n            RENT                  INTEGER NULL,\n            AREA_IN_SQFT          INTEGER NOT NULL,\n            OFFERED_BY_TYPE       INTEGER  NOT NULL,\n            FURNISHING_STATUS     INTEGER  NOT NULL,\n            COMMENTS              TEXT NULL,\n            CREATED_ON            TEXT  NOT NULL,\n            MODIFY_ON             TEXT NULL,\n            FK_CONTACT_ID         INTEGER    REFERENCES CONTACTS (CONTACT_ID) ON DELETE CASCADE,\n            FK_GROUP_ID           INTEGER    REFERENCES PROPERTY_GROUP (GROUP_ID) ON DELETE CASCADE\n        );\n        CREATE INDEX idx_fk_property_record_contactId ON PROPERTY_RECORDS (FK_CONTACT_ID);\n        CREATE INDEX idx_fk_property_record_groupId ON PROPERTY_RECORDS (FK_GROUP_ID);\n\n\n        CREATE TABLE PROPERTY_STATUS (\n            PROPERTY_STATUS_ID   INTEGER    PRIMARY KEY ASC AUTOINCREMENT,\n            PROPERTY_STATUS INTEGER NOT NULL,\n            FK_PROPERTY_ID INTEGER    REFERENCES PROPERTY_RECORDS (PROPERTY_ID) ON DELETE CASCADE,\n            CREATED_ON  TEXT  NOT NULL  DEFAULT (strftime('%d-%m-%Y %H:%M:%S', datetime('now', 'localtime') ) )\n        );\n        CREATE INDEX idx_fk_property_status_propertyId ON PROPERTY_STATUS (FK_PROPERTY_ID);\n\n        CREATE TABLE PROPERTY_ON_RENT (\n            PROPERTY_ON_RENT_ID  INTEGER PRIMARY KEY ASC AUTOINCREMENT,\n            START_DATE           TEXT    NOT NULL,\n            DEPOSIT              INTEGER  NULL,\n            RENT                 INTEGER  NULL,\n            FK_OWNER_CONTACT_ID  INTEGER NOT NULL REFERENCES CONTACTS (CONTACT_ID) ON DELETE CASCADE,\n            FK_TENANT_CONTACT_ID INTEGER NOT NULL REFERENCES CONTACTS (CONTACT_ID) ON DELETE CASCADE,\n            FK_RENTED_BY_CONTACT_ID INTEGER NULL,\n            TENURE_IN_MONTHS     INTEGER NOT NULL,\n            END_DATE             TEXT    NOT NULL,\n            TERMINATION_REASON   TEXT NULL,\n            TERMINATION_DATE     TEXT NULL,\n            BROKERAGE            INTEGER  NULL,\n            CREATED_ON           TEXT    NOT NULL,\n            MODIFY_ON            TEXT NULL,\n            PROPERTY_RENT_BY INTEGER DEFAULT (0),\n            FK_PROPERTY_STATUS_ID  INTEGER NOT NULL REFERENCES PROPERTY_STATUS (PROPERTY_STATUS_ID) ON DELETE CASCADE\n        );\n         CREATE INDEX idx_fk_property_on_rent_owner_contactId ON PROPERTY_ON_RENT (FK_OWNER_CONTACT_ID);\n         CREATE INDEX idx_fk_property_on_rent_tenant_contactId ON PROPERTY_ON_RENT (FK_TENANT_CONTACT_ID);\n         CREATE INDEX idx_fk_property_on_rent_statusId ON PROPERTY_ON_RENT (FK_PROPERTY_STATUS_ID);\n\n        CREATE TABLE PROPERTY_SELL_DETAILS (\n            PROPERTY_SELL_ID  INTEGER PRIMARY KEY ASC AUTOINCREMENT,\n            CONTRACT_DATE TEXT    NOT NULL,\n            PRICE  INTEGER NOT NULL,\n            FK_BUYER_ID  INTEGER NOT NULL REFERENCES CONTACTS (CONTACT_ID) ON DELETE CASCADE,\n            FK_SELLER_ID INTEGER NOT NULL REFERENCES CONTACTS (CONTACT_ID) ON DELETE CASCADE,\n            FK_SELL_BY_CONTACT_ID INTEGER NULL,\n            BROKERAGE            INTEGER  NULL,\n            CREATED_ON           TEXT    NOT NULL,\n            MODIFY_ON            TEXT NULL,\n            PROPERTY_SELL_BY INTEGER DEFAULT (0),\n            FK_PROPERTY_STATUS_ID  INTEGER NOT NULL REFERENCES PROPERTY_STATUS (PROPERTY_STATUS_ID) ON DELETE CASCADE\n        );\n        CREATE INDEX idx_fk_property_on_sell_buyer_contactId ON PROPERTY_SELL_DETAILS (FK_BUYER_ID);\n        CREATE INDEX idx_fk_property_on_sell_seller_contactId ON PROPERTY_SELL_DETAILS (FK_SELLER_ID);\n        CREATE INDEX idx_fk_property_on_sell_statusId ON PROPERTY_SELL_DETAILS (FK_PROPERTY_STATUS_ID);\n\n\n\n        CREATE TABLE USER_DETAILS (\n            USER_ID   INTEGER    PRIMARY KEY ASC AUTOINCREMENT,\n            CLIENT_ID  TEXT   NOT NULL,\n            USER_NAME  TEXT   NOT NULL,\n            ADDRESS TEXT NOT NULL,\n            LOGO BLOB NULL,\n            PASSWORD TEXT NOT NULL,\n            EMAIL TEXT NOT NULL,\n            MOBILE TEXT NOT NULL,\n            VERSION TEXT NOT NULL DEFAULT '4.5',\n            CREATED_ON  TEXT NOT NULL\n        );\n\n        CREATE TABLE KEY_DETAILS (\n            KEY_ID   INTEGER    PRIMARY KEY ASC AUTOINCREMENT,\n            KEY TEXT NOT NULL,\n            KEY_DATE NOT NULL UNIQUE\n        );\n\n        CREATE TABLE PAYMENT_TRACKER (\n            PAYMENT_TRACKER_ID  INTEGER PRIMARY KEY ASC AUTOINCREMENT,\n            PAYMENT_DATE TEXT NOT NULL,\n            MONTH TEXT NOT NULL,\n            MODE_OF_PAYMENT INTEGER NOT NULL,\n            PAYMENT_REFERENCE_NO TEXT NULL,\n            PAYMENT_AMOUNT INTEGER NOT NULL,\n            COMMENTS TEXT NULL,\n            CREATED_ON TEXT NOT NULL,\n            MODIFY_ON  TEXT NULL,\n            FK_PROPERTY_ON_RENT_ID  INTEGER NOT NULL REFERENCES PROPERTY_ON_RENT (PROPERTY_ON_RENT_ID) ON DELETE CASCADE\n        );\n        CREATE INDEX idx_fk_property_payment_tracker ON PAYMENT_TRACKER (FK_PROPERTY_ON_RENT_ID);\n\n\n        CREATE TABLE ENQUIRY (\n          ENQUIRY_ID  INTEGER    PRIMARY KEY ASC AUTOINCREMENT,\n          DATE  TEXT NOT NULL,\n          LOOKING_FOR TEXT NOT NULL,\n          AREA TEXT NULL,\n          BUDGET_FROM TEXT NULL,\n          BUDGET_TO TEXT NULL,\n          SIZE_FROM TEXT NULL,\n          SIZE_TO TEXT NULL,\n          SOURCE TEXT NULL,\n          COMMENTS TEXT NULL,\n          STATUS INTEGER NOT NULL,\n          CREATED_ON  TEXT  NOT NULL,\n          MODIFY_ON   TEXT NULL,\n          FK_CONTACT_ID INTEGER  REFERENCES CONTACTS (CONTACT_ID) ON DELETE CASCADE,\n          FK_GROUP_ID   INTEGER  REFERENCES PROPERTY_GROUP (GROUP_ID) ON DELETE CASCADE\n        );\n        CREATE INDEX idx_fk_enquiry_contactId ON ENQUIRY (FK_CONTACT_ID);\n        CREATE INDEX idx_fk_enquiry_groupId ON ENQUIRY (FK_GROUP_ID);\n\n        CREATE TABLE ENQUIRY_FOLLOWUP (\n              ENQUIRY_FOLLOW_UP_ID  INTEGER    PRIMARY KEY ASC AUTOINCREMENT,\n              DATE  TEXT NOT NULL,\n              FOLLOW_UP_DATE  TEXT NOT NULL,\n              COMMENTS TEXT NULL,\n               FOLLOWUP_STATUS INTEGER NOT NULL,\n              CREATED_ON  TEXT  NOT NULL,\n              MODIFY_ON   TEXT NULL,\n              FK_ENQUIRY_ID INTEGER  REFERENCES ENQUIRY (ENQUIRY_ID) ON DELETE CASCADE\n           );\n           CREATE INDEX idx_fk_enquiry_followUp ON ENQUIRY_FOLLOWUP (FK_ENQUIRY_ID);\n\n\n\n        CREATE TABLE DEPOSIT_TRACKER (\n            DEPOSIT_ID  INTEGER PRIMARY KEY ASC AUTOINCREMENT,\n            PAYMENT_DATE TEXT NOT NULL,\n            MODE_OF_PAYMENT INTEGER NOT NULL,\n            PAYMENT_REFERENCE_NO TEXT NULL,\n            PAYMENT_AMOUNT INTEGER NOT NULL,\n            COMMENTS TEXT NULL,\n            PAID_BY TEXT NOT NULL,\n            CREATED_ON TEXT NOT NULL,\n            MODIFY_ON  TEXT NULL,\n            FK_PROPERTY_ON_RENT_ID  INTEGER NOT NULL REFERENCES PROPERTY_ON_RENT (PROPERTY_ON_RENT_ID) ON DELETE CASCADE\n        );\n        CREATE INDEX idx_fk_rent_deposit_tracker ON DEPOSIT_TRACKER (FK_PROPERTY_ON_RENT_ID);\n\n        CREATE TABLE RENT_CONDITIONS (\n            RENT_CONDITIONS_ID  INTEGER PRIMARY KEY ASC AUTOINCREMENT,\n            START_MONTH           TEXT    NOT NULL,\n            END_MONTH             TEXT    NOT NULL,\n            RENT                 INTEGER  NULL,\n            RENT_REVISED_IN_MONTHS     INTEGER NOT NULL,\n            FK_PROPERTY_STATUS_ID  INTEGER NOT NULL REFERENCES PROPERTY_STATUS (PROPERTY_STATUS_ID) ON DELETE CASCADE\n         );\n\n         CREATE INDEX idx_fk_rent_conditions ON RENT_CONDITIONS (FK_PROPERTY_STATUS_ID);\n\n          CREATE TABLE CONTACT_DOCUMENTS (\n            CONTACT_DOCUMENT_ID  INTEGER PRIMARY KEY ASC AUTOINCREMENT,\n            DOCUMENT_NAME TEXT NOT NULL,\n            DOCUMENT BLOB NULL,\n            CREATED_ON  TEXT  NOT NULL,\n            MODIFY_ON   TEXT NULL,\n            FK_CONTACT_ID INTEGER NOT NULL ,\n            CONSTRAINT FK_CONTACT_ID_CONSTRAINT\n            FOREIGN KEY (FK_CONTACT_ID)\n            REFERENCES CONTACTS(CONTACT_ID)\n            ON DELETE CASCADE\n        );\n         CREATE INDEX idx_fk_contact_document ON CONTACT_DOCUMENTS (FK_CONTACT_ID);\n\n        CREATE TABLE PROPERTY_DOCUMENTS (\n            PROPERTY_DOCUMENT_ID  INTEGER PRIMARY KEY ASC AUTOINCREMENT,\n            DOCUMENT_NAME TEXT NOT NULL,\n            DOCUMENT BLOB NULL,\n            CREATED_ON  TEXT  NOT NULL,\n            MODIFY_ON   TEXT NULL,\n            FK_PROPERTY_ID INTEGER    REFERENCES PROPERTY_RECORDS (PROPERTY_ID) ON DELETE CASCADE\n        );\n        CREATE INDEX idx_fk_property_document_propertyId ON PROPERTY_DOCUMENTS (FK_PROPERTY_ID);\n\n\n        CREATE TABLE PROPERTY_TRANSACTION_DOCUMENTS (\n                TRANSACTION_DOCUMENT_ID  INTEGER PRIMARY KEY ASC AUTOINCREMENT,\n                DOCUMENT_NAME TEXT NOT NULL,\n                DOCUMENT BLOB NULL,\n                CREATED_ON  TEXT  NOT NULL,\n                MODIFY_ON   TEXT NULL,\n                FK_PROPERTY_STATUS_ID INTEGER REFERENCES PROPERTY_STATUS (PROPERTY_STATUS_ID) ON DELETE CASCADE\n         );\n\n        CREATE INDEX idx_fk_property_trans_document_statusId ON PROPERTY_TRANSACTION_DOCUMENTS (FK_PROPERTY_STATUS_ID);\n\n        CREATE TABLE TEAM_MEMBERS (\n            TEAM_MEMBER_ID  INTEGER    PRIMARY KEY ASC AUTOINCREMENT,\n            FK_CONTACT_ID INTEGER NOT NULL ,\n            CREATED_ON  TEXT  NOT NULL,\n            CONSTRAINT FK_CONTACT_ID_CONSTRAINT\n            FOREIGN KEY (FK_CONTACT_ID)\n            REFERENCES CONTACTS(CONTACT_ID)\n            ON DELETE CASCADE\n        );\n\n         CREATE TABLE TEAM_AUDIT_DETAILS (\n            TEAM_AUDIT_ID  INTEGER    PRIMARY KEY ASC AUTOINCREMENT,\n            FK_TEAM_MEMBER_ID INTEGER NOT NULL ,\n            REQUEST_RECEIVED TEXT  NOT NULL,\n            REQUEST_DATE_TIME TEXT NOT NULL,\n            RESPONSE TEXT  NULL,\n            RESPONSE_DATE_TIME TEXT NULL,\n            CREATED_ON  TEXT  NOT NULL,\n            CONSTRAINT FK_TEAM_MEMBER_CONSTRAINT\n            FOREIGN KEY (FK_TEAM_MEMBER_ID)\n            REFERENCES TEAM_MEMBERS(TEAM_MEMBER_ID)\n            ON DELETE CASCADE\n        );\n\n        CREATE TABLE EMAIL_CONFIG_DETAILS (\n            EMAIL_CONFIG_ID  INTEGER    PRIMARY KEY ASC AUTOINCREMENT,\n            EMAIL TEXT  NOT NULL,\n            PASSWORD TEXT NOT NULL,\n            IMAP_HOST TEXT NOT NULL,\n            IMAP_PORT TEXT NOT NULL,\n            SMTP_HOST TEXT NOT NULL,\n            SMTP_PORT TEXT NOT NULL,\n            CREATED_ON  TEXT  NOT NULL,\n            MODIFY_ON   TEXT NULL\n        );\n\n        CREATE TABLE PROJECT_TYPES\n          (\n            PROJECT_TYPE_ID   INTEGER  PRIMARY KEY ASC AUTOINCREMENT,\n            PROJECT_TYPE_NAME TEXT  UNIQUE NOT NULL,\n            CREATED_ON TEXT NOT NULL ,\n            MODIFY_ON  TEXT NULL\n        );\n\n        CREATE TABLE PROJECT_DETAILS\n          (\n            PROJECT_ID  INTEGER  PRIMARY KEY ASC AUTOINCREMENT,\n            PROJECT_NAME TEXT  UNIQUE NOT NULL,\n            FK_PROJECT_TYPE_ID INTEGER  REFERENCES PROJECT_TYPES (PROJECT_TYPE_ID) ON DELETE CASCADE,\n            PROJECT_STATUS TEXT NULL,\n            TOTAL_AREA INTEGER NULL,\n            TOTAL_UNITS INTEGER NULL,\n            NUMBER_OF_FLOORS INTEGER NULL,\n            PROJECT_DESCRIPTION TEXT NULL,\n            LAUNCH_DATE TEXT NULL,\n            COMPLETION_DATE TEXT NULL,\n            LOCATION_DETAILS TEXT NULL,\n            FK_BUILDER_CONTACT_ID  INTEGER NOT NULL ,\n            FK_ARCHITECT_CONTACT_ID INTEGER NULL,\n            RERA_REGISTRATION_NUMBER TEXT NULL,\n            CREATED_ON TEXT NOT NULL ,\n            MODIFY_ON  TEXT NULL\n        );\n\n        CREATE INDEX idx_fk_project_type_id ON PROJECT_DETAILS (FK_PROJECT_TYPE_ID);\n        CREATE INDEX idx_project_name ON PROJECT_DETAILS (PROJECT_NAME);\n\n         CREATE TABLE PROJECT_UNIT_DETAILS\n          (\n            UNIT_ID   INTEGER  PRIMARY KEY ASC AUTOINCREMENT,\n            PROPERTY_TYPE TEXT  NOT NULL,\n            UNIT_SIZE INTEGER  NULL ,\n            UNIT_BASE_PRICE INTEGER  NULL ,\n            PAYMENT_PLAN TEXT NULL,\n            COMMENTS TEXT NULL,\n            FK_PROJECT_ID INT REFERENCES PROJECT_DETAILS (PROJECT_ID) ON DELETE CASCADE,\n            CREATED_ON TEXT NOT NULL ,\n            MODIFY_ON  TEXT NULL\n        );\n\n        CREATE INDEX idx_fk_project_id_unit_details ON PROJECT_UNIT_DETAILS (FK_PROJECT_ID);\n\n\n         CREATE TABLE PROJECT_AMENITIES_DETAILS\n          (\n            AMENITIES_ID   INTEGER  PRIMARY KEY ASC AUTOINCREMENT,\n            AMENITIES TEXT  NOT NULL,\n            FK_PROJECT_ID INT REFERENCES PROJECT_DETAILS (PROJECT_ID) ON DELETE CASCADE,\n            CREATED_ON TEXT NOT NULL\n        );\n        CREATE INDEX idx_fk_project_id_amenities_details ON PROJECT_AMENITIES_DETAILS (FK_PROJECT_ID);\n\n\n        CREATE TABLE PROJECT_ADDITIONAL_DETAILS\n          (\n            ADDITIONAL_ID INTEGER  PRIMARY KEY ASC AUTOINCREMENT,\n            NAME TEXT  NOT NULL,\n            VALUE TEXT NOT  NULL,\n            FK_PROJECT_ID INT REFERENCES PROJECT_DETAILS (PROJECT_ID) ON DELETE CASCADE,\n            CREATED_ON TEXT NOT NULL\n        );\n        CREATE INDEX idx_fk_project_id_additional_details ON PROJECT_ADDITIONAL_DETAILS (FK_PROJECT_ID);\n\n\n         CREATE TABLE PROJECT_TRANSACTION_DOCUMENTS (\n                TRANSACTION_DOCUMENT_ID  INTEGER PRIMARY KEY ASC AUTOINCREMENT,\n                DOCUMENT_NAME TEXT NOT NULL,\n                DOCUMENT BLOB NULL,\n                CREATED_ON  TEXT  NOT NULL,\n                MODIFY_ON   TEXT NULL,\n                FK_PROJECT_ID INT REFERENCES PROJECT_DETAILS (PROJECT_ID) ON DELETE CASCADE\n         );\n         CREATE INDEX idx_fk_project_documents ON PROJECT_TRANSACTION_DOCUMENTS (FK_PROJECT_ID);\n\n         CREATE TABLE PROPERTY_ADDITIONAL_DETAILS\n         (\n            ADDITIONAL_ID INTEGER  PRIMARY KEY ASC AUTOINCREMENT,\n            NAME TEXT  NOT NULL,\n            VALUE TEXT NOT  NULL,\n            FK_PROPERTY_ID INT REFERENCES PROPERTY_RECORDS (PROPERTY_ID) ON DELETE CASCADE,\n            CREATED_ON TEXT NOT NULL\n         );\n        CREATE INDEX idx_fk_property_id_additional_details ON PROPERTY_ADDITIONAL_DETAILS (FK_PROPERTY_ID);\n\n        ALTER TABLE PROPERTY_RECORDS\n        ADD COLUMN UNAVAILABLE_UNTIL TEXT;\n\n        ALTER TABLE ENQUIRY\n        ADD COLUMN ADDITIONAL_INFO TEXT;\n";
    private static final String CLIENT_DETAILS = "  Select  USER_NAME, ADDRESS , PASSWORD , EMAIL, MOBILE, CLIENT_ID,\n  (Select KEY_DATE from KEY_DETAILS where KEY_ID=(Select MAX(KEY_ID) from KEY_DETAILS)) as EFFECTIVE_TILL\n  , LOGO ,VERSION , MOBILE from  USER_DETAILS;\n";
    private static final String INSERT_USER_DETAILS = "INSERT INTO USER_DETAILS (CLIENT_ID,USER_NAME, ADDRESS, PASSWORD , EMAIL, MOBILE, CREATED_ON, LOGO,VERSION) VALUES (?,?,?,?,?,?,?,?,?)\n";
    private static final String INSERT_KEYS = "INSERT INTO KEY_DETAILS (KEY, KEY_DATE) VALUES (?,?);\n";
    private static final String UPDATE_NEW_PASSWORD = "UPDATE USER_DETAILS SET PASSWORD =?";
    private static final String USER_PASSWORD = "SELECT USER_NAME, PASSWORD , VERSION FROM USER_DETAILS";
    private static final String DELETE_ALL_KEYS = "DELETE from KEY_DETAILS";
    private static final String FETCH_KEY = "SELECT KEY from KEY_DETAILS where KEY_DATE=?";
    private static final String INSERT_DEFAULT_CONTACT_CATEGORIES = "INSERT INTO CONTACT_GROUP (GROUP_NAME, CREATED_ON) VALUES (?, ?);";
    private static final String INSERT_DEFAULT_PROPERTY_CATEGORIES = "INSERT INTO PROPERTY_GROUP (GROUP_NAME, CREATED_ON) VALUES (?, ?);";
    private static final String INSERT_DEFAULT_PROJECT_CATEGORIES = "INSERT INTO PROJECT_TYPES (PROJECT_TYPE_NAME, CREATED_ON) VALUES (?, ?);";

    @Override
    public void createUserWithDatabase(UserDetails userDetails) throws DatabaseException {
        try (Connection conn = DbUtility.getConnection();){
            conn.setAutoCommit(false);
            try {
                this.createDatabaseTables(conn);
                this.insertUserDetails(conn, userDetails);
                this.insertKeys(conn, userDetails);
                this.insertDefaultCategories(conn);
                conn.commit();
            }
            catch (Exception e) {
                conn.rollback();
                throw new DatabaseException("Error creating user with database: " + e.getMessage(), e);
            }
        }
        catch (SQLException e) {
            throw new DatabaseException("Database connection error: " + e.getMessage(), e);
        }
    }

    @Override
    public UserDetails fetchUserDetails() throws DatabaseException {
        UserDetails userDetails = null;
        try (Connection con = DbUtility.getConnection();
             Statement statement = con.createStatement();
             ResultSet resultSet = statement.executeQuery(CLIENT_DETAILS);){
            if (resultSet.next()) {
                userDetails = new UserDetails.Builder().userName(resultSet.getString("USER_NAME")).address(resultSet.getString("ADDRESS")).effectiveTill(resultSet.getString("EFFECTIVE_TILL")).email(resultSet.getString("EMAIL")).logo(resultSet.getBinaryStream("LOGO")).clientId(resultSet.getString("CLIENT_ID")).softwareVersion(resultSet.getString("VERSION")).mobileNo(resultSet.getString("MOBILE")).build();
            }
        }
        catch (Exception e) {
            throw new DatabaseException("Error in fetching client Details " + e.getMessage(), e);
        }
        return userDetails;
    }

    @Override
    public boolean validateUser(String password) throws DatabaseException {
        boolean isValidUser = false;
        try (Connection con = DbUtility.getConnection();
             Statement statement = con.createStatement();
             ResultSet resultSet = statement.executeQuery(USER_PASSWORD);){
            if (resultSet.next() && BCrypt.checkpw(password, resultSet.getString("PASSWORD"))) {
                isValidUser = true;
            }
        }
        catch (Exception e) {
            throw new DatabaseException("Error in validate user " + e.getMessage(), e);
        }
        return isValidUser;
    }

    @Override
    public void changePassword(String newPassword) throws DatabaseException {
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement ps = conn.prepareStatement(UPDATE_NEW_PASSWORD);){
            ps.setString(1, BCrypt.hashpw(newPassword, BCrypt.gensalt()));
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new DatabaseException("Error in changePassword " + e.getMessage(), e);
        }
    }

    @Override
    public void renewDatabase(long noOfDays, String password) throws DatabaseException {
        try (Connection conn = DbUtility.getConnection();){
            conn.setAutoCommit(false);
            LocalDate currentDate = LocalDate.now();
            try (PreparedStatement deleteStatement = conn.prepareStatement(DELETE_ALL_KEYS);){
                deleteStatement.executeUpdate();
                try (PreparedStatement insertStatement = conn.prepareStatement(INSERT_KEYS);){
                    int i = 0;
                    while ((long)i <= noOfDays) {
                        String hashedKey = BCrypt.hashpw(currentDate.plusDays(i) + password, BCrypt.gensalt());
                        String formattedDate = AppUtility.convertDatetoString(currentDate.plusDays(i));
                        insertStatement.setString(1, hashedKey);
                        insertStatement.setString(2, formattedDate);
                        insertStatement.addBatch();
                        ++i;
                    }
                    insertStatement.executeBatch();
                    conn.commit();
                }
            }
            catch (Exception e) {
                conn.rollback();
                throw new DatabaseException("Transaction failed: " + e.getMessage(), e);
            }
        }
        catch (Exception e) {
            throw new DatabaseException("Database operation failed: " + e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String fetchKey() throws DatabaseException {
        try (Connection con = DbUtility.getConnection();
             PreparedStatement ps = con.prepareStatement(FETCH_KEY);){
            ps.setString(1, AppUtility.convertDatetoString(LocalDate.now()));
            try (ResultSet resultSet = ps.executeQuery();){
                if (!resultSet.next()) return null;
                String string = resultSet.getString("KEY");
                return string;
            }
        }
        catch (Exception e) {
            throw new DatabaseException("Unable to fetch key: " + e.getMessage(), e);
        }
    }

    private void createDatabaseTables(Connection conn) throws Exception {
        try (Statement stmt = conn.createStatement();){
            stmt.executeUpdate(CREATE_DATABASE_TABLES);
        }
        catch (Exception e) {
            throw new DatabaseException("Error while create database table " + e.getMessage(), e);
        }
    }

    private void insertUserDetails(Connection conn, UserDetails userDetails) throws Exception {
        try (PreparedStatement ps = conn.prepareStatement(INSERT_USER_DETAILS);){
            ps.setString(1, userDetails.clientId());
            ps.setString(2, userDetails.userName());
            ps.setString(3, userDetails.address());
            ps.setString(4, BCrypt.hashpw(userDetails.password(), BCrypt.gensalt()));
            ps.setString(5, userDetails.email());
            ps.setString(6, userDetails.mobileNo());
            ps.setString(7, AppUtility.getCurrentDateInString());
            String path = userDetails.logoPath().trim();
            if (!path.isEmpty() && !"-".equals(path)) {
                File file = new File(path);
                FileInputStream fis = new FileInputStream(file);
                ps.setBinaryStream(8, (InputStream)fis, (int)file.length());
            } else {
                ps.setBinaryStream(8, (InputStream)new ByteArrayInputStream(new byte[0]), 0);
            }
            ps.setString(9, LoginView.version);
            ps.executeUpdate();
        }
        catch (Exception e) {
            conn.rollback();
            throw new DatabaseException("Error in inserting user details " + e.getMessage(), e);
        }
    }

    private void insertKeys(Connection conn, UserDetails userDetails) throws DatabaseException {
        LocalDate currentDate = LocalDate.now();
        try (PreparedStatement ps = conn.prepareStatement(INSERT_KEYS);){
            for (int i = 0; i < 10; ++i) {
                ps.setString(1, BCrypt.hashpw(currentDate.plusDays(i) + userDetails.password(), BCrypt.gensalt()));
                ps.setString(2, AppUtility.convertDatetoString(currentDate.plusDays(i)));
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (Exception e) {
            throw new DatabaseException("Error in inserting keys " + e.getMessage(), e);
        }
    }

    private void insertDefaultCategories(Connection conn) throws DatabaseException {
        List<String> defaultConCategories;
        PreparedStatement ps;
        LocalDate currentDate = LocalDate.now();
        try {
            ps = conn.prepareStatement(INSERT_DEFAULT_CONTACT_CATEGORIES);
            try {
                defaultConCategories = Arrays.asList("Owners", "Tenants", "Visitors");
                for (String category : defaultConCategories) {
                    ps.setString(1, category);
                    ps.setString(2, AppUtility.convertDatetoString(currentDate));
                    ps.addBatch();
                }
                ps.executeBatch();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        try {
            ps = conn.prepareStatement(INSERT_DEFAULT_PROPERTY_CATEGORIES);
            try {
                defaultConCategories = Arrays.asList("1BHK", "2BHK", "3BHK", "Shops", "Offices", "Warehouses");
                for (String category : defaultConCategories) {
                    ps.setString(1, category);
                    ps.setString(2, AppUtility.convertDatetoString(currentDate));
                    ps.addBatch();
                }
                ps.executeBatch();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        try {
            ps = conn.prepareStatement(INSERT_DEFAULT_PROJECT_CATEGORIES);
            try {
                List<String> defaultProjectTypes = Arrays.asList("Residential", "Commercial", "Land", "Industrial");
                for (String category : defaultProjectTypes) {
                    ps.setString(1, category);
                    ps.setString(2, AppUtility.convertDatetoString(currentDate));
                    ps.addBatch();
                }
                ps.executeBatch();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
    }
}

