/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.dao.contact;

import com.arun.bhardwaj.dao.contact.ContactDao;
import com.arun.bhardwaj.exceptions.DatabaseException;
import com.arun.bhardwaj.model.contact.ContactAddress;
import com.arun.bhardwaj.model.contact.ContactEvents;
import com.arun.bhardwaj.model.contact.ContactNumber;
import com.arun.bhardwaj.model.contact.ContactRecord;
import com.arun.bhardwaj.model.contact.ContactStatistics;
import com.arun.bhardwaj.utility.AppUtility;
import com.arun.bhardwaj.utility.DbUtility;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ContactDaoImpl
implements ContactDao {
    private static final String CONTACTS = "SELECT\n    COUNT(*) OVER() AS TOTAL_COUNT,\n    C.NAME,\n    C.COMMENTS,\n    CN.VALUE AS NUMBER,\n    CN.NUMBER_ID,\n    CA.ADDRESS,\n    CA.AREA,\n    CA.CITY,\n    CA.PIN,\n    CA.ADDRESS_ID,\n    C.CONTACT_ID,\n    CG.GROUP_NAME\nFROM CONTACTS C\nJOIN CONTACT_GROUP CG\n    ON C.FK_GROUP_ID = CG.GROUP_ID\nLEFT JOIN CONTACT_NUMBERS CN\n    ON C.CONTACT_ID = CN.FK_CONTACT_ID AND CN.IS_PRIMARY = 'Yes'\nLEFT JOIN CONTACT_ADDRESS CA\n    ON C.CONTACT_ID = CA.FK_CONTACT_ID AND CA.IS_PRIMARY = 'Yes' WHERE FK_GROUP_ID\n";
    private static final String LOAD_CONTACT_NAMES_BY_GROUP = "SELECT C.CONTACT_ID, C.NAME FROM CONTACTS C JOIN CONTACT_GROUP CG ON C.FK_GROUP_ID = CG.GROUP_ID  WHERE CG.GROUP_NAME =? order by C.NAME";
    private static final String DELETE_CONTACTS = "Delete from CONTACTS where CONTACT_ID in(";
    private static final String FETCH_CONTACT_ID = "    Select C.CONTACT_ID  from CONTACT_GROUP CG\n    JOIN CONTACTS C ON CG.GROUP_ID = C.FK_GROUP_ID\n    where CG.GROUP_NAME =? and C.NAME=?\n";
    private static final String FETCH_IMAGE_BY_CONTACT_ID = "Select IMAGE from CONTACTS where CONTACT_ID=?\n";
    private static final String FETCH_CONTACTS_STATISTICS = "select count(*) as COUNT , CG.GROUP_NAME\n            FROM CONTACTS C\n            JOIN CONTACT_GROUP CG ON CG.GROUP_ID = C.FK_GROUP_ID \n            Group by GROUP_NAME\n";
    private static final String FETCH_CONTACTS_EVENTS = "    SELECT C.NAME, CE.TAG_AS, CN.VALUE\n            FROM CONTACT_EVENTS CE\n            JOIN CONTACTS C ON C.CONTACT_ID = CE.FK_CONTACT_ID\n            LEFT JOIN CONTACT_NUMBERS CN ON CN.FK_CONTACT_ID = C.CONTACT_ID\n            WHERE (CN.IS_PRIMARY = 'Yes' OR CN.FK_CONTACT_ID IS NULL) AND CE.VALUE LIKE\n\n";

    private String getContactIdsBySearchCategory(String searchBy, String value) throws DatabaseException {
        ArrayList<Integer> contactIds = new ArrayList<Integer>();
        Object sql = "";
        if ("ADDRESS".equals(searchBy)) {
            sql = "Select FK_CONTACT_ID from CONTACT_ADDRESS WHERE ADDRESS LIKE '%" + value + "%' OR AREA LIKE '%" + value + "%' OR CITY LIKE '%" + value + "%' OR PIN LIKE '%" + value + "%'";
        } else if ("CONTACT NO".equals(searchBy)) {
            sql = "Select FK_CONTACT_ID from CONTACT_NUMBERS WHERE VALUE LIKE '%" + value + "%'";
        } else if ("EMAIL/LINKS".equals(searchBy)) {
            sql = "Select FK_CONTACT_ID from CONTACT_EMAILS WHERE VALUE LIKE '%" + value + "%'";
        } else if ("EVENTS".equals(searchBy)) {
            sql = "Select FK_CONTACT_ID from CONTACT_EVENTS WHERE VALUE LIKE '%" + value + "%'";
        } else if ("ADDITIONAL INFO".equals(searchBy)) {
            sql = "Select FK_CONTACT_ID from CONTACT_ADDITIONAL_INFO WHERE VALUE LIKE '%" + value + "%'";
        }
        try (Connection conn = DbUtility.getConnection();
             Statement state = conn.createStatement();
             ResultSet res = state.executeQuery((String)sql);){
            while (res.next()) {
                contactIds.add(res.getInt("FK_CONTACT_ID"));
            }
        }
        catch (Exception e) {
            throw new DatabaseException("getContactIdsBySearchCategory", e);
        }
        return contactIds.stream().map(String::valueOf).collect(Collectors.joining(","));
    }

    @Override
    public List<ContactRecord> loadContactDetails(Integer groupId, String search, String searchBy, int page, int pageSize) throws Exception {
        String contactIds;
        int offset = (page - 1) * pageSize;
        StringBuilder strSql = new StringBuilder();
        strSql.append(CONTACTS);
        if (groupId == -1) {
            strSql.append(" in(select GROUP_ID from CONTACT_GROUP)");
        } else {
            strSql.append(" = ? ");
        }
        if (!search.trim().isEmpty() && ("NAME".equals(searchBy) || "COMMENTS".equals(searchBy))) {
            strSql.append(" AND ");
            strSql.append(searchBy);
            strSql.append(" like '%");
            strSql.append(search);
            strSql.append("%'");
        } else if (!search.trim().isEmpty() && !(contactIds = this.getContactIdsBySearchCategory(searchBy, search)).isEmpty()) {
            strSql.append(" AND  C.CONTACT_ID in(");
            strSql.append(contactIds);
            strSql.append(")");
        }
        strSql.append(" order by NAME LIMIT ? OFFSET ?");
        ArrayList<ContactRecord> contactList = new ArrayList<ContactRecord>();
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement ps = conn.prepareStatement(strSql.toString());){
            if (groupId != -1) {
                ps.setInt(1, groupId);
                ps.setInt(2, pageSize);
                ps.setInt(3, offset);
            } else {
                ps.setInt(1, pageSize);
                ps.setInt(2, offset);
            }
            try (ResultSet result = ps.executeQuery();){
                while (result.next()) {
                    ContactAddress contactAddress = new ContactAddress.Builder().address(AppUtility.validateString(result.getString("ADDRESS")) ? " " : result.getString("ADDRESS")).area(AppUtility.validateString(result.getString("AREA")) ? " " : result.getString("AREA")).city(AppUtility.validateString(result.getString("CITY")) ? " " : result.getString("CITY")).pin(AppUtility.validateString(result.getString("PIN")) ? " " : result.getString("PIN")).addressId(result.getInt("ADDRESS_ID")).build();
                    ContactNumber contactNumber = new ContactNumber.Builder().contactValue(result.getString("NUMBER") == null ? "" : result.getString("NUMBER")).contactNumberId(result.getInt("NUMBER_ID")).build();
                    ContactRecord record = new ContactRecord.Builder().totalRecords(result.getInt("TOTAL_COUNT")).name(result.getString("NAME")).comments(result.getString("COMMENTS")).primaryAddress(contactAddress).primaryNumber(contactNumber).groupName(result.getString("GROUP_NAME")).contactId(result.getInt("CONTACT_ID")).build();
                    contactList.add(record);
                }
            }
        }
        catch (Exception e) {
            throw new DatabaseException("loadContactDetails", e);
        }
        return contactList;
    }

    @Override
    public void deleteRecord(List<Integer> contactIds) throws DatabaseException {
        StringBuilder queryBuilder = new StringBuilder(DELETE_CONTACTS);
        for (int i = 0; i < contactIds.size(); ++i) {
            queryBuilder.append("?");
            if (i >= contactIds.size() - 1) continue;
            queryBuilder.append(",");
        }
        queryBuilder.append(")");
        try (Connection con = DbUtility.getConnection();
             PreparedStatement ps = con.prepareStatement(queryBuilder.toString());){
            for (int i = 0; i < contactIds.size(); ++i) {
                ps.setInt(i + 1, contactIds.get(i));
            }
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public InputStream getImage(int contactId) throws DatabaseException {
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement ps = conn.prepareStatement(FETCH_IMAGE_BY_CONTACT_ID);){
            ps.setInt(1, contactId);
            try (ResultSet res = ps.executeQuery();){
                if (!res.next()) return null;
                InputStream inputStream = res.getBinaryStream("IMAGE");
                return inputStream;
            }
        }
        catch (Exception e) {
            throw new DatabaseException("getImage", e);
        }
    }

    @Override
    public Map<Integer, String> loadContactNamesByGroup(String groupName) throws DatabaseException {
        LinkedHashMap<Integer, String> contacts = new LinkedHashMap<Integer, String>();
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement ps = conn.prepareStatement(LOAD_CONTACT_NAMES_BY_GROUP);){
            ps.setString(1, groupName);
            try (ResultSet res = ps.executeQuery();){
                while (res.next()) {
                    contacts.put(res.getInt("CONTACT_ID"), res.getString("NAME"));
                }
            }
        }
        catch (Exception e) {
            throw new DatabaseException("loadContactNamesByGroup", e);
        }
        return contacts;
    }

    @Override
    public int fetchContactId(String contactGroup, String contactName) throws DatabaseException {
        int contactId = 0;
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement ps = conn.prepareStatement(FETCH_CONTACT_ID);){
            ps.setString(1, contactGroup);
            ps.setString(2, contactName);
            try (ResultSet res = ps.executeQuery();){
                if (res.next()) {
                    contactId = res.getInt("CONTACT_ID");
                }
            }
        }
        catch (Exception e) {
            throw new DatabaseException("fetchContactId", e);
        }
        return contactId;
    }

    @Override
    public List<ContactStatistics> fetchContactStatistics() throws DatabaseException {
        ArrayList<ContactStatistics> contactStatistics = new ArrayList<ContactStatistics>();
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement ps = conn.prepareStatement(FETCH_CONTACTS_STATISTICS);
             ResultSet res = ps.executeQuery();){
            while (res.next()) {
                contactStatistics.add(new ContactStatistics(res.getString("GROUP_NAME"), res.getInt("COUNT")));
            }
        }
        catch (Exception e) {
            throw new DatabaseException("fetchContactStatistics", e);
        }
        return contactStatistics;
    }

    @Override
    public List<ContactEvents> fetchTodayContactEvents() throws DatabaseException {
        ArrayList<ContactEvents> contactEvents = new ArrayList<ContactEvents>();
        Calendar calendar = Calendar.getInstance();
        String strDate = calendar.get(5) + "-" + new SimpleDateFormat("MMM").format(calendar.getTime()) + "%'";
        String sql = "    SELECT C.NAME, CE.TAG_AS, CN.VALUE\n            FROM CONTACT_EVENTS CE\n            JOIN CONTACTS C ON C.CONTACT_ID = CE.FK_CONTACT_ID\n            LEFT JOIN CONTACT_NUMBERS CN ON CN.FK_CONTACT_ID = C.CONTACT_ID\n            WHERE (CN.IS_PRIMARY = 'Yes' OR CN.FK_CONTACT_ID IS NULL) AND CE.VALUE LIKE\n\n '" + strDate;
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);
             ResultSet res = ps.executeQuery();){
            while (res.next()) {
                contactEvents.add(new ContactEvents(res.getString("NAME"), res.getString("TAG_AS"), res.getString("VALUE")));
            }
        }
        catch (Exception e) {
            throw new DatabaseException("fetchTodayContactEvents", e);
        }
        return contactEvents;
    }

    @Override
    public Map<Integer, String> loadContactByIds(List contactIds) throws DatabaseException {
        HashMap<Integer, String> contactMap = new HashMap<Integer, String>();
        if (contactIds == null || contactIds.isEmpty()) {
            return contactMap;
        }
        StringBuilder queryBuilder = new StringBuilder("SELECT CONTACT_ID, NAME FROM CONTACTS WHERE CONTACT_ID IN (");
        for (int i = 0; i < contactIds.size(); ++i) {
            queryBuilder.append("?");
            if (i >= contactIds.size() - 1) continue;
            queryBuilder.append(",");
        }
        queryBuilder.append(");");
        String query = queryBuilder.toString();
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement preparedStatement = conn.prepareStatement(query);){
            for (int i = 0; i < contactIds.size(); ++i) {
                preparedStatement.setInt(i + 1, (Integer)contactIds.get(i));
            }
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    int contactId = resultSet.getInt("CONTACT_ID");
                    String name = resultSet.getString("NAME");
                    contactMap.put(contactId, name);
                }
            }
        }
        catch (SQLException e) {
            throw new DatabaseException("loadContactByIds", e);
        }
        return contactMap;
    }
}

