/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.dao.contact;

import com.arun.bhardwaj.factory.DocumentManagement;
import com.arun.bhardwaj.model.DocumentDetails;
import com.arun.bhardwaj.utility.AppUtility;
import com.arun.bhardwaj.utility.DbUtility;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

public class ContactDocumentDaoImpl
implements DocumentManagement {
    private static final String SAVE_CONTACT_DOCUMENT = "   INSERT INTO CONTACT_DOCUMENTS (DOCUMENT_NAME, DOCUMENT, CREATED_ON,FK_CONTACT_ID)\n                                         VALUES (?,?,?,?);\n";
    private static final String LOAD_CONTACT_DOCUMENTS = "SELECT CONTACT_DOCUMENT_ID,DOCUMENT_NAME, CREATED_ON\nFROM CONTACT_DOCUMENTS\nWHERE FK_CONTACT_ID =? order by CONTACT_DOCUMENT_ID desc\n";
    private static final String FETCH_DOCUMENT_BY_ID = "Select DOCUMENT , DOCUMENT_NAME from CONTACT_DOCUMENTS where CONTACT_DOCUMENT_ID=?\n";
    private static final String DELETE_DOCUMENT_BY_ID = "DELETE from CONTACT_DOCUMENTS where CONTACT_DOCUMENT_ID=?\n";
    private static final String LOAD_ALL_DOCUMENTS = "SELECT DOCUMENT_NAME, DOCUMENT\nFROM CONTACT_DOCUMENTS\nWHERE FK_CONTACT_ID =?\n";

    @Override
    public void save(DocumentDetails documentDetails) throws Exception {
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement preparedStatement = conn.prepareStatement(SAVE_CONTACT_DOCUMENT);){
            preparedStatement.setString(1, documentDetails.fileName());
            File file = new File(documentDetails.filePath());
            FileInputStream fis = new FileInputStream(file);
            preparedStatement.setBinaryStream(2, (InputStream)fis, (int)file.length());
            preparedStatement.setString(3, AppUtility.getCurrentDateInString());
            preparedStatement.setInt(4, documentDetails.primaryKey());
            preparedStatement.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public List<DocumentDetails> loadDocuments(Integer primaryKey) throws Exception {
        ArrayList<DocumentDetails> documentDetailsList = new ArrayList<DocumentDetails>();
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement preparedStatement = conn.prepareStatement(LOAD_CONTACT_DOCUMENTS);){
            preparedStatement.setInt(1, primaryKey);
            try (ResultSet result = preparedStatement.executeQuery();){
                while (result.next()) {
                    documentDetailsList.add(new DocumentDetails.Builder().date(result.getString("CREATED_ON")).fileName(result.getString("DOCUMENT_NAME")).documentId(result.getInt("CONTACT_DOCUMENT_ID")).build());
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return documentDetailsList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DocumentDetails getDocument(int documentId) throws Exception {
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement ps = conn.prepareStatement(FETCH_DOCUMENT_BY_ID);){
            ps.setInt(1, documentId);
            try (ResultSet res = ps.executeQuery();){
                if (!res.next()) return null;
                DocumentDetails documentDetails = new DocumentDetails.Builder().document(res.getBinaryStream("DOCUMENT")).fileName(res.getString("DOCUMENT_NAME")).build();
                return documentDetails;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public void deleteDocument(int documentId) throws Exception {
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement ps = conn.prepareStatement(DELETE_DOCUMENT_BY_ID);){
            ps.setInt(1, documentId);
            ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public List<DocumentDetails> downloadAllDocuments(Integer primaryKey) throws Exception {
        ArrayList<DocumentDetails> documentDetailsList = new ArrayList<DocumentDetails>();
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement preparedStatement = conn.prepareStatement(LOAD_ALL_DOCUMENTS);){
            preparedStatement.setInt(1, primaryKey);
            try (ResultSet result = preparedStatement.executeQuery();){
                while (result.next()) {
                    documentDetailsList.add(new DocumentDetails.Builder().fileName(result.getString("DOCUMENT_NAME")).document(result.getBinaryStream("DOCUMENT")).build());
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return documentDetailsList;
    }
}

