/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.dao.contact;

import com.arun.bhardwaj.dao.contact.ContactRecordDao;
import com.arun.bhardwaj.model.contact.ContactAdditionalInfo;
import com.arun.bhardwaj.model.contact.ContactAddress;
import com.arun.bhardwaj.model.contact.ContactEvent;
import com.arun.bhardwaj.model.contact.ContactLinks;
import com.arun.bhardwaj.model.contact.ContactNumber;
import com.arun.bhardwaj.model.contact.ContactRecord;
import com.arun.bhardwaj.utility.AppUtility;
import com.arun.bhardwaj.utility.DbUtility;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

public class ContactRecordDaoImpl
implements ContactRecordDao {
    private static final String SAVE_CONTACT_RECORD = "INSERT INTO CONTACTS (NAME, COMMENTS , IMAGE, FK_GROUP_ID,CREATED_ON) values(?,?,?,?,?)";
    private static final String IS_RECORD_EXISTS = "SELECT 1 FROM CONTACTS WHERE NAME=? AND FK_GROUP_ID =?";
    private static final String UPDATE_CONTACT_RECORD = "UPDATE CONTACTS SET NAME =?, COMMENTS=? , IMAGE=?, FK_GROUP_ID=?,MODIFY_ON =? WHERE CONTACT_ID=?";
    private static final String UPDATE_CONTACT_RECORD_WITHOUT_IMAGE = "UPDATE CONTACTS SET NAME =?, COMMENTS=? , FK_GROUP_ID=?,MODIFY_ON =? WHERE CONTACT_ID=?";
    private static final String SAVE_CONTACT_ADDRESS = "INSERT INTO CONTACT_ADDRESS(ADDRESS_TAG_AS, ADDRESS,AREA,CITY,PIN,CREATED_ON ,IS_PRIMARY , FK_CONTACT_ID) values(?,?,?,?,?,?,?,?)";
    private static final String LOAD_CONTACT_ADDRESS = "SELECT ADDRESS_TAG_AS, ADDRESS, AREA, CITY, PIN, ADDRESS_ID , IS_PRIMARY FROM CONTACT_ADDRESS WHERE FK_CONTACT_ID=? ORDER BY ADDRESS_ID ASC";
    private static final String DELETE_CONTACT_ADDRESS = "DELETE FROM CONTACT_ADDRESS WHERE ADDRESS_ID=? ";
    private static final String UPDATE_CONTACT_ADDRESS = "UPDATE CONTACT_ADDRESS SET ADDRESS_TAG_AS =?, ADDRESS=?, AREA=?, CITY=?, PIN=?, IS_PRIMARY=? , MODIFY_ON=? WHERE ADDRESS_ID=? ";
    private static final String UPDATE_ADDRESS_PRIMARY_STATUS_EMPTY = "UPDATE CONTACT_ADDRESS SET IS_PRIMARY=''  WHERE FK_CONTACT_ID=?";
    private static final String SAVE_CONTACT_NUMBER = "INSERT INTO CONTACT_NUMBERS (TAG_AS, VALUE, IS_PRIMARY, CREATED_ON,FK_CONTACT_ID) values(?,?,?,?,?)";
    private static final String LOAD_CONTACT_NUMBERS = "SELECT TAG_AS, VALUE, NUMBER_ID , IS_PRIMARY FROM CONTACT_NUMBERS WHERE FK_CONTACT_ID=? ORDER BY NUMBER_ID ASC";
    private static final String LOAD_PRIMARY_CONTACT_NUMBERS = "SELECT TAG_AS, VALUE, NUMBER_ID , IS_PRIMARY FROM CONTACT_NUMBERS WHERE FK_CONTACT_ID=? AND IS_PRIMARY='Yes' ";
    private static final String DELETE_CONTACT_NUMBER = "DELETE FROM CONTACT_NUMBERS WHERE NUMBER_ID=? ";
    private static final String UPDATE_CONTACT_NUMBER = "UPDATE CONTACT_NUMBERS SET TAG_AS=?, VALUE=?, IS_PRIMARY=?, MODIFY_ON=? WHERE NUMBER_ID=?";
    private static final String UPDATE_CONTACTS_PRIMARY_STATUS_EMPTY = "UPDATE CONTACT_NUMBERS SET IS_PRIMARY=''  WHERE FK_CONTACT_ID=?";
    private static final String SAVE_CONTACT_LINKS = "INSERT INTO CONTACT_EMAILS (TYPE, TAG_AS, VALUE, CREATED_ON,FK_CONTACT_ID) values(?,?,?,?,?)";
    private static final String LOAD_CONTACT_LINKS = "SELECT TYPE, TAG_AS, VALUE, EMAIL_ID FROM CONTACT_EMAILS WHERE FK_CONTACT_ID =? ORDER BY EMAIL_ID ASC";
    private static final String DELETE_CONTACT_LINKS = "DELETE FROM CONTACT_EMAILS WHERE EMAIL_ID =?";
    private static final String UPDATE_CONTACT_LINKS = "UPDATE CONTACT_EMAILS SET TYPE=?, TAG_AS=?, VALUE=?, MODIFY_ON=? WHERE EMAIL_ID =?";
    private static final String SAVE_CONTACT_EVENT = "INSERT INTO CONTACT_EVENTS (TAG_AS, VALUE,  CREATED_ON,FK_CONTACT_ID) values(?,?,?,?)";
    private static final String LOAD_CONTACT_EVENT = "SELECT TAG_AS, VALUE, EVENT_ID  FROM CONTACT_EVENTS WHERE FK_CONTACT_ID=? ORDER BY EVENT_ID ASC";
    private static final String DELETE_CONTACT_EVENT = "DELETE FROM CONTACT_EVENTS WHERE EVENT_ID=? ";
    private static final String UPDATE_CONTACT_EVENT = "UPDATE CONTACT_EVENTS SET TAG_AS=?, VALUE=?, MODIFY_ON=? WHERE EVENT_ID=?";
    private static final String SAVE_CONTACT_ADDITIONAL_INFO = "INSERT INTO CONTACT_ADDITIONAL_INFO (TAG_AS, VALUE,  CREATED_ON,FK_CONTACT_ID) values(?,?,?,?)";
    private static final String LOAD_CONTACT_ADDITIONAL_INFO = "SELECT TAG_AS, VALUE, ADDITIONAL_INFO_ID  FROM CONTACT_ADDITIONAL_INFO WHERE FK_CONTACT_ID=? ORDER BY ADDITIONAL_INFO_ID ASC";
    private static final String DELETE_CONTACT_ADDITIONAL_INFO = "DELETE FROM CONTACT_ADDITIONAL_INFO WHERE ADDITIONAL_INFO_ID=? ";
    private static final String UPDATE_CONTACT_ADDITIONAL_INFO = "UPDATE CONTACT_ADDITIONAL_INFO SET TAG_AS=?, VALUE=?, MODIFY_ON=? WHERE ADDITIONAL_INFO_ID=?";
    private static final String FETCH_CONTACT_BASIC_DETAILS = "SELECT NAME,COMMENTS, CP.GROUP_NAME\n  FROM CONTACTS C\n  JOIN CONTACT_GROUP CP ON CP.GROUP_ID = C.FK_GROUP_ID\n  where CONTACT_ID = ?\n";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isRecordExists(String name, int groupId) throws Exception {
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement ps = conn.prepareStatement(IS_RECORD_EXISTS);){
            ps.setString(1, name);
            ps.setInt(2, groupId);
            try (ResultSet resultSet = ps.executeQuery();){
                if (!resultSet.next()) return false;
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public int save(ContactRecord contactRecord) throws Exception {
        try (Connection conn = DbUtility.getConnection();){
            int n;
            block16: {
                PreparedStatement ps = conn.prepareStatement(SAVE_CONTACT_RECORD, 1);
                try {
                    ps.setString(1, contactRecord.name());
                    ps.setString(2, contactRecord.comments());
                    String path = contactRecord.imagePath().trim();
                    if (!path.isEmpty()) {
                        File file = new File(path);
                        FileInputStream fis = new FileInputStream(file);
                        ps.setBinaryStream(3, (InputStream)fis, (int)file.length());
                    } else {
                        ps.setBinaryStream(3, (InputStream)new ByteArrayInputStream(new byte[0]), 0);
                    }
                    ps.setInt(4, contactRecord.groupId());
                    ps.setString(5, AppUtility.getCurrentDateInString());
                    ps.executeUpdate();
                    n = ps.getGeneratedKeys().getInt(1);
                    if (ps == null) break block16;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ps.close();
            }
            return n;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public int update(ContactRecord contactRecord) throws Exception {
        String path = contactRecord.imagePath().trim();
        String sql = "";
        sql = !path.isEmpty() ? UPDATE_CONTACT_RECORD : UPDATE_CONTACT_RECORD_WITHOUT_IMAGE;
        try (Connection conn = DbUtility.getConnection();){
            int n;
            block18: {
                PreparedStatement ps = conn.prepareStatement(sql);
                try {
                    ps.setString(1, contactRecord.name());
                    ps.setString(2, contactRecord.comments());
                    if (!path.isEmpty()) {
                        if ("-".equals(path)) {
                            ps.setBinaryStream(3, (InputStream)new ByteArrayInputStream(new byte[0]), 0);
                        } else {
                            File file = new File(path);
                            FileInputStream fis = new FileInputStream(file);
                            ps.setBinaryStream(3, (InputStream)fis, (int)file.length());
                        }
                        ps.setInt(4, contactRecord.groupId());
                        ps.setString(5, AppUtility.getCurrentDateInString());
                        ps.setInt(6, contactRecord.contactId());
                    } else {
                        ps.setInt(3, contactRecord.groupId());
                        ps.setString(4, AppUtility.getCurrentDateInString());
                        ps.setInt(5, contactRecord.contactId());
                    }
                    ps.executeUpdate();
                    n = contactRecord.contactId();
                    if (ps == null) break block18;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ps.close();
            }
            return n;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private void updateAddressPrimaryStatus(int contactId) {
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement ps = conn.prepareStatement(UPDATE_ADDRESS_PRIMARY_STATUS_EMPTY);){
            ps.setInt(1, contactId);
            ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public int saveAddress(ContactAddress address) throws Exception {
        if (address.isPrimary()) {
            this.updateAddressPrimaryStatus(address.contactId());
        }
        try (Connection conn = DbUtility.getConnection();){
            int n;
            block15: {
                PreparedStatement ps = conn.prepareStatement(SAVE_CONTACT_ADDRESS, 1);
                try {
                    ps.setString(1, address.addressTagAs());
                    ps.setString(2, address.address());
                    ps.setString(3, address.area());
                    ps.setString(4, address.city());
                    ps.setString(5, address.pin());
                    ps.setString(6, AppUtility.getCurrentDateInString());
                    ps.setString(7, address.isPrimary() ? "Yes" : "");
                    ps.setInt(8, address.contactId());
                    ps.executeUpdate();
                    n = ps.getGeneratedKeys().getInt(1);
                    if (ps == null) break block15;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ps.close();
            }
            return n;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public void updateAddress(ContactAddress address) throws Exception {
        if (address.isPrimary()) {
            this.updateAddressPrimaryStatus(address.contactId());
        }
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement ps = conn.prepareStatement(UPDATE_CONTACT_ADDRESS);){
            ps.setString(1, address.addressTagAs());
            ps.setString(2, address.address());
            ps.setString(3, address.area());
            ps.setString(4, address.city());
            ps.setString(5, address.pin());
            ps.setString(6, address.isPrimary() ? "Yes" : "");
            ps.setString(7, AppUtility.getCurrentDateInString());
            ps.setInt(8, address.addressId());
            ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public void deleteAddress(int addressId) throws Exception {
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement ps = conn.prepareStatement(DELETE_CONTACT_ADDRESS);){
            ps.setInt(1, addressId);
            ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public List<ContactAddress> loadContactAddress(int contactId) throws Exception {
        ArrayList<ContactAddress> contactAddresses = new ArrayList<ContactAddress>();
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement preparedStatement = conn.prepareStatement(LOAD_CONTACT_ADDRESS);){
            preparedStatement.setInt(1, contactId);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    ContactAddress contactAddress = new ContactAddress.Builder().address(resultSet.getString("ADDRESS")).area(resultSet.getString("AREA")).city(resultSet.getString("CITY")).pin(resultSet.getString("PIN")).addressId(resultSet.getInt("ADDRESS_ID")).isPrimary("Yes".equals(resultSet.getString("IS_PRIMARY"))).addressTagAs(resultSet.getString("ADDRESS_TAG_AS")).build();
                    contactAddresses.add(contactAddress);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return contactAddresses;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public int saveContact(ContactNumber contactNumber) throws Exception {
        if (contactNumber.isPrimary()) {
            this.updateContactsPrimaryStatus(contactNumber.contactId());
        }
        try (Connection conn = DbUtility.getConnection();){
            int n;
            block15: {
                PreparedStatement ps = conn.prepareStatement(SAVE_CONTACT_NUMBER, 1);
                try {
                    ps.setString(1, contactNumber.contactTagAs());
                    ps.setString(2, contactNumber.contactValue());
                    ps.setString(3, contactNumber.isPrimary() ? "Yes" : "");
                    ps.setString(4, AppUtility.getCurrentDateInString());
                    ps.setInt(5, contactNumber.contactId());
                    ps.executeUpdate();
                    n = ps.getGeneratedKeys().getInt(1);
                    if (ps == null) break block15;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ps.close();
            }
            return n;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public void updateContact(ContactNumber contactNumber) throws Exception {
        if (contactNumber.isPrimary()) {
            this.updateContactsPrimaryStatus(contactNumber.contactId());
        }
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement ps = conn.prepareStatement(UPDATE_CONTACT_NUMBER);){
            ps.setString(1, contactNumber.contactTagAs());
            ps.setString(2, contactNumber.contactValue());
            ps.setString(3, contactNumber.isPrimary() ? "Yes" : "");
            ps.setString(4, AppUtility.getCurrentDateInString());
            ps.setInt(5, contactNumber.contactNumberId());
            ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public void deleteContact(int contactNumberId) throws Exception {
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement ps = conn.prepareStatement(DELETE_CONTACT_NUMBER);){
            ps.setInt(1, contactNumberId);
            ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public List<ContactNumber> loadContacts(int contactId) throws Exception {
        ArrayList<ContactNumber> contactNumbers = new ArrayList<ContactNumber>();
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement preparedStatement = conn.prepareStatement(LOAD_CONTACT_NUMBERS);){
            preparedStatement.setInt(1, contactId);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    ContactNumber contactNumber = new ContactNumber.Builder().contactTagAs(resultSet.getString("TAG_AS")).contactValue(resultSet.getString("VALUE")).isPrimary("Yes".equals(resultSet.getString("IS_PRIMARY"))).contactNumberId(resultSet.getInt("NUMBER_ID")).build();
                    contactNumbers.add(contactNumber);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return contactNumbers;
    }

    @Override
    public void saveLinks(ContactLinks contactLinks) throws Exception {
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement ps = conn.prepareStatement(SAVE_CONTACT_LINKS);){
            ps.setString(1, contactLinks.linkType());
            ps.setString(2, contactLinks.tagAs());
            ps.setString(3, contactLinks.value());
            ps.setString(4, AppUtility.getCurrentDateInString());
            ps.setInt(5, contactLinks.contactId());
            ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public void updateLinks(ContactLinks contactLinks) throws Exception {
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement ps = conn.prepareStatement(UPDATE_CONTACT_LINKS);){
            ps.setString(1, contactLinks.linkType());
            ps.setString(2, contactLinks.tagAs());
            ps.setString(3, contactLinks.value());
            ps.setString(4, AppUtility.getCurrentDateInString());
            ps.setInt(5, contactLinks.linkId());
            ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public void deleteLinks(int contactLinkId) throws Exception {
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement ps = conn.prepareStatement(DELETE_CONTACT_LINKS);){
            ps.setInt(1, contactLinkId);
            ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public List<ContactLinks> loadLinks(int contactId) throws Exception {
        ArrayList<ContactLinks> links = new ArrayList<ContactLinks>();
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement preparedStatement = conn.prepareStatement(LOAD_CONTACT_LINKS);){
            preparedStatement.setInt(1, contactId);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    ContactLinks contactLinks = new ContactLinks.Builder().linkType(resultSet.getString("TYPE")).value(resultSet.getString("VALUE")).tagAs(resultSet.getString("TAG_AS")).linkId(resultSet.getInt("EMAIL_ID")).build();
                    links.add(contactLinks);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return links;
    }

    private void updateContactsPrimaryStatus(int contactId) {
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement ps = conn.prepareStatement(UPDATE_CONTACTS_PRIMARY_STATUS_EMPTY);){
            ps.setInt(1, contactId);
            ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public void saveEvent(ContactEvent contactEvent) throws Exception {
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement ps = conn.prepareStatement(SAVE_CONTACT_EVENT);){
            ps.setString(1, contactEvent.eventTagAs());
            ps.setString(2, contactEvent.date());
            ps.setString(3, AppUtility.getCurrentDateInString());
            ps.setInt(4, contactEvent.contactId());
            ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public void updateEvent(ContactEvent contactEvent) throws Exception {
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement ps = conn.prepareStatement(UPDATE_CONTACT_EVENT);){
            ps.setString(1, contactEvent.eventTagAs());
            ps.setString(2, contactEvent.date());
            ps.setString(3, AppUtility.getCurrentDateInString());
            ps.setInt(4, contactEvent.eventId());
            ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public void deleteEvent(int eventId) throws Exception {
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement ps = conn.prepareStatement(DELETE_CONTACT_EVENT);){
            ps.setInt(1, eventId);
            ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public List<ContactEvent> loadEvents(int contactId) throws Exception {
        ArrayList<ContactEvent> contactEvents = new ArrayList<ContactEvent>();
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement preparedStatement = conn.prepareStatement(LOAD_CONTACT_EVENT);){
            preparedStatement.setInt(1, contactId);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    ContactEvent contactEvent = new ContactEvent.Builder().eventTagAs(resultSet.getString("TAG_AS")).date(resultSet.getString("VALUE")).eventId(resultSet.getInt("EVENT_ID")).build();
                    contactEvents.add(contactEvent);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return contactEvents;
    }

    @Override
    public void saveAdditionalInfo(ContactAdditionalInfo contactAdditionalInfo) throws Exception {
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement ps = conn.prepareStatement(SAVE_CONTACT_ADDITIONAL_INFO);){
            ps.setString(1, contactAdditionalInfo.tagAs());
            ps.setString(2, contactAdditionalInfo.value());
            ps.setString(3, AppUtility.getCurrentDateInString());
            ps.setInt(4, contactAdditionalInfo.contactId());
            ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public void updateAdditionalInfo(ContactAdditionalInfo contactAdditionalInfo) throws Exception {
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement ps = conn.prepareStatement(UPDATE_CONTACT_ADDITIONAL_INFO);){
            ps.setString(1, contactAdditionalInfo.tagAs());
            ps.setString(2, contactAdditionalInfo.value());
            ps.setString(3, AppUtility.getCurrentDateInString());
            ps.setInt(4, contactAdditionalInfo.id());
            ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public void deleteAdditionalInfo(int id) throws Exception {
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement ps = conn.prepareStatement(DELETE_CONTACT_ADDITIONAL_INFO);){
            ps.setInt(1, id);
            ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public List<ContactAdditionalInfo> loadAdditionalInfo(int contactId) throws Exception {
        ArrayList<ContactAdditionalInfo> contactAdditionalInfos = new ArrayList<ContactAdditionalInfo>();
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement preparedStatement = conn.prepareStatement(LOAD_CONTACT_ADDITIONAL_INFO);){
            preparedStatement.setInt(1, contactId);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    ContactAdditionalInfo contactAdditionalInfo = new ContactAdditionalInfo.Builder().tagAs(resultSet.getString("TAG_AS")).value(resultSet.getString("VALUE")).id(resultSet.getInt("ADDITIONAL_INFO_ID")).build();
                    contactAdditionalInfos.add(contactAdditionalInfo);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return contactAdditionalInfos;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ContactRecord fetchContactBasicDetails(int contactId) throws Exception {
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement preparedStatement = conn.prepareStatement(FETCH_CONTACT_BASIC_DETAILS);){
            preparedStatement.setInt(1, contactId);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                ContactRecord contactRecord;
                if (!resultSet.next()) return null;
                ContactRecord contactRecord2 = contactRecord = new ContactRecord.Builder().name(resultSet.getString("NAME")).comments(resultSet.getString("COMMENTS")).groupName(resultSet.getString("GROUP_NAME")).primaryNumber(this.loadPrimaryContacts(contactId)).build();
                return contactRecord2;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ContactNumber loadPrimaryContacts(int contactId) throws Exception {
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement preparedStatement = conn.prepareStatement(LOAD_PRIMARY_CONTACT_NUMBERS);){
            preparedStatement.setInt(1, contactId);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (!resultSet.next()) return null;
                ContactNumber contactNumber = new ContactNumber.Builder().contactTagAs(resultSet.getString("TAG_AS")).contactValue(resultSet.getString("VALUE")).isPrimary("Yes".equals(resultSet.getString("IS_PRIMARY"))).contactNumberId(resultSet.getInt("NUMBER_ID")).build();
                return contactNumber;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

