/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.dao.contact;

import com.arun.bhardwaj.dao.contact.ManageGroupDao;
import com.arun.bhardwaj.exceptions.DatabaseException;
import com.arun.bhardwaj.utility.AppUtility;
import com.arun.bhardwaj.utility.DbUtility;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashMap;
import java.util.Map;

public class ManageGroupDaoImpl
implements ManageGroupDao {
    private final String createGroup = "INSERT INTO CONTACT_GROUP(GROUP_NAME,CREATED_ON) values(?,?)";
    private final String UPDATE_CONTACT_GROUP = "UPDATE CONTACT_GROUP SET GROUP_NAME=? ,MODIFY_ON=? where GROUP_ID=?";
    private final String FIND_GROUP = "SELECT GROUP_ID FROM  CONTACT_GROUP WHERE GROUP_NAME=?";
    private final String GROUP_NAMES = "select GROUP_ID, GROUP_NAME from CONTACT_GROUP order by GROUP_NAME ASC";
    private final String DELETE_GROUP = "Delete from CONTACT_GROUP where GROUP_ID=?";

    @Override
    public void saveContactGroup(String groupName) throws DatabaseException {
        try (Connection con = DbUtility.getConnection();){
            try (PreparedStatement ps = con.prepareStatement("INSERT INTO CONTACT_GROUP(GROUP_NAME,CREATED_ON) values(?,?)");){
                ps.setString(1, groupName);
                ps.setString(2, AppUtility.getCurrentDateInString());
                ps.executeUpdate();
            }
            catch (Exception e) {
                throw new DatabaseException(e.getMessage(), e);
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
    }

    @Override
    public void updateGroup(String groupName, int selectedGroupId) throws DatabaseException {
        try (Connection conn = DbUtility.getConnection();){
            try (PreparedStatement ps = conn.prepareStatement("UPDATE CONTACT_GROUP SET GROUP_NAME=? ,MODIFY_ON=? where GROUP_ID=?");){
                ps.setString(1, groupName);
                ps.setString(2, AppUtility.getCurrentDateInString());
                ps.setInt(3, selectedGroupId);
                ps.executeUpdate();
            }
            catch (Exception e) {
                throw new DatabaseException(e.getMessage(), e);
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
    }

    @Override
    public boolean isGroupExists(String groupName) throws DatabaseException {
        boolean isExists = false;
        try (Connection conn = DbUtility.getConnection();){
            try (PreparedStatement ps = conn.prepareStatement("SELECT GROUP_ID FROM  CONTACT_GROUP WHERE GROUP_NAME=?");){
                ps.setString(1, groupName);
                try (ResultSet resultSet = ps.executeQuery();){
                    if (resultSet.next()) {
                        isExists = true;
                    }
                }
            }
            catch (SQLException e) {
                throw new DatabaseException(e.getMessage(), e);
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        return isExists;
    }

    @Override
    public Map<Integer, String> loadGroups() throws DatabaseException {
        LinkedHashMap<Integer, String> groupList = new LinkedHashMap<Integer, String>();
        try (Connection conn = DbUtility.getConnection();
             Statement state = conn.createStatement();
             ResultSet res = state.executeQuery("select GROUP_ID, GROUP_NAME from CONTACT_GROUP order by GROUP_NAME ASC");){
            while (res.next()) {
                groupList.put(res.getInt("GROUP_ID"), res.getString("GROUP_NAME").trim());
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        return groupList;
    }

    @Override
    public void deleteGroup(int groupId) throws DatabaseException {
        try (Connection con = DbUtility.getConnection();
             PreparedStatement ps = con.prepareStatement("Delete from CONTACT_GROUP where GROUP_ID=?");){
            ps.setInt(1, groupId);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
    }
}

