/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.dao.enquiry;

import com.arun.bhardwaj.dao.enquiry.EnquiryDao;
import com.arun.bhardwaj.model.enquiry.EnquiryFollowUpStatus;
import com.arun.bhardwaj.model.enquiry.EnquiryFollowupStatistics;
import com.arun.bhardwaj.model.enquiry.EnquiryRecord;
import com.arun.bhardwaj.model.enquiry.EnquiryStatistics;
import com.arun.bhardwaj.utility.AppUtility;
import com.arun.bhardwaj.utility.DbUtility;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class EnquiryDaoImpl
implements EnquiryDao {
    private static final String LOAD_ENQUIRES = "SELECT  count(*) over() as TOTAL_COUNT,  ENQUIRY_ID, DATE, LOOKING_FOR, AREA,BUDGET_FROM, BUDGET_TO, SIZE_FROM, SIZE_TO, SOURCE, ME.COMMENTS,\n       FK_CONTACT_ID,\n       C.NAME, PG.GROUP_NAME,\n       ADDITIONAL_INFO\n  FROM ENQUIRY ME\n  JOIN CONTACTS C ON ME.FK_CONTACT_ID = C.CONTACT_ID\n  JOIN PROPERTY_GROUP PG ON ME.FK_GROUP_ID= PG.GROUP_ID\n  WHERE STATUS =? and ME.FK_GROUP_ID\n";
    private static final String RE_OPEN_ENQUIRY = "UPDATE ENQUIRY SET STATUS=1 WHERE ENQUIRY_ID=?";
    private static final String DELETE_ENQUIRY = "DELETE FROM ENQUIRY WHERE ENQUIRY_ID =?";
    private static final String FETCH_ENQUIRY_STATISTICS = "      select count(*) as COUNT,DATE\n      FROM ENQUIRY PR where STATUS=1\n      Group by DATE\n";
    private static final String FETCH_FOLLOWUP_STATISTICS = "      SELECT count(*) AS COUNT, FOLLOWUP_STATUS\n      FROM ENQUIRY_FOLLOWUP  EF\n      JOIN ENQUIRY E ON EF.FK_ENQUIRY_ID= E.ENQUIRY_ID\n      WHERE E.STATUS=1 and  FOLLOW_UP_DATE =? GROUP BY FOLLOWUP_STATUS\n";

    @Override
    public List<EnquiryRecord> loadEnquiries(int propertyGroupId, String search, String searchBy, int enquiryStatus, boolean todayFollowUp, String enquiryFor, int page, int pageSize) throws Exception {
        int offset = (page - 1) * pageSize;
        ArrayList<EnquiryRecord> enquiryRecords = new ArrayList<EnquiryRecord>();
        StringBuilder strSql = new StringBuilder();
        strSql.append(LOAD_ENQUIRES);
        if (propertyGroupId == -1) {
            strSql.append(" in(select GROUP_ID from PROPERTY_GROUP)");
        } else {
            strSql.append(" = ? ");
        }
        if (!search.trim().isEmpty()) {
            strSql.append(" AND ");
            if ("NAME".equals(searchBy)) {
                strSql.append("C.NAME");
                strSql.append(" like '%");
                strSql.append(search);
                strSql.append("%'");
            } else if ("BUDGET".equals(searchBy)) {
                strSql.append("BUDGET_TO <=");
                strSql.append(search);
            } else if ("Area in Sqft".equals(searchBy)) {
                strSql.append("SIZE_TO <=");
                strSql.append(search);
            } else if ("LOCATION".equals(searchBy)) {
                strSql.append("AREA");
                strSql.append(" like '%");
                strSql.append(search);
                strSql.append("%'");
            } else if ("SOURCE".equals(searchBy)) {
                strSql.append("SOURCE");
                strSql.append(" like '%");
                strSql.append(search);
                strSql.append("%'");
            } else if ("COMMENTS".equals(searchBy)) {
                strSql.append("ME.COMMENTS");
                strSql.append(" like '%");
                strSql.append(search);
                strSql.append("%'");
            }
        }
        if (todayFollowUp) {
            strSql.append("AND ENQUIRY_ID in(select FK_ENQUIRY_ID from ENQUIRY_FOLLOWUP where FOLLOW_UP_DATE = '").append(AppUtility.getCurrentDateInString()).append("')");
        }
        if (!"All Records".equals(enquiryFor)) {
            strSql.append("AND LOOKING_FOR ='").append(enquiryFor).append("'");
        }
        strSql.append(" order by ENQUIRY_ID DESC LIMIT ? OFFSET ?");
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement ps = conn.prepareStatement(strSql.toString());){
            ps.setInt(1, enquiryStatus);
            if (propertyGroupId != -1) {
                ps.setInt(2, propertyGroupId);
                ps.setInt(3, pageSize);
                ps.setInt(4, offset);
            } else {
                ps.setInt(2, pageSize);
                ps.setInt(3, offset);
            }
            try (ResultSet result = ps.executeQuery();){
                while (result.next()) {
                    EnquiryRecord record = new EnquiryRecord.Builder().totalRecords(result.getInt("TOTAL_COUNT")).date(result.getString("DATE")).lookingFor(result.getString("LOOKING_FOR")).location(result.getString("AREA")).budgetFrom(result.getInt("BUDGET_FROM")).budgetTo(result.getInt("BUDGET_TO")).sizeFrom(result.getInt("SIZE_FROM")).sizeTo(result.getInt("SIZE_TO")).source(result.getString("SOURCE")).comments(result.getString("COMMENTS")).contactName(result.getString("NAME")).propertyGroupName(result.getString("GROUP_NAME")).enquiryId(result.getInt("ENQUIRY_ID")).contactId(result.getInt("FK_CONTACT_ID")).additionalInfo(result.getString("ADDITIONAL_INFO")).localDate(AppUtility.convertStringToDate(result.getString("DATE"))).build();
                    enquiryRecords.add(record);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        Collections.sort(enquiryRecords, Comparator.comparing(EnquiryRecord::localDate).reversed());
        return enquiryRecords;
    }

    @Override
    public void deleteEnquiry(int enquiryId) throws Exception {
        try (Connection con = DbUtility.getConnection();
             PreparedStatement ps = con.prepareStatement(DELETE_ENQUIRY);){
            ps.setInt(1, enquiryId);
            ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public void reOpenEnquiry(int enquiryId) throws Exception {
        try (Connection con = DbUtility.getConnection();
             PreparedStatement ps = con.prepareStatement(RE_OPEN_ENQUIRY);){
            ps.setInt(1, enquiryId);
            ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public List<EnquiryStatistics> loadEnquiryStatistics() throws Exception {
        ArrayList<EnquiryStatistics> enquiryStatistics = new ArrayList<EnquiryStatistics>();
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement ps = conn.prepareStatement(FETCH_ENQUIRY_STATISTICS);
             ResultSet res = ps.executeQuery();){
            while (res.next()) {
                enquiryStatistics.add(new EnquiryStatistics(res.getString("DATE"), res.getInt("COUNT"), AppUtility.convertStringToDate(res.getString("DATE"))));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        Collections.sort(enquiryStatistics, Comparator.comparing(EnquiryStatistics::localDate).reversed());
        return enquiryStatistics;
    }

    @Override
    public List<EnquiryFollowupStatistics> loadEnquiriesFollowupStatistics() throws Exception {
        ArrayList<EnquiryFollowupStatistics> enquiryFollowupStatistics = new ArrayList<EnquiryFollowupStatistics>();
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement ps = conn.prepareStatement(FETCH_FOLLOWUP_STATISTICS);){
            ps.setString(1, AppUtility.getCurrentDateInString());
            try (ResultSet res = ps.executeQuery();){
                while (res.next()) {
                    enquiryFollowupStatistics.add(new EnquiryFollowupStatistics(EnquiryFollowUpStatus.enquiryCode(res.getInt("FOLLOWUP_STATUS")).name(), res.getInt("COUNT")));
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return enquiryFollowupStatistics;
    }
}

