/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.dao.enquiry;

import com.arun.bhardwaj.dao.enquiry.EnquiryFollowUpDao;
import com.arun.bhardwaj.model.enquiry.EnquiryFollowUp;
import com.arun.bhardwaj.model.enquiry.EnquiryFollowUpStatus;
import com.arun.bhardwaj.utility.AppUtility;
import com.arun.bhardwaj.utility.DbUtility;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

public class EnquiryFollowUpDaoImpl
implements EnquiryFollowUpDao {
    private static final String SAVE_ENQUIRY_FOLLOW_UP = "INSERT INTO ENQUIRY_FOLLOWUP (DATE,FOLLOW_UP_DATE, COMMENTS, FOLLOWUP_STATUS, CREATED_ON, FK_ENQUIRY_ID)\n   VALUES (?,?,?,?,?,?)\n";
    private static final String LOAD_FOLLOWUP_DETAILS = "SELECT ENQUIRY_FOLLOW_UP_ID,\n       DATE,\n       FOLLOW_UP_DATE,\n       COMMENTS\n  FROM ENQUIRY_FOLLOWUP WHERE FK_ENQUIRY_ID =? order by ENQUIRY_FOLLOW_UP_ID desc\n";
    private static final String DELETE_FOLLOW_UP = "DELETE FROM ENQUIRY_FOLLOWUP WHERE ENQUIRY_FOLLOW_UP_ID =?\n";
    private static final String UPDATE_ENQUIRY_FOLLOW_UP = "UPDATE ENQUIRY_FOLLOWUP SET DATE=?,FOLLOW_UP_DATE=?, COMMENTS=?, MODIFY_ON=?\n  WHERE ENQUIRY_FOLLOW_UP_ID =?\n";

    @Override
    public void saveEnquiryFollowUp(EnquiryFollowUp enquiryFollowUp) throws Exception {
        try (Connection con = DbUtility.getConnection();){
            try (PreparedStatement ps = con.prepareStatement(SAVE_ENQUIRY_FOLLOW_UP);){
                ps.setString(1, enquiryFollowUp.date());
                ps.setString(2, enquiryFollowUp.followUpDate());
                ps.setString(3, enquiryFollowUp.comments());
                ps.setInt(4, EnquiryFollowUpStatus.OPEN.ordinal());
                ps.setString(5, AppUtility.getCurrentDateInString());
                ps.setInt(6, enquiryFollowUp.enquiryId());
                ps.executeUpdate();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    @Override
    public List<EnquiryFollowUp> loadFollowUpDetails(int enquiryId) throws Exception {
        ArrayList<EnquiryFollowUp> enquiryFollowUps = new ArrayList<EnquiryFollowUp>();
        try (Connection con = DbUtility.getConnection();){
            try (PreparedStatement ps = con.prepareStatement(LOAD_FOLLOWUP_DETAILS);){
                ps.setInt(1, enquiryId);
                try (ResultSet resultSet = ps.executeQuery();){
                    while (resultSet.next()) {
                        enquiryFollowUps.add(new EnquiryFollowUp(resultSet.getString("DATE"), resultSet.getString("FOLLOW_UP_DATE"), resultSet.getString("COMMENTS"), enquiryId, resultSet.getInt("ENQUIRY_FOLLOW_UP_ID")));
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        return enquiryFollowUps;
    }

    @Override
    public void updateEnquiryFollowUp(EnquiryFollowUp enquiryFollowUp) throws Exception {
        try (Connection con = DbUtility.getConnection();){
            try (PreparedStatement ps = con.prepareStatement(UPDATE_ENQUIRY_FOLLOW_UP);){
                ps.setString(1, enquiryFollowUp.date());
                ps.setString(2, enquiryFollowUp.followUpDate());
                ps.setString(3, enquiryFollowUp.comments());
                ps.setString(4, AppUtility.getCurrentDateInString());
                ps.setInt(5, enquiryFollowUp.followUpId());
                ps.executeUpdate();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    @Override
    public void deleteEnquiryFollowUp(int enquiryFollowUpId) throws Exception {
        try (Connection con = DbUtility.getConnection();){
            try (PreparedStatement ps = con.prepareStatement(DELETE_FOLLOW_UP);){
                ps.setInt(1, enquiryFollowUpId);
                ps.executeUpdate();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
    }
}

