/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.dao.enquiry;

import com.arun.bhardwaj.dao.enquiry.EnquiryPropertySearchDao;
import com.arun.bhardwaj.model.enquiry.EnquiryRecord;
import com.arun.bhardwaj.model.property.PropertyRecord;
import com.arun.bhardwaj.utility.AppUtility;
import com.arun.bhardwaj.utility.DbUtility;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class EnquiryPropertySearchDaoImpl
implements EnquiryPropertySearchDao {
    private static final String SEARCH_PROPERTY_FOR_ENQUIRY = "SELECT  PR.DATE, ADDRESS,LOCATION, CITY, PIN,PRICE,\n       DEPOSIT, RENT, AREA_IN_SQFT, OFFERED_BY_TYPE,\n       FURNISHING_STATUS,PR.COMMENTS, C.NAME AS OFFERED_BY, PR.FK_CONTACT_ID,PR.FK_GROUP_ID,\n       (Select PROPERTY_STATUS from PROPERTY_STATUS where PROPERTY_STATUS_ID=(Select max(PROPERTY_STATUS_ID) from PROPERTY_STATUS where FK_PROPERTY_ID = PROPERTY_ID)) as CURRENT_PROPERTY_STATUS,\n       (select GROUP_CONCAT(VALUE, ' , ') from CONTACT_NUMBERS where FK_CONTACT_ID=PR.FK_CONTACT_ID) as ownerContactNumbers\n FROM PROPERTY_RECORDS PR\n  JOIN CONTACTS C ON C.CONTACT_ID = PR.FK_CONTACT_ID\n";

    @Override
    public List<PropertyRecord> loadPropertiesForEnquiry(EnquiryRecord enquiryRecord, boolean allProperties) throws Exception {
        ArrayList<PropertyRecord> propertyRecords = new ArrayList<PropertyRecord>();
        StringBuilder strSql = new StringBuilder();
        strSql.append(SEARCH_PROPERTY_FOR_ENQUIRY);
        String lookingFor = enquiryRecord.lookingFor();
        if (lookingFor.contains("RENT") || lookingFor.contains("rent")) {
            strSql.append(" AND CURRENT_PROPERTY_STATUS in (0,3)");
            if (enquiryRecord.budgetDescription() != null && !enquiryRecord.budgetDescription().isEmpty()) {
                if (enquiryRecord.budgetDescription().contains("Minimum")) {
                    strSql.append(" AND PR.RENT>=").append(AppUtility.removeCurrencyAndCommas(enquiryRecord.budgetDescription().split("Minimum")[1]));
                } else if (enquiryRecord.budgetDescription().contains("Maximum")) {
                    strSql.append(" AND PR.RENT<=").append(AppUtility.removeCurrencyAndCommas(enquiryRecord.budgetDescription().split("Maximum")[1]));
                } else {
                    strSql.append(" AND PR.RENT BETWEEN ").append(AppUtility.removeCurrencyAndCommas(enquiryRecord.budgetDescription().split("to")[0]) + " and " + AppUtility.removeCurrencyAndCommas(enquiryRecord.budgetDescription().split("to")[1]));
                }
            }
        } else {
            strSql.append(" AND CURRENT_PROPERTY_STATUS in(1,3)");
            if (enquiryRecord.budgetDescription() != null && !enquiryRecord.budgetDescription().isEmpty()) {
                if (enquiryRecord.budgetDescription().contains("Minimum")) {
                    strSql.append(" AND PR.PRICE>=").append(AppUtility.removeCurrencyAndCommas(enquiryRecord.budgetDescription().split("Minimum")[1]));
                } else if (enquiryRecord.budgetDescription().contains("Maximum")) {
                    strSql.append(" AND PR.PRICE<=").append(AppUtility.removeCurrencyAndCommas(enquiryRecord.budgetDescription().split("Maximum")[1]));
                } else {
                    strSql.append(" AND PR.PRICE BETWEEN ").append(AppUtility.removeCurrencyAndCommas(enquiryRecord.budgetDescription().split("to")[0]) + " and " + AppUtility.removeCurrencyAndCommas(enquiryRecord.budgetDescription().split("to")[1]));
                }
            }
        }
        if (enquiryRecord.areaDescription() != null && !enquiryRecord.areaDescription().isEmpty()) {
            if (enquiryRecord.areaDescription().contains("Minimum")) {
                strSql.append(" AND PR.AREA_IN_SQFT>=").append(enquiryRecord.areaDescription().split("Minimum")[1]);
            } else if (enquiryRecord.areaDescription().contains("Maximum")) {
                strSql.append(" AND PR.AREA_IN_SQFT<=").append(enquiryRecord.areaDescription().split("Maximum")[1]);
            } else {
                strSql.append(" AND PR.AREA_IN_SQFT BETWEEN ").append(enquiryRecord.areaDescription().split("to")[0]).append(" and ").append(enquiryRecord.areaDescription().split("to")[1]);
            }
        }
        if (!allProperties) {
            strSql.append(" AND PR.FK_GROUP_ID= (SELECT GROUP_ID FROM PROPERTY_GROUP where GROUP_NAME = '").append(lookingFor.split("for")[0].trim()).append("')");
        }
        if (!enquiryRecord.location().isEmpty()) {
            List locations = Stream.of(enquiryRecord.location().split(",")).map(String::trim).collect(Collectors.toList());
            int count = 0;
            for (String location : locations) {
                if (count == 0) {
                    strSql.append(" AND ( ");
                } else {
                    strSql.append(" OR ");
                }
                strSql.append(" PR.ADDRESS like '%").append(location).append("%' OR PR.LOCATION like '%").append(location).append("%' OR  PR.CITY like '%").append(location).append("%' OR PR.PIN like '%").append(location).append("%'");
                ++count;
            }
            strSql.append(" )");
        }
        if (enquiryRecord.additionalInfo() != null && !"".equals(enquiryRecord.additionalInfo())) {
            List additionalInfoList = Stream.of(enquiryRecord.additionalInfo().split(",")).map(String::trim).collect(Collectors.toUnmodifiableList());
            StringBuilder findPropertyIdsByAdditionalInfo = new StringBuilder();
            findPropertyIdsByAdditionalInfo.append("select FK_PROPERTY_ID  from PROPERTY_ADDITIONAL_DETAILS  where VALUE ");
            for (String additionalInfo : additionalInfoList) {
                findPropertyIdsByAdditionalInfo.append(" like '%").append(additionalInfo).append("%'").append(" OR ");
            }
            strSql.append(" AND PROPERTY_ID in ( ").append(findPropertyIdsByAdditionalInfo.toString().substring(0, findPropertyIdsByAdditionalInfo.toString().length() - 4)).append(" )");
        }
        strSql.append(" order by ADDRESS ASC");
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement ps = conn.prepareStatement(strSql.toString());
             ResultSet result = ps.executeQuery();){
            while (result.next()) {
                propertyRecords.add(new PropertyRecord.Builder().date(result.getString("DATE")).address(result.getString("ADDRESS")).location(result.getString("LOCATION")).city(result.getString("CITY")).pin(result.getString("PIN")).deposit(result.getInt("DEPOSIT")).rent(result.getInt("RENT")).price(result.getInt("PRICE")).areaInSqFt(result.getInt("AREA_IN_SQFT")).offeredByType(result.getInt("OFFERED_BY_TYPE")).furnishingStatus(result.getInt("FURNISHING_STATUS")).comments(result.getString("COMMENTS")).fkGroupId(result.getInt("FK_GROUP_ID")).fkContactId(result.getInt("FK_CONTACT_ID")).localDate(AppUtility.convertStringToDate(result.getString("DATE"))).ownerContactNumbers(result.getString("ownerContactNumbers")).build());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return propertyRecords;
    }
}

