/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.dao.enquiry;

import com.arun.bhardwaj.dao.enquiry.EnquiryRecordDao;
import com.arun.bhardwaj.model.enquiry.EnquiryRecord;
import com.arun.bhardwaj.model.enquiry.EnquiryStatus;
import com.arun.bhardwaj.utility.AppUtility;
import com.arun.bhardwaj.utility.DbUtility;
import java.sql.Connection;
import java.sql.PreparedStatement;

public class EnquiryRecordDaoImpl
implements EnquiryRecordDao {
    private static final String SAVE_ENQUIRY = "INSERT INTO ENQUIRY ( DATE, LOOKING_FOR, AREA, BUDGET_FROM, BUDGET_TO,\n    SIZE_FROM, SIZE_TO, SOURCE, COMMENTS, STATUS,\n    CREATED_ON, FK_CONTACT_ID, FK_GROUP_ID , ADDITIONAL_INFO)\nVALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)\n";
    private static final String UPDATE_ENQUIRY = " UPDATE ENQUIRY SET DATE=?, LOOKING_FOR=?, AREA=?, BUDGET_FROM=?, BUDGET_TO=?,\n    SIZE_FROM=?, SIZE_TO=?, SOURCE=?, COMMENTS=?, STATUS=?,\n    MODIFY_ON=?, FK_CONTACT_ID=?, FK_GROUP_ID=?, ADDITIONAL_INFO=?\n    where ENQUIRY_ID =?\n";

    @Override
    public int save(EnquiryRecord record) throws Exception {
        int enquiryId;
        try (Connection con = DbUtility.getConnection();
             PreparedStatement ps = con.prepareStatement(SAVE_ENQUIRY, 1);){
            ps.setString(1, record.date());
            ps.setString(2, record.lookingFor());
            ps.setString(3, record.location());
            ps.setInt(4, record.budgetFrom());
            ps.setInt(5, record.budgetTo());
            ps.setInt(6, record.sizeFrom());
            ps.setInt(7, record.sizeTo());
            ps.setString(8, record.source());
            ps.setString(9, record.comments());
            ps.setInt(10, EnquiryStatus.ACTIVE.ordinal());
            ps.setString(11, AppUtility.getCurrentDateInString());
            ps.setInt(12, record.contactId());
            ps.setInt(13, record.propertyGroupId());
            ps.setString(14, record.additionalInfo());
            ps.executeUpdate();
            enquiryId = ps.getGeneratedKeys().getInt(1);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return enquiryId;
    }

    @Override
    public void update(EnquiryRecord record, boolean closeEnquiry) throws Exception {
        try (Connection con = DbUtility.getConnection();
             PreparedStatement ps = con.prepareStatement(UPDATE_ENQUIRY);){
            ps.setString(1, record.date());
            ps.setString(2, record.lookingFor());
            ps.setString(3, record.location());
            ps.setInt(4, record.budgetFrom());
            ps.setInt(5, record.budgetTo());
            ps.setInt(6, record.sizeFrom());
            ps.setInt(7, record.sizeTo());
            ps.setString(8, record.source());
            ps.setString(9, record.comments());
            ps.setInt(10, closeEnquiry ? 0 : 1);
            ps.setString(11, AppUtility.getCurrentDateInString());
            ps.setInt(12, record.contactId());
            ps.setInt(13, record.propertyGroupId());
            ps.setString(14, record.additionalInfo());
            ps.setInt(15, record.enquiryId());
            ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

