/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.dao.project;

import com.arun.bhardwaj.dao.project.ManageProjectDao;
import com.arun.bhardwaj.exceptions.DatabaseException;
import com.arun.bhardwaj.model.project.AmenitiesRecord;
import com.arun.bhardwaj.model.project.ProjectAdditionalDetails;
import com.arun.bhardwaj.model.project.ProjectRecord;
import com.arun.bhardwaj.model.project.UnitPricingAndPaymentDetails;
import com.arun.bhardwaj.utility.AppUtility;
import com.arun.bhardwaj.utility.DbUtility;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ManageProjectDaoImpl
implements ManageProjectDao {
    private static final String INSERT_PROJECT_DETAILS = "INSERT INTO PROJECT_DETAILS (PROJECT_NAME, FK_PROJECT_TYPE_ID, PROJECT_STATUS,TOTAL_AREA,\n                                TOTAL_UNITS, NUMBER_OF_FLOORS,PROJECT_DESCRIPTION, LAUNCH_DATE,COMPLETION_DATE,\n                                LOCATION_DETAILS,FK_BUILDER_CONTACT_ID,  FK_ARCHITECT_CONTACT_ID,RERA_REGISTRATION_NUMBER,CREATED_ON)\n                            VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?);\n\n";
    private static final String UPDATE_PROJECT_DETAILS = "UPDATE PROJECT_DETAILS SET PROJECT_NAME =?,FK_PROJECT_TYPE_ID==?,PROJECT_STATUS==?,TOTAL_AREA=?,TOTAL_UNITS=?,NUMBER_OF_FLOORS=?,\nPROJECT_DESCRIPTION=?, LAUNCH_DATE=?,LOCATION_DETAILS=?,FK_BUILDER_CONTACT_ID=?,FK_ARCHITECT_CONTACT_ID=?,\nRERA_REGISTRATION_NUMBER=?,COMPLETION_DATE=?, MODIFY_ON =? where PROJECT_ID = ?\n";
    private static final String DELETE_PROJECT_BY_ID = "DELETE from PROJECT_DETAILS where PROJECT_ID in(";
    private static final String INSERT_UNIT_DETAILS = "INSERT INTO PROJECT_UNIT_DETAILS (PROPERTY_TYPE,UNIT_SIZE, UNIT_BASE_PRICE,PAYMENT_PLAN,COMMENTS,FK_PROJECT_ID,CREATED_ON) VALUES (?,?,?,?,?,?,?);\n";
    private static final String LOAD_UNIT_DETAILS_BY_PROJECT_ID = "SELECT UNIT_ID, PROPERTY_TYPE,  UNIT_SIZE,UNIT_BASE_PRICE,COMMENTS ,PAYMENT_PLAN\n  FROM PROJECT_UNIT_DETAILS where FK_PROJECT_ID=? order by PROPERTY_TYPE asc ;\n";
    private static final String LOAD_UNIT_DETAILS_BY_UNIT_ID = "SELECT PROPERTY_TYPE,  UNIT_SIZE,UNIT_BASE_PRICE,COMMENTS ,PAYMENT_PLAN\n  FROM PROJECT_UNIT_DETAILS where UNIT_ID=?;\n";
    private static final String CHECK_PROJECT_EXISTS = "SELECT 1 FROM PROJECT_DETAILS WHERE PROJECT_NAME = ? LIMIT 1";
    private static final String CHECK_PROPERTY_TYPE_EXISTS_IN_PROJECT = "SELECT 1 FROM PROJECT_UNIT_DETAILS WHERE FK_PROJECT_ID = ? and PROPERTY_TYPE=? LIMIT 1";
    private static final String DELETE_PROPERTY_TYPE_BY_UNIT_ID = "DELETE FROM PROJECT_UNIT_DETAILS WHERE UNIT_ID = ?";
    private static final String UPDATE_PROJECT_UNIT_DETAILS = "    UPDATE PROJECT_UNIT_DETAILS\n       SET PROPERTY_TYPE = ?,UNIT_SIZE = ?, UNIT_BASE_PRICE = ?,PAYMENT_PLAN = ?, COMMENTS = ?, MODIFY_ON = ?\n     WHERE UNIT_ID = ?\n";
    private static final String INSERT_AMENITIES_DETAILS = "INSERT INTO PROJECT_AMENITIES_DETAILS (AMENITIES, FK_PROJECT_ID,CREATED_ON )VALUES (?,?,?);";
    private static final String DELETE_AMENITIES_DETAILS = "DELETE FROM PROJECT_AMENITIES_DETAILS WHERE AMENITIES_ID=? and FK_PROJECT_ID =?";
    private static final String LOAD_AMENITIES_DETAILS = "SELECT AMENITIES_ID, AMENITIES FROM PROJECT_AMENITIES_DETAILS WHERE FK_PROJECT_ID =? order by AMENITIES asc ";
    private static final String INSERT_ADDITIONAL_DETAILS = "INSERT INTO PROJECT_ADDITIONAL_DETAILS (NAME,VALUE,FK_PROJECT_ID,CREATED_ON) VALUES (?,?,?,?)";
    private static final String DELETE_ADDITIONAL_DETAILS = "DELETE FROM PROJECT_ADDITIONAL_DETAILS WHERE ADDITIONAL_ID=? and FK_PROJECT_ID =?";
    private static final String LOAD_ADDITIONAL_DETAILS = "SELECT ADDITIONAL_ID, NAME, VALUE FROM PROJECT_ADDITIONAL_DETAILS WHERE FK_PROJECT_ID =? order by NAME asc ";
    private static final String LOAD_BUILDER_NAMES = "SELECT distinct (FK_BUILDER_CONTACT_ID), C.NAME\n  FROM PROJECT_DETAILS PD\n  JOIN CONTACTS C ON PD.FK_BUILDER_CONTACT_ID = C.CONTACT_ID;\n";
    private static final String LOAD_ARCHITECT_NAMES = "SELECT distinct (FK_ARCHITECT_CONTACT_ID), C.NAME\n  FROM PROJECT_DETAILS PD\n  JOIN CONTACTS C ON PD.FK_ARCHITECT_CONTACT_ID = C.CONTACT_ID;\n";

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public int saveProjectDetails(ProjectRecord projectRecord) throws DatabaseException {
        try (Connection con = DbUtility.getConnection();){
            int n;
            block14: {
                PreparedStatement ps = con.prepareStatement(INSERT_PROJECT_DETAILS, 1);
                try {
                    ps.setString(1, projectRecord.projectName());
                    ps.setInt(2, projectRecord.fkProjectType());
                    ps.setString(3, projectRecord.projectStatus());
                    ps.setFloat(4, projectRecord.totalArea());
                    ps.setInt(5, projectRecord.totalUnits());
                    ps.setInt(6, projectRecord.numberOfFloors());
                    ps.setString(7, projectRecord.description());
                    ps.setString(8, projectRecord.launchDate());
                    ps.setString(9, projectRecord.completionDate());
                    ps.setString(10, projectRecord.locationDetails());
                    ps.setInt(11, projectRecord.fkBuilderContactId());
                    ps.setInt(12, projectRecord.fkArchitectContactId());
                    ps.setString(13, projectRecord.reraRegistrationNumber());
                    ps.setString(14, AppUtility.getCurrentDateInString());
                    ps.executeUpdate();
                    n = ps.getGeneratedKeys().getInt(1);
                    if (ps == null) break block14;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ps.close();
            }
            return n;
        }
        catch (SQLException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
    }

    @Override
    public void updateProjectDetails(ProjectRecord projectRecord) throws DatabaseException {
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement ps = conn.prepareStatement(UPDATE_PROJECT_DETAILS);){
            ps.setString(1, projectRecord.projectName());
            ps.setInt(2, projectRecord.fkProjectType());
            ps.setString(3, projectRecord.projectStatus());
            ps.setFloat(4, projectRecord.totalArea());
            ps.setInt(5, projectRecord.totalUnits());
            ps.setInt(6, projectRecord.numberOfFloors());
            ps.setString(7, projectRecord.description());
            ps.setString(8, projectRecord.launchDate());
            ps.setString(9, projectRecord.locationDetails());
            ps.setInt(10, projectRecord.fkBuilderContactId());
            ps.setInt(11, projectRecord.fkArchitectContactId());
            ps.setString(12, projectRecord.reraRegistrationNumber());
            ps.setString(13, projectRecord.completionDate());
            ps.setString(14, AppUtility.getCurrentDateInString());
            ps.setInt(15, projectRecord.projectId());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
    }

    @Override
    public void deleteProjectDetails(List<Integer> projectIds) throws DatabaseException {
        if (projectIds != null || !projectIds.isEmpty()) {
            StringBuilder queryBuilder = new StringBuilder(DELETE_PROJECT_BY_ID);
            for (int i = 0; i < projectIds.size(); ++i) {
                queryBuilder.append("?");
                if (i >= projectIds.size() - 1) continue;
                queryBuilder.append(",");
            }
            queryBuilder.append(")");
            try (Connection con = DbUtility.getConnection();
                 PreparedStatement ps = con.prepareStatement(queryBuilder.toString());){
                for (int i = 0; i < projectIds.size(); ++i) {
                    ps.setInt(i + 1, projectIds.get(i));
                }
                ps.executeUpdate();
            }
            catch (SQLException e) {
                throw new DatabaseException(e.getMessage(), e);
            }
        }
    }

    @Override
    public boolean isProjectExist(String projectName) throws DatabaseException {
        boolean isExists = false;
        try (Connection con = DbUtility.getConnection();
             PreparedStatement stmt = con.prepareStatement(CHECK_PROJECT_EXISTS);){
            stmt.setString(1, projectName);
            try (ResultSet rs = stmt.executeQuery();){
                isExists = rs.next();
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        return isExists;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public int addUnitDetails(UnitPricingAndPaymentDetails unitPricingAndPaymentDetails) throws DatabaseException {
        try (Connection con = DbUtility.getConnection();){
            int n;
            block14: {
                PreparedStatement ps = con.prepareStatement(INSERT_UNIT_DETAILS, 1);
                try {
                    ps.setString(1, unitPricingAndPaymentDetails.propertyType());
                    ps.setInt(2, unitPricingAndPaymentDetails.unitSize());
                    ps.setInt(3, unitPricingAndPaymentDetails.unitBasePrice());
                    ps.setString(4, unitPricingAndPaymentDetails.paymentPlan());
                    ps.setString(5, unitPricingAndPaymentDetails.comments());
                    ps.setInt(6, unitPricingAndPaymentDetails.fkProjectId());
                    ps.setString(7, AppUtility.getCurrentDateInString());
                    ps.executeUpdate();
                    n = ps.getGeneratedKeys().getInt(1);
                    if (ps == null) break block14;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ps.close();
            }
            return n;
        }
        catch (SQLException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
    }

    @Override
    public void updateUnitDetails(UnitPricingAndPaymentDetails unitPricingAndPaymentDetails) throws DatabaseException {
        try (Connection con = DbUtility.getConnection();
             PreparedStatement ps = con.prepareStatement(UPDATE_PROJECT_UNIT_DETAILS);){
            ps.setString(1, unitPricingAndPaymentDetails.propertyType());
            ps.setInt(2, unitPricingAndPaymentDetails.unitSize());
            ps.setInt(3, unitPricingAndPaymentDetails.unitBasePrice());
            ps.setString(4, unitPricingAndPaymentDetails.paymentPlan());
            ps.setString(5, unitPricingAndPaymentDetails.comments());
            ps.setString(6, AppUtility.getCurrentDateInString());
            ps.setInt(7, unitPricingAndPaymentDetails.unitId());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
    }

    @Override
    public void deleteUnitDetails(int unitId) throws DatabaseException {
        try (Connection con = DbUtility.getConnection();
             PreparedStatement ps = con.prepareStatement(DELETE_PROPERTY_TYPE_BY_UNIT_ID);){
            ps.setInt(1, unitId);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
    }

    @Override
    public List<UnitPricingAndPaymentDetails> loadAllUnitDetailsByProjectId(int projectId) throws DatabaseException {
        ArrayList<UnitPricingAndPaymentDetails> unitPricingAndPaymentList = new ArrayList<UnitPricingAndPaymentDetails>();
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement ps = conn.prepareStatement(LOAD_UNIT_DETAILS_BY_PROJECT_ID);){
            ps.setInt(1, projectId);
            try (ResultSet result = ps.executeQuery();){
                while (result.next()) {
                    unitPricingAndPaymentList.add(new UnitPricingAndPaymentDetails.Builder().unitId(result.getInt("UNIT_ID")).propertyType(result.getString("PROPERTY_TYPE")).unitSize(result.getInt("UNIT_SIZE")).unitBasePrice(result.getInt("UNIT_BASE_PRICE")).paymentPlan(result.getString("PAYMENT_PLAN")).comments(result.getString("COMMENTS")).build());
                }
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        return unitPricingAndPaymentList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public UnitPricingAndPaymentDetails loadUnitDetails(int unitId) throws DatabaseException {
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement ps = conn.prepareStatement(LOAD_UNIT_DETAILS_BY_UNIT_ID);){
            ps.setInt(1, unitId);
            try (ResultSet result = ps.executeQuery();){
                if (!result.next()) return null;
                UnitPricingAndPaymentDetails unitPricingAndPaymentDetails = new UnitPricingAndPaymentDetails.Builder().propertyType(result.getString("PROPERTY_TYPE")).unitSize(result.getInt("UNIT_SIZE")).unitBasePrice(result.getInt("UNIT_BASE_PRICE")).paymentPlan(result.getString("PAYMENT_PLAN")).comments(result.getString("COMMENTS")).build();
                return unitPricingAndPaymentDetails;
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
    }

    @Override
    public boolean isPropertyTypeExistInProject(int projectId, String propertyType) throws DatabaseException {
        boolean isExists = false;
        try (Connection con = DbUtility.getConnection();
             PreparedStatement stmt = con.prepareStatement(CHECK_PROPERTY_TYPE_EXISTS_IN_PROJECT);){
            stmt.setInt(1, projectId);
            stmt.setString(2, propertyType);
            try (ResultSet rs = stmt.executeQuery();){
                isExists = rs.next();
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        return isExists;
    }

    @Override
    public void addAmenities(AmenitiesRecord amenitiesRecord) throws DatabaseException {
        try (Connection con = DbUtility.getConnection();
             PreparedStatement ps = con.prepareStatement(INSERT_AMENITIES_DETAILS);){
            ps.setString(1, amenitiesRecord.amenities());
            ps.setInt(2, amenitiesRecord.fkProjectId());
            ps.setString(3, AppUtility.getCurrentDateInString());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
    }

    @Override
    public void deleteAmenities(AmenitiesRecord amenitiesRecord) throws DatabaseException {
        try (Connection con = DbUtility.getConnection();
             PreparedStatement ps = con.prepareStatement(DELETE_AMENITIES_DETAILS);){
            ps.setInt(1, amenitiesRecord.amenitiesId());
            ps.setInt(2, amenitiesRecord.fkProjectId());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
    }

    @Override
    public List<AmenitiesRecord> loadAllAmenities(int projectId) throws DatabaseException {
        ArrayList<AmenitiesRecord> amenitiesRecordList = new ArrayList<AmenitiesRecord>();
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement ps = conn.prepareStatement(LOAD_AMENITIES_DETAILS);){
            ps.setInt(1, projectId);
            try (ResultSet result = ps.executeQuery();){
                while (result.next()) {
                    amenitiesRecordList.add(new AmenitiesRecord(result.getInt("AMENITIES_ID"), result.getString("AMENITIES"), projectId));
                }
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        return amenitiesRecordList;
    }

    @Override
    public void addAdditionalDetails(ProjectAdditionalDetails projectAdditionalDetails) throws DatabaseException {
        try (Connection con = DbUtility.getConnection();
             PreparedStatement ps = con.prepareStatement(INSERT_ADDITIONAL_DETAILS);){
            ps.setString(1, projectAdditionalDetails.name());
            ps.setString(2, projectAdditionalDetails.value());
            ps.setInt(3, projectAdditionalDetails.fkProjectId());
            ps.setString(4, AppUtility.getCurrentDateInString());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
    }

    @Override
    public void deleteAdditionalDetails(ProjectAdditionalDetails projectAdditionalDetails) throws DatabaseException {
        try (Connection con = DbUtility.getConnection();
             PreparedStatement ps = con.prepareStatement(DELETE_ADDITIONAL_DETAILS);){
            ps.setInt(1, projectAdditionalDetails.additionalId());
            ps.setInt(2, projectAdditionalDetails.fkProjectId());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
    }

    @Override
    public List<ProjectAdditionalDetails> loadAllAdditionalDetails(int projectId) throws DatabaseException {
        ArrayList<ProjectAdditionalDetails> projectAdditionalDetails = new ArrayList<ProjectAdditionalDetails>();
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement ps = conn.prepareStatement(LOAD_ADDITIONAL_DETAILS);){
            ps.setInt(1, projectId);
            try (ResultSet result = ps.executeQuery();){
                while (result.next()) {
                    projectAdditionalDetails.add(new ProjectAdditionalDetails(result.getInt("ADDITIONAL_ID"), result.getString("NAME"), result.getString("VALUE"), projectId));
                }
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        return projectAdditionalDetails;
    }

    @Override
    public Map<Integer, String> loadBuilderNames() throws DatabaseException {
        LinkedHashMap<Integer, String> builderNames = new LinkedHashMap<Integer, String>();
        try (Connection conn = DbUtility.getConnection();
             Statement state = conn.createStatement();
             ResultSet res = state.executeQuery(LOAD_BUILDER_NAMES);){
            while (res.next()) {
                builderNames.put(res.getInt("FK_BUILDER_CONTACT_ID"), res.getString("NAME").trim());
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        return builderNames;
    }

    @Override
    public Map<Integer, String> loadArchitectName() throws DatabaseException {
        LinkedHashMap<Integer, String> architectNames = new LinkedHashMap<Integer, String>();
        try (Connection conn = DbUtility.getConnection();
             Statement state = conn.createStatement();
             ResultSet res = state.executeQuery(LOAD_ARCHITECT_NAMES);){
            while (res.next()) {
                architectNames.put(res.getInt("FK_ARCHITECT_CONTACT_ID"), res.getString("NAME").trim());
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        return architectNames;
    }
}

