/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.dao.project;

import com.arun.bhardwaj.dao.project.ProjectCategoryDao;
import com.arun.bhardwaj.exceptions.DatabaseException;
import com.arun.bhardwaj.utility.AppUtility;
import com.arun.bhardwaj.utility.DbUtility;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashMap;
import java.util.Map;

public class ProjectCategoryDaoImpl
implements ProjectCategoryDao {
    private static final String SAVE_CATEGORY = "INSERT INTO PROJECT_TYPES (PROJECT_TYPE_NAME,CREATED_ON) values(?,?)";
    private static final String UPDATE_PROJECT_TYPES = "UPDATE PROJECT_TYPES set PROJECT_TYPE_NAME=? , MODIFY_ON=? where PROJECT_TYPE_ID=?";
    private static final String DELETE_RECORD = "DELETE FROM PROJECT_TYPES where PROJECT_TYPE_ID = ?";
    private static final String FIND_CATEGORY = "SELECT PROJECT_TYPE_ID FROM PROJECT_TYPES WHERE PROJECT_TYPE_NAME=?";
    private static final String PROJECT_TYPES = "select PROJECT_TYPE_ID, PROJECT_TYPE_NAME from PROJECT_TYPES order by PROJECT_TYPE_NAME";

    @Override
    public void saveCategory(String categoryName) throws DatabaseException {
        try (Connection con = DbUtility.getConnection();){
            try (PreparedStatement ps = con.prepareStatement(SAVE_CATEGORY);){
                ps.setString(1, categoryName);
                ps.setString(2, AppUtility.getCurrentDateInString());
                ps.executeUpdate();
            }
            catch (SQLException e) {
                throw new DatabaseException(e.getMessage(), e);
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
    }

    @Override
    public void updateCategory(String categoryName, int selectedGroupId) throws DatabaseException {
        try (Connection conn = DbUtility.getConnection();){
            try (PreparedStatement ps = conn.prepareStatement(UPDATE_PROJECT_TYPES);){
                ps.setString(1, categoryName);
                ps.setString(2, AppUtility.getCurrentDateInString());
                ps.setInt(3, selectedGroupId);
                ps.executeUpdate();
            }
            catch (SQLException e) {
                throw new DatabaseException(e.getMessage(), e);
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
    }

    @Override
    public void deleteCategory(int selectedGroupId) throws DatabaseException {
        try (Connection con = DbUtility.getConnection();
             PreparedStatement ps = con.prepareStatement(DELETE_RECORD);){
            ps.setInt(1, selectedGroupId);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
    }

    @Override
    public boolean isCategoryExists(String categoryName) throws DatabaseException {
        boolean isExists = false;
        try (Connection conn = DbUtility.getConnection();){
            try (PreparedStatement ps = conn.prepareStatement(FIND_CATEGORY);){
                ps.setString(1, categoryName);
                try (ResultSet resultSet = ps.executeQuery();){
                    if (resultSet.next()) {
                        isExists = true;
                    }
                }
            }
            catch (SQLException e) {
                throw new DatabaseException(e.getMessage(), e);
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        return isExists;
    }

    @Override
    public Map<Integer, String> loadGroups() throws DatabaseException {
        LinkedHashMap<Integer, String> groupList = new LinkedHashMap<Integer, String>();
        try (Connection conn = DbUtility.getConnection();
             Statement state = conn.createStatement();
             ResultSet res = state.executeQuery(PROJECT_TYPES);){
            while (res.next()) {
                groupList.put(res.getInt("PROJECT_TYPE_ID"), res.getString("PROJECT_TYPE_NAME").trim());
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        return groupList;
    }
}

