/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.dao.project;

import com.arun.bhardwaj.dao.project.ProjectDetailsDao;
import com.arun.bhardwaj.exceptions.DatabaseException;
import com.arun.bhardwaj.model.project.ProjectRecord;
import com.arun.bhardwaj.model.project.UnitPricingAndPaymentDetails;
import com.arun.bhardwaj.utility.DbUtility;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProjectDetailsDaoImpl
implements ProjectDetailsDao {
    private static final String LOAD_ALL_PROJECT_DETAILS = "        SELECT count(*) over() as TOTAL_COUNT, PROJECT_ID,\n           PROJECT_NAME,\n           FK_PROJECT_TYPE_ID,\n           PROJECT_STATUS,\n           PROJECT_DESCRIPTION,\n           LAUNCH_DATE,\n           COMPLETION_DATE\n      FROM PROJECT_DETAILS where 1=1\n";
    private static final String LOAD_PROJECT_DETAILS_BY_ID = "SELECT PROJECT_NAME, FK_PROJECT_TYPE_ID,PROJECT_STATUS,\n       TOTAL_AREA,\n       TOTAL_UNITS,\n       NUMBER_OF_FLOORS,\n       PROJECT_DESCRIPTION,\n       LAUNCH_DATE,\n       COMPLETION_DATE,\n       LOCATION_DETAILS,\n       FK_BUILDER_CONTACT_ID,\n       FK_ARCHITECT_CONTACT_ID,\n       RERA_REGISTRATION_NUMBER\n  FROM PROJECT_DETAILS where PROJECT_ID =?\n";
    private static final String LOAD_PROJECT_UNIT_DETAILS_BY_ID = "    SELECT\n           PROPERTY_TYPE,\n           UNIT_SIZE,\n           UNIT_BASE_PRICE,\n           PAYMENT_PLAN,\n           COMMENTS\n      FROM PROJECT_UNIT_DETAILS where FK_PROJECT_ID =? order by PROPERTY_TYPE ASC\n\n";
    private static final String LOAD_PROJECT_AMENITIES_DETAILS_BY_ID = "    SELECT  AMENITIES\n      FROM PROJECT_AMENITIES_DETAILS where FK_PROJECT_ID =? order by AMENITIES ASC\n";
    private static final String LOAD_PROJECT_ADDITIONAL_DETAILS_BY_ID = "    SELECT  NAME,VALUE\n      FROM PROJECT_ADDITIONAL_DETAILS where FK_PROJECT_ID =?\n";

    @Override
    public List<ProjectRecord> loadAllProjects(String filterType, Object filterValue, int page, int pageSize) throws DatabaseException {
        StringBuilder sql = new StringBuilder();
        sql.append(LOAD_ALL_PROJECT_DETAILS);
        if ("Project Type".equals(filterType)) {
            int projectTypeId = (Integer)filterValue;
            if (projectTypeId > 0) {
                sql.append(" and FK_PROJECT_TYPE_ID =? ");
            }
        } else if ("Property Type".equals(filterType)) {
            if (!"All Records".equals(filterValue)) {
                sql.append(" and PROJECT_ID in (SELECT FK_PROJECT_ID FROM PROJECT_UNIT_DETAILS where PROPERTY_TYPE =? ) ");
            }
        } else if ("Project Status".equals(filterType)) {
            if (!"All Records".equals(filterValue)) {
                sql.append(" and PROJECT_STATUS =? ");
            }
        } else if ("Project Name".equals(filterType)) {
            sql.append(" and PROJECT_NAME like ? ");
        } else if ("Location".equals(filterType)) {
            sql.append(" and LOCATION_DETAILS like ? ");
        } else if ("RERA Registration No".equals(filterType)) {
            sql.append(" and RERA_REGISTRATION_NUMBER like ? ");
        } else if ("Builder Name".equals(filterType) && (Integer)filterValue > 0) {
            sql.append(" and FK_BUILDER_CONTACT_ID =?");
        } else if ("Architect Name".equals(filterType) && (Integer)filterValue > 0) {
            sql.append(" and FK_ARCHITECT_CONTACT_ID =?");
        }
        sql.append(" order by PROJECT_NAME LIMIT ? OFFSET ?");
        ArrayList<ProjectRecord> projects = new ArrayList<ProjectRecord>();
        int offset = (page - 1) * pageSize;
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql.toString());){
            if ("Project Type".equals(filterType)) {
                int projectTypeId = (Integer)filterValue;
                if (projectTypeId > 0) {
                    ps.setInt(1, projectTypeId);
                    ps.setInt(2, pageSize);
                    ps.setInt(3, offset);
                } else {
                    ps.setInt(1, pageSize);
                    ps.setInt(2, offset);
                }
            } else if ("Property Type".equals(filterType) || "Project Status".equals(filterType)) {
                if (!"All Records".equals(filterValue)) {
                    ps.setString(1, (String)filterValue);
                    ps.setInt(2, pageSize);
                    ps.setInt(3, offset);
                } else {
                    ps.setInt(1, pageSize);
                    ps.setInt(2, offset);
                }
            } else if ("Project Name".equals(filterType) || "Location".equals(filterType) || "RERA Registration No".equals(filterType)) {
                ps.setString(1, "%" + (String)filterValue + "%");
                ps.setInt(2, pageSize);
                ps.setInt(3, offset);
            } else if (("Builder Name".equals(filterType) || "Architect Name".equals(filterType)) && (Integer)filterValue > 0) {
                ps.setInt(1, (Integer)filterValue);
                ps.setInt(2, pageSize);
                ps.setInt(3, offset);
            } else {
                ps.setInt(1, pageSize);
                ps.setInt(2, offset);
            }
            try (ResultSet result = ps.executeQuery();){
                while (result.next()) {
                    projects.add(new ProjectRecord.Builder().totalRecords(result.getInt("TOTAL_COUNT")).projectId(result.getInt("PROJECT_ID")).projectName(result.getString("PROJECT_NAME")).fkProjectType(result.getInt("FK_PROJECT_TYPE_ID")).projectStatus(result.getString("PROJECT_STATUS")).description(result.getString("PROJECT_DESCRIPTION")).launchDate(result.getString("LAUNCH_DATE")).completionDate(result.getString("COMPLETION_DATE")).build());
                }
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        return projects;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ProjectRecord loadProjectsDetails(int projectId) throws DatabaseException {
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement ps = conn.prepareStatement(LOAD_PROJECT_DETAILS_BY_ID);){
            ps.setInt(1, projectId);
            List<UnitPricingAndPaymentDetails> unitPricingAndPaymentDetailsList = this.loadProjectUnitDetails(conn, projectId);
            List<String> amenitiesDetails = this.loadProjectAmenitiesDetails(conn, projectId);
            Map<String, String> additionalDetails = this.loadProjectAdditionalDetails(conn, projectId);
            try (ResultSet res = ps.executeQuery();){
                if (!res.next()) return null;
                ProjectRecord projectRecord = new ProjectRecord.Builder().projectName(res.getString("PROJECT_NAME")).fkProjectType(res.getInt("FK_PROJECT_TYPE_ID")).projectStatus(res.getString("PROJECT_STATUS")).totalArea(res.getFloat("TOTAL_AREA")).totalUnits(res.getInt("TOTAL_UNITS")).numberOfFloors(res.getInt("NUMBER_OF_FLOORS")).description(res.getString("PROJECT_DESCRIPTION")).launchDate(res.getString("LAUNCH_DATE")).completionDate(res.getString("COMPLETION_DATE")).locationDetails(res.getString("LOCATION_DETAILS")).fkBuilderContactId(res.getInt("FK_BUILDER_CONTACT_ID")).fkArchitectContactId(res.getInt("FK_ARCHITECT_CONTACT_ID")).reraRegistrationNumber(res.getString("RERA_REGISTRATION_NUMBER")).unitPricingAndPaymentDetails(unitPricingAndPaymentDetailsList).amenitiesRecordList(amenitiesDetails).projectAdditionalDetails(additionalDetails).build();
                return projectRecord;
            }
        }
        catch (SQLException e) {
            throw new DatabaseException("", e);
        }
    }

    private List<UnitPricingAndPaymentDetails> loadProjectUnitDetails(Connection conn, int projectId) throws DatabaseException {
        ArrayList<UnitPricingAndPaymentDetails> unitPricingAndPaymentDetailsList = new ArrayList<UnitPricingAndPaymentDetails>();
        try (PreparedStatement ps = conn.prepareStatement(LOAD_PROJECT_UNIT_DETAILS_BY_ID);){
            ps.setInt(1, projectId);
            try (ResultSet res = ps.executeQuery();){
                while (res.next()) {
                    unitPricingAndPaymentDetailsList.add(new UnitPricingAndPaymentDetails.Builder().propertyType(res.getString("PROPERTY_TYPE")).unitSize(res.getInt("UNIT_SIZE")).unitBasePrice(res.getInt("UNIT_BASE_PRICE")).paymentPlan(res.getString("PAYMENT_PLAN")).comments(res.getString("COMMENTS")).build());
                }
            }
        }
        catch (SQLException e) {
            throw new DatabaseException("loadProjectUnitDetails", e);
        }
        return unitPricingAndPaymentDetailsList;
    }

    private List<String> loadProjectAmenitiesDetails(Connection conn, int projectId) throws DatabaseException {
        ArrayList<String> projectAmenitiesDetailsList = new ArrayList<String>();
        try (PreparedStatement ps = conn.prepareStatement(LOAD_PROJECT_AMENITIES_DETAILS_BY_ID);){
            ps.setInt(1, projectId);
            try (ResultSet res = ps.executeQuery();){
                while (res.next()) {
                    projectAmenitiesDetailsList.add(res.getString("AMENITIES"));
                }
            }
        }
        catch (SQLException e) {
            throw new DatabaseException("loadProjectUnitDetails", e);
        }
        return projectAmenitiesDetailsList;
    }

    private Map<String, String> loadProjectAdditionalDetails(Connection conn, int projectId) throws DatabaseException {
        HashMap<String, String> projectAdditionalDetails = new HashMap<String, String>();
        try (PreparedStatement ps = conn.prepareStatement(LOAD_PROJECT_ADDITIONAL_DETAILS_BY_ID);){
            ps.setInt(1, projectId);
            try (ResultSet res = ps.executeQuery();){
                while (res.next()) {
                    projectAdditionalDetails.put(res.getString("NAME"), res.getString("VALUE"));
                }
            }
        }
        catch (SQLException e) {
            throw new DatabaseException("loadProjectUnitDetails", e);
        }
        return projectAdditionalDetails;
    }
}

