/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.dao.property;

import com.arun.bhardwaj.dao.property.PropertyAuditDao;
import com.arun.bhardwaj.model.property.PropertyAuditStatus;
import com.arun.bhardwaj.model.property.PropertyOnRentDetails;
import com.arun.bhardwaj.model.property.PropertySoldDetails;
import com.arun.bhardwaj.model.property.PropertyStatus;
import com.arun.bhardwaj.model.property.RentDetails;
import com.arun.bhardwaj.utility.DbUtility;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

public class PropertyAuditDaoImpl
implements PropertyAuditDao {
    private static final String FETCH_PROPERTY_STATUS = "SELECT PROPERTY_STATUS_ID,\n       PROPERTY_STATUS,\n       CREATED_ON\n  FROM PROPERTY_STATUS where FK_PROPERTY_ID=? ORDER BY PROPERTY_STATUS_ID DESC\n";
    private static final String FETCH_PROPERTY_ON_RENT_DETAILS = " Select PON.START_DATE,\n  PON.FK_OWNER_CONTACT_ID,\n  PON.FK_TENANT_CONTACT_ID,\n  PON.FK_RENTED_BY_CONTACT_ID,\n (select NAME from CONTACTS WHERE CONTACT_ID = PON.FK_OWNER_CONTACT_ID) as 'OWNER_NAME',\n (select NAME from CONTACTS WHERE CONTACT_ID = PON.FK_TENANT_CONTACT_ID) as 'TENANT_NAME',\n (select NAME from CONTACTS WHERE CONTACT_ID = PON.FK_RENTED_BY_CONTACT_ID) as 'RENTED_BY_NAME',\n PON.DEPOSIT,PON.RENT,PON.BROKERAGE,PON.TENURE_IN_MONTHS,\n PON.PROPERTY_RENT_BY,PON.END_DATE,PON.PROPERTY_ON_RENT_ID,\n (SELECT VALUE FROM CONTACT_NUMBERS WHERE IS_PRIMARY='Yes' and FK_CONTACT_ID = PON.FK_OWNER_CONTACT_ID) as 'OWNER_NUMBER',\n (SELECT VALUE FROM CONTACT_NUMBERS WHERE IS_PRIMARY='Yes' and FK_CONTACT_ID = PON.FK_TENANT_CONTACT_ID) as 'TENANT_NUMBER',\n (SELECT VALUE FROM CONTACT_NUMBERS WHERE IS_PRIMARY='Yes' and FK_CONTACT_ID = PON.FK_RENTED_BY_CONTACT_ID) as 'RENTED_BY_NUMBER',\n PON.TERMINATION_REASON,\n PON.TERMINATION_DATE\n FROM PROPERTY_ON_RENT PON\n where FK_PROPERTY_STATUS_ID=?\n";
    private static final String FETCH_RENT_CONDITIONS = "SELECT RENT_CONDITIONS_ID,\n       START_MONTH,\n       END_MONTH,\n       RENT,\n       RENT_REVISED_IN_MONTHS\n  FROM RENT_CONDITIONS\n  WHERE FK_PROPERTY_STATUS_ID=?\n";
    private static final String FETCH_PROPERTY_SELL_DETAILS = "SELECT CONTRACT_DATE,\n      (select NAME from CONTACTS WHERE CONTACT_ID = FK_BUYER_ID) as 'BUYER_NAME',\n      (select NAME from CONTACTS WHERE CONTACT_ID = FK_SELLER_ID) as 'SELLER_NAME',\n      (select NAME from CONTACTS WHERE CONTACT_ID = FK_SELL_BY_CONTACT_ID) as 'SELL_BY_NAME',\n      (SELECT VALUE FROM CONTACT_NUMBERS WHERE IS_PRIMARY='Yes' and FK_CONTACT_ID = FK_BUYER_ID) as 'BUYER_CONTACT',\n      (SELECT VALUE FROM CONTACT_NUMBERS WHERE IS_PRIMARY='Yes' and FK_CONTACT_ID = FK_SELLER_ID) as 'SELLER_CONTACT',\n      (SELECT VALUE FROM CONTACT_NUMBERS WHERE IS_PRIMARY='Yes' and FK_CONTACT_ID =FK_SELL_BY_CONTACT_ID) as 'SELL_BY_CONTACT',\n       PRICE,\n       BROKERAGE,\n       CREATED_ON,\n       PROPERTY_SELL_BY\n  FROM PROPERTY_SELL_DETAILS WHERE FK_PROPERTY_STATUS_ID =?\n";

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<PropertyAuditStatus> getPropertyStatusHistory(Integer propertyId) throws Exception {
        ArrayList<PropertyAuditStatus> data = new ArrayList<PropertyAuditStatus>();
        try (Connection con = DbUtility.getConnection();){
            ArrayList<PropertyAuditStatus> arrayList;
            block22: {
                PreparedStatement ps = con.prepareStatement(FETCH_PROPERTY_STATUS);
                try {
                    ps.setInt(1, propertyId);
                    try (ResultSet rs = ps.executeQuery();){
                        while (rs.next()) {
                            data.add(new PropertyAuditStatus(rs.getString("CREATED_ON"), PropertyStatus.propertyCode(rs.getInt("PROPERTY_STATUS")).name().replaceAll("_", " "), rs.getInt("PROPERTY_STATUS_ID")));
                        }
                    }
                    arrayList = data;
                    if (ps == null) break block22;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ps.close();
            }
            return arrayList;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PropertyOnRentDetails getPropertyOnRentDetails(Integer propStatusId) throws Exception {
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement ps = conn.prepareStatement(FETCH_PROPERTY_ON_RENT_DETAILS);){
            ps.setInt(1, propStatusId);
            try (ResultSet res = ps.executeQuery();){
                if (!res.next()) return null;
                PropertyOnRentDetails propertyOnRentDetails = new PropertyOnRentDetails(res.getString("START_DATE"), res.getInt("FK_OWNER_CONTACT_ID"), res.getInt("FK_TENANT_CONTACT_ID"), res.getInt("FK_RENTED_BY_CONTACT_ID"), res.getString("OWNER_NAME"), res.getString("TENANT_NAME"), res.getString("RENTED_BY_NAME"), res.getInt("DEPOSIT"), res.getInt("RENT"), res.getInt("BROKERAGE"), res.getInt("TENURE_IN_MONTHS"), res.getInt("PROPERTY_RENT_BY"), res.getString("END_DATE"), res.getInt("PROPERTY_ON_RENT_ID"), 0, res.getString("RENTED_BY_NUMBER"), res.getString("OWNER_NUMBER"), res.getString("TENANT_NUMBER"), res.getString("TERMINATION_REASON"), res.getString("TERMINATION_DATE"), this.fetchRentDetails(propStatusId));
                return propertyOnRentDetails;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private List<RentDetails> fetchRentDetails(int statusId) throws Exception {
        ArrayList<RentDetails> rentDetailsList = new ArrayList<RentDetails>();
        try (Connection conn = DbUtility.getConnection();){
            ArrayList<RentDetails> arrayList;
            block22: {
                PreparedStatement ps = conn.prepareStatement(FETCH_RENT_CONDITIONS);
                try {
                    ps.setInt(1, statusId);
                    try (ResultSet res = ps.executeQuery();){
                        while (res.next()) {
                            rentDetailsList.add(new RentDetails(res.getString("START_MONTH"), res.getString("END_MONTH"), res.getInt("RENT"), res.getString("RENT_REVISED_IN_MONTHS"), 0));
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e.getMessage());
                    }
                    arrayList = rentDetailsList;
                    if (ps == null) break block22;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ps.close();
            }
            return arrayList;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PropertySoldDetails getPropertySellDetails(Integer propStatusId) throws Exception {
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement ps = conn.prepareStatement(FETCH_PROPERTY_SELL_DETAILS);){
            ps.setInt(1, propStatusId);
            try (ResultSet res = ps.executeQuery();){
                if (!res.next()) return null;
                PropertySoldDetails propertySoldDetails = new PropertySoldDetails(res.getString("CONTRACT_DATE"), res.getString("BUYER_NAME"), res.getString("SELLER_NAME"), res.getString("SELL_BY_NAME"), res.getString("BUYER_CONTACT"), res.getString("SELLER_CONTACT"), res.getString("SELL_BY_CONTACT"), res.getInt("PROPERTY_SELL_BY"), res.getInt("PRICE"));
                return propertySoldDetails;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

