/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.dao.property;

import com.arun.bhardwaj.dao.property.PropertyCategoryDao;
import com.arun.bhardwaj.exceptions.DatabaseException;
import com.arun.bhardwaj.utility.AppUtility;
import com.arun.bhardwaj.utility.DbUtility;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashMap;
import java.util.Map;

public class PropertyCategoryDaoImpl
implements PropertyCategoryDao {
    private static final String SAVE_CATEGORY = "INSERT INTO PROPERTY_GROUP (GROUP_NAME,CREATED_ON) values(?,?)";
    private static final String UPDATE_PROPERTY_GROUP = "UPDATE PROPERTY_GROUP set GROUP_NAME=? , MODIFY_ON=? where GROUP_ID=?";
    private static final String DELETE_RECORD = "DELETE FROM PROPERTY_GROUP where GROUP_ID = ?";
    private static final String FIND_CATEGORY = "SELECT GROUP_ID FROM PROPERTY_GROUP WHERE GROUP_NAME=?";
    private static final String GROUP_NAMES = "select GROUP_ID, GROUP_NAME from PROPERTY_GROUP order by GROUP_NAME";

    @Override
    public void saveCategory(String categoryName) throws DatabaseException {
        try (Connection con = DbUtility.getConnection();){
            try (PreparedStatement ps = con.prepareStatement(SAVE_CATEGORY);){
                ps.setString(1, categoryName);
                ps.setString(2, AppUtility.getCurrentDateInString());
                ps.executeUpdate();
            }
            catch (SQLException e) {
                throw new DatabaseException(e.getMessage(), e);
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
    }

    @Override
    public void updateCategory(String categoryName, int propertyGroupId) throws DatabaseException {
        try (Connection conn = DbUtility.getConnection();){
            try (PreparedStatement ps = conn.prepareStatement(UPDATE_PROPERTY_GROUP);){
                ps.setString(1, categoryName);
                ps.setString(2, AppUtility.getCurrentDateInString());
                ps.setInt(3, propertyGroupId);
                ps.executeUpdate();
            }
            catch (SQLException e) {
                throw new DatabaseException(e.getMessage(), e);
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
    }

    @Override
    public void deleteCategory(int propertyGroupId) throws DatabaseException {
        try (Connection con = DbUtility.getConnection();
             PreparedStatement ps = con.prepareStatement(DELETE_RECORD);){
            ps.setInt(1, propertyGroupId);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
    }

    @Override
    public boolean isCategoryExists(String categoryName) throws DatabaseException {
        boolean isExists = false;
        try (Connection conn = DbUtility.getConnection();){
            try (PreparedStatement ps = conn.prepareStatement(FIND_CATEGORY);){
                ps.setString(1, categoryName);
                try (ResultSet resultSet = ps.executeQuery();){
                    if (resultSet.next()) {
                        isExists = true;
                    }
                }
            }
            catch (SQLException e) {
                throw new DatabaseException(e.getMessage(), e);
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        return isExists;
    }

    @Override
    public Map<Integer, String> loadGroups() throws DatabaseException {
        LinkedHashMap<Integer, String> groupList = new LinkedHashMap<Integer, String>();
        try (Connection conn = DbUtility.getConnection();
             Statement state = conn.createStatement();
             ResultSet res = state.executeQuery(GROUP_NAMES);){
            while (res.next()) {
                groupList.put(res.getInt("GROUP_ID"), res.getString("GROUP_NAME").trim());
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        return groupList;
    }
}

