/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.dao.property;

import com.arun.bhardwaj.dao.property.PropertyDao;
import com.arun.bhardwaj.exceptions.DatabaseException;
import com.arun.bhardwaj.model.property.FurnitureStatus;
import com.arun.bhardwaj.model.property.PropertyDetails;
import com.arun.bhardwaj.model.property.PropertyFilterCriteria;
import com.arun.bhardwaj.model.property.PropertyForRentDetails;
import com.arun.bhardwaj.model.property.PropertyOfferedBy;
import com.arun.bhardwaj.model.property.PropertyOnRentDetails;
import com.arun.bhardwaj.model.property.PropertyRecord;
import com.arun.bhardwaj.model.property.PropertySearchCriteria;
import com.arun.bhardwaj.model.property.PropertyStatistics;
import com.arun.bhardwaj.model.property.PropertyStatus;
import com.arun.bhardwaj.model.property.RentDetails;
import com.arun.bhardwaj.utility.AppUtility;
import com.arun.bhardwaj.utility.DbUtility;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class PropertyDaoImpl
implements PropertyDao {
    private static final String LOAD_RECORDS = "select count(*) over() as TOTAL_COUNT, DATE,PROPERTY_ID, ADDRESS,LOCATION,CITY,PIN,DEPOSIT,RENT,PRICE,AREA_IN_SQFT,\nOFFERED_BY_TYPE, FURNISHING_STATUS,COMMENTS,\nCREATED_ON,MODIFY_ON,FK_CONTACT_ID,\nFK_GROUP_ID,\n(Select PROPERTY_STATUS from PROPERTY_STATUS where PROPERTY_STATUS_ID=(Select max(PROPERTY_STATUS_ID) from PROPERTY_STATUS where FK_PROPERTY_ID = PROPERTY_ID)) as PROPERTY_STATUS,\nUNAVAILABLE_UNTIL,\n(SELECT START_DATE || ' - ' || END_DATE AS RENT_PERIOD FROM PROPERTY_ON_RENT where FK_PROPERTY_STATUS_ID =(Select max(PROPERTY_STATUS_ID) from PROPERTY_STATUS where FK_PROPERTY_ID = PROPERTY_ID)) as Lease_Duration\nFROM PROPERTY_RECORDS PR\nwhere FK_GROUP_ID\n";
    private static final String LOAD_RECORD = "select DATE, PROPERTY_ID, ADDRESS,LOCATION,CITY,PIN,DEPOSIT,RENT,PRICE,AREA_IN_SQFT,\nOFFERED_BY_TYPE, FURNISHING_STATUS,COMMENTS,\nCREATED_ON,MODIFY_ON,FK_CONTACT_ID,\nFK_GROUP_ID,\n(Select PROPERTY_STATUS from PROPERTY_STATUS where PROPERTY_STATUS_ID=(Select max(PROPERTY_STATUS_ID) from PROPERTY_STATUS where FK_PROPERTY_ID = PROPERTY_ID)) as PROPERTY_STATUS,\nUNAVAILABLE_UNTIL\nFROM PROPERTY_RECORDS PR\nWHERE  PROPERTY_ID=?\n";
    private static final String FETCH_PROPERTY_DETAILS = "Select LG.GROUP_NAME , LR.OFFERED_BY_TYPE , C.NAME , C.CONTACT_ID , PON.FK_TENANT_CONTACT_ID,\n(SELECT VALUE FROM CONTACT_NUMBERS WHERE IS_PRIMARY='Yes' and FK_CONTACT_ID = C.CONTACT_ID) AS MOBILE ,\nLR.FURNISHING_STATUS ,\nLR.CREATED_ON , LR.MODIFY_ON , PON.START_DATE, PON.END_DATE,\n(select NAME from CONTACTS WHERE CONTACT_ID = PON.FK_TENANT_CONTACT_ID) as 'TENANT_NAME',\n(SELECT VALUE FROM CONTACT_NUMBERS WHERE FK_CONTACT_ID = PON.FK_TENANT_CONTACT_ID and IS_PRIMARY='Yes') as 'TENANT_NUMBER',\nUNAVAILABLE_UNTIL\nFROM PROPERTY_RECORDS  LR\nJOIN PROPERTY_GROUP LG ON LG.GROUP_ID  = LR.FK_GROUP_ID\nJOIN CONTACTS C ON C.CONTACT_ID = LR.FK_CONTACT_ID\nLEFT JOIN PROPERTY_ON_RENT PON ON FK_PROPERTY_STATUS_ID = (Select PROPERTY_STATUS_ID from PROPERTY_STATUS\nwhere PROPERTY_STATUS_ID=(Select max(PROPERTY_STATUS_ID) from PROPERTY_STATUS where FK_PROPERTY_ID = LR.PROPERTY_ID))\nwhere PROPERTY_ID=?\n";
    private static final String FETCH_PROPERTY_FOR_RENT_DETAILS = "   Select LR.OFFERED_BY_TYPE , LR.DEPOSIT , LR.RENT  , CON.NAME , CON.CONTACT_ID\n   FROM PROPERTY_RECORDS LR\n   JOIN CONTACTS  CON ON CON.CONTACT_ID  = LR.FK_CONTACT_ID\n   where PROPERTY_ID  =?\n";
    private static final String FETCH_ON_RENT_DETAILS = "Select PON.START_DATE,\n PON.FK_OWNER_CONTACT_ID,\n PON.FK_TENANT_CONTACT_ID,\n PON.FK_RENTED_BY_CONTACT_ID,\n(select NAME from CONTACTS WHERE CONTACT_ID = PON.FK_OWNER_CONTACT_ID) as 'OWNER_NAME',\n(select NAME from CONTACTS WHERE CONTACT_ID = PON.FK_TENANT_CONTACT_ID) as 'TENANT_NAME',\n(select NAME from CONTACTS WHERE CONTACT_ID = PON.FK_RENTED_BY_CONTACT_ID) as 'RENTED_BY_NAME',\nPON.DEPOSIT,PON.RENT,PON.BROKERAGE,PON.TENURE_IN_MONTHS,\nPON.PROPERTY_RENT_BY,PON.END_DATE,PON.PROPERTY_ON_RENT_ID,\n(SELECT VALUE FROM CONTACT_NUMBERS WHERE IS_PRIMARY='Yes' and FK_CONTACT_ID = PON.FK_OWNER_CONTACT_ID) as 'OWNER_NUMBER',\n(SELECT VALUE FROM CONTACT_NUMBERS WHERE IS_PRIMARY='Yes' and FK_CONTACT_ID = PON.FK_TENANT_CONTACT_ID) as 'TENANT_NUMBER',\n(SELECT VALUE FROM CONTACT_NUMBERS WHERE IS_PRIMARY='Yes' and FK_CONTACT_ID = PON.FK_RENTED_BY_CONTACT_ID) as 'RENTED_BY_NUMBER'\nFROM PROPERTY_ON_RENT PON\nwhere FK_PROPERTY_STATUS_ID=(Select max(PROPERTY_STATUS_ID) from PROPERTY_STATUS where FK_PROPERTY_ID = ? AND PROPERTY_STATUS=2)\n";
    private static final String FETCH_PROPERTY_STATISTICS = "select count(*) as COUNT,\n(Select PROPERTY_STATUS from PROPERTY_STATUS where PROPERTY_STATUS_ID=(Select max(PROPERTY_STATUS_ID) from PROPERTY_STATUS where FK_PROPERTY_ID = PROPERTY_ID)) as PROPERTY_STATUS\nFROM PROPERTY_RECORDS PR\nGroup by PROPERTY_STATUS\n";
    private static final String FETCH_END_DATES_FOR_ON_RENT = "Select END_DATE  from PROPERTY_ON_RENT where FK_PROPERTY_STATUS_ID\nin( Select max(PROPERTY_STATUS_ID) as STATUS_ID from PROPERTY_STATUS PS\nJOIN PROPERTY_RECORDS PR ON PR.PROPERTY_ID= PS.FK_PROPERTY_ID\nGROUP BY PROPERTY_ID having PROPERTY_STATUS=2);\n";
    private static final String FETCH_END_DATES_WITH_PROPERTY_ID = " Select END_DATE , FK_PROPERTY_ID from PROPERTY_ON_RENT POR\n JOIN PROPERTY_STATUS PS ON POR.FK_PROPERTY_STATUS_ID = PS.PROPERTY_STATUS_ID\n where FK_PROPERTY_STATUS_ID\n            in( Select max(PROPERTY_STATUS_ID) as STATUS_ID from PROPERTY_STATUS PS\n            JOIN PROPERTY_RECORDS PR ON PR.PROPERTY_ID= PS.FK_PROPERTY_ID\n            GROUP BY PROPERTY_ID having PROPERTY_STATUS=2 );\n";
    private static final String FETCH_PROPERTY_ID_BY_TENANTS = "SELECT\n       DISTINCT(PRE.PROPERTY_ID) AS PROPERTY_ID\n  FROM PROPERTY_ON_RENT PR\n  JOIN PROPERTY_STATUS PS ON PR.FK_PROPERTY_STATUS_ID = PS.PROPERTY_STATUS_ID\n  JOIN PROPERTY_RECORDS PRE ON PRE.PROPERTY_ID = PS.FK_PROPERTY_ID\n  where FK_TENANT_CONTACT_ID =?;\n";
    private static final String FETCH_PROPERTY_COUNT_BY_CONTACT_ID = "select count(*) as PROPERTY_COUNT from  PROPERTY_RECORDS where FK_CONTACT_ID=?";
    private static final String FETCH_RENT_CONDITIONS = "SELECT RENT_CONDITIONS_ID,\n       START_MONTH,\n       END_MONTH,\n       RENT,\n       RENT_REVISED_IN_MONTHS\n  FROM RENT_CONDITIONS\n  WHERE FK_PROPERTY_STATUS_ID\n  =(Select max(PROPERTY_STATUS_ID) from PROPERTY_STATUS where FK_PROPERTY_ID = ? AND PROPERTY_STATUS=2)\n";
    private static final String LOAD_PROPERTY_ADDITIONAL_DETAILS_BY_ID = "    SELECT  NAME,VALUE\n      FROM PROPERTY_ADDITIONAL_DETAILS where FK_PROPERTY_ID =?\n";
    private static final String FETCH_UNAVAILABLE_PROPERTY_IDS = "SELECT PROPERTY_ID,  UNAVAILABLE_UNTIL\n  FROM PROPERTY_RECORDS where\n  UNAVAILABLE_UNTIL is not null AND UNAVAILABLE_UNTIL <> ''\n";
    List<String> propIdsReadyForRenewal;

    public List<String> getPropIdsReadyForRenewal() {
        return this.propIdsReadyForRenewal;
    }

    public void setPropIdsReadyForRenewal(List<String> propIdsReadyForRenewal) {
        this.propIdsReadyForRenewal = propIdsReadyForRenewal;
    }

    @Override
    public List<PropertyRecord> loadRecords(String groupName, PropertySearchCriteria criteria, PropertyFilterCriteria filterCriteria, int page, int pageSize) throws Exception {
        int offset = (page - 1) * pageSize;
        StringBuilder strSql = new StringBuilder();
        strSql.append(LOAD_RECORDS);
        if ("All Records".equals(groupName)) {
            strSql.append(" in(select GROUP_ID from PROPERTY_GROUP)");
        } else {
            strSql.append(" = (select GROUP_ID from PROPERTY_GROUP where GROUP_NAME ='");
            strSql.append(groupName);
            strSql.append("')");
        }
        if (criteria != null) {
            String searchBy = criteria.searchBy();
            if ("Deposit".equals(searchBy)) {
                strSql.append(" and DEPOSIT between ").append(criteria.from()).append(" and ").append(criteria.to());
            } else if ("Rent".equals(searchBy)) {
                strSql.append(" and RENT between ").append(criteria.from()).append(" and ").append(criteria.to());
            } else if ("Price".equals(searchBy)) {
                strSql.append(" and PRICE between ").append(criteria.from()).append(" and ").append(criteria.to());
            } else if ("Address".equals(searchBy)) {
                if (!"address".equals(criteria.address().address())) {
                    strSql.append(" and ADDRESS like '%").append(criteria.address().address()).append("%'");
                } else if (!"location".equals(criteria.address().location())) {
                    strSql.append(" and LOCATION like '%").append(criteria.address().location()).append("%'");
                } else if (!"city".equals(criteria.address().city())) {
                    strSql.append(" and CITY like '%").append(criteria.address().city()).append("%'");
                } else if (!"pin".equals(criteria.address().pin())) {
                    strSql.append(" and PIN like '%").append(criteria.address().pin()).append("%'");
                }
            } else if ("Comments".equals(searchBy)) {
                strSql.append(" and COMMENTS like '%").append(criteria.freeText()).append("%'");
            } else if ("Additional Info".equals(searchBy)) {
                strSql.append(" and PROPERTY_ID in (");
                strSql.append("Select FK_PROPERTY_ID from PROPERTY_ADDITIONAL_DETAILS WHERE VALUE LIKE '%").append(criteria.freeText()).append("%'");
                strSql.append(")");
            } else if ("Offered by".equals(searchBy)) {
                strSql.append(" and FK_CONTACT_ID =").append(Integer.parseInt(criteria.freeText()));
            } else if ("Tenant".equals(searchBy)) {
                strSql.append(" and PROPERTY_ID in (");
                strSql.append(this.fetchPropertyIdsByTenant(Integer.parseInt(criteria.freeText())));
                strSql.append(")");
            }
        }
        if (filterCriteria.pendingForRenewal()) {
            strSql.append(" and PROPERTY_ID in (");
            strSql.append(this.fetchReadyForRenewalPropertyIds());
            strSql.append(")");
        } else {
            if (!"All Records".equals(filterCriteria.offeredByType())) {
                Optional<PropertyOfferedBy> offeredBy = Arrays.stream(PropertyOfferedBy.values()).filter(offBy -> offBy.name().equals(filterCriteria.offeredByType())).findAny();
                offeredBy.ifPresent(propertyOfferedBy -> strSql.append(" and OFFERED_BY_TYPE =").append(propertyOfferedBy.ordinal()));
            }
            if (!"All Records".equals(filterCriteria.furnishingStatus())) {
                Optional<FurnitureStatus> furnitureStatus = Arrays.stream(FurnitureStatus.values()).filter(furStatus -> furStatus.name().equals(filterCriteria.furnishingStatus())).findAny();
                furnitureStatus.ifPresent(status -> strSql.append(" and FURNISHING_STATUS =").append(status.ordinal()));
            }
            strSql.append(" and (");
            if (filterCriteria.forRent()) {
                strSql.append("  PROPERTY_STATUS in( ").append(PropertyStatus.FOR_RENT.ordinal()).append(",").append(PropertyStatus.FOR_RENT_AND_SELL.ordinal()).append(" )");
                strSql.append(" OR");
            }
            if (filterCriteria.forSale()) {
                strSql.append("  PROPERTY_STATUS in( ").append(PropertyStatus.FOR_SELL.ordinal()).append(",").append(PropertyStatus.FOR_RENT_AND_SELL.ordinal()).append(" )");
                strSql.append(" OR");
            }
            if (filterCriteria.onRent()) {
                strSql.append("  PROPERTY_STATUS = ").append(PropertyStatus.ON_RENT.ordinal());
                strSql.append(" OR");
            }
            if (filterCriteria.unavailableProperties()) {
                strSql.append("  PROPERTY_STATUS = ").append(PropertyStatus.NOT_FOR_RENT_OR_SELL.ordinal());
                strSql.append(" )");
                if (filterCriteria.alreadyAvailable()) {
                    strSql.append(" and PROPERTY_ID in (");
                    strSql.append(this.fetchAlreadyAvailablePropertyIds());
                    strSql.append(")");
                }
                if (filterCriteria.availableWithInDays()) {
                    int withInDays = filterCriteria.noOfDays();
                    strSql.append(" and PROPERTY_ID in (");
                    strSql.append(this.fetchUnAvailablePropertyIds(withInDays));
                    strSql.append(")");
                }
            } else {
                strSql.deleteCharAt(strSql.length() - 1);
                strSql.deleteCharAt(strSql.length() - 1);
                strSql.append(" ) ");
            }
        }
        strSql.append(" order by PROPERTY_ID DESC LIMIT ? OFFSET ?");
        this.fetchReadyForRenewalPropertyIds();
        ArrayList<PropertyRecord> recordList = new ArrayList<PropertyRecord>();
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement ps = conn.prepareStatement(strSql.toString());){
            ps.setInt(1, pageSize);
            ps.setInt(2, offset);
            try (ResultSet result = ps.executeQuery();){
                while (result.next()) {
                    recordList.add(new PropertyRecord.Builder().totalRecords(result.getInt("TOTAL_COUNT")).date(result.getString("DATE")).address(result.getString("ADDRESS")).location(result.getString("LOCATION")).city(result.getString("CITY")).pin(result.getString("PIN")).deposit(result.getInt("DEPOSIT")).rent(result.getInt("RENT")).price(result.getInt("PRICE")).areaInSqFt(result.getInt("AREA_IN_SQFT")).offeredByType(result.getInt("OFFERED_BY_TYPE")).furnishingStatus(result.getInt("FURNISHING_STATUS")).propertyStatus(result.getInt("PROPERTY_STATUS")).comments(result.getString("COMMENTS")).fkGroupId(result.getInt("FK_GROUP_ID")).fkContactId(result.getInt("FK_CONTACT_ID")).leaseId(result.getInt("PROPERTY_ID")).localDate(AppUtility.convertStringToDate(result.getString("DATE"))).unAvailableUntil(result.getString("UNAVAILABLE_UNTIL") == null ? "-" : result.getString("UNAVAILABLE_UNTIL")).leaseDuration(result.getString("Lease_Duration")).contractExpiryFlag(this.isPropertyContractExpired(result.getInt("PROPERTY_ID"))).build());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        Collections.sort(recordList, Comparator.comparing(PropertyRecord::localDate).reversed());
        return recordList;
    }

    private boolean isPropertyContractExpired(int propertyId) {
        boolean isContractExpired = false;
        for (String expiredId : this.getPropIdsReadyForRenewal()) {
            if (Integer.parseInt(expiredId) != propertyId) continue;
            isContractExpired = true;
        }
        return isContractExpired;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PropertyDetails fetchPropertyDetails(int leaseId) throws Exception {
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement ps = conn.prepareStatement(FETCH_PROPERTY_DETAILS);){
            ps.setInt(1, leaseId);
            Map<String, String> additionalDetails = this.loadPropertyAdditionalDetails(conn, leaseId);
            try (ResultSet res = ps.executeQuery();){
                if (!res.next()) return null;
                PropertyDetails propertyDetails = new PropertyDetails(res.getString("GROUP_NAME"), res.getInt("OFFERED_BY_TYPE"), res.getString("NAME"), res.getString("MOBILE"), res.getInt("FURNISHING_STATUS"), res.getString("CREATED_ON"), res.getString("MODIFY_ON"), res.getString("TENANT_NAME"), res.getString("TENANT_NUMBER"), res.getString("START_DATE"), res.getString("END_DATE"), res.getInt("CONTACT_ID"), res.getInt("FK_TENANT_CONTACT_ID"), additionalDetails, res.getString("UNAVAILABLE_UNTIL"));
                return propertyDetails;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PropertyRecord fetchPropertyRecord(int leaseId) throws Exception {
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement ps = conn.prepareStatement(LOAD_RECORD);){
            ps.setInt(1, leaseId);
            try (ResultSet result = ps.executeQuery();){
                if (!result.next()) return null;
                PropertyRecord propertyRecord = new PropertyRecord.Builder().date(result.getString("DATE")).address(result.getString("ADDRESS")).location(result.getString("LOCATION")).city(result.getString("CITY")).pin(result.getString("PIN")).deposit(result.getInt("DEPOSIT")).rent(result.getInt("RENT")).price(result.getInt("PRICE")).areaInSqFt(result.getInt("AREA_IN_SQFT")).offeredByType(result.getInt("OFFERED_BY_TYPE")).furnishingStatus(result.getInt("FURNISHING_STATUS")).propertyStatus(result.getInt("PROPERTY_STATUS")).comments(result.getString("COMMENTS")).fkGroupId(result.getInt("FK_GROUP_ID")).fkContactId(result.getInt("FK_CONTACT_ID")).leaseId(result.getInt("PROPERTY_ID")).localDate(AppUtility.convertStringToDate(result.getString("DATE"))).unAvailableUntil(result.getString("UNAVAILABLE_UNTIL")).build();
                return propertyRecord;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PropertyForRentDetails fetchPropertyDetailsForRent(int propertyId) throws Exception {
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement ps = conn.prepareStatement(FETCH_PROPERTY_FOR_RENT_DETAILS);){
            ps.setInt(1, propertyId);
            try (ResultSet res = ps.executeQuery();){
                if (!res.next()) return null;
                PropertyForRentDetails propertyForRentDetails = new PropertyForRentDetails(res.getInt("OFFERED_BY_TYPE"), res.getInt("DEPOSIT"), res.getInt("RENT"), res.getInt("CONTACT_ID"), res.getString("NAME"));
                return propertyForRentDetails;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PropertyOnRentDetails fetchPropertyDetailsOnRent(int propertyId) throws Exception {
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement ps = conn.prepareStatement(FETCH_ON_RENT_DETAILS);){
            ps.setInt(1, propertyId);
            try (ResultSet res = ps.executeQuery();){
                if (!res.next()) return null;
                PropertyOnRentDetails propertyOnRentDetails = new PropertyOnRentDetails(res.getString("START_DATE"), res.getInt("FK_OWNER_CONTACT_ID"), res.getInt("FK_TENANT_CONTACT_ID"), res.getInt("FK_RENTED_BY_CONTACT_ID"), res.getString("OWNER_NAME"), res.getString("TENANT_NAME"), res.getString("RENTED_BY_NAME"), res.getInt("DEPOSIT"), res.getInt("RENT"), res.getInt("BROKERAGE"), res.getInt("TENURE_IN_MONTHS"), res.getInt("PROPERTY_RENT_BY"), res.getString("END_DATE"), res.getInt("PROPERTY_ON_RENT_ID"), propertyId, res.getString("RENTED_BY_NUMBER"), res.getString("OWNER_NUMBER"), res.getString("TENANT_NUMBER"), null, null, this.fetchRentDetails(propertyId));
                return propertyOnRentDetails;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private List<RentDetails> fetchRentDetails(int propertyId) throws Exception {
        ArrayList<RentDetails> rentDetailsList = new ArrayList<RentDetails>();
        try (Connection conn = DbUtility.getConnection();){
            ArrayList<RentDetails> arrayList;
            block22: {
                PreparedStatement ps = conn.prepareStatement(FETCH_RENT_CONDITIONS);
                try {
                    ps.setInt(1, propertyId);
                    try (ResultSet res = ps.executeQuery();){
                        while (res.next()) {
                            rentDetailsList.add(new RentDetails(res.getString("START_MONTH"), res.getString("END_MONTH"), res.getInt("RENT"), res.getString("RENT_REVISED_IN_MONTHS"), res.getInt("RENT_CONDITIONS_ID")));
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e.getMessage());
                    }
                    arrayList = rentDetailsList;
                    if (ps == null) break block22;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ps.close();
            }
            return arrayList;
        }
    }

    @Override
    public List<PropertyStatistics> fetchPropertyStatistics() throws Exception {
        ArrayList<PropertyStatistics> propertyStatistics = new ArrayList<PropertyStatistics>();
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement ps = conn.prepareStatement(FETCH_PROPERTY_STATISTICS);
             ResultSet res = ps.executeQuery();){
            while (res.next()) {
                propertyStatistics.add(new PropertyStatistics(PropertyStatus.propertyCode(res.getInt("PROPERTY_STATUS")).name().replaceAll("_", " "), res.getInt("COUNT")));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return propertyStatistics;
    }

    @Override
    public List<String> fetchEndDatesForOnRentProperty() throws Exception {
        ArrayList<String> endDates = new ArrayList<String>();
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement ps = conn.prepareStatement(FETCH_END_DATES_FOR_ON_RENT);
             ResultSet res = ps.executeQuery();){
            while (res.next()) {
                endDates.add(res.getString("END_DATE"));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return endDates;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int fetchPropertyCountByContactId(int contactId) throws Exception {
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement ps = conn.prepareStatement(FETCH_PROPERTY_COUNT_BY_CONTACT_ID);){
            ps.setInt(1, contactId);
            try (ResultSet res = ps.executeQuery();){
                if (!res.next()) return 0;
                int n = res.getInt("PROPERTY_COUNT");
                return n;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    /*
     * Exception decompiling
     */
    private String fetchReadyForRenewalPropertyIds() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private String fetchAlreadyAvailablePropertyIds() throws DatabaseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private String fetchUnAvailablePropertyIds(int noOfDays) throws DatabaseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private String fetchPropertyIdsByTenant(int tenantId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Map<String, String> loadPropertyAdditionalDetails(Connection conn, int propertyId) throws DatabaseException {
        HashMap<String, String> propertyAdditionalDetails = new HashMap<String, String>();
        try (PreparedStatement ps = conn.prepareStatement(LOAD_PROPERTY_ADDITIONAL_DETAILS_BY_ID);){
            ps.setInt(1, propertyId);
            try (ResultSet res = ps.executeQuery();){
                while (res.next()) {
                    propertyAdditionalDetails.put(res.getString("NAME"), res.getString("VALUE"));
                }
            }
        }
        catch (SQLException e) {
            throw new DatabaseException("loadPropertyAdditionalDetails", e);
        }
        return propertyAdditionalDetails;
    }

    private static /* synthetic */ void lambda$fetchUnAvailablePropertyIds$6(int noOfDays, List propIds, Integer id, String unavailableUnitDate) {
        LocalDate unavailableUnitDateObj = AppUtility.convertStringToDate(unavailableUnitDate);
        long days = ChronoUnit.DAYS.between(LocalDate.now(), unavailableUnitDateObj);
        if (days <= (long)noOfDays) {
            propIds.add(String.valueOf(id));
        }
    }

    private static /* synthetic */ void lambda$fetchAlreadyAvailablePropertyIds$5(List propIds, Integer id, String unavailableUnitDate) {
        LocalDate unavailableUnitDateObj = AppUtility.convertStringToDate(unavailableUnitDate);
        long days = ChronoUnit.DAYS.between(LocalDate.now(), unavailableUnitDateObj);
        if (days <= 0L) {
            propIds.add(String.valueOf(id));
        }
    }

    private static /* synthetic */ void lambda$fetchReadyForRenewalPropertyIds$4(List propIdsReadyForRenewal, Integer id, String endDate) {
        LocalDate endDateObj = AppUtility.convertStringToDate(endDate);
        long days = ChronoUnit.DAYS.between(LocalDate.now(), endDateObj);
        if (days <= 45L) {
            propIdsReadyForRenewal.add(String.valueOf(id));
        }
    }
}

